/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.cache;

import com.hs.atic.analysis.report.dns.cache.DnsCache;
import com.hs.atic.analysis.report.dns.cache.DnsCacheComparator;
import com.hs.atic.analysis.report.dns.cache.TransmitData;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DnsCacheForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IFlexTableData;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.comparators.ReverseComparator;

public class DnsCacheDataSet
extends IJavaDataSource {
    private static final long NUM_300 = 300L;
    private static final long NUM_3600 = 3600L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<DnsCache> dataList = new ArrayList<DnsCache>();
    private int success = 0;
    private Boolean isDNSType = false;
    private IDataStatService dataStatService;

    public List<DnsCache> sortListByField(List<DnsCache> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<DnsCache> orderedList = null;
        orderedList = null != sortList ? this.sortListByField(this.dataList, sortList.getOrderField(), sortList.getOrderType()) : this.dataList;
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<DnsCache> list = new ArrayList<DnsCache>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public List<IFlexTableData> getFlexTableHeader() {
        return null;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        Map<String, List<DnsCacheForm>> allDnsCacheForm = null;
        try {
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return this.success;
            }
            if (datastatConditionForm.getDeviceId() > 0L) {
                allDnsCacheForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                allDnsCacheForm = this.getMultiDeviceData(currentLogUserId, datastatConditionForm);
            }
            if (allDnsCacheForm == null) {
                this.logger.info((Object)"Map is empty, no data !");
                return this.success;
            }
            List<DnsCacheForm> dnsCacheFormList = null;
            dnsCacheFormList = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectCacheForm(allDnsCacheForm) : this.getCacheForm(allDnsCacheForm);
            dnsCacheFormList = this.getAllTimeData(dnsCacheFormList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
            this.processFinalData(dnsCacheFormList, datastatConditionForm, sessionId);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("DnsCacheDataSet prepareData happened exception !" + e.getMessage()));
        }
        return this.success;
    }

    /*
     * WARNING - void declaration
     */
    private void processFinalData(List<DnsCacheForm> dnsCacheFormList, DataStatConditionForm datastatConditionForm, long sessionId) {
        void var6_9;
        for (DnsCacheForm dnsCacheForm : dnsCacheFormList) {
            DnsCache dnsCache = new DnsCache();
            dnsCache.setDateTime(dnsCacheForm.getDateTime() * 1000L);
            dnsCache.setPps(dnsCacheForm.getPps());
            if (this.isDNSType.booleanValue()) {
                dnsCache.setDnsName(AticUtil.htmlEncodeCore((String)dnsCacheForm.getDnsName()) + "-" + AticUtil.htmlEncodeCore((String)dnsCacheForm.getRequestType()));
                dnsCache.setRequestType(AticUtil.htmlEncodeCore((String)dnsCacheForm.getRequestType()));
            } else {
                dnsCache.setDnsName(AticUtil.htmlEncodeCore((String)dnsCacheForm.getDnsName()));
                dnsCache.setRequestType("-");
            }
            this.dataList.add(dnsCache);
        }
        ArrayList<DnsCache> list = new ArrayList<DnsCache>();
        for (DnsCache ds : this.dataList) {
            DnsCache tmp = new DnsCache();
            try {
                BeanUtils.copyProperties((Object)tmp, (Object)ds);
                list.add(tmp);
            }
            catch (IllegalAccessException e) {
                this.logger.error((Object)("IllegalAccessException:" + e.getMessage()));
            }
            catch (InvocationTargetException e) {
                this.logger.error((Object)("InvocationTargetException:" + e.getMessage()));
            }
            catch (Exception e) {
                this.logger.error((Object)("unknow exception:" + e.getMessage()));
            }
        }
        if (null == datastatConditionForm.getTopn()) {
            ArrayList<DnsCache> arrayList = list;
        } else {
            int length = list.size();
            if (length > datastatConditionForm.getTopn()) {
                length = datastatConditionForm.getTopn();
            }
            Collections.sort(list, new DnsCacheComparator());
            List list2 = list.subList(0, length);
        }
        TransmitData.getInstance().addDataList((List<DnsCache>)var6_9, sessionId);
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        String topn;
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (0L == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        String bisId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "dnsType");
        ArrayList<String> requestTrendType = new ArrayList<String>();
        for (JsonValueItem item : jsonValueItem) {
            if (AticUtil.isNull((String)item.getValue())) continue;
            requestTrendType.add(item.getValue());
        }
        if (!requestTrendType.isEmpty()) {
            datastatConditionForm.setRequestTrendType(requestTrendType);
            this.isDNSType = true;
        }
        if (!AticUtil.isNull((String)(topn = String.valueOf((jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN")).get(0).getValue())))) {
            datastatConditionForm.setTopn(Integer.parseInt(topn));
        }
    }

    private Map<String, List<DnsCacheForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<DnsCacheForm>> allDnsCacheForm = new HashMap();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(datastatConditionForm.getDeviceId());
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,fwId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            allDnsCacheForm = this.dataStatService.getDnsCache(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return allDnsCacheForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Map<String, List<DnsCacheForm>> getMultiDeviceData(Long currentLogUserId, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<DnsCacheForm>> allDnsCacheForm = new HashMap<String, List<DnsCacheForm>>();
        List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMaps = ReportAnalysisUtil.getCollectDevMap(firewallList);
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMaps.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            allDnsCacheForm.putAll(this.processOneQuery(collector.getIpAddress(), entry, datastatConditionForm));
        }
        return allDnsCacheForm;
    }

    private Map<String, List<DnsCacheForm>> processOneQuery(String collectorIp, Map.Entry<Long, List<AticDevice>> entry, DataStatConditionForm datastatConditionForm) {
        Map<String, List<DnsCacheForm>> tempMap = new HashMap<String, List<DnsCacheForm>>();
        try {
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            tempMap = this.dataStatService.getDnsCache(datastatConditionForm, collectorIp);
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
        }
        return tempMap;
    }

    private List<DnsCacheForm> getAllDetectCacheForm(Map<String, List<DnsCacheForm>> inputMap) {
        List<DnsCacheForm> distinctForm = new ArrayList<DnsCacheForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<DnsCacheForm> listForm = new ArrayList<DnsCacheForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<DnsCacheForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getDistinctForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getDistinctForm(distinctForm, 1);
        return distinctForm;
    }

    private List<DnsCacheForm> getDistinctForm(List<DnsCacheForm> allForm, int netMode) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getDnsName().equals(allForm.get(j).getDnsName()) || !this.isDNSType.booleanValue() || !allForm.get(i).getRequestType().equals(allForm.get(j).getRequestType()) || !allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime())) continue;
                this.dealWithSame(allForm, netMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<DnsCacheForm> allForm, int netMode, int i, int j) {
        if (netMode == 0) {
            if (allForm.get(i).getPps() > allForm.get(j).getPps()) {
                allForm.get(i).setPps(allForm.get(i).getPps());
            } else {
                allForm.get(i).setPps(allForm.get(j).getPps());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setPps(allForm.get(i).getPps() + allForm.get(j).getPps());
            allForm.remove(j);
        }
    }

    private List<DnsCacheForm> getCacheForm(Map<String, List<DnsCacheForm>> inputMap) {
        List<DnsCacheForm> formList = new ArrayList<DnsCacheForm>();
        for (Map.Entry<String, List<DnsCacheForm>> entry : inputMap.entrySet()) {
            formList.addAll((Collection<DnsCacheForm>)entry.getValue());
        }
        formList = this.getDistinctForm(formList, 1);
        return formList;
    }

    private List<DnsCacheForm> getAllTimeData(List<DnsCacheForm> dnsCacheFormList, long startTime, long endTime) {
        startTime = ReportAnalysisUtil.getRealStartTime(startTime, endTime);
        long timeSlot = this.getTimeSlot(startTime, endTime);
        ArrayList<String> dnsNameList = new ArrayList<String>();
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < dnsCacheFormList.size(); ++i) {
            DnsCacheForm form = dnsCacheFormList.get(i);
            if (i == 0) {
                minTime = form.getDateTime();
                maxTime = form.getDateTime();
            } else {
                if (form.getDateTime() < minTime) {
                    minTime = form.getDateTime();
                }
                if (form.getDateTime() > maxTime) {
                    maxTime = form.getDateTime();
                }
            }
            this.getDnsNameList(form, dnsNameList);
        }
        HashMap map = new HashMap();
        while (minTime <= maxTime) {
            ArrayList<DnsCacheForm> tmpList = new ArrayList<DnsCacheForm>();
            for (DnsCacheForm form : dnsCacheFormList) {
                if (!form.getDateTime().equals(minTime)) continue;
                tmpList.add(form);
            }
            map.put(minTime, tmpList);
            minTime = minTime + timeSlot;
        }
        for (Map.Entry<Long, List<DnsCacheForm>> entry : map.entrySet()) {
            this.getDnsCacheFormListData(entry, dnsNameList, dnsCacheFormList);
        }
        return dnsCacheFormList;
    }

    private long getTimeSlot(long startTime, long endTime) {
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        if (type == AnalysisConstants.LESS_THAN_SEVEN_DAYS) {
            return 3600L;
        }
        if (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS) {
            return 86400L;
        }
        return 300L;
    }

    private void getDnsNameList(DnsCacheForm form, List<String> dnsNameList) {
        boolean hasData = false;
        for (int j = 0; j < dnsNameList.size(); ++j) {
            if (this.isDNSType.booleanValue()) {
                if (!(form.getDnsName() + "-" + form.getRequestType()).equals(dnsNameList.get(j))) continue;
                hasData = true;
                break;
            }
            if (!form.getDnsName().equals(dnsNameList.get(j))) continue;
            hasData = true;
            break;
        }
        if (!hasData) {
            if (this.isDNSType.booleanValue()) {
                dnsNameList.add(AticUtil.htmlEncodeCore((String)form.getDnsName()) + "-" + AticUtil.htmlEncodeCore((String)form.getRequestType()));
            } else {
                dnsNameList.add(AticUtil.htmlEncodeCore((String)form.getDnsName()));
            }
        }
    }

    private void getDnsCacheFormListData(Map.Entry<Long, List<DnsCacheForm>> entry, List<String> dnsNameList, List<DnsCacheForm> dnsCacheFormList) {
        for (int i = 0; i < dnsNameList.size(); ++i) {
            boolean hasData = false;
            for (DnsCacheForm form : entry.getValue()) {
                if (this.isDNSType.booleanValue()) {
                    if (!(form.getDnsName() + "-" + form.getRequestType()).equals(dnsNameList.get(i))) continue;
                    hasData = true;
                    break;
                }
                if (!form.getDnsName().equals(dnsNameList.get(i))) continue;
                hasData = true;
                break;
            }
            if (hasData) continue;
            DnsCacheForm form = new DnsCacheForm();
            form.setDateTime(entry.getKey());
            if (this.isDNSType.booleanValue()) {
                form.setDnsName(dnsNameList.get(i).split("-")[0]);
                form.setRequestType(dnsNameList.get(i).split("-")[1]);
            } else {
                form.setDnsName(dnsNameList.get(i));
            }
            form.setPps(0L);
            dnsCacheFormList.add(form);
        }
    }
}

