/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.cache;

import com.hs.atic.analysis.report.dns.cache.DnsCache;
import com.hs.atic.analysis.report.dns.cache.TransmitData;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class DnsCacheTableDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<DnsCache> dnsCacheList = new ArrayList<DnsCache>();

    public List<DnsCache> sortListByField(List<DnsCache> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<DnsCache> orderedList = null;
        orderedList = null != sortList ? this.sortListByField(this.dnsCacheList, sortList.getOrderField(), sortList.getOrderType()) : this.dnsCacheList;
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<DnsCache> list = new ArrayList<DnsCache>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dnsCacheList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        try {
            DnsCache di;
            int i;
            this.dnsCacheList = TransmitData.getInstance().getDataList().get(sessionId);
            TransmitData.getInstance().removeData(sessionId);
            if (null == this.dnsCacheList || this.dnsCacheList.isEmpty()) {
                this.logger.info((Object)"dnsCacheList is null or empty");
                return 0;
            }
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            for (i = 0; i < this.dnsCacheList.size(); ++i) {
                di = this.dnsCacheList.get(i);
                countMap.put(di.getDnsName(), 1);
                for (int j = this.dnsCacheList.size() - 1; j > i; --j) {
                    this.fillCountMap(di, j, countMap);
                }
            }
            for (i = 0; i < this.dnsCacheList.size(); ++i) {
                di = this.dnsCacheList.get(i);
                int times = 1;
                if (!countMap.isEmpty()) {
                    times = (Integer)countMap.get(di.getDnsName());
                }
                if (times <= true) continue;
                di.setPps(di.getPps() / (long)times);
            }
        }
        catch (LegoCheckedException legoException) {
            this.dnsCacheList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dnsCacheList.clear();
            this.logger.error((Object)("DnsCacheTableDataSet prepareData happened exception !" + e.getMessage()));
        }
        BeanComparator comparator = new BeanComparator("pps");
        comparator = new ReverseComparator((Comparator)comparator);
        Collections.sort(this.dnsCacheList, comparator);
        this.logger.info((Object)"end prepareDate");
        return 0;
    }

    private void fillCountMap(DnsCache di, int j, Map<String, Integer> countMap) {
        DnsCache dj = this.dnsCacheList.get(j);
        if (di.getDnsName().equals(dj.getDnsName())) {
            String dnsName = di.getDnsName();
            if (0L != dj.getPps()) {
                di.setPps(di.getPps() + dj.getPps());
                if (countMap.containsKey(dnsName)) {
                    int times = countMap.get(dnsName);
                    countMap.remove(dnsName);
                    countMap.put(dnsName, ++times);
                } else {
                    countMap.put(dnsName, 1);
                }
            }
            this.dnsCacheList.remove(j);
        }
    }
}

