/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.dnsdefend;

import com.hs.atic.analysis.report.dns.dnsdefend.DnsDefendLog;
import com.hs.atic.analysis.report.dns.dnsdefend.DnsDefendLogComparator;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DnsDefendLogForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class DnsDefendLogDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<DnsDefendLog> dataList = null;
    private Integer total = 0;
    private IDataStatService dataStatService;
    private DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
    private Long currentLogUserId;

    public List<DnsDefendLog> sortListByField(List<DnsDefendLog> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        List<DnsDefendLogForm> attackLogFormList = null;
        if (0L == pageIndex && 0L == pageSize) {
            pageSize = Integer.MAX_VALUE;
        }
        if (pageIndex < 1L) {
            pageIndex = 1L;
        }
        this.datastatConditionForm.setStartRow((int)((pageIndex - 1L) * pageSize));
        this.datastatConditionForm.setLimit((int)pageSize);
        this.dataList = new ArrayList<DnsDefendLog>();
        try {
            attackLogFormList = this.getSingleDeviceData(this.datastatConditionForm, sortList);
            this.processAttackLogList(attackLogFormList);
            if (null != this.datastatConditionForm.getTopn()) {
                this.getTopnData();
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)("AttackLogDataSet fetchData() LegoCheckedException:" + legoException.getErrorCode()));
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("AttackLogDataSet fetchData() unknow exception!" + e.getMessage()));
        }
        return this.dataList;
    }

    private void processAttackLogList(List<DnsDefendLogForm> attackLogFormList) {
        if (null == attackLogFormList) {
            return;
        }
        for (DnsDefendLogForm form : attackLogFormList) {
            DnsDefendLog log = new DnsDefendLog();
            log.setLogTimeStr(AticUtil.convertTimeLong((Long)form.getLogTime()));
            log.setDeviceIpStr(form.getDeviceIp());
            log.setDomain(form.getDomain());
            log.setSourceIpStr(form.getSourceIpStr());
            log.setRequestTime(form.getRequestTime());
            this.dataList.add(log);
        }
    }

    private void getTopnData() {
        Collections.sort(this.dataList, new DnsDefendLogComparator("accessTime", "desc"));
        int length = this.dataList.size();
        if (length > this.datastatConditionForm.getTopn()) {
            length = this.datastatConditionForm.getTopn();
        }
        this.dataList = new ArrayList<DnsDefendLog>(this.dataList.subList(0, length));
    }

    private List<DnsDefendLogForm> getSingleDeviceData(DataStatConditionForm datastatConditionForms, OrderInfo sortList) {
        List<Object> attackLogFormList = new ArrayList();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForms.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForms.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForms.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(datastatConditionForms.getDeviceId());
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,fwId = " + datastatConditionForms.getDeviceId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            attackLogFormList = null != sortList ? this.dataStatService.getDnsDefendLog(datastatConditionForms, collectorInfo.getIpAddress(), sortList.getOrderField(), sortList.getOrderType()) : this.dataStatService.getDnsDefendLog(datastatConditionForms, collectorInfo.getIpAddress(), null, null);
            this.total = this.dataStatService.getDnsDefendLogNum(datastatConditionForms, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return attackLogFormList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.total.intValue();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        try {
            List<JsonValueItem> jsonValueItem = null;
            this.datastatConditionForm = new DataStatConditionForm();
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
            String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
            ReportAnalysisUtil.processDeviceInfo(this.datastatConditionForm, deviceId);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "domain");
            String domain = String.valueOf(jsonValueItem.get(0).getValue()).trim();
            this.datastatConditionForm.setDomain(domain);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "source_ip");
            String sourceIp = String.valueOf(jsonValueItem.get(0).getValue());
            this.datastatConditionForm.setSouceIp(sourceIp);
            ReportAnalysisUtil.setDateRange(queryCond, this.datastatConditionForm);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
            String topn = String.valueOf(jsonValueItem.get(0).getValue());
            if (!AticUtil.isNull((String)topn)) {
                this.datastatConditionForm.setTopn(Integer.parseInt(topn));
            }
            ICollectorService collectorService = ResActionUtil.getCollectorService();
            Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(this.datastatConditionForm.getDeviceId());
            if (null == collectorId) {
                this.logger.error((Object)("no collector exist,fwId = " + this.datastatConditionForm.getDeviceId()));
                throw new LegoCheckedException(570512L);
            }
            CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
            if (null == collectorInfo) {
                this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
                throw new LegoCheckedException(570512L);
            }
            if (2 == collectorInfo.getStatus()) {
                this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + collectorInfo.getIpAddress()));
                throw new LegoCheckedException(570504L);
            }
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"BotLogDataSet prepareData happened  exception.");
        }
        catch (LegoCheckedException legoException) {
            this.logger.error((Object)("BotLogDataSet prepareData happened  exception :" + legoException.getErrorCode() + ". " + legoException.getMessage()));
            throw legoException;
        }
        return 0;
    }

    public Long getCurrentLogUserId() {
        return this.currentLogUserId;
    }

    public void setCurrentLogUserId(Long currentLogUserId) {
        this.currentLogUserId = currentLogUserId;
    }
}

