/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.dnsdefendtopn;

import com.hs.atic.analysis.report.dns.dnsdefendtopn.DnsDefendTopN;
import com.hs.atic.analysis.report.dns.dnsdefendtopn.DomainAndRequestTime;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DnsDefendTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class DnsDefendTopNChartDataSet
extends IJavaDataSource {
    private static final Long NUM_THREE_HUNDRED = 300L;
    private static final Long NUM_THREE_THOUSAND_SIX_HUNDRED = 3600L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<DnsDefendTopN> dataList = new ArrayList<DnsDefendTopN>();
    private IDataStatService dataStatService;

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        return this.dataList;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"dnsDefendTopnDataSet start prepareData()");
        List<DnsDefendTopNForm> requestTrendFormList = null;
        Map<String, List<DnsDefendTopNForm>> allCollectorRequestForm = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm);
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorRequestForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect4DnsAnalysis(datastatConditionForm, currentLogUserId);
                Map<Long, List<AticDevice>> collectDevMap = null;
                collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
                allCollectorRequestForm = this.getAllCollectorIpTopNForm(collectDevMap, datastatConditionForm);
            }
            if (-2L == datastatConditionForm.getDeviceId()) {
                requestTrendFormList = this.getAllDetectTopNForm(allCollectorRequestForm);
            } else {
                ArrayList<DnsDefendTopNForm> allForm = new ArrayList<DnsDefendTopNForm>();
                for (Map.Entry<String, List<DnsDefendTopNForm>> entry : allCollectorRequestForm.entrySet()) {
                    allForm.addAll((Collection<DnsDefendTopNForm>)entry.getValue());
                }
                requestTrendFormList = this.getTopNForm(allForm, 1);
            }
            this.getRequestTrendFormData(datastatConditionForm, requestTrendFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("dnsDefendTopnDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        this.logger.info((Object)"dnsDefendTopnDataSet end prepareData()");
        return 0;
    }

    private void getRequestTrendFormData(DataStatConditionForm datastatConditionForm, List<DnsDefendTopNForm> dnsDefendTopNFormList) {
        HashMap<Object, Integer> domainRequestTime = new HashMap<Object, Integer>();
        for (int i = 0; i < dnsDefendTopNFormList.size(); ++i) {
            String domainKey = dnsDefendTopNFormList.get(i).getDomain();
            int n = dnsDefendTopNFormList.get(i).getRequestTime();
            if (domainRequestTime.containsKey(domainKey)) {
                int tempValue = (Integer)domainRequestTime.get(domainKey);
                domainRequestTime.put(domainKey, n + tempValue);
                continue;
            }
            domainRequestTime.put(domainKey, n);
        }
        ArrayList<DomainAndRequestTime> domainRequestTimeTopN = new ArrayList<DomainAndRequestTime>();
        for (Map.Entry entry : domainRequestTime.entrySet()) {
            DomainAndRequestTime temp = new DomainAndRequestTime();
            temp.setDomian((String)entry.getKey());
            temp.setRequestTime((Integer)entry.getValue());
            domainRequestTimeTopN.add(temp);
        }
        List<DomainAndRequestTime> domainRequestOrder = this.sortListByField(domainRequestTimeTopN, "requestTime", "DESC");
        ArrayList<DomainAndRequestTime> arrayList = new ArrayList<DomainAndRequestTime>();
        int endIndex = 0;
        endIndex = datastatConditionForm.getTopn() >= domainRequestOrder.size() ? domainRequestOrder.size() : datastatConditionForm.getTopn().intValue();
        if (!domainRequestOrder.isEmpty()) {
            arrayList.addAll(domainRequestOrder.subList(0, endIndex));
        }
        ArrayList<String> domainTopNName = new ArrayList<String>();
        for (DomainAndRequestTime temp : arrayList) {
            domainTopNName.add(temp.getDomian());
        }
        for (String domainName : domainTopNName) {
            for (int i = 0; i < dnsDefendTopNFormList.size(); ++i) {
                if (!domainName.equals(dnsDefendTopNFormList.get(i).getDomain())) continue;
                DnsDefendTopN data = new DnsDefendTopN();
                data.setDateTime(dnsDefendTopNFormList.get(i).getDateTime() * 1000L);
                data.setDomain(dnsDefendTopNFormList.get(i).getDomain());
                data.setRequestTime(dnsDefendTopNFormList.get(i).getRequestTime());
                this.dataList.add(data);
            }
        }
        this.dataList = this.getAllTimeData(this.dataList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
    }

    private long getTimeSlot(long startTime, long endTime) {
        long timeSlot = 0L;
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        timeSlot = type == AnalysisConstants.LESS_THAN_SEVEN_DAYS ? NUM_THREE_THOUSAND_SIX_HUNDRED : (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS ? 24L * NUM_THREE_THOUSAND_SIX_HUNDRED : NUM_THREE_HUNDRED);
        return timeSlot;
    }

    private void getDnsNameList(DnsDefendTopN form, List<String> dnsNameList) {
        boolean hasData = false;
        for (int j = 0; j < dnsNameList.size(); ++j) {
            if (!form.getDomain().equals(dnsNameList.get(j))) continue;
            hasData = true;
            break;
        }
        if (!hasData) {
            dnsNameList.add(form.getDomain());
        }
    }

    private List<DnsDefendTopN> getAllTimeData(List<DnsDefendTopN> requestTrendFormList, long startTime, long endTime) {
        startTime = ReportAnalysisUtil.getRealStartTime(startTime, endTime);
        long timeSlot = this.getTimeSlot(startTime, endTime);
        ArrayList<String> dnsNameList = new ArrayList<String>();
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < requestTrendFormList.size(); ++i) {
            DnsDefendTopN form = requestTrendFormList.get(i);
            if (i == 0) {
                minTime = form.getDateTime();
                maxTime = form.getDateTime();
            } else {
                if (form.getDateTime() < minTime) {
                    minTime = form.getDateTime();
                }
                if (form.getDateTime() > maxTime) {
                    maxTime = form.getDateTime();
                }
            }
            this.getDnsNameList(form, dnsNameList);
        }
        HashMap<Long, List<DnsDefendTopN>> map = new HashMap<Long, List<DnsDefendTopN>>();
        while (minTime <= maxTime) {
            ArrayList<DnsDefendTopN> tmpList = new ArrayList<DnsDefendTopN>();
            for (DnsDefendTopN form : requestTrendFormList) {
                if (!form.getDateTime().equals(minTime)) continue;
                tmpList.add(form);
            }
            map.put(minTime, tmpList);
            minTime = minTime + timeSlot * 1000L;
        }
        this.getRequestTrendFormList(map, dnsNameList, requestTrendFormList);
        return requestTrendFormList;
    }

    private void getRequestTrendFormList(Map<Long, List<DnsDefendTopN>> map, List<String> dnsNameList, List<DnsDefendTopN> requestTrendFormList) {
        for (Map.Entry<Long, List<DnsDefendTopN>> entry : map.entrySet()) {
            for (int i = 0; i < dnsNameList.size(); ++i) {
                boolean hasData = false;
                for (DnsDefendTopN form : entry.getValue()) {
                    if (!form.getDomain().equals(dnsNameList.get(i))) continue;
                    hasData = true;
                    break;
                }
                if (hasData) continue;
                DnsDefendTopN form = new DnsDefendTopN();
                form.setDateTime(entry.getKey());
                form.setRequestTime(0);
                form.setDomain(dnsNameList.get(i));
                requestTrendFormList.add(form);
            }
        }
    }

    public List<DomainAndRequestTime> sortListByField(List<DomainAndRequestTime> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    private Map<String, List<DnsDefendTopNForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,fwId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        HashMap<String, List<DnsDefendTopNForm>> allCollectorRequestForm = new HashMap();
        try {
            allCollectorRequestForm = this.dataStatService.getDnsDefendTopN(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return allCollectorRequestForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
    }

    private List<DnsDefendTopNForm> getAllDetectTopNForm(Map<String, List<DnsDefendTopNForm>> inputMap) {
        List<DnsDefendTopNForm> distinctForm = new ArrayList<DnsDefendTopNForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<DnsDefendTopNForm> listForm = new ArrayList<DnsDefendTopNForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<DnsDefendTopNForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getTopNForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getTopNForm(distinctForm, 1);
        return distinctForm;
    }

    private Map<String, List<DnsDefendTopNForm>> getAllCollectorIpTopNForm(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<DnsDefendTopNForm>> allCollectorRequestTrendForm = new HashMap<String, List<DnsDefendTopNForm>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getDnsDefendTopN(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
            }
            allCollectorRequestTrendForm.putAll(tempMap);
        }
        return allCollectorRequestTrendForm;
    }

    private List<DnsDefendTopNForm> getTopNForm(List<DnsDefendTopNForm> allForm, int netMode) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime()) || !allForm.get(i).getDomain().equals(allForm.get(j).getDomain())) continue;
                this.dealWithSame(allForm, netMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<DnsDefendTopNForm> allForm, int netMode, int i, int j) {
        if (netMode == 0) {
            if (allForm.get(i).getRequestTime() > allForm.get(j).getRequestTime()) {
                allForm.get(i).setRequestTime(allForm.get(i).getRequestTime());
            } else {
                allForm.get(i).setRequestTime(allForm.get(j).getRequestTime());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setRequestTime(allForm.get(i).getRequestTime() + allForm.get(j).getRequestTime());
            allForm.remove(j);
        }
    }
}

