/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.normalandexception;

import com.hs.atic.analysis.report.dns.normalandexception.NormalAbnormalComparator;
import com.hs.atic.analysis.report.dns.normalandexception.NormalAbnormalView;
import com.hs.atic.analysis.report.dns.normalandexception.TransmitNormalAbnormalData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.NormalAbnormalConditionForm;
import com.hs.atic.sdk.analysis.form.NormalAbnormalForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class NormalAbnormalChartDataSet
extends IJavaDataSource {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private NormalAbnormalConditionForm normalAndExceptionConditionForm;
    private List<AticDevice> firewallList;
    private Map<String, List<String>> collectorDeviceMap = new HashMap<String, List<String>>();
    private boolean isAllDetect;
    private Map<?, ?> queryCond4Security;
    private DataStatConditionForm datastatConditionForm = new DataStatConditionForm();

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String arg0, String arg1, Map<?, ?> queryCond, long sessionId) {
        try {
            this.queryCond4Security = queryCond;
            this.normalAndExceptionConditionForm = this.beforeQuery(queryCond, sessionId);
        }
        catch (LegoCheckedException legoException) {
            logger.error((Object)("FlowCompareChartDataSet prepareData() unknow exception!" + legoException.getMessage()));
            throw legoException;
        }
        catch (Exception e) {
            logger.error((Object)("FlowCompareChartDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        return 0;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        logger.info((Object)"start NormalAbnormalChartDataSet fetchData");
        ArrayList<NormalAbnormalView> resultList = new ArrayList<NormalAbnormalView>();
        try {
            List<NormalAbnormalForm> allList = this.queryNormalAndException(this.normalAndExceptionConditionForm, sessionId);
            for (NormalAbnormalForm normalAndExceptionForm : allList) {
                resultList.add((NormalAbnormalView)ReportAnalysisUtil.copyProperties(normalAndExceptionForm, new NormalAbnormalView()));
            }
        }
        catch (LegoCheckedException legoException) {
            resultList.clear();
            logger.error((Object)("NormalAbnormalChartDataSet fetchData() LegoCheckedException :" + legoException.getErrorCode()));
        }
        catch (Exception e) {
            resultList.clear();
            logger.error((Object)("NormalAbnormalChartDataSet fetchData() unknow exception!" + e.getMessage()));
        }
        logger.info((Object)"end NormalAbnormalChartDataSet fetchData");
        return resultList;
    }

    public long getAllCount(String arg0, long arg1) {
        return 0L;
    }

    private List<NormalAbnormalForm> queryNormalAndException(NormalAbnormalConditionForm normalAndExceptionConditionForms, long sessionId) {
        IDataStatService dataStatService = ReportAnalysisUtil.getDataStatService();
        List<Object> normalAndExceptionFormList = new ArrayList();
        ArrayList<NormalAbnormalForm> allList = new ArrayList<NormalAbnormalForm>();
        if (!ReportAnalysisUtil.checkDeviceAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, normalAndExceptionConditionForms.getTimeSpanType(), sessionId);
        }
        if (!ReportAnalysisUtil.checkZoneAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, normalAndExceptionConditionForms.getTimeSpanType(), sessionId);
        }
        if (null != normalAndExceptionConditionForms.getSessionId() && normalAndExceptionConditionForms.getZoneIdList().isEmpty()) {
            return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, normalAndExceptionConditionForms.getTimeSpanType(), sessionId);
        }
        for (Map.Entry<String, List<String>> entry : this.collectorDeviceMap.entrySet()) {
            normalAndExceptionConditionForms.setDeviceIpList(entry.getValue());
            try {
                normalAndExceptionFormList = dataStatService.queryNormalAndException(normalAndExceptionConditionForms, entry.getKey());
            }
            catch (Exception e) {
                logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
            }
            logger.info((Object)("query normalAndException chart result size : " + normalAndExceptionFormList.size()));
            allList.addAll(normalAndExceptionFormList);
        }
        return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, normalAndExceptionConditionForms.getTimeSpanType(), sessionId);
    }

    private List<NormalAbnormalForm> processResult(List<List<String>> firewallIpList, List<NormalAbnormalForm> allList, int timeType, long sessionId) {
        List<NormalAbnormalForm> result = this.isAllDetect ? this.processRedundancyAndAdd(firewallIpList, allList) : this.processAdd(allList);
        if (null != this.normalAndExceptionConditionForm) {
            List<NormalAbnormalForm> resultForTable;
            if (null == this.normalAndExceptionConditionForm.getTopn()) {
                resultForTable = result;
            } else {
                ArrayList<NormalAbnormalForm> tempList = new ArrayList<NormalAbnormalForm>(result);
                Collections.sort(tempList, NormalAbnormalComparator.getComparatorByFieldName("total", "desc"));
                int length = this.normalAndExceptionConditionForm.getTopn();
                if (tempList.size() <= this.normalAndExceptionConditionForm.getTopn()) {
                    length = tempList.size();
                }
                resultForTable = tempList.subList(0, length);
            }
            TransmitNormalAbnormalData.getInstance().addDataList(new ArrayList<NormalAbnormalForm>(resultForTable), sessionId);
        }
        this.fillContinuousTime(result, 0, 1, ReportAnalysisUtil.getGapTime(timeType));
        return result;
    }

    public List<NormalAbnormalForm> processRedundancyAndAdd(List<List<String>> ipList, List<NormalAbnormalForm> flowCompareFormList) {
        ArrayList<NormalAbnormalForm> result = new ArrayList<NormalAbnormalForm>();
        for (List<String> ips : ipList) {
            ArrayList<NormalAbnormalForm> allList = new ArrayList<NormalAbnormalForm>(flowCompareFormList);
            allList.retainAll(ips);
            flowCompareFormList.removeAll(allList);
            result.addAll(this.processRedundancy0(allList));
        }
        result.addAll(flowCompareFormList);
        return this.processAdd(result);
    }

    private List<NormalAbnormalForm> processRedundancy0(List<NormalAbnormalForm> allList) {
        ArrayList<NormalAbnormalForm> result = new ArrayList<NormalAbnormalForm>();
        Collections.sort(allList, NormalAbnormalComparator.getComparatorByFieldName("logTime", "asc"));
        ListIterator<NormalAbnormalForm> iter = allList.listIterator();
        int endIndex = 0;
        block0: while (iter.hasNext()) {
            NormalAbnormalForm first = iter.next();
            int startIndex = endIndex;
            if (!iter.hasNext()) {
                result.add(first);
            }
            while (iter.hasNext()) {
                boolean isEqual;
                boolean bl = isEqual = iter.next().getLogTime() == first.getLogTime();
                if (isEqual) {
                    ++endIndex;
                    if (iter.hasNext()) continue;
                }
                List<NormalAbnormalForm> subList = allList.subList(startIndex, endIndex + 1);
                Collections.sort(subList, NormalAbnormalComparator.getComparatorByFieldName("total", "desc"));
                result.add(subList.get(0));
                if (isEqual) continue block0;
                ++endIndex;
                iter = allList.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return result;
    }

    private NormalAbnormalConditionForm beforeQuery(Map<?, ?> queryCond, Long sessionId) {
        this.valiateParams(queryCond);
        return this.processQueryCondition(queryCond, sessionId);
    }

    private void valiateParams(Map<?, ?> queryCond) {
        logger.info((Object)"begin to validate normalAndException params.");
        if (null == queryCond) {
            logger.error((Object)"map is empty !");
        }
        logger.info((Object)"validate normalAndException params successfully");
    }

    private List<NormalAbnormalForm> processAdd(List<NormalAbnormalForm> normalAndExceptionFormList) {
        Collections.sort(normalAndExceptionFormList, NormalAbnormalComparator.getComparatorByFieldName("logTime", "asc"));
        ListIterator<NormalAbnormalForm> iter = normalAndExceptionFormList.listIterator();
        block0: while (iter.hasNext()) {
            NormalAbnormalForm first = iter.next();
            while (iter.hasNext()) {
                NormalAbnormalForm next = iter.next();
                if (next.getLogTime() == first.getLogTime()) {
                    first.setTotal(first.getTotal() + next.getTotal());
                    first.setIlegal(first.getIlegal() + next.getIlegal());
                    first.setLarge(first.getLarge() + next.getLarge());
                    first.setNormal(first.getNormal() + next.getNormal());
                    first.setTtlDenied(first.getTtlDenied() + next.getTtlDenied());
                    iter.remove();
                    continue;
                }
                iter = normalAndExceptionFormList.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return normalAndExceptionFormList;
    }

    protected void fillContinuousTime(List<NormalAbnormalForm> normalAndExceptionFormList, int first, int next, int timeSpan) {
        if (next < normalAndExceptionFormList.size()) {
            NormalAbnormalForm firstForm = normalAndExceptionFormList.get(first);
            NormalAbnormalForm nextForm = normalAndExceptionFormList.get(next);
            long timeGap = nextForm.getLogTime() - firstForm.getLogTime();
            if (timeGap > (long)timeSpan) {
                ArrayList<NormalAbnormalForm> normalAbnormalForm = new ArrayList<NormalAbnormalForm>();
                int i = 1;
                while ((long)i < timeGap / (long)timeSpan) {
                    NormalAbnormalForm normalAndExceptionFormGap = new NormalAbnormalForm();
                    normalAndExceptionFormGap.setLogTime(firstForm.getLogTime() + (long)timeSpan);
                    firstForm = normalAndExceptionFormGap;
                    normalAbnormalForm.add(normalAndExceptionFormGap);
                    ++i;
                }
                normalAndExceptionFormList.addAll(next, normalAbnormalForm);
                int nextIndex = ++first + normalAbnormalForm.size();
                this.fillContinuousTime(normalAndExceptionFormList, nextIndex, nextIndex + 1, timeSpan);
            } else {
                this.fillContinuousTime(normalAndExceptionFormList, ++first, ++next, timeSpan);
            }
        }
    }

    private NormalAbnormalConditionForm processQueryCondition(Map<?, ?> queryCond, Long sessionId) {
        logger.info((Object)"start to process query condition for normalAndException.");
        NormalAbnormalConditionForm normalAndExceptionConditionForms = new NormalAbnormalConditionForm();
        String deviceId = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox").get(0).getValue();
        Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
        this.processDeviceParam(currentLogUserId, deviceId, normalAndExceptionConditionForms);
        Long zoneId = Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox").get(0).getValue());
        normalAndExceptionConditionForms.setZoneId(zoneId);
        ReportAnalysisUtil.processDeviceInfo(this.datastatConditionForm, deviceId);
        this.datastatConditionForm.setZoneId(zoneId);
        if (0L == normalAndExceptionConditionForms.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, deviceId, normalAndExceptionConditionForms, sessionId);
        }
        String bizId = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox").get(0).getValue();
        ReportAnalysisUtil.processServiceCond(normalAndExceptionConditionForms, bizId);
        String zoneIp = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip").get(0).getValue();
        normalAndExceptionConditionForms.setZoneIp(AticUtil.isNull((String)zoneIp) ? null : zoneIp);
        ReportAnalysisUtil.processTimeParams(queryCond, normalAndExceptionConditionForms);
        String topn = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN").get(0).getValue());
        if (!AticUtil.isNull((String)topn)) {
            normalAndExceptionConditionForms.setTopn(Integer.parseInt(topn));
        }
        logger.info((Object)"process query condition for normalAndException sucessfully.");
        return normalAndExceptionConditionForms;
    }

    public void processDeviceParam(Long currentLogUserId, String deviceId, NormalAbnormalConditionForm normalAndExceptionConditionForms) {
        this.firewallList = ReportAnalysisUtil.processDeviceParam4DnsAnalysis(deviceId, normalAndExceptionConditionForms, currentLogUserId);
        this.isAllDetect = ReportAnalysisUtil.isAllDetect(deviceId);
        if (this.firewallList.isEmpty()) {
            logger.error((Object)"query normalAndExceptin error, no devices exist!");
        } else {
            ReportAnalysisUtil.generateCollectorDeviceMap(deviceId, this.firewallList, this.collectorDeviceMap);
        }
    }
}

