/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.normalandexception;

import com.hs.atic.analysis.report.dns.normalandexception.NormalAbnormalComparator;
import com.hs.atic.analysis.report.dns.normalandexception.NormalAbnormalView;
import com.hs.atic.analysis.report.dns.normalandexception.TransmitNormalAbnormalData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.sdk.analysis.form.NormalAbnormalForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NormalAbnormalTableDataSet
extends IJavaDataSource {
    private List<NormalAbnormalForm> cacheForTable = new ArrayList<NormalAbnormalForm>();
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        this.log.info((Object)"start NormalAbnormalTableDataSet fetchData");
        ArrayList<NormalAbnormalView> result = new ArrayList<NormalAbnormalView>();
        try {
            this.getNormalAbnormalTableData(sessionId);
            ArrayList<NormalAbnormalForm> resultList = new ArrayList<NormalAbnormalForm>();
            this.processOrder(sortList);
            this.processPaging(pageIndex, pageSize, resultList);
            for (NormalAbnormalForm normalAndExceptionForm : resultList) {
                result.add((NormalAbnormalView)ReportAnalysisUtil.copyProperties(normalAndExceptionForm, new NormalAbnormalView()));
            }
        }
        catch (LegoCheckedException legoException) {
            result.clear();
            this.log.error((Object)("NormalAbnormalTableDataSet fetchData() LegoCheckedException :" + legoException.getErrorCode()));
        }
        catch (Exception e) {
            result.clear();
            this.log.error((Object)("NormalAbnormalTableDataSet fetchData() unknow exception!" + e.getMessage()));
        }
        this.log.info((Object)"end NormalAbnormalTableDataSet fetchDate");
        return result;
    }

    private void getNormalAbnormalTableData(long sessionId) {
        List<NormalAbnormalForm> tableData = TransmitNormalAbnormalData.getInstance().getDataList(sessionId);
        TransmitNormalAbnormalData.getInstance().removeData(sessionId);
        if (null != tableData) {
            this.cacheForTable = tableData;
        }
    }

    public long getAllCount(String arg0, long arg1) {
        return this.cacheForTable.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return 0;
    }

    private void processPaging(long pageIndex, long pageSize, List<NormalAbnormalForm> resultList) {
        if (pageIndex != 0L && pageSize != 0L) {
            int startIndex = (int)((pageIndex - 1L) * pageSize);
            if ((long)this.cacheForTable.size() >= (long)startIndex + pageSize) {
                resultList.addAll(this.cacheForTable.subList(startIndex, startIndex + (int)pageSize));
            } else {
                resultList.addAll(this.cacheForTable.subList(startIndex, this.cacheForTable.size()));
            }
        }
        if (pageIndex == 0L && pageSize == 0L) {
            resultList.addAll(this.cacheForTable);
        }
    }

    private void processOrder(OrderInfo sortList) {
        if (null != sortList) {
            Collections.sort(this.cacheForTable, NormalAbnormalComparator.getComparatorByFieldName(sortList.getOrderField(), sortList.getOrderType()));
        }
    }
}

