/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.bistopn;

import com.hs.atic.analysis.report.flux.bistopn.BisFluxTopN;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.BisTopNForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class BisFluxTopNDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<BisFluxTopN> dataList = new ArrayList<BisFluxTopN>();
    private IDataStatService dataStatService;

    public List<BisFluxTopN> sortListByField(List<BisFluxTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<BisFluxTopN> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<BisFluxTopN> list = new ArrayList<BisFluxTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start BisFluxTopNDataSet prepareData");
        List<BisTopNForm> bisTopNFormList = null;
        Map<String, List<BisTopNForm>> allCollectorBisTopNForm = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            HashMap<Long, List<AticDevice>> collectDevMap = new HashMap<Long, List<AticDevice>>();
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorBisTopNForm = this.getSingleDeviceData(collectDevMap, datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                allCollectorBisTopNForm = this.getMultiDeviceData(currentLogUserId, datastatConditionForm);
                if (allCollectorBisTopNForm.isEmpty()) {
                    return 0;
                }
            }
            bisTopNFormList = datastatConditionForm.getAppType() == 1 ? this.getMaxData(allCollectorBisTopNForm, collectDevMap, datastatConditionForm) : (-2L == datastatConditionForm.getDeviceId() ? this.getAllDetectTopNForm(allCollectorBisTopNForm, datastatConditionForm.getTopn(), datastatConditionForm.getUnit(), false) : this.getTopNForm(allCollectorBisTopNForm, datastatConditionForm.getTopn(), datastatConditionForm.getUnit(), false));
            this.getFinalData(bisTopNFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("ZoneFluxTopNDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        this.logger.info((Object)"start BisFluxTopNDataSet prepareData");
        return 0;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (0L == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type");
        String type = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAttackType(Integer.parseInt(type));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type_combobox");
        String statType = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAppType(Integer.parseInt(statType));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unit = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setUnit(Integer.parseInt(unit));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
    }

    private Map<String, List<BisTopNForm>> getSingleDeviceData(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        ArrayList<AticDevice> tempList = new ArrayList<AticDevice>();
        tempList.add(firewall);
        collectDevMap.put(collectorInfo.getId(), tempList);
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        HashMap<String, List<BisTopNForm>> allCollectorBisTopNForm = new HashMap();
        try {
            allCollectorBisTopNForm = this.dataStatService.getBisFlux(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return allCollectorBisTopNForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Map<String, List<BisTopNForm>> getMultiDeviceData(Long currentLogUserId, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<BisTopNForm>> allCollectorBisTopNForm = new HashMap<String, List<BisTopNForm>>();
        List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMaps = ReportAnalysisUtil.getCollectDevMap(firewallList);
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMaps.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            String collectorIp = collector.getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getBisFlux(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
            }
            for (Map.Entry<Object, Object> entryTemp : tempMap.entrySet()) {
                if (allCollectorBisTopNForm.containsKey(entryTemp.getKey())) {
                    ((List)allCollectorBisTopNForm.get(entryTemp.getKey())).addAll((Collection)entryTemp.getValue());
                    continue;
                }
                allCollectorBisTopNForm.put((String)entryTemp.getKey(), (List<BisTopNForm>)entryTemp.getValue());
            }
        }
        return allCollectorBisTopNForm;
    }

    /*
     * WARNING - void declaration
     */
    private List<BisTopNForm> getMaxData(Map<String, List<BisTopNForm>> allCollectorBisTopNForm, Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        void var6_11;
        List<BisTopNForm> distinctForm = new ArrayList<BisTopNForm>();
        for (Map.Entry<String, List<BisTopNForm>> entry : allCollectorBisTopNForm.entrySet()) {
            distinctForm.addAll((Collection<BisTopNForm>)entry.getValue());
        }
        distinctForm = this.getDistinctMaxForm(distinctForm);
        HashMap<String, List<BisTopNForm>> maxAllForm = new HashMap<String, List<BisTopNForm>>();
        for (Long collectorId : collectDevMap.keySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(collectorId.longValue());
            if (null == collector) continue;
            String collectorIp = collector.getIpAddress();
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> temp = new HashMap();
            try {
                temp = this.dataStatService.getBisFlux(datastatConditionForm, collectorIp, distinctForm);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
            }
            if (temp.isEmpty()) continue;
            for (Map.Entry<Object, Object> entryTemp : temp.entrySet()) {
                if (maxAllForm.containsKey(entryTemp.getKey())) {
                    ((List)maxAllForm.get(entryTemp.getKey())).addAll((Collection)entryTemp.getValue());
                    continue;
                }
                maxAllForm.put((String)entryTemp.getKey(), (List<BisTopNForm>)entryTemp.getValue());
            }
        }
        Object var6_8 = null;
        if (-2L == datastatConditionForm.getDeviceId()) {
            List<BisTopNForm> list = this.getAllDetectTopNForm(maxAllForm, datastatConditionForm.getTopn(), datastatConditionForm.getUnit(), true);
        } else {
            List<BisTopNForm> list = this.getTopNForm(maxAllForm, datastatConditionForm.getTopn(), datastatConditionForm.getUnit(), true);
        }
        return var6_11;
    }

    private void getFinalData(List<BisTopNForm> bisTopNFormList) {
        HashMap<String, Integer> sameBizNameNum = new HashMap<String, Integer>();
        for (BisTopNForm form : bisTopNFormList) {
            ZoneInfoForm zoneForm = ReportBisUtil.getZoneService().getById(Long.valueOf(form.getZoneId()));
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                form.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone") + form.getZoneId());
            } else {
                form.setZoneName(zoneForm.getZoneDesc());
            }
            ZoneServiceForm serviceForm = ReportBisUtil.getZoneMgrNorthSerice().getBizTypeById(Long.valueOf(form.getBisId()));
            if (null != serviceForm) {
                String bisName = serviceForm.getServiceName();
                form.setBisName(bisName);
            } else {
                this.logger.info((Object)("the biz not exist,BisId = " + form.getBisId()));
                form.setBisName(AticUtil.getText((String)"atic.analysis.common.unknownBiz") + form.getBisId());
            }
            if (sameBizNameNum.containsKey(form.getBisName())) {
                int newNum = (Integer)sameBizNameNum.get(form.getBisName()) + 1;
                sameBizNameNum.put(form.getBisName(), newNum);
                continue;
            }
            sameBizNameNum.put(form.getBisName(), 1);
        }
        Set set = sameBizNameNum.entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer num = (Integer)entry.getValue();
            if (num > 1) continue;
            iter.remove();
        }
        this.processTopNData(bisTopNFormList, sameBizNameNum);
    }

    private void processTopNData(List<BisTopNForm> bisTopNFormList, Map<String, Integer> sameBizNameNum) {
        for (BisTopNForm form : bisTopNFormList) {
            BisFluxTopN data = new BisFluxTopN();
            data.setKbps(form.getKbps());
            data.setPps(form.getPps());
            data.setZoneName(form.getZoneName());
            if (sameBizNameNum.containsKey(form.getBisName()) && sameBizNameNum.get(form.getBisName()) > 0) {
                int tempNum = sameBizNameNum.get(form.getBisName());
                data.setBisName(form.getBisName() + "(" + tempNum + ")");
                sameBizNameNum.put(form.getBisName(), tempNum - 1);
            } else {
                data.setBisName(form.getBisName());
            }
            this.dataList.add(data);
        }
    }

    private List<BisTopNForm> getDistinctMaxForm(List<BisTopNForm> allForm) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (allForm.get(i).getBisId() != allForm.get(j).getBisId() || !allForm.get(i).getLogTime().equals(allForm.get(j).getLogTime())) continue;
                allForm.remove(j);
            }
        }
        return allForm;
    }

    private List<BisTopNForm> getAllDetectTopNForm(Map<String, List<BisTopNForm>> inputMap, int topn, int unit, boolean isMax) {
        List<BisTopNForm> distinctForm = new ArrayList<BisTopNForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<BisTopNForm> listForm = new ArrayList<BisTopNForm>();
            if (AticUtil.isNull((String)defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<BisTopNForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(!isMax ? this.getDistinctForm(listForm, defendGroupForm.getDetectMode(), unit) : this.getSameTimeDistinctForm(listForm, defendGroupForm.getDetectMode(), unit));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        if (!isMax) {
            distinctForm = this.getDistinctForm(distinctForm, 1, unit);
        } else {
            distinctForm = this.getSameTimeDistinctForm(distinctForm, 1, unit);
            distinctForm = this.getDistinctForm(distinctForm, 0, unit);
        }
        List<BisTopNForm> orderformList = null;
        orderformList = this.processDataSort(distinctForm, unit);
        this.processData4TopN(topn, orderformList);
        return distinctForm;
    }

    private void processData4TopN(int topn, List<BisTopNForm> distinctForm) {
        if (distinctForm.size() > topn) {
            for (int i = distinctForm.size() - 1; i >= topn; --i) {
                distinctForm.remove(i);
            }
        }
    }

    private List<BisTopNForm> getTopNForm(Map<String, List<BisTopNForm>> inputMap, int topn, int unit, boolean isMax) {
        List<BisTopNForm> formList = new ArrayList<BisTopNForm>();
        for (Map.Entry<String, List<BisTopNForm>> entry : inputMap.entrySet()) {
            formList.addAll((Collection<BisTopNForm>)entry.getValue());
        }
        if (!isMax) {
            formList = this.getDistinctForm(formList, 1, unit);
        } else {
            formList = this.getSameTimeDistinctForm(formList, 1, unit);
            formList = this.getDistinctForm(formList, 0, unit);
        }
        List<BisTopNForm> orderformList = null;
        orderformList = this.processDataSort(formList, unit);
        if (orderformList.size() > topn) {
            for (int i = orderformList.size() - 1; i >= topn; --i) {
                orderformList.remove(i);
            }
        }
        return orderformList;
    }

    private List<BisTopNForm> processDataSort(List<BisTopNForm> formList, int unit) {
        List<BisTopNForm> orderformList = new ArrayList<BisTopNForm>();
        if (null == formList || formList.isEmpty()) {
            return orderformList;
        }
        orderformList = formList;
        String orderName = "";
        orderName = unit == 0 ? "kbps" : "pps";
        orderformList = this.sortDataZoneTopNFormListByField(orderformList, orderName, "DESC");
        return orderformList;
    }

    private List<BisTopNForm> sortDataZoneTopNFormListByField(List<BisTopNForm> orderformList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(orderformList, comparator);
        return orderformList;
    }

    private List<BisTopNForm> getDistinctForm(List<BisTopNForm> allForm, int netMode, int unit) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (allForm.get(i).getBisId() != allForm.get(j).getBisId()) continue;
                this.dealWithSame(allForm, netMode, unit, i, j);
            }
        }
        return allForm;
    }

    private List<BisTopNForm> getSameTimeDistinctForm(List<BisTopNForm> allForm, int netMode, int unit) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (allForm.get(i).getBisId() != allForm.get(j).getBisId() || !allForm.get(i).getLogTime().equals(allForm.get(j).getLogTime())) continue;
                this.dealWithSame(allForm, netMode, unit, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<BisTopNForm> allForm, int netMode, int unit, int i, int j) {
        if (netMode == 0) {
            if (unit == 0) {
                if (allForm.get(i).getKbps() > allForm.get(j).getKbps()) {
                    allForm.get(i).setKbps(allForm.get(i).getKbps());
                    allForm.get(i).setPps(allForm.get(i).getPps());
                } else {
                    allForm.get(i).setKbps(allForm.get(j).getKbps());
                    allForm.get(i).setPps(allForm.get(j).getPps());
                }
            } else if (allForm.get(i).getPps() > allForm.get(j).getPps()) {
                allForm.get(i).setKbps(allForm.get(i).getKbps());
                allForm.get(i).setPps(allForm.get(i).getPps());
            } else {
                allForm.get(i).setKbps(allForm.get(j).getKbps());
                allForm.get(i).setPps(allForm.get(j).getPps());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setKbps(allForm.get(i).getKbps() + allForm.get(j).getKbps());
            allForm.get(i).setPps(allForm.get(i).getPps() + allForm.get(j).getPps());
            allForm.remove(j);
        }
    }
}

