/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.conncompare;

import com.hs.atic.analysis.report.flux.conncompare.ConnComparator;
import com.hs.atic.analysis.report.flux.conncompare.ConnCompare;
import com.hs.atic.analysis.report.flux.conncompare.ConnFormComparator;
import com.hs.atic.analysis.report.flux.conncompare.TransmitConnCompareData;
import com.hs.atic.analysis.report.integration.datasource.AllReportHaveDataCache;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.ConnCompareForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class ConnCompareDataSet
extends IJavaDataSource {
    private static final Long NUM_ONE_THOUSAND = 1000L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<ConnCompare> dataList = new ArrayList<ConnCompare>();
    private IDataStatService dataStatService;

    public List<ConnCompare> sortListByField(List<ConnCompare> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<ConnCompare> orderedList = null;
        orderedList = null != sortList ? this.sortListByField(this.dataList, sortList.getOrderField(), sortList.getOrderType()) : this.dataList;
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<ConnCompare> list = new ArrayList<ConnCompare>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        try {
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            Map<String, List<ConnCompareForm>> connCompareFormMap = null;
            if (datastatConditionForm.getDeviceId() > 0L) {
                connCompareFormMap = this.getSingleDeviceConn(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                connCompareFormMap = this.getMultiDeviceConn(currentLogUserId, datastatConditionForm);
            }
            List<ConnCompareForm> connCompareFormList = this.getConnCompareFormList(connCompareFormMap, datastatConditionForm);
            this.dataList = this.getConnCompareList(connCompareFormList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
            String isNeedTransmitChartData = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
            if (!AticUtil.isNull((String)isNeedTransmitChartData) && isNeedTransmitChartData.equalsIgnoreCase("true")) {
                if (null != this.dataList && !this.dataList.isEmpty()) {
                    AllReportHaveDataCache.getInstance().addDataList("ConnCompare", sessionId);
                }
            } else {
                List<ConnCompare> resultForTable;
                if (null == datastatConditionForm.getTopn()) {
                    resultForTable = this.dataList;
                } else {
                    ArrayList<ConnCompare> connList = new ArrayList<ConnCompare>(this.dataList);
                    int length = connList.size();
                    if (length > datastatConditionForm.getTopn()) {
                        length = datastatConditionForm.getTopn();
                    }
                    Collections.sort(connList, new ConnComparator("currentConn", "DESC"));
                    resultForTable = connList.subList(0, length);
                }
                TransmitConnCompareData.getInstance().addConnDataList(new ArrayList<ConnCompare>(resultForTable), sessionId);
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("ConnCompareDataSet prepareData happened exception !" + e.getMessage()));
        }
        return 0;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        String ipType;
        List<JsonValueItem> jsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "switchOption");
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String zoneId = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        if (null != jsonValueItemList && !jsonValueItemList.isEmpty() && !"0".equals(zoneId = String.valueOf(jsonValueItemList.get(0).getValue()))) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        }
        if (null == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        String bisId = String.valueOf(jsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        String zoneIp = String.valueOf(jsonValueItemList.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type_combobox");
        String type = String.valueOf(jsonValueItemList.get(0).getValue());
        datastatConditionForm.setAppType(Integer.parseInt(type));
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItemList.get(0).getValue());
        if (!AticUtil.isNull((String)topn)) {
            datastatConditionForm.setTopn(Integer.parseInt(topn));
        }
        if (AticUtil.isNull((String)(ipType = String.valueOf((jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "ipType")).get(0).getValue())))) {
            ipType = "0";
        }
        datastatConditionForm.setAttackType(Integer.parseInt(ipType));
    }

    public String processBizParam(Long bizId) {
        String bizType;
        if (0L == bizId) {
            bizType = "";
        } else {
            IZoneMgrNorthSerice zoneMgrNorthSerice = ReportAnalysisUtil.getZoneMgrNorthSerice();
            bizType = zoneMgrNorthSerice.getBizTypeById(bizId).getProtocol();
        }
        return bizType;
    }

    private List<ConnCompareForm> getConnCompareFormList(Map<String, List<ConnCompareForm>> connCompareFormMap, DataStatConditionForm datastatConditionForm) {
        List<ConnCompareForm> connFormList = new ArrayList<ConnCompareForm>();
        if (null == connCompareFormMap) {
            return connFormList;
        }
        connFormList = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectConnForm(connCompareFormMap) : this.getConnForm(connCompareFormMap);
        return connFormList;
    }

    private Map<String, List<ConnCompareForm>> getSingleDeviceConn(DataStatConditionForm datastatConditionForm) {
        Map<String, List<ConnCompareForm>> singleDeviceConnMap = new HashMap<String, List<ConnCompareForm>>();
        AticDevice firewall = ReportBisUtil.getIFirewallService().getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            return singleDeviceConnMap;
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            singleDeviceConnMap = this.processDeviceData4ServiceGroup(datastatConditionForm, this.dataStatService.getConnCompare(datastatConditionForm, collectorInfo.getIpAddress()));
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return singleDeviceConnMap;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Map<String, List<ConnCompareForm>> processDeviceData4ServiceGroup(DataStatConditionForm datastatConditionForm, Map<String, List<ConnCompareForm>> allDeviceConnMap) {
        HashMap<String, List<ConnCompareForm>> returnDeviceConnMap = new HashMap<String, List<ConnCompareForm>>();
        if (0 == datastatConditionForm.getAttackType()) {
            for (Map.Entry<String, List<ConnCompareForm>> temp : allDeviceConnMap.entrySet()) {
                List<ConnCompareForm> tempList = this.getConnCompareList4ServiceGroup(temp.getValue());
                returnDeviceConnMap.put(temp.getKey(), tempList);
            }
            return returnDeviceConnMap;
        }
        return allDeviceConnMap;
    }

    private Map<String, List<ConnCompareForm>> getMultiDeviceConn(Long currentLogUserId, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<ConnCompareForm>> multiDeviceConnMap = new HashMap<String, List<ConnCompareForm>>();
        List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            String collectorIp = collector.getIpAddress();
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<String, List<ConnCompareForm>> tempMap = null;
            try {
                tempMap = this.processDeviceData4ServiceGroup(datastatConditionForm, this.dataStatService.getConnCompare(datastatConditionForm, collectorIp));
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
            }
            if (null == tempMap || tempMap.isEmpty()) continue;
            multiDeviceConnMap.putAll(tempMap);
        }
        return multiDeviceConnMap;
    }

    private List<ConnCompareForm> getConnForm(Map<String, List<ConnCompareForm>> connCompareFormMap) {
        if (null == connCompareFormMap) {
            return new ArrayList<ConnCompareForm>();
        }
        ArrayList<ConnCompareForm> connCompareFormList = new ArrayList<ConnCompareForm>();
        for (Map.Entry<String, List<ConnCompareForm>> entry : connCompareFormMap.entrySet()) {
            connCompareFormList.addAll((Collection<ConnCompareForm>)entry.getValue());
        }
        return connCompareFormList;
    }

    private List<ConnCompareForm> getAllDetectConnForm(Map<String, List<ConnCompareForm>> connCompareFormMap) {
        ArrayList<ConnCompareForm> distinctFormList = new ArrayList<ConnCompareForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<ConnCompareForm> listForm = new ArrayList<ConnCompareForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!connCompareFormMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<ConnCompareForm>)connCompareFormMap.get(devIp));
                connCompareFormMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctFormList.addAll(this.getDistinctForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : connCompareFormMap.entrySet()) {
            distinctFormList.addAll((Collection)entry.getValue());
        }
        return distinctFormList;
    }

    private List<ConnCompareForm> getDistinctForm(List<ConnCompareForm> listForm, int detectMode) {
        if (detectMode == 0) {
            return this.processRedunData(listForm);
        }
        if (detectMode == 1) {
            return this.processBalanData(listForm);
        }
        return new ArrayList<ConnCompareForm>();
    }

    private List<ConnCompareForm> processBalanData(List<ConnCompareForm> listForm) {
        ArrayList<ConnCompareForm> result = new ArrayList<ConnCompareForm>();
        Collections.sort(listForm, new ConnFormComparator("logTime"));
        ListIterator<ConnCompareForm> iter = listForm.listIterator();
        int endIndex = 0;
        block0: while (iter.hasNext()) {
            ConnCompareForm tempForm = new ConnCompareForm();
            ConnCompareForm first = iter.next();
            int startIndex = endIndex;
            if (!iter.hasNext()) {
                result.add(first);
            }
            while (iter.hasNext()) {
                boolean isEqual = iter.next().getLogTime().equals(first.getLogTime());
                if (isEqual) {
                    ++endIndex;
                    if (iter.hasNext()) continue;
                }
                List<ConnCompareForm> subList = listForm.subList(startIndex, endIndex + 1);
                long increaseConn = 0L;
                long currentConn = 0L;
                for (ConnCompareForm form : subList) {
                    increaseConn += form.getIncreaseConn().longValue();
                    currentConn += form.getCurrentConn().longValue();
                }
                tempForm.setLogTime(subList.get(0).getLogTime());
                tempForm.setIncreaseConn(increaseConn);
                tempForm.setCurrentConn(currentConn);
                result.add(tempForm);
                if (isEqual) continue block0;
                ++endIndex;
                iter = listForm.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return result;
    }

    private List<ConnCompareForm> processRedunData(List<ConnCompareForm> listForm) {
        ArrayList<ConnCompareForm> result = new ArrayList<ConnCompareForm>();
        Collections.sort(listForm, new ConnFormComparator("logTime"));
        ListIterator<ConnCompareForm> iter = listForm.listIterator();
        int endIndex = 0;
        block0: while (iter.hasNext()) {
            ConnCompareForm tempForm = new ConnCompareForm();
            ConnCompareForm first = iter.next();
            int startIndex = endIndex;
            if (!iter.hasNext()) {
                result.add(first);
            }
            while (iter.hasNext()) {
                boolean isEqual = iter.next().getLogTime().equals(first.getLogTime());
                if (isEqual) {
                    ++endIndex;
                    if (iter.hasNext()) continue;
                }
                List<ConnCompareForm> subList = listForm.subList(startIndex, endIndex + 1);
                tempForm.setLogTime(subList.get(0).getLogTime());
                Collections.sort(subList, new ConnFormComparator("increaseConn"));
                tempForm.setIncreaseConn(subList.get(0).getIncreaseConn());
                Collections.sort(subList, new ConnFormComparator("currentConn"));
                tempForm.setCurrentConn(subList.get(0).getCurrentConn());
                result.add(tempForm);
                if (isEqual) continue block0;
                ++endIndex;
                iter = listForm.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return result;
    }

    private List<ConnCompareForm> getConnCompareList4ServiceGroup(List<ConnCompareForm> connCompareFormList) {
        if (null != connCompareFormList && !connCompareFormList.isEmpty()) {
            for (int i = 0; i < connCompareFormList.size(); ++i) {
                for (int j = connCompareFormList.size() - 1; j > i; --j) {
                    if (!connCompareFormList.get(i).getLogTime().equals(connCompareFormList.get(j).getLogTime())) continue;
                    long increaseConn = connCompareFormList.get(i).getIncreaseConn() + connCompareFormList.get(j).getIncreaseConn();
                    long currentConn = connCompareFormList.get(i).getCurrentConn() + connCompareFormList.get(j).getCurrentConn();
                    connCompareFormList.get(i).setIncreaseConn(increaseConn);
                    connCompareFormList.get(i).setCurrentConn(currentConn);
                    connCompareFormList.remove(j);
                }
            }
        } else {
            connCompareFormList = new ArrayList<ConnCompareForm>();
        }
        return connCompareFormList;
    }

    private List<ConnCompare> getConnCompareList(List<ConnCompareForm> connCompareFormList, long startTime, long endTime) {
        long currentConn;
        long increaseConn;
        ArrayList<ConnCompare> connCompareList = new ArrayList<ConnCompare>();
        if (null == connCompareFormList || connCompareFormList.isEmpty()) {
            this.logger.info((Object)"No data, connCompareList is empty !");
            return connCompareList;
        }
        HashMap<Long, ConnCompareForm> connCompareMap = new HashMap<Long, ConnCompareForm>();
        for (ConnCompareForm connCompareForm : connCompareFormList) {
            Long logTime = connCompareForm.getLogTime();
            if (connCompareMap.containsKey(logTime)) {
                ConnCompareForm tempForm = (ConnCompareForm)connCompareMap.get(logTime);
                increaseConn = tempForm.getIncreaseConn() + connCompareForm.getIncreaseConn();
                currentConn = tempForm.getCurrentConn() + connCompareForm.getCurrentConn();
                tempForm.setIncreaseConn(increaseConn);
                tempForm.setCurrentConn(currentConn);
                connCompareMap.put(logTime, tempForm);
                continue;
            }
            connCompareMap.put(logTime, connCompareForm);
        }
        for (Map.Entry entry : connCompareMap.entrySet()) {
            ConnCompare connCompare = new ConnCompare();
            Long logTime = (Long)entry.getKey();
            increaseConn = ((ConnCompareForm)entry.getValue()).getIncreaseConn();
            currentConn = ((ConnCompareForm)entry.getValue()).getCurrentConn();
            connCompare.setLogTime(logTime * 1000L);
            connCompare.setIncreaseConn(increaseConn);
            connCompare.setCurrentConn(currentConn);
            connCompare.setIncreaseConnStr(this.formatLongToStr(increaseConn));
            connCompare.setCurrentConnStr(this.formatLongToStr(currentConn));
            connCompareList.add(connCompare);
        }
        List<ConnCompare> filledCompareList = this.fillAllTimeData(connCompareList, startTime, endTime);
        Collections.sort(filledCompareList, new ConnComparator("logTime", "ASC"));
        return filledCompareList;
    }

    private List<ConnCompare> fillAllTimeData(List<ConnCompare> connCompareList, long startTime, long endTime) {
        ArrayList<ConnCompare> listConnCompare = new ArrayList<ConnCompare>(connCompareList);
        startTime = ReportAnalysisUtil.getRealStartTime(startTime, endTime);
        long timeSlot = this.getTimeSlot(startTime, endTime);
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < connCompareList.size(); ++i) {
            ConnCompare form = connCompareList.get(i);
            if (i == 0) {
                minTime = form.getLogTime();
                maxTime = form.getLogTime();
                continue;
            }
            if (form.getLogTime() < minTime) {
                minTime = form.getLogTime();
            }
            if (form.getLogTime() <= maxTime) continue;
            maxTime = form.getLogTime();
        }
        while (minTime <= maxTime) {
            boolean hasData = false;
            for (ConnCompare form : connCompareList) {
                if (form.getLogTime() != minTime.longValue()) continue;
                hasData = true;
                break;
            }
            if (!hasData) {
                ConnCompare tempForm = new ConnCompare();
                tempForm.setLogTime(minTime);
                tempForm.setIncreaseConn(0L);
                tempForm.setCurrentConn(0L);
                tempForm.setIncreaseConnStr(String.valueOf(0));
                tempForm.setCurrentConnStr(String.valueOf(0));
                listConnCompare.add(tempForm);
            }
            minTime = minTime + timeSlot;
        }
        return listConnCompare;
    }

    private long getTimeSlot(long startTime, long endTime) {
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        if (type == AnalysisConstants.LESS_THAN_SEVEN_DAYS) {
            return 3600L * NUM_ONE_THOUSAND;
        }
        if (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS) {
            return 86400L * NUM_ONE_THOUSAND;
        }
        return 300L * NUM_ONE_THOUSAND;
    }

    private String formatLongToStr(long conn) {
        int comma = 0;
        String connStr = null;
        try {
            connStr = String.valueOf(conn);
        }
        catch (Exception e) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int length = connStr.length();
        comma = length % 3 == 0 ? length / 3 - 1 : length / 3;
        int len = length - comma * 3;
        for (int i = 0; i <= comma; ++i) {
            if (i == 0) {
                buffer.append(connStr.substring(0, len));
                buffer.append(',');
                continue;
            }
            buffer.append(connStr.substring(len + (i - 1) * 3, len + i * 3));
            buffer.append(',');
        }
        connStr = buffer.substring(0, buffer.length() - 1);
        return connStr;
    }
}

