/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.flowcompare;

import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareComparator;
import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareView;
import com.hs.atic.analysis.report.flux.flowcompare.TransmitFlowCompareDataPPS4Integration;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.logserver.module.condition.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class FlowCompareChartPPS4Integration
extends IJavaDataSource {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AticDevice> firewallList;
    private Map<String, List<String>> collectorDeviceMap = new HashMap<String, List<String>>();
    private FlowCompareConditionForm flowCompareConditionForm;
    private boolean isAllDetect;
    private Map<?, ?> queryCond4Security;
    private DataStatConditionForm datastatConditionForm = new DataStatConditionForm();

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        try {
            this.queryCond4Security = queryCond;
            this.flowCompareConditionForm = this.beforeQuery(queryCond, sessionId);
        }
        catch (LegoCheckedException legoException) {
            logger.error((Object)("FlowCompareChartDataSet prepareData() unknow exception!" + legoException.getMessage()));
            throw legoException;
        }
        catch (Exception e) {
            logger.error((Object)("FlowCompareChartDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        return 0;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        logger.info((Object)"start flowCompare fetchData");
        ArrayList<FlowCompareView> resultList = new ArrayList<FlowCompareView>();
        try {
            List<FlowCompareForm> allList = this.queryFlowCompare(this.flowCompareConditionForm, sessionId);
            for (FlowCompareForm flowCompareForm : allList) {
                resultList.add((FlowCompareView)ReportAnalysisUtil.copyProperties(flowCompareForm, new FlowCompareView()));
            }
        }
        catch (LegoCheckedException legoException) {
            TransmitFlowCompareDataPPS4Integration.getInstance().removeData(sessionId);
            resultList.clear();
            logger.error((Object)("FlowCompareChartDataSet fetchData() LegoCheckedException :" + legoException.getErrorCode()));
        }
        catch (Exception e) {
            TransmitFlowCompareDataPPS4Integration.getInstance().removeData(sessionId);
            resultList.clear();
            logger.error((Object)("FlowCompareChartDataSet fetchData() unknow exception!" + e.getMessage()));
        }
        logger.info((Object)"end flowCompare fetchData");
        return resultList;
    }

    private List<FlowCompareForm> queryFlowCompare(FlowCompareConditionForm flowCompareConditionForms, long sessionId) {
        IDataStatService dataStatService = ReportAnalysisUtil.getDataStatService();
        List<FlowCompareForm> flowCompareList = null;
        ArrayList<FlowCompareForm> allList = new ArrayList<FlowCompareForm>();
        if (!ReportAnalysisUtil.checkDeviceAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, flowCompareConditionForms.getTimeSpanType(), sessionId);
        }
        if (!ReportAnalysisUtil.checkZoneAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, flowCompareConditionForms.getTimeSpanType(), sessionId);
        }
        Boolean needQuery = this.checkNeedQuery(flowCompareConditionForms);
        if (!needQuery.booleanValue()) {
            return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, flowCompareConditionForms.getTimeSpanType(), sessionId);
        }
        for (Map.Entry<String, List<String>> entry : this.collectorDeviceMap.entrySet()) {
            flowCompareConditionForms.setDeviceIpList(entry.getValue());
            try {
                flowCompareList = dataStatService.queryFlowCompare(flowCompareConditionForms, entry.getKey());
                allList.addAll(flowCompareList);
            }
            catch (Exception e) {
                logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
            }
        }
        return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, flowCompareConditionForms.getTimeSpanType(), sessionId);
    }

    private Boolean checkNeedQuery(FlowCompareConditionForm flowCompareConditionForms) {
        Boolean queryTypeIsDevice = this.chekcQueryTypeIsDevice(flowCompareConditionForms);
        if (!queryTypeIsDevice.booleanValue() && null != flowCompareConditionForms.getSessionId() && flowCompareConditionForms.getZoneIdList().isEmpty()) {
            return false;
        }
        return true;
    }

    private Boolean chekcQueryTypeIsDevice(FlowCompareConditionForm flowCompareConditionForms) {
        Boolean queryTypeDevice = false;
        if (0L == flowCompareConditionForms.getZoneId() && null == flowCompareConditionForms.getZoneIp() && -1 == flowCompareConditionForms.getBizType()) {
            queryTypeDevice = true;
        }
        return queryTypeDevice;
    }

    private List<FlowCompareForm> processResult(List<List<String>> firewallIpList, List<FlowCompareForm> allList, int timeType, long sessionId) {
        List<FlowCompareForm> result = this.isAllDetect ? this.processRedundancyAndAdd(firewallIpList, allList) : this.processAdd(allList);
        List<FlowCompareForm> resultForTable = result;
        TransmitFlowCompareDataPPS4Integration.getInstance().addDataList(new ArrayList<FlowCompareForm>(resultForTable), sessionId);
        this.fillContinuousTime(result, 0, 1, ReportAnalysisUtil.getGapTime(timeType));
        return result;
    }

    public List<FlowCompareForm> processRedundancyAndAdd(List<List<String>> ipList, List<FlowCompareForm> flowCompareFormList) {
        ArrayList<FlowCompareForm> result = new ArrayList<FlowCompareForm>();
        for (List<String> ips : ipList) {
            ArrayList<FlowCompareForm> allList = new ArrayList<FlowCompareForm>(flowCompareFormList);
            allList.retainAll(ips);
            flowCompareFormList.removeAll(allList);
            result.addAll(this.processRedundancy0(allList));
        }
        result.addAll(flowCompareFormList);
        return this.processAdd(result);
    }

    private List<FlowCompareForm> processRedundancy0(List<FlowCompareForm> allList) {
        ArrayList<FlowCompareForm> result = new ArrayList<FlowCompareForm>();
        Collections.sort(allList, FlowCompareComparator.getComparatorByFieldName("logTime", "asc"));
        ListIterator<FlowCompareForm> iter = allList.listIterator();
        int endIndex = 0;
        block0: while (iter.hasNext()) {
            FlowCompareForm first = iter.next();
            int startIndex = endIndex;
            if (!iter.hasNext()) {
                result.add(first);
            }
            while (iter.hasNext()) {
                boolean isEqual;
                boolean bl = isEqual = iter.next().getLogTime() == first.getLogTime();
                if (isEqual) {
                    ++endIndex;
                    if (iter.hasNext()) continue;
                }
                List<FlowCompareForm> subList = allList.subList(startIndex, endIndex + 1);
                Collections.sort(subList, FlowCompareComparator.getComparatorByFieldName("inFlow", "desc"));
                result.add(subList.get(0));
                if (isEqual) continue block0;
                ++endIndex;
                iter = allList.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return result;
    }

    private List<FlowCompareForm> processAdd(List<FlowCompareForm> flowCompareList) {
        Collections.sort(flowCompareList, FlowCompareComparator.getComparatorByFieldName("logTime", "asc"));
        ListIterator<FlowCompareForm> iter = flowCompareList.listIterator();
        block0: while (iter.hasNext()) {
            FlowCompareForm first = iter.next();
            while (iter.hasNext()) {
                FlowCompareForm next = iter.next();
                if (next.getLogTime() == first.getLogTime()) {
                    first.setAttackFlow(first.getAttackFlow() + next.getAttackFlow());
                    first.setInFlow(first.getInFlow() + next.getInFlow());
                    first.setMaxAttackFlow(first.getMaxAttackFlow() + next.getMaxAttackFlow());
                    first.setMaxInFlow(first.getMaxInFlow() + next.getMaxInFlow());
                    first.setOutFlow(first.getOutFlow() + next.getOutFlow());
                    if (null != first.getReboundFlow()) {
                        first.setReboundFlow(first.getReboundFlow() + next.getReboundFlow());
                    }
                    iter.remove();
                    continue;
                }
                iter = flowCompareList.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return flowCompareList;
    }

    protected void fillContinuousTime(List<FlowCompareForm> flowCompareFormList, int first, int next, int timeSpan) {
        if (next < flowCompareFormList.size()) {
            FlowCompareForm firstForm = flowCompareFormList.get(first);
            FlowCompareForm nextForm = flowCompareFormList.get(next);
            long timeGap = nextForm.getLogTime() - firstForm.getLogTime();
            if (timeGap > (long)timeSpan) {
                ArrayList<FlowCompareForm> flowCompareFormListGap = new ArrayList<FlowCompareForm>();
                int i = 1;
                while ((long)i < timeGap / (long)timeSpan) {
                    FlowCompareForm flowCompareFormGap = new FlowCompareForm();
                    flowCompareFormGap.setLogTime(firstForm.getLogTime() + (long)timeSpan);
                    flowCompareFormGap.setInFlow(0L);
                    flowCompareFormGap.setOutFlow(0L);
                    flowCompareFormGap.setAttackFlow(0L);
                    flowCompareFormGap.setMaxInFlow(0L);
                    flowCompareFormGap.setMaxAttackFlow(0L);
                    flowCompareFormGap.setReboundFlow(0L);
                    firstForm = flowCompareFormGap;
                    flowCompareFormListGap.add(flowCompareFormGap);
                    ++i;
                }
                flowCompareFormList.addAll(next, flowCompareFormListGap);
                int nextIndex = ++first + flowCompareFormListGap.size();
                this.fillContinuousTime(flowCompareFormList, nextIndex, nextIndex + 1, timeSpan);
            } else {
                this.fillContinuousTime(flowCompareFormList, ++first, ++next, timeSpan);
            }
        }
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return 0L;
    }

    private FlowCompareConditionForm beforeQuery(Map<?, ?> queryCond, Long sessionId) {
        this.valiateParams(queryCond);
        return this.processQueryCondition(queryCond, sessionId);
    }

    private FlowCompareConditionForm processQueryCondition(Map<?, ?> queryCond, Long sessionId) {
        FlowCompareConditionForm flowCompareConditionForms = new FlowCompareConditionForm();
        String deviceId = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox").get(0).getValue();
        Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
        this.processDeviceParam(deviceId, flowCompareConditionForms, currentLogUserId);
        Long zoneId = Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox").get(0).getValue());
        flowCompareConditionForms.setZoneId(zoneId);
        ReportAnalysisUtil.processDeviceInfo(this.datastatConditionForm, deviceId);
        this.datastatConditionForm.setZoneId(zoneId);
        String bizId = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox").get(0).getValue();
        if (AticUtil.isNull((String)bizId)) {
            bizId = "0";
        }
        ReportAnalysisUtil.processServiceCond(flowCompareConditionForms, bizId);
        String zoneIp = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip").get(0).getValue();
        flowCompareConditionForms.setZoneIp(AticUtil.isNull((String)zoneIp) || "0".equals(zoneIp) ? null : zoneIp);
        ReportAnalysisUtil.processTimeParams(queryCond, flowCompareConditionForms);
        int protocol = Integer.parseInt("0");
        if (!AticUtil.isNull((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "protocol_combobox").get(0).getValue())) {
            protocol = Integer.parseInt(ReportAnalysisUtil.getJsonValueItemList(queryCond, "protocol_combobox").get(0).getValue());
        }
        flowCompareConditionForms.setProtocol(protocol);
        this.processBizParam(deviceId, flowCompareConditionForms);
        flowCompareConditionForms.setUnit(1);
        String topn = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN").get(0).getValue());
        if (!AticUtil.isNull((String)topn)) {
            flowCompareConditionForms.setTopn(Integer.parseInt(topn));
        }
        Boolean queryTypeIsDevice = this.chekcQueryTypeIsDevice(flowCompareConditionForms);
        if (0L == flowCompareConditionForms.getZoneId() && !queryTypeIsDevice.booleanValue()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, deviceId, flowCompareConditionForms, sessionId);
        }
        return flowCompareConditionForms;
    }

    private Boolean checkDeviceIsV1(String deviceId) {
        if (!AticUtil.isNull((String)deviceId) && deviceId.contains("_")) {
            String[] dev = deviceId.split("_");
            deviceId = dev[0];
        }
        Long deviceIdLong = Long.parseLong(deviceId);
        Boolean v1 = false;
        if (deviceIdLong > 0L) {
            AticDevice firewall = ReportBisUtil.getIFirewallService().getDeviceByMoid(deviceIdLong.longValue());
            v1 = ReportAnalysisUtil.isV1(firewall);
        }
        return v1;
    }

    private void processBizParam(String deviceId, FlowCompareConditionForm flowCompareConditionForms) {
        Map<String, List<Long>> serviceIds;
        int protocol = flowCompareConditionForms.getProtocol();
        if (0 == protocol) {
            return;
        }
        if (null != flowCompareConditionForms.getIsServiceGroup() && flowCompareConditionForms.getIsServiceGroup().booleanValue() && null != (serviceIds = flowCompareConditionForms.getServiceIds()) && !serviceIds.isEmpty()) {
            Boolean v1 = this.checkDeviceIsV1(deviceId);
            List<String> removeKeyList = this.getRemoveKey(v1, flowCompareConditionForms);
            for (String key : removeKeyList) {
                if (!serviceIds.containsKey(key)) continue;
                serviceIds.remove(key);
            }
        }
    }

    private List<String> getRemoveKey(Boolean v1, FlowCompareConditionForm flowCompareConditionForms) {
        ArrayList<String> removeKeyList = new ArrayList<String>();
        String protocol = flowCompareConditionForms.getProtocol().toString();
        String zoneId = flowCompareConditionForms.getZoneId().toString();
        String displayZoneIp = null == flowCompareConditionForms.getZoneIp() ? "" : flowCompareConditionForms.getZoneIp();
        for (Map.Entry<String, List<Long>> entry : flowCompareConditionForms.getServiceIds().entrySet()) {
            List<Object> temp = new ArrayList<Pair>();
            if ("DEFAULT".equalsIgnoreCase(entry.getKey())) {
                temp = ReportAnalysisUtil.processDafaultBizPro(v1, zoneId, displayZoneIp);
            } else if (v1.booleanValue()) {
                temp.add(new Pair((Object)AnalysisConstants.getBizToId().get(entry.getKey()), (Object)entry.getKey()));
            } else {
                temp = ReportAnalysisUtil.getBizType2ProtocolTypeMap(v1).get(AnalysisConstants.getBizToId().get(entry.getKey()));
            }
            ArrayList<Object> protocolList = new ArrayList<Object>();
            for (Pair pair : temp) {
                protocolList.add(pair.getKey());
            }
            if (protocolList.isEmpty() || protocolList.contains(protocol)) continue;
            removeKeyList.add(entry.getKey());
        }
        return removeKeyList;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    private void valiateParams(Map<?, ?> queryCond) {
        if (null == queryCond) {
            logger.error((Object)"map is empty !");
        }
    }

    public void processDeviceParam(String deviceId, FlowCompareConditionForm flowCompareConditionForms, Long currentLogUserId) {
        this.firewallList = ReportAnalysisUtil.processDeviceParam(deviceId, flowCompareConditionForms, currentLogUserId);
        this.isAllDetect = ReportAnalysisUtil.isAllDetect(deviceId);
        if (this.firewallList.isEmpty()) {
            logger.error((Object)"query flowcompare error, no devices exist!");
        } else {
            ReportAnalysisUtil.generateCollectorDeviceMap(deviceId, this.firewallList, this.collectorDeviceMap);
        }
    }
}

