/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.fluxdistribute;

import com.hs.atic.analysis.report.flux.fluxdistribute.FluxDistribute;
import com.hs.atic.analysis.report.flux.fluxdistribute.TransmitFluxDistributeData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class InTabFluxDistributeDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<FluxDistribute> dataList = new ArrayList<FluxDistribute>();

    public List<FluxDistribute> sortListByField(List<FluxDistribute> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<FluxDistribute> orderedList = null;
        orderedList = null != sortList ? this.sortListByField(this.dataList, sortList.getOrderField(), sortList.getOrderType()) : this.dataList;
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<FluxDistribute> list = new ArrayList<FluxDistribute>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"begin prepareData !");
        List<FluxDistribute> tableFlowList = null;
        try {
            tableFlowList = TransmitFluxDistributeData.getInstance().getInFluxDataList(sessionId);
            TransmitFluxDistributeData.getInstance().removeInFluxData(sessionId);
            this.getInFluxDisOfAllType(tableFlowList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("InTabFluxDistributeDataSet prepareData happened exception !" + e.getMessage()));
        }
        return 0;
    }

    private void getInFluxDisOfAllType(List<FluxDistribute> tableFlowList) {
        if (null == tableFlowList || tableFlowList.isEmpty()) {
            this.logger.info((Object)"getInFlowTableData is empty!");
            return;
        }
        long totalFlow = 0L;
        double totalPercent = 0.0;
        FluxDistribute total = new FluxDistribute();
        FluxDistribute tcp = new FluxDistribute();
        FluxDistribute udp = new FluxDistribute();
        FluxDistribute icmp = new FluxDistribute();
        FluxDistribute other = new FluxDistribute();
        for (FluxDistribute flux : tableFlowList) {
            totalFlow += flux.getFlow();
            totalPercent += flux.getPercent();
            if ("TCP".equalsIgnoreCase(flux.getProtocolType())) {
                ReportAnalysisUtil.copyProperties(flux, tcp);
                tcp.setFlowStr(String.valueOf(flux.getFlow()));
                tcp.setPercentStr(flux.getPercent() + "%");
                continue;
            }
            if ("UDP".equalsIgnoreCase(flux.getProtocolType())) {
                ReportAnalysisUtil.copyProperties(flux, udp);
                udp.setFlowStr(String.valueOf(flux.getFlow()));
                udp.setPercentStr(flux.getPercent() + "%");
                continue;
            }
            if ("ICMP".equalsIgnoreCase(flux.getProtocolType())) {
                ReportAnalysisUtil.copyProperties(flux, icmp);
                icmp.setFlowStr(String.valueOf(flux.getFlow()));
                icmp.setPercentStr(flux.getPercent() + "%");
                continue;
            }
            if (!"OTHER".equalsIgnoreCase(flux.getProtocolType())) continue;
            ReportAnalysisUtil.copyProperties(flux, other);
            other.setFlowStr(String.valueOf(flux.getFlow()));
            other.setPercentStr(flux.getPercent() + "%");
        }
        if (totalFlow == 0L) {
            return;
        }
        this.processDataPercentContent(other, icmp, udp, tcp, totalPercent);
        total.setProtocolType("TOTAL");
        total.setFlow(totalFlow);
        total.setFlowStr(String.valueOf(totalFlow));
        total.setPercent(this.formatPercent(1.0));
        total.setPercentStr(this.formatPercent(1.0) + "%");
        this.dataList.add(total);
        this.dataList.add(tcp);
        this.dataList.add(udp);
        this.dataList.add(icmp);
        this.dataList.add(other);
    }

    private void processDataPercentContent(FluxDistribute other, FluxDistribute icmp, FluxDistribute udp, FluxDistribute tcp, double totalPercent) {
        double percent = 0.0;
        if (other.getPercent() > 0.0) {
            percent = this.formatPercent(1.0 + (other.getPercent() - totalPercent) / 100.0);
            other.setPercent(percent);
            other.setPercentStr(percent + "%");
        } else if (icmp.getPercent() > 0.0) {
            percent = this.formatPercent(1.0 + (icmp.getPercent() - totalPercent) / 100.0);
            icmp.setPercent(percent);
            icmp.setPercentStr(percent + "%");
        } else if (udp.getPercent() > 0.0) {
            percent = this.formatPercent(1.0 + (udp.getPercent() - totalPercent) / 100.0);
            udp.setPercent(percent);
            udp.setPercentStr(percent + "%");
        } else if (tcp.getPercent() > 0.0) {
            percent = this.formatPercent(1.0 + (tcp.getPercent() - totalPercent) / 100.0);
            tcp.setPercent(percent);
            tcp.setPercentStr(percent + "%");
        }
    }

    private double formatPercent(double percent) {
        long tmp = Math.round(percent * 1000.0);
        double base = 10.0;
        return (double)tmp / base;
    }
}

