/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.highFlowPrevention;

import com.hs.atic.analysis.report.flux.highFlowPrevention.DefenseReportResult;
import com.hs.atic.analysis.report.flux.highFlowPrevention.HighFlowPreventionDistribute;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.highdefense.domain.model.form.DefenseConfigForm;
import com.hs.atic.highdefense.domain.service.IDefenseConfigService;
import com.hs.atic.highdefense.util.RestInvoker;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.restful.util.JSONUtil;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.struts2.ServletActionContext;

public class HighFlowPreventionDataSet
extends IJavaDataSource {
    private List<HighFlowPreventionDistribute> dataList = new ArrayList<HighFlowPreventionDistribute>();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return 0;
    }

    public void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, long sessionId) {
        List<JsonValueItem> jsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        String zoneIp = String.valueOf(jsonValueItemList.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
    }

    public void getResultFromDefense(DataStatConditionForm condition) {
        IDefenseConfigService defenseConfigService = ReportBisUtil.getDefenseConfigService();
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        User user = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        conditionMap.put("userId", String.valueOf(user.getUserID()));
        conditionMap.put("isAdmin", user.getIsAdmin());
        conditionMap.put("ips", condition.getZoneIp());
        List defenseConfig = defenseConfigService.queryDefenseConfigsByIp(conditionMap);
        if (null == defenseConfig || defenseConfig.isEmpty()) {
            return;
        }
        int bandwidth = ((DefenseConfigForm)defenseConfig.get(0)).getDefenseBindwidth();
        try {
            HashMap<String, Number> mapForDefense = new HashMap<String, Number>();
            mapForDefense.put("start_time", condition.getStartTime() * 1000L);
            mapForDefense.put("end_time", condition.getEndTime() * 1000L);
            mapForDefense.put("limit", 500);
            mapForDefense.put("offset", 5);
            this.logger.info((Object)"--------start calling interface(defense switching history)-----");
            String result = "";
            result = !defenseConfigService.isDefenseIndependentAccount() ? RestInvoker.get((String)("/v1/{domain_id}/dpp/ipnodes/" + ((DefenseConfigForm)defenseConfig.get(0)).getIpId() + "/flow-bps"), (int)bandwidth, mapForDefense, (int)3) : RestInvoker.get((String)("/v1/{domain_id}/dpp/ipnodes/" + ((DefenseConfigForm)defenseConfig.get(0)).getIpId() + "/flow-bps"), mapForDefense, (int)3);
            this.logger.info((Object)("----call interface end,result = " + result));
            DefenseReportResult dataFromJSON = (DefenseReportResult)JSONUtil.getInstance().fromJSON(result, DefenseReportResult.class);
            this.dataList.addAll(dataFromJSON.getReportData());
        }
        catch (Exception e) {
            this.logger.error((Object)("defense restfull.defense json Conversion failed ," + e.getMessage()));
        }
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<HighFlowPreventionDistribute> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<HighFlowPreventionDistribute> list = new ArrayList<HighFlowPreventionDistribute>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (!orderedList.isEmpty()) {
            list.addAll(orderedList.subList(startIndex, endIndex));
        }
        return list;
    }

    public List<HighFlowPreventionDistribute> sortListByField(List<HighFlowPreventionDistribute> highFlowPreventionData, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(highFlowPreventionData, comparator);
        return highFlowPreventionData;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        this.getConditionForm(queryCond, datastatConditionForm, sessionId);
        if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
            return map;
        }
        this.getResultFromDefense(datastatConditionForm);
        this.logger.info((Object)("get defense data: dataList = " + this.dataList));
        ArrayList<String> companyName = new ArrayList<String>();
        companyName.add(ReportAnalysisUtil.getCompanyName());
        map.put("companyName", companyName);
        ArrayList<String> logUrl = new ArrayList<String>();
        logUrl.add(ReportAnalysisUtil.getCompaneLog());
        map.put("logImageUrl", logUrl);
        return map;
    }
}

