/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.iplocation;

import com.hs.atic.analysis.report.flux.iplocation.IpLocationTopN;
import com.hs.atic.analysis.report.flux.iplocation.IpLocationTopNStaticData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.sdk.analysis.form.IpLocationTopNForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class IpLocationFlowTableDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<IpLocationTopN> dataList = new ArrayList<IpLocationTopN>();

    public List<IpLocationTopN> sortListByField(List<IpLocationTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<IpLocationTopN> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<IpLocationTopN> list = new ArrayList<IpLocationTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        List<IpLocationTopNForm> dnsTopNFormList = null;
        try {
            dnsTopNFormList = IpLocationTopNStaticData.getInstance().getDataList(sessionId);
            IpLocationTopNStaticData.getInstance().removeData(sessionId);
            if (null != dnsTopNFormList) {
                for (IpLocationTopNForm form : dnsTopNFormList) {
                    if (form.getInFlow() <= 0L) continue;
                    IpLocationTopN ipLocationTopN = new IpLocationTopN();
                    ipLocationTopN.setDateTime(form.getDateTime() * 1000L);
                    ipLocationTopN.setFlowValue(form.getFlowValue());
                    ipLocationTopN.setInFlow(form.getInFlow());
                    ipLocationTopN.setAttackFlow(form.getAttackFlow());
                    ipLocationTopN.setIpLocationName(form.getIpLocationName());
                    this.dataList.add(ipLocationTopN);
                }
            }
            this.dataList = this.sortListByField(this.dataList, "dateTime", "ASC");
        }
        catch (Exception e) {
            this.dataList.clear();
            IpLocationTopNStaticData.getInstance().removeData(sessionId);
            this.logger.error((Object)("IpLocationFlowTableDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        return 0;
    }

    public List<IpLocationTopN> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<IpLocationTopN> dataList) {
        this.dataList = dataList;
    }
}

