/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.iplocation;

import com.hs.atic.analysis.report.flux.iplocation.IpLocationTopN;
import com.hs.atic.analysis.report.flux.iplocation.IpLocationTopNStaticData;
import com.hs.atic.analysis.report.flux.iplocation.IpLocationTopNTableDataSet;
import com.hs.atic.analysis.report.integration.datasource.AllReportHaveDataCache;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.IpLocationTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.util.PolicyUtil;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class IpLocationTopNChartDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<IpLocationTopN> dataList = new ArrayList<IpLocationTopN>();
    private String statisticalDimension = "-1";
    private IDataStatService dataStatService;
    private boolean isIpLocFlow = false;
    private int ipLocationId = -1;
    private int showCountryNum = 10;

    public List<IpLocationTopN> sortListByField(List<IpLocationTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        List<IpLocationTopN> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        ArrayList<IpLocationTopN> result = new ArrayList<IpLocationTopN>();
        if (null != orderedList) {
            for (IpLocationTopN ipLocationTopN : orderedList) {
                if (null == ipLocationTopN) continue;
                ipLocationTopN.setIpLocationShortName(null != ipLocationTopN.getIpLocationShortName() && ipLocationTopN.getIpLocationShortName().indexOf("/") == 0 ? ipLocationTopN.getIpLocationShortName().replaceFirst("/", "") : ipLocationTopN.getIpLocationShortName());
                ipLocationTopN.setIpLocationName(null != ipLocationTopN.getIpLocationName() && ipLocationTopN.getIpLocationName().indexOf("/") == 0 ? ipLocationTopN.getIpLocationName().replaceFirst("/", "") : ipLocationTopN.getIpLocationName());
                if (this.statisticalDimension.equals("1") && ipLocationTopN.getIpLocationName().lastIndexOf("/") > 0) {
                    ipLocationTopN.setIpLocationName(ipLocationTopN.getIpLocationName().substring(ipLocationTopN.getIpLocationName().lastIndexOf("/") + 1, ipLocationTopN.getIpLocationName().length()));
                }
                result.add(ipLocationTopN);
            }
            orderedList = result;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<IpLocationTopN> list = new ArrayList<IpLocationTopN>();
        if (null != orderedList) {
            int endIndex;
            int startIndex = (int)((pageIndex - 1L) * pageSize);
            if (startIndex < 0 || startIndex >= orderedList.size()) {
                startIndex = orderedList.size() - 1;
            }
            if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
                endIndex = orderedList.size();
            }
            if (!orderedList.isEmpty()) {
                list.addAll(orderedList.subList(startIndex, endIndex));
            } else {
                return list;
            }
        }
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        String isNeedTransmitChartData = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isNeedTransmitChartData) && isNeedTransmitChartData.equalsIgnoreCase("true")) {
            IpLocationTopNTableDataSet ipLocationTopN = new IpLocationTopNTableDataSet();
            ipLocationTopN.prepareData(reportId, dataSourceId, queryCond, sessionId);
        }
        if (null != queryCond.get("statisticalDimension_combobox")) {
            JsonValueObj temp = (JsonValueObj)queryCond.get("statisticalDimension_combobox");
            this.statisticalDimension = null != temp && null != temp.getValueList() && temp.getValueList().size() > 0 ? ((JsonValueItem)temp.getValueList().get(0)).getValue() : "0";
        }
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        List<Object> dnsTopNFormList = new ArrayList();
        try {
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (this.isIpLocFlow) {
                IpLocationTopNForm ipLocationTopNForm = new IpLocationTopNForm();
                ipLocationTopNForm.setIpLocationId(this.ipLocationId);
                ipLocationTopNForm.setIpLocationName(ReportAnalysisUtil.getIpLocationName(this.ipLocationId));
                dnsTopNFormList.add(ipLocationTopNForm);
            } else {
                dnsTopNFormList = IpLocationTopNStaticData.getInstance().getDataList(sessionId);
                IpLocationTopNStaticData.getInstance().removeData(sessionId);
                if (null != dnsTopNFormList && dnsTopNFormList.size() > this.showCountryNum) {
                    dnsTopNFormList = dnsTopNFormList.subList(0, this.showCountryNum);
                }
            }
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            Map<String, List<IpLocationTopNForm>> allCollectorIpLocationTopNForm = null;
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorIpLocationTopNForm = this.getSingleDeviceData(datastatConditionForm, dnsTopNFormList);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                allCollectorIpLocationTopNForm = this.getMultiDeviceData(currentLogUserId, datastatConditionForm, dnsTopNFormList);
            }
            List<IpLocationTopNForm> dnsGraphFormList = null;
            dnsGraphFormList = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectTopNForm(allCollectorIpLocationTopNForm) : this.getTopNForm(allCollectorIpLocationTopNForm);
            if (this.isIpLocFlow) {
                IpLocationTopNStaticData.getInstance().addDataList(dnsGraphFormList, sessionId);
            }
            dnsGraphFormList = this.getallTimeData(dnsGraphFormList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
            this.processFinalData(dnsGraphFormList);
            if (!AticUtil.isNull((String)isNeedTransmitChartData) && isNeedTransmitChartData.equalsIgnoreCase("true") && null != this.dataList && !this.dataList.isEmpty()) {
                AllReportHaveDataCache.getInstance().addDataList("IpLocationTopN", sessionId);
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("IpLocationTopNDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        return 0;
    }

    private void processFinalData(List<IpLocationTopNForm> ipLocFormList) {
        for (IpLocationTopNForm form : ipLocFormList) {
            IpLocationTopN ipLocationTopN = new IpLocationTopN();
            ipLocationTopN.setDateTime(form.getDateTime() * 1000L);
            ipLocationTopN.setFlowValue(form.getFlowValue());
            ipLocationTopN.setIpLocationName(form.getIpLocationName());
            this.dataList.add(ipLocationTopN);
        }
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        String unit;
        String isInteReport;
        String type;
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (0L == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "ipLocation_combobox");
        String ipLocId = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)ipLocId)) {
            this.ipLocationId = Integer.parseInt(ipLocId);
            this.isIpLocFlow = true;
        }
        if (AticUtil.isNull((String)(type = String.valueOf((jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type")).get(0).getValue())))) {
            type = "0";
        }
        datastatConditionForm.setAttackType(Integer.parseInt(type));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)topn)) {
            datastatConditionForm.setTopn(Integer.parseInt(topn));
        }
        if (!AticUtil.isNull((String)(isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue()))) && isInteReport.equalsIgnoreCase("true")) {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "IpLocationTopNTOPN");
            String topn4Inte = String.valueOf(jsonValueItem.get(0).getValue());
            Integer topn4InteValue = Integer.parseInt(topn4Inte);
            datastatConditionForm.setTopn(topn4InteValue);
        }
        if (!AticUtil.isNull((String)(unit = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit").get(0).getValue()))) {
            datastatConditionForm.setUnit(Integer.parseInt(unit));
        }
    }

    private Map<String, List<IpLocationTopNForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm, List<IpLocationTopNForm> dnsTopNFormList) {
        HashMap<String, List<IpLocationTopNForm>> allCollectorIpLocationTopNForm = new HashMap<String, List<IpLocationTopNForm>>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewallId = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        if (dnsTopNFormList != null) {
            for (int i = 0; i < dnsTopNFormList.size(); ++i) {
                Map<Object, Object> tempMap = new HashMap();
                try {
                    tempMap = this.dataStatService.getIpLocationTopNGraph(datastatConditionForm, dnsTopNFormList.get(i), collectorInfo.getIpAddress());
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
                }
                for (Map.Entry<Object, Object> entryTemp : tempMap.entrySet()) {
                    if (allCollectorIpLocationTopNForm.containsKey(entryTemp.getKey())) {
                        ((List)allCollectorIpLocationTopNForm.get(entryTemp.getKey())).addAll((Collection)entryTemp.getValue());
                        continue;
                    }
                    allCollectorIpLocationTopNForm.put((String)entryTemp.getKey(), (List<IpLocationTopNForm>)entryTemp.getValue());
                }
            }
        }
        return allCollectorIpLocationTopNForm;
    }

    private Map<String, List<IpLocationTopNForm>> getMultiDeviceData(Long currentLogUserId, DataStatConditionForm datastatConditionForm, List<IpLocationTopNForm> dnsTopNFormList) {
        List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect4DnsAnalysis(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMaps = ReportAnalysisUtil.getCollectDevMap(firewallList);
        HashMap<String, List<AticDevice>> colDevMap = new HashMap<String, List<AticDevice>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMaps.entrySet()) {
            CollectorInfo collector = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            String collectorIp = collector.getIpAddress();
            colDevMap.put(collectorIp, entry.getValue());
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
        }
        return this.processAllCollectorIpLocationTopNFormData(datastatConditionForm, dnsTopNFormList, colDevMap);
    }

    private Map<String, List<IpLocationTopNForm>> processAllCollectorIpLocationTopNFormData(DataStatConditionForm datastatConditionForm, List<IpLocationTopNForm> dnsTopNFormList, Map<String, List<AticDevice>> colDevMap) {
        HashMap<String, List<IpLocationTopNForm>> allCollectorIpLocationTopNForm = new HashMap<String, List<IpLocationTopNForm>>();
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        if (dnsTopNFormList != null) {
            for (int i = 0; i < dnsTopNFormList.size(); ++i) {
                for (Map.Entry<String, List<AticDevice>> entry : colDevMap.entrySet()) {
                    List<AticDevice> listFirewall = colDevMap.get(entry.getKey());
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                    for (AticDevice firewall : listFirewall) {
                        datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
                    }
                    Map<Object, Object> tempMap = new HashMap();
                    try {
                        tempMap = this.dataStatService.getIpLocationTopNGraph(datastatConditionForm, dnsTopNFormList.get(i), entry.getKey());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
                    }
                    for (Map.Entry<Object, Object> entryTemp : tempMap.entrySet()) {
                        if (allCollectorIpLocationTopNForm.containsKey(entryTemp.getKey())) {
                            ((List)allCollectorIpLocationTopNForm.get(entryTemp.getKey())).addAll((Collection)entryTemp.getValue());
                            continue;
                        }
                        allCollectorIpLocationTopNForm.put((String)entryTemp.getKey(), (List<IpLocationTopNForm>)entryTemp.getValue());
                    }
                }
            }
        }
        return allCollectorIpLocationTopNForm;
    }

    private List<IpLocationTopNForm> getAllDetectTopNForm(Map<String, List<IpLocationTopNForm>> inputMap) {
        List<IpLocationTopNForm> distinctForm = new ArrayList<IpLocationTopNForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<IpLocationTopNForm> listForm = new ArrayList<IpLocationTopNForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<IpLocationTopNForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getDistinctForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getDistinctForm(distinctForm, 1);
        return distinctForm;
    }

    private List<IpLocationTopNForm> getDistinctForm(List<IpLocationTopNForm> allForm, int detectMode) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (allForm.get(i).getIpLocationId() != allForm.get(j).getIpLocationId() || !allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime())) continue;
                this.dealWithSame(allForm, detectMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<IpLocationTopNForm> allForm, int detectMode, int i, int j) {
        if (detectMode == 0) {
            if (allForm.get(i).getFlowValue() > allForm.get(j).getFlowValue()) {
                allForm.get(i).setFlowValue(allForm.get(i).getFlowValue());
            } else {
                allForm.get(i).setFlowValue(allForm.get(j).getFlowValue());
            }
            allForm.remove(j);
        } else if (detectMode == 1) {
            allForm.get(i).setFlowValue(allForm.get(i).getFlowValue() + allForm.get(j).getFlowValue());
            allForm.remove(j);
        }
    }

    private List<IpLocationTopNForm> getTopNForm(Map<String, List<IpLocationTopNForm>> inputMap) {
        List<IpLocationTopNForm> formList = new ArrayList<IpLocationTopNForm>();
        for (Map.Entry<String, List<IpLocationTopNForm>> entry : inputMap.entrySet()) {
            formList.addAll((Collection<IpLocationTopNForm>)entry.getValue());
        }
        formList = this.getDistinctForm(formList, 1);
        return formList;
    }

    private List<IpLocationTopNForm> getallTimeData(List<IpLocationTopNForm> dnsGraphFormList, long startTime, long endTime) {
        startTime = ReportAnalysisUtil.getRealStartTime(startTime, endTime);
        long timeSlot = this.getTimeSlot(startTime, endTime);
        ArrayList<String> dnsNameList = new ArrayList<String>();
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < dnsGraphFormList.size(); ++i) {
            IpLocationTopNForm form = dnsGraphFormList.get(i);
            if (i == 0) {
                minTime = form.getDateTime();
                maxTime = form.getDateTime();
            } else {
                if (form.getDateTime() < minTime) {
                    minTime = form.getDateTime();
                }
                if (form.getDateTime() > maxTime) {
                    maxTime = form.getDateTime();
                }
            }
            this.getNameOrIpList(form, dnsNameList);
        }
        Map<Long, List<IpLocationTopNForm>> map = null;
        map = this.getMapData4LogTime(minTime, maxTime, timeSlot, dnsGraphFormList);
        for (Map.Entry<Long, List<IpLocationTopNForm>> entry : map.entrySet()) {
            this.getGraphByDnsName(dnsNameList, entry, dnsGraphFormList);
        }
        return dnsGraphFormList;
    }

    private Map<Long, List<IpLocationTopNForm>> getMapData4LogTime(Long minTime, Long maxTime, long timeSlot, List<IpLocationTopNForm> dnsGraphFormList) {
        HashMap<Long, List<IpLocationTopNForm>> map = new HashMap<Long, List<IpLocationTopNForm>>();
        while (minTime <= maxTime) {
            ArrayList<IpLocationTopNForm> tmpList = new ArrayList<IpLocationTopNForm>();
            for (IpLocationTopNForm form : dnsGraphFormList) {
                if (!form.getDateTime().equals(minTime)) continue;
                tmpList.add(form);
            }
            map.put(minTime, tmpList);
            minTime = minTime + timeSlot;
        }
        return map;
    }

    private long getTimeSlot(long startTime, long endTime) {
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        if (type == AnalysisConstants.LESS_THAN_SEVEN_DAYS) {
            return PolicyUtil.NUM_THREE_THOUSAND_SIX_HUNDRED;
        }
        if (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS) {
            return 24L * PolicyUtil.NUM_THREE_THOUSAND_SIX_HUNDRED;
        }
        return PolicyUtil.NUM_THREE_HUNDRED;
    }

    private void getNameOrIpList(IpLocationTopNForm form, List<String> dnsNameList) {
        boolean hasData = false;
        for (int j = 0; j < dnsNameList.size(); ++j) {
            if (!form.getIpLocationName().equals(dnsNameList.get(j))) continue;
            hasData = true;
            break;
        }
        if (!hasData) {
            dnsNameList.add(form.getIpLocationName());
        }
    }

    private void getGraphByDnsName(List<String> dnsNameList, Map.Entry<Long, List<IpLocationTopNForm>> entry, List<IpLocationTopNForm> dnsGraphFormList) {
        for (int i = 0; i < dnsNameList.size(); ++i) {
            boolean hasData = false;
            for (IpLocationTopNForm form : entry.getValue()) {
                if (!form.getIpLocationName().equals(dnsNameList.get(i))) continue;
                hasData = true;
                break;
            }
            if (hasData) continue;
            IpLocationTopNForm form = new IpLocationTopNForm();
            form.setDateTime(entry.getKey());
            form.setFlowValue(0L);
            form.setInFlow(0L);
            form.setAttackFlow(0L);
            form.setIpLocationName(dnsNameList.get(i));
            dnsGraphFormList.add(form);
        }
    }

    public List<IpLocationTopN> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<IpLocationTopN> dataList) {
        this.dataList = dataList;
    }
}

