/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.flux.iptopn;

import com.hs.atic.analysis.report.flux.iptopn.IpFluxTopN;
import com.hs.atic.analysis.report.integration.datasource.AllReportHaveDataCache;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.IpTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.IpDomainForm;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IIpDomainService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class IpFluxTopNDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<IpFluxTopN> dataList = new ArrayList<IpFluxTopN>();
    private IDataStatService dataStatService;

    private List<IpFluxTopN> sortListByField(List<IpFluxTopN> beSortedList, String sortField, String sortType) {
        if (sortField.equalsIgnoreCase("displayZoneIp")) {
            sortField = "zoneIp";
        }
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<IpFluxTopN> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<IpFluxTopN> list = new ArrayList<IpFluxTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start IpFluxTopNDataSet prepareData");
        List<IpTopNForm> ipTopNFormList = null;
        Map<String, List<IpTopNForm>> allCollectorIpTopNForm = new HashMap<String, List<IpTopNForm>>();
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            HashMap<Long, List<AticDevice>> collectDevMap = new HashMap<Long, List<AticDevice>>();
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorIpTopNForm = this.getSingleDeviceData(collectDevMap, datastatConditionForm);
            }
            ipTopNFormList = this.getTopNForm(allCollectorIpTopNForm, datastatConditionForm.getTopn(), datastatConditionForm.getUnit());
            this.getFinalData(ipTopNFormList);
            this.processDomainCompare();
            String isNeedTransmitChartData = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
            if (!AticUtil.isNull((String)isNeedTransmitChartData) && isNeedTransmitChartData.equalsIgnoreCase("true") && null != this.dataList && !this.dataList.isEmpty()) {
                AllReportHaveDataCache.getInstance().addDataList("FlowTopN", sessionId);
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("ZoneFluxTopNDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        this.logger.info((Object)"end IpFluxTopNDataSet prepareData");
        return 0;
    }

    private void processDomainCompare() {
        StringBuffer zoneIp = new StringBuffer();
        for (int i = 0; i < this.dataList.size(); ++i) {
            if (i == this.dataList.size() - 1) {
                zoneIp.append(this.dataList.get(i).getZoneIp());
                continue;
            }
            zoneIp.append(this.dataList.get(i).getZoneIp()).append(',');
        }
        ServiceContext serviceContext = ServiceContext.getInstance();
        IIpDomainService service = (IIpDomainService)serviceContext.getService("ipDomainService", IIpDomainService.class);
        List ipDomainForms = service.getByIps(zoneIp.toString());
        block1: for (IpFluxTopN topn : this.dataList) {
            for (IpDomainForm form : ipDomainForms) {
                if (!IPUtil4Atic.convert2CompleteIp((String)topn.getZoneIp()).equals(IPUtil4Atic.convert2CompleteIp((String)form.getDestIp()))) continue;
                topn.setIpDomain(form.getDomain());
                continue block1;
            }
        }
    }

    private void getFinalData(List<IpTopNForm> ipTopNFormList) {
        HashMap<String, Integer> sameIpNameNum = new HashMap<String, Integer>();
        for (IpTopNForm form : ipTopNFormList) {
            if (sameIpNameNum.containsKey(form.getDisIp())) {
                int newNum = (Integer)sameIpNameNum.get(form.getDisIp()) + 1;
                sameIpNameNum.put(form.getDisIp(), newNum);
                continue;
            }
            sameIpNameNum.put(form.getDisIp(), 1);
        }
        Set set = sameIpNameNum.entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer num = (Integer)entry.getValue();
            if (num > 1) continue;
            iter.remove();
        }
        IZoneService zoneService = ReportBisUtil.getZoneService();
        for (int i = 0; i < ipTopNFormList.size(); ++i) {
            IpFluxTopN data = new IpFluxTopN();
            data.setKbps(ipTopNFormList.get(i).getKbps());
            data.setPps(ipTopNFormList.get(i).getPps());
            ZoneInfoForm zoneForm = zoneService.getById(ipTopNFormList.get(i).getZoneId());
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                data.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone") + ipTopNFormList.get(i).getZoneId());
            } else {
                data.setZoneName(zoneForm.getZoneDesc());
            }
            String key = ipTopNFormList.get(i).getDisIp();
            if (sameIpNameNum.containsKey(key) && (Integer)sameIpNameNum.get(key) > 0) {
                int tempNum = (Integer)sameIpNameNum.get(key);
                data.setDisplayZoneIp(IPUtil4Atic.compressIP((String)key) + "(" + tempNum + ")");
                sameIpNameNum.put(key, tempNum - 1);
            } else {
                data.setDisplayZoneIp(IPUtil4Atic.compressIP((String)ipTopNFormList.get(i).getDisIp()));
            }
            data.setZoneIp(ipTopNFormList.get(i).getZoneIp());
            this.dataList.add(data);
        }
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)direction) || !direction.matches("^(0|1|2)$")) {
            datastatConditionForm.setDirection(1);
        } else {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (0L == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        String bisId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type");
        String type = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAttackType(Integer.parseInt(type));
        String statType = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "type_combobox");
        statType = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAppType(Integer.parseInt(statType));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "protocol_combobox");
        String protocol = String.valueOf(jsonValueItem.get(0).getValue());
        if (protocol.matches("^[\\d]*$")) {
            datastatConditionForm.setProtocol(Integer.parseInt(protocol));
        } else {
            datastatConditionForm.setProtocol(-1);
        }
        this.processBizParam(protocol, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unit = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setUnit(Integer.parseInt(unit));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "FlowTopNTOPN");
            String topn4Inte = String.valueOf(jsonValueItem.get(0).getValue());
            Integer topn4InteValue = Integer.parseInt(topn4Inte);
            datastatConditionForm.setTopn(topn4InteValue);
        }
    }

    private void processBizParam(String protocol, DataStatConditionForm datastatConditionForm) {
        if (null != datastatConditionForm.getIsServiceGroup() && datastatConditionForm.getIsServiceGroup().booleanValue()) {
            Map<String, List<Long>> serviceIds = null;
            serviceIds = datastatConditionForm.getServiceIds();
            if (null != serviceIds && !serviceIds.isEmpty()) {
                this.processServiceIds(datastatConditionForm, protocol, serviceIds);
            }
        }
    }

    private void processTCP(Map<String, List<Long>> serviceIds, DataStatConditionForm datastatConditionForm, Map<String, List<Long>> temp) {
        if (serviceIds.containsKey("TCP")) {
            temp.put("TCP", serviceIds.get("TCP"));
        }
        if (serviceIds.containsKey("DEFAULT")) {
            temp.put("DEFAULT", serviceIds.get("DEFAULT"));
        }
        datastatConditionForm.setServiceIds(temp);
    }

    private void processUDP(Map<String, List<Long>> serviceIds, DataStatConditionForm datastatConditionForm, Map<String, List<Long>> temp) {
        if (serviceIds.containsKey("UDP")) {
            temp.put("UDP", serviceIds.get("UDP"));
        }
        if (serviceIds.containsKey("DEFAULT")) {
            temp.put("DEFAULT", serviceIds.get("DEFAULT"));
        }
        datastatConditionForm.setServiceIds(temp);
    }

    private void processICMP(Map<String, List<Long>> serviceIds, DataStatConditionForm datastatConditionForm, Map<String, List<Long>> temp) {
        if (serviceIds.containsKey("ICMP")) {
            temp.put("ICMP", serviceIds.get("ICMP"));
        }
        if (serviceIds.containsKey("DEFAULT")) {
            temp.put("DEFAULT", serviceIds.get("DEFAULT"));
        }
        datastatConditionForm.setServiceIds(temp);
    }

    private void processOTHER(Map<String, List<Long>> serviceIds, DataStatConditionForm datastatConditionForm, Map<String, List<Long>> temp) {
        if (serviceIds.containsKey("OTHER")) {
            temp.put("OTHER", serviceIds.get("OTHER"));
        }
        if (serviceIds.containsKey("Other")) {
            temp.put("Other", serviceIds.get("Other"));
        }
        if (serviceIds.containsKey("DEFAULT")) {
            temp.put("DEFAULT", serviceIds.get("DEFAULT"));
        }
        datastatConditionForm.setServiceIds(temp);
    }

    private void processServiceIds(DataStatConditionForm datastatConditionForm, String protocol, Map<String, List<Long>> serviceIds) {
        HashMap<String, List<Long>> temp = new HashMap<String, List<Long>>();
        if (protocol.equals("1")) {
            this.processTCP(serviceIds, datastatConditionForm, temp);
        } else if (protocol.equals("2")) {
            this.processUDP(serviceIds, datastatConditionForm, temp);
        } else if (protocol.equals("3")) {
            this.processICMP(serviceIds, datastatConditionForm, temp);
        } else if (protocol.equals("4")) {
            this.processOTHER(serviceIds, datastatConditionForm, temp);
        } else if (serviceIds.containsKey(protocol)) {
            temp.put(protocol, serviceIds.get(protocol));
            datastatConditionForm.setServiceIds(temp);
        }
    }

    private Map<String, List<IpTopNForm>> getSingleDeviceData(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        ArrayList<AticDevice> tempList = new ArrayList<AticDevice>();
        tempList.add(firewall);
        collectDevMap.put(collectorInfo.getId(), tempList);
        HashMap<String, List<IpTopNForm>> allCollectorIpTopNForm = new HashMap();
        try {
            allCollectorIpTopNForm = this.dataStatService.getIPFlux(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return allCollectorIpTopNForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<IpTopNForm> getTopNForm(Map<String, List<IpTopNForm>> inputMap, int topn, int unit) {
        ArrayList<IpTopNForm> formList = new ArrayList<IpTopNForm>();
        for (Map.Entry<String, List<IpTopNForm>> entry : inputMap.entrySet()) {
            formList.addAll((Collection<IpTopNForm>)entry.getValue());
        }
        List<IpTopNForm> orderformList = null;
        orderformList = this.processDataSortByIp(formList, unit);
        if (orderformList.size() > topn) {
            for (int i = orderformList.size() - 1; i >= topn; --i) {
                orderformList.remove(i);
            }
        }
        return orderformList;
    }

    private List<IpTopNForm> processDataSortByIp(List<IpTopNForm> formList, int unit) {
        List<IpTopNForm> orderformList = new ArrayList<IpTopNForm>();
        if (null == formList || formList.isEmpty()) {
            return orderformList;
        }
        orderformList = formList;
        if (unit == 0) {
            orderformList = this.sortDataZoneTopNFormListByField(orderformList, "kbps", "DESC");
            this.processData4Kbps(orderformList);
        } else {
            orderformList = this.sortDataZoneTopNFormListByField(orderformList, "pps", "DESC");
            this.processData4Pps(orderformList);
        }
        return orderformList;
    }

    private List<IpTopNForm> sortDataZoneTopNFormListByField(List<IpTopNForm> orderformList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(orderformList, comparator);
        return orderformList;
    }

    private void processData4Kbps(List<IpTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getKbps().equals(orderformList.get(j).getKbps()) || orderformList.get(i).getZoneIp().compareTo(orderformList.get(j).getZoneIp()) <= 0) continue;
                IpTopNForm temp = orderformList.get(i);
                orderformList.set(i, orderformList.get(j));
                orderformList.set(j, temp);
            }
        }
    }

    private void processData4Pps(List<IpTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getPps().equals(orderformList.get(j).getPps()) || orderformList.get(i).getZoneIp().compareTo(orderformList.get(j).getZoneIp()) <= 0) continue;
                IpTopNForm temp = orderformList.get(i);
                orderformList.set(i, orderformList.get(j));
                orderformList.set(j, temp);
            }
        }
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    public List<IpFluxTopN> getDataList() {
        return this.dataList;
    }
}

