/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.integration.system;

import com.hs.atic.analysis.report.attack.attacktype.AtackTypeDistribute;
import com.hs.atic.analysis.report.attack.log.AttackLog;
import com.hs.atic.analysis.report.attack.log.AttackLogDataSet;
import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareChartDataSet;
import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareView;
import com.hs.atic.analysis.report.flux.flowcompare.TransmitFlowCompareData;
import com.hs.atic.analysis.report.integration.AvgAndMaxView;
import com.hs.atic.analysis.report.integration.TotalData4InteDataSource;
import com.hs.atic.analysis.report.integration.TransmitZoneOrIpTopNViewData;
import com.hs.atic.analysis.report.integration.ZoneOrIpTopNView;
import com.hs.atic.analysis.report.integration.datasource.TransmitAttackCountData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.analysis.util.ReportAticUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareForm;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.util.AticUtil;
import com.huawei.atic.util.CommonUtil;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TotalSystemSecurityDs
extends IJavaDataSource {
    private static Integer totalAbnormalCount = 0;
    private static final String TAB_SPACE = "   ";
    private static final double NUM_05 = 0.5;
    private List<AvgAndMaxView> resultList = new ArrayList<AvgAndMaxView>();
    private Long timeSpan = 1L;
    private int deviceType;
    private String schedule;
    private Map<String, Integer> dataList = new HashMap<String, Integer>();
    private Locale locale;
    private List<AtackTypeDistribute> attackCountList = new ArrayList<AtackTypeDistribute>();

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        List<FlowCompareForm> tableData = TransmitFlowCompareData.getInstance().getDataList(sessionId);
        TransmitFlowCompareData.getInstance().removeData(sessionId);
        if (null != tableData) {
            this.resultList = ReportAnalysisUtil.processAvgAndMaxData4Table(tableData, this.timeSpan, this.deviceType, this.locale);
        }
        return this.resultList;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return 0L;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        Map<String, List<String>> timeSpanMap = ReportAnalysisUtil.getPrepareParasMap(queryCond);
        String timeSpanStr = timeSpanMap.get("timeLevel").get(0);
        this.timeSpan = Long.parseLong(timeSpanStr);
        TotalData4InteDataSource totalData4Inte = new TotalData4InteDataSource();
        this.dataList = totalData4Inte.processTotalData(queryCond, sessionId);
        Integer tempIn = this.dataList.get("abnormalCount");
        TotalSystemSecurityDs.setTotalAbnormalCount(tempIn == null ? Integer.valueOf(0) : this.dataList.get("abnormalCount"));
        return 0;
    }

    public boolean splitTask(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return true;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        ILicenseOutboundService licenseOutboundService;
        boolean isSupportOutbound;
        this.locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List<JsonValueItem> jsonValueItem = null;
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        String deviceName = ReportAnalysisUtil.processDeviceType4SysAndZoneReport(queryCond, datastatConditionForm, map);
        this.deviceType = datastatConditionForm.getDevSerType();
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)direction) || !direction.matches("^(0|1|2)$")) {
            direction = "1";
        }
        if (!(isSupportOutbound = (licenseOutboundService = ReportBisUtil.getLicenseOutboundService()).isSupportOutbound())) {
            ReportAnalysisUtil.processCompNameAndLogo4SysAndZoneReport(map, this.locale, "sys", "");
        } else {
            ReportAnalysisUtil.processCompNameAndLogo4SysAndZoneReport(map, this.locale, "sys", direction);
        }
        ArrayList<String> zoneReportName = new ArrayList<String>();
        zoneReportName.add(AticUtil.getText((String)"report.total.sys.summary.sysReport", (Locale)this.locale));
        map.put("tableTitle", zoneReportName);
        ArrayList<String> authorName = new ArrayList<String>();
        String userName = ReportAnalysisUtil.getCurrentLogUserName(queryCond);
        userName = ReportAnalysisUtil.getStrContent4HtmlFile(userName, 16);
        authorName.add(userName);
        map.put("authorName", authorName);
        ArrayList<String> reportTypes = new ArrayList<String>();
        reportTypes.add(ReportAnalysisUtil.getReportType(queryCond, this.locale));
        map.put("reportType", reportTypes);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        ArrayList<String> datesOfData = new ArrayList<String>();
        String startDatesOfDataStr = AticUtil.convertTimeLong((Long)datastatConditionForm.getStartTime());
        String endDatesOfDataStr = AticUtil.convertTimeLong((Long)datastatConditionForm.getEndTime());
        String datesOfDataStr = "";
        datesOfDataStr = startDatesOfDataStr.equalsIgnoreCase(endDatesOfDataStr) ? startDatesOfDataStr : startDatesOfDataStr + " " + AticUtil.getText((String)"atic.report.common.to4Report", (Locale)this.locale) + " " + endDatesOfDataStr;
        datesOfData.add(datesOfDataStr);
        map.put("datesOfData", datesOfData);
        ArrayList<String> createTimes = new ArrayList<String>();
        createTimes.add(AticUtil.convertTimeLong((Long)(System.currentTimeMillis() / 1000L)));
        map.put("createTime", createTimes);
        ArrayList<String> deviceNameList = new ArrayList<String>();
        String deviceNameTemp = ReportAnalysisUtil.getStrContent4HtmlFile(deviceName, 16);
        deviceNameList.add(deviceNameTemp);
        map.put("logCollector", deviceNameList);
        map.put("cleanReport", deviceNameList);
        map.put("detectReport", deviceNameList);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "schedule");
        this.schedule = jsonValueItem.get(0).getText();
        ArrayList<String> scheduleList = new ArrayList<String>();
        if (!AticUtil.isNull((String)this.schedule)) {
            scheduleList.add("true");
            map.put("showSchedule", scheduleList);
        } else {
            scheduleList.add("false");
            map.put("showSchedule", scheduleList);
        }
        ArrayList<String> totalSecurityTextList = new ArrayList<String>();
        StringBuffer totalSecurityText = new StringBuffer(TAB_SPACE);
        totalSecurityText.append("\u25cf ");
        String dataTimeAndZoneStr = AticUtil.getText((String)"report.total.sys.summary.dataTimeAndZoneName", (Locale)this.locale);
        Object[] dataTimeAndZoneObjs = new Object[]{datesOfDataStr};
        dataTimeAndZoneStr = MessageFormat.format(dataTimeAndZoneStr, dataTimeAndZoneObjs);
        totalSecurityText.append(dataTimeAndZoneStr);
        totalSecurityText.append('\n');
        totalSecurityText.append(TAB_SPACE);
        totalSecurityText.append(' ');
        totalSecurityText.append("\u25cf ");
        int ipCount = this.dataList.get("ipCount") == null ? 0 : this.dataList.get("ipCount");
        String attackIpCountStr = "";
        attackIpCountStr = this.deviceType == 1 ? AticUtil.getText((String)"report.total.summary.abnormalIpCount", (Locale)this.locale) : AticUtil.getText((String)"report.total.summary.attackIpCount", (Locale)this.locale);
        Object[] ipCountObjs = new Object[]{this.transFormNumber(ipCount)};
        attackIpCountStr = MessageFormat.format(attackIpCountStr, ipCountObjs);
        totalSecurityText.append(attackIpCountStr);
        FlowCompareChartDataSet flowCompareChartDataSet = new FlowCompareChartDataSet();
        flowCompareChartDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
        List<FlowCompareView> flowCompareViewList = flowCompareChartDataSet.fetchData(0L, 0L, null, dataSourceId, sessionId);
        TransmitFlowCompareData.getInstance().removeData(sessionId);
        totalSecurityText.append('\n');
        totalSecurityText.append(TAB_SPACE);
        totalSecurityText.append(' ');
        totalSecurityText.append("\u25cf ");
        AttackLogDataSet attackLogDataSet = new AttackLogDataSet();
        attackLogDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
        List<AttackLog> attackLogDataSetViewList = attackLogDataSet.fetchDataTotal(0L, 0L, null, dataSourceId, sessionId);
        String attackCountStr = this.processAttackLogDataFormat4ThirdSummary(queryCond, attackLogDataSetViewList);
        totalSecurityText.append(attackCountStr);
        totalSecurityText.append('\n');
        totalSecurityText.append(TAB_SPACE);
        totalSecurityText.append(' ');
        totalSecurityText.append("\u25cf ");
        String attackTypeFormat = this.processAttackDataFormat4FourthSummary(sessionId);
        totalSecurityText.append(attackTypeFormat);
        totalSecurityText.append('\n');
        totalSecurityText.append(TAB_SPACE);
        totalSecurityText.append(' ');
        totalSecurityText.append("\u25cf ");
        String attackDataFormat = this.processAttackDataFormat4FiveSummary(sessionId, flowCompareViewList, datastatConditionForm);
        totalSecurityText.append(attackDataFormat);
        String attackInfoFormat = ReportAnalysisUtil.processAttackDataFormat4SixSummary(this.attackCountList, this.deviceType, sessionId, this.locale);
        if (!ReportAticUtil.isNull(attackInfoFormat)) {
            totalSecurityText.append(attackInfoFormat);
        }
        totalSecurityText.append('\n');
        totalSecurityTextList.add(totalSecurityText.toString());
        map.put("totalSecurityText", totalSecurityTextList);
        Integer abnormalCount = this.dataList.get("abnormalCount") == null ? Integer.valueOf(0) : this.dataList.get("abnormalCount");
        this.processSummary(map, abnormalCount);
        ReportAnalysisUtil.processChapterContent(map, queryCond, sessionId, this.locale, this.deviceType);
        return map;
    }

    private String processAttackDataFormat4FourthSummary(long sessionId) {
        double factor;
        Integer attackCount;
        List<AtackTypeDistribute> dataListTemp = null;
        dataListTemp = TransmitAttackCountData.getInstance().getDataList(sessionId);
        TransmitAttackCountData.getInstance().removeData(sessionId);
        this.attackCountList = dataListTemp;
        int topnTemp = dataListTemp.size() < 3 ? dataListTemp.size() : 3;
        Long countNum = 0L;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < topnTemp; ++i) {
            buf.append(dataListTemp.get(i).getAttackTypeName());
            if (i < topnTemp - 1) {
                buf.append(',');
            } else {
                buf.append(';');
            }
            countNum = countNum + dataListTemp.get(i).getCount();
        }
        String attackTypeStr = buf.toString();
        String percenet = "0%";
        Integer abnormalCount = this.dataList.get("abnormalCount") == null ? Integer.valueOf(0) : this.dataList.get("abnormalCount");
        Integer n = attackCount = this.dataList.get("attackCount") == null ? Integer.valueOf(0) : this.dataList.get("attackCount");
        if (this.deviceType == 1) {
            if (abnormalCount > 0) {
                factor = Math.pow(10.0, 1.0);
                percenet = Math.floor(countNum.doubleValue() / abnormalCount.doubleValue() * 100.0 * factor + 0.5) / factor + "%";
            }
        } else if (attackCount > 0) {
            factor = Math.pow(10.0, 1.0);
            percenet = Math.floor(countNum.doubleValue() / attackCount.doubleValue() * 100.0 * factor + 0.5) / factor + "%";
        }
        if (AticUtil.isNull((String)attackTypeStr)) {
            return AticUtil.getText((String)"report.total.sys.summary.noabnormal", (Locale)this.locale);
        }
        String attackTypeFormat = "";
        attackTypeFormat = this.deviceType == 1 ? AticUtil.getText((String)"report.total.summary.abnormalTypeCount", (Locale)this.locale) : AticUtil.getText((String)"report.total.summary.attackTypeCount", (Locale)this.locale);
        Object[] attackTypeObjs = new Object[]{attackTypeStr, percenet};
        attackTypeFormat = MessageFormat.format(attackTypeFormat, attackTypeObjs);
        return attackTypeFormat;
    }

    private String processAttackLogDataFormat4ThirdSummary(Map<?, ?> queryCond, List<AttackLog> attackLogDataSetViewList) {
        Integer abnormalCount = this.dataList.get("abnormalCount") == null ? Integer.valueOf(0) : this.dataList.get("abnormalCount");
        Integer attackCount = this.dataList.get("attackCount") == null ? Integer.valueOf(0) : this.dataList.get("attackCount");
        FlowCompareConditionForm flowCompareConditionForm = new FlowCompareConditionForm();
        ReportAnalysisUtil.processTimeParams(queryCond, flowCompareConditionForm);
        Long totalDropBps = 0L;
        for (AttackLog temp : attackLogDataSetViewList) {
            totalDropBps = totalDropBps + temp.getDropBytes();
        }
        if (this.deviceType == 1) {
            String abnormalCountStr = AticUtil.getText((String)"report.total.summary.abnormalEventCount", (Locale)this.locale);
            Object[] abnormalCountObjs = new Object[]{this.transFormNumber(abnormalCount)};
            abnormalCountStr = MessageFormat.format(abnormalCountStr, abnormalCountObjs);
            return abnormalCountStr;
        }
        String attackCountStr = AticUtil.getText((String)"report.total.summary.attackEventCount", (Locale)this.locale);
        double totalDropBps4Com = totalDropBps.longValue();
        String totalDropFlow = ReportAnalysisUtil.conversionFlowUnit(totalDropBps4Com);
        Object[] attackCountObjs = new Object[]{this.transFormNumber(abnormalCount), this.transFormNumber(attackCount), totalDropFlow + "B"};
        attackCountStr = MessageFormat.format(attackCountStr, attackCountObjs);
        return attackCountStr;
    }

    private String processAttackDataFormat4FiveSummary(long sessionId, List<FlowCompareView> flowCompareViewList, DataStatConditionForm datastatConditionForm) {
        Long maxInFlow = 0L;
        Long maxAttackFlow = 0L;
        for (FlowCompareView temp : flowCompareViewList) {
            maxInFlow = maxInFlow < temp.getMaxInFlow() ? temp.getMaxInFlow() : maxInFlow;
            maxAttackFlow = maxAttackFlow < temp.getMaxAttackFlow() ? temp.getMaxAttackFlow() : maxAttackFlow;
        }
        List<ZoneOrIpTopNView> zoneOrIpTopNViewTemp = null;
        zoneOrIpTopNViewTemp = TransmitZoneOrIpTopNViewData.getInstance().getDataList(sessionId);
        TransmitZoneOrIpTopNViewData.getInstance().removeData(sessionId);
        String unit = "bps";
        String maxInFlow4Com = ReportAnalysisUtil.conversionFlowUnit(maxInFlow.longValue());
        String maxAttackFlow4Com = ReportAnalysisUtil.conversionFlowUnit(maxAttackFlow.longValue());
        if (this.deviceType == 1) {
            String attackDataFormat = AticUtil.getText((String)"report.total.sys.summary.noAttackData", (Locale)this.locale);
            Object[] attackDataObjs = new Object[]{maxInFlow4Com + unit};
            attackDataFormat = MessageFormat.format(attackDataFormat, attackDataObjs);
            return attackDataFormat;
        }
        String attackDataFormat = "";
        String attackTimeAndCountStr = ReportAnalysisUtil.getAttackTime4SysAndZoneReport(sessionId, datastatConditionForm, this.locale);
        String attackTime = "";
        String attackCount = "";
        if (!AticUtil.isNull((String)attackTimeAndCountStr)) {
            attackTime = attackTimeAndCountStr.split("#")[0];
            attackCount = attackTimeAndCountStr.split("#")[1];
        }
        if (null != zoneOrIpTopNViewTemp && !zoneOrIpTopNViewTemp.isEmpty()) {
            attackDataFormat = AticUtil.getText((String)"report.total.sys.summary.attackData", (Locale)this.locale);
            String attackIp = zoneOrIpTopNViewTemp.get(0).getName();
            String attackDuraData = zoneOrIpTopNViewTemp.get(0).getDisTotalDate();
            Long zoneAttackCount = zoneOrIpTopNViewTemp.get(0).getAttackTimes();
            Object[] attackDataObjs = new Object[]{maxInFlow4Com + unit, maxAttackFlow4Com + unit, attackTime, attackCount, attackIp, zoneAttackCount, attackDuraData};
            attackDataFormat = MessageFormat.format(attackDataFormat, attackDataObjs);
        } else if (AticUtil.isNull((String)attackTimeAndCountStr)) {
            attackDataFormat = AticUtil.getText((String)"report.total.sys.summary.attackDataOnlyFlow", (Locale)this.locale);
            Object[] attackDataObjs = new Object[]{maxInFlow4Com + unit, maxAttackFlow4Com + unit};
            attackDataFormat = MessageFormat.format(attackDataFormat, attackDataObjs);
        } else {
            attackDataFormat = AticUtil.getText((String)"report.total.sys.summary.attackDataNoAttackIp", (Locale)this.locale);
            Object[] attackDataObjs = new Object[]{maxInFlow4Com + unit, maxAttackFlow4Com + unit, attackTime, attackCount};
            attackDataFormat = MessageFormat.format(attackDataFormat, attackDataObjs);
        }
        return attackDataFormat;
    }

    private void processSummary(Map<String, List<String>> map, Integer abnormalCount) {
        StringBuffer summaryText = new StringBuffer(TAB_SPACE);
        summaryText.append("1) ");
        if (abnormalCount > 0) {
            if (this.deviceType == 1) {
                summaryText.append(AticUtil.getText((String)"report.total.system.summary.abnormal", (Locale)this.locale));
            } else {
                summaryText.append(AticUtil.getText((String)"report.total.system.summary1", (Locale)this.locale));
            }
            summaryText.append('\n');
            summaryText.append(TAB_SPACE);
            summaryText.append(' ');
            summaryText.append("2) ");
            summaryText.append(AticUtil.getText((String)"report.total.system.summary2", (Locale)this.locale));
            summaryText.append('\n');
        } else {
            summaryText.append(AticUtil.getText((String)"report.total.system.summary.noAbnormal", (Locale)this.locale));
        }
        ArrayList<String> summaryTextList = new ArrayList<String>();
        summaryTextList.add(summaryText.toString());
        map.put("summaryDetail", summaryTextList);
    }

    private String transFormNumber(int ipCount) {
        return CommonUtil.transformNumber((String)String.valueOf(ipCount), (String)"");
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public static Integer getTotalAbnormalCount() {
        return totalAbnormalCount;
    }

    public static void setTotalAbnormalCount(Integer totalAbnormalCount) {
        TotalSystemSecurityDs.totalAbnormalCount = totalAbnormalCount;
    }
}

