/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.integration.zone;

import com.hs.atic.analysis.report.attack.attacktype.AtackTypeDistribute;
import com.hs.atic.analysis.report.attack.log.AttackLog;
import com.hs.atic.analysis.report.attack.log.AttackLogDataSet;
import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareChartDataSet;
import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareComparator;
import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareView;
import com.hs.atic.analysis.report.flux.flowcompare.TransmitFlowCompareData;
import com.hs.atic.analysis.report.integration.AvgAndMaxView;
import com.hs.atic.analysis.report.integration.TotalData4InteDataSource;
import com.hs.atic.analysis.report.integration.TransmitZoneOrIpTopNViewData;
import com.hs.atic.analysis.report.integration.ZoneOrIpTopNView;
import com.hs.atic.analysis.report.integration.datasource.TransmitAttackCountData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.analysis.util.ReportAticUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareForm;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.util.AticUtil;
import com.huawei.atic.util.CommonUtil;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TotalZoneSecurityDs
extends IJavaDataSource {
    private static Integer totalAbnormalCount = 0;
    private static final String TAB_SPACE = "   ";
    private static final double NUM_05 = 0.5;
    private List<AvgAndMaxView> resultList = new ArrayList<AvgAndMaxView>();
    private Long timeSpan = 1L;
    private int deviceType;
    private String schedule;
    private Map<String, Integer> dataList = new HashMap<String, Integer>();
    private Locale locale;
    private boolean checkQueryPeakValue = true;
    private List<AtackTypeDistribute> attackCountList = new ArrayList<AtackTypeDistribute>();

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        List<FlowCompareForm> tableData = TransmitFlowCompareData.getInstance().getDataList(sessionId);
        TransmitFlowCompareData.getInstance().removeData(sessionId);
        if (null != tableData) {
            this.resultList = this.processAvgAndMaxData4Table(tableData);
        }
        return this.resultList;
    }

    private List<AvgAndMaxView> processAvgAndMaxData4Table(List<FlowCompareForm> tableData) {
        AvgAndMaxView inFlow;
        ArrayList<AvgAndMaxView> resultLists = new ArrayList<AvgAndMaxView>();
        if (null == tableData || tableData.isEmpty()) {
            return resultLists;
        }
        if (this.checkQueryPeakValue) {
            for (FlowCompareForm form : tableData) {
                form.setInFlow(form.getMaxInFlow());
                form.setAttackFlow(form.getMaxAttackFlow());
                form.setOutFlow(form.getMaxOutFlow());
            }
        }
        Long timeNum = this.getTimeNum(tableData);
        Long totalInFlow = tableData.get(0).getInFlow();
        Long maxInFlow = tableData.get(0).getInFlow();
        Long maxInFlowTime = tableData.get(0).getLogTime();
        Long totalDropFlow = tableData.get(0).getAttackFlow();
        Long maxDropFlow = tableData.get(0).getAttackFlow();
        Long maxDropFlowTime = tableData.get(0).getLogTime();
        Long totalOutFlow = tableData.get(0).getOutFlow();
        Long maxOutFlow = tableData.get(0).getOutFlow();
        Long maxOutFlowTime = tableData.get(0).getLogTime();
        int i = 0;
        for (FlowCompareForm form : tableData) {
            if (i > 0) {
                totalInFlow = totalInFlow + form.getInFlow();
                maxInFlowTime = maxInFlow < form.getInFlow() ? Long.valueOf(form.getLogTime()) : maxInFlowTime;
                maxInFlow = maxInFlow < form.getInFlow() ? form.getInFlow() : maxInFlow;
                totalDropFlow = totalDropFlow + form.getAttackFlow();
                maxDropFlowTime = maxDropFlow < form.getAttackFlow() ? Long.valueOf(form.getLogTime()) : maxDropFlowTime;
                maxDropFlow = maxDropFlow < form.getAttackFlow() ? form.getAttackFlow() : maxDropFlow;
                totalOutFlow = totalOutFlow + form.getOutFlow();
                maxOutFlowTime = maxOutFlow < form.getOutFlow() ? Long.valueOf(form.getLogTime()) : maxOutFlowTime;
                maxOutFlow = maxOutFlow < form.getOutFlow() ? form.getOutFlow() : maxOutFlow;
            }
            ++i;
        }
        if (this.deviceType == 1) {
            inFlow = new AvgAndMaxView();
            inFlow.setNameColor(ReportAnalysisUtil.getFontColor("77,130,249"));
            inFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.detect", (Locale)this.locale));
            inFlow.setAvgValue(totalInFlow / timeNum);
            inFlow.setAvgValueStr(CommonUtil.transformNumber((String)String.valueOf(totalInFlow / timeNum), (String)""));
            inFlow.setMaxValue(maxInFlow);
            inFlow.setMaxValueStr(CommonUtil.transformNumber((String)String.valueOf(maxInFlow), (String)""));
            inFlow.setLogTime(maxInFlowTime);
            resultLists.add(inFlow);
        } else {
            inFlow = new AvgAndMaxView();
            inFlow.setNameColor(ReportAnalysisUtil.getFontColor("77,130,249"));
            inFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.in", (Locale)this.locale));
            inFlow.setAvgValue(totalInFlow / timeNum);
            inFlow.setAvgValueStr(CommonUtil.transformNumber((String)String.valueOf(totalInFlow / timeNum), (String)""));
            inFlow.setMaxValue(maxInFlow);
            inFlow.setMaxValueStr(CommonUtil.transformNumber((String)String.valueOf(maxInFlow), (String)""));
            inFlow.setLogTime(maxInFlowTime);
            resultLists.add(inFlow);
            AvgAndMaxView dropFlow = new AvgAndMaxView();
            dropFlow.setNameColor(ReportAnalysisUtil.getFontColor("209,78,57"));
            dropFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.attack", (Locale)this.locale));
            dropFlow.setAvgValue(totalDropFlow / timeNum);
            dropFlow.setAvgValueStr(CommonUtil.transformNumber((String)String.valueOf(totalDropFlow / timeNum), (String)""));
            dropFlow.setMaxValue(maxDropFlow);
            dropFlow.setMaxValueStr(CommonUtil.transformNumber((String)String.valueOf(maxDropFlow), (String)""));
            dropFlow.setLogTime(maxDropFlowTime);
            AvgAndMaxView outFlow = new AvgAndMaxView();
            outFlow.setNameColor(ReportAnalysisUtil.getFontColor("94,237,79"));
            outFlow.setName(AticUtil.getText((String)"atic.analysis.common.flux.out", (Locale)this.locale));
            outFlow.setAvgValue(inFlow.getAvgValue() - dropFlow.getAvgValue());
            outFlow.setAvgValueStr(CommonUtil.transformNumber((String)String.valueOf(inFlow.getAvgValue() - dropFlow.getAvgValue()), (String)""));
            outFlow.setMaxValue(maxOutFlow);
            outFlow.setMaxValueStr(CommonUtil.transformNumber((String)String.valueOf(maxOutFlow), (String)""));
            outFlow.setLogTime(maxOutFlowTime);
            resultLists.add(outFlow);
        }
        return resultLists;
    }

    private Long getTimeNum(List<FlowCompareForm> tableData) {
        if (null == tableData || tableData.isEmpty()) {
            return 1L;
        }
        Collections.sort(tableData, FlowCompareComparator.getComparatorByFieldName("logTime", "desc"));
        Long endTime = tableData.get(0).getLogTime();
        Long startTime = tableData.get(tableData.size() - 1).getLogTime();
        Long returnTimeNum = 1L;
        returnTimeNum = this.timeSpan.equals(2L) ? Long.valueOf((endTime - startTime) / 3600000L + 1L) : (this.timeSpan.equals(3L) ? Long.valueOf((endTime - startTime) / 86400000L + 1L) : Long.valueOf((endTime - startTime) / 300000L + 1L));
        return returnTimeNum;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return 0L;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        Map<String, List<String>> timeSpanMap = ReportAnalysisUtil.getPrepareParasMap(queryCond);
        String timeSpanStr = timeSpanMap.get("timeLevel").get(0);
        this.timeSpan = Long.parseLong(timeSpanStr);
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        if (deviceId.contains("_")) {
            deviceId = deviceId.split("_")[0];
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        if (Long.parseLong(deviceId) > 0L && Long.parseLong(zoneId) > 0L) {
            this.checkQueryPeakValue = true;
        }
        TotalData4InteDataSource totalData4Inte = new TotalData4InteDataSource();
        this.dataList = totalData4Inte.processTotalData(queryCond, sessionId);
        Integer totalAbnormalCountTemp = this.dataList.get("abnormalCount") == null ? Integer.valueOf(0) : this.dataList.get("abnormalCount");
        TotalZoneSecurityDs.setTotalAbnormalCount(totalAbnormalCountTemp);
        return 0;
    }

    public boolean splitTask(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return true;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        ILicenseOutboundService licenseOutboundService;
        boolean isSupportOutbound;
        this.locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List<JsonValueItem> jsonValueItem = null;
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        String deviceName = ReportAnalysisUtil.processDeviceType4SysAndZoneReport(queryCond, datastatConditionForm, map);
        this.deviceType = datastatConditionForm.getDevSerType();
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)direction) || !direction.matches("^(0|1|2)$")) {
            direction = "1";
        }
        if (!(isSupportOutbound = (licenseOutboundService = ReportBisUtil.getLicenseOutboundService()).isSupportOutbound())) {
            ReportAnalysisUtil.processCompNameAndLogo4SysAndZoneReport(map, this.locale, "zone", "");
        } else {
            ReportAnalysisUtil.processCompNameAndLogo4SysAndZoneReport(map, this.locale, "zone", direction);
        }
        ArrayList<String> zoneReportName = new ArrayList<String>();
        zoneReportName.add(AticUtil.getText((String)"report.total.zone.summary.zoneReport", (Locale)this.locale));
        map.put("tableTitle", zoneReportName);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneName = String.valueOf(jsonValueItem.get(0).getText());
        datastatConditionForm.setZoneId(Long.parseLong(jsonValueItem.get(0).getValue()));
        ArrayList<String> coverTitle = new ArrayList<String>();
        coverTitle.add(AticUtil.getText((String)"report.total.zone.summary.zoneReport", (Locale)this.locale) + "-" + zoneName);
        map.put("coverTitle", coverTitle);
        ArrayList<String> zoneNameList = new ArrayList<String>();
        zoneNameList.add(zoneName);
        map.put("zoneName", zoneNameList);
        ArrayList<String> zoneNameList4Table = new ArrayList<String>();
        String zoneNameTemp = ReportAnalysisUtil.getStrContent4HtmlFile(zoneName, 16);
        zoneNameList4Table.add(zoneNameTemp);
        map.put("zoneName4Table", zoneNameList4Table);
        ArrayList<String> authorName = new ArrayList<String>();
        String userName = ReportAnalysisUtil.getCurrentLogUserName(queryCond);
        userName = ReportAnalysisUtil.getStrContent4HtmlFile(userName, 16);
        authorName.add(userName);
        map.put("authorName", authorName);
        ArrayList<String> reportTypes = new ArrayList<String>();
        reportTypes.add(ReportAnalysisUtil.getReportType(queryCond, this.locale));
        map.put("reportType", reportTypes);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        ArrayList<String> datesOfData = new ArrayList<String>();
        String startDatesOfDataStr = AticUtil.convertTimeLong((Long)datastatConditionForm.getStartTime());
        String endDatesOfDataStr = AticUtil.convertTimeLong((Long)datastatConditionForm.getEndTime());
        String datesOfDataStr = "";
        datesOfDataStr = startDatesOfDataStr.equalsIgnoreCase(endDatesOfDataStr) ? startDatesOfDataStr : startDatesOfDataStr + " " + AticUtil.getText((String)"atic.report.common.to4Report", (Locale)this.locale) + " " + endDatesOfDataStr;
        datesOfData.add(datesOfDataStr);
        map.put("datesOfData", datesOfData);
        ArrayList<String> createTimes = new ArrayList<String>();
        createTimes.add(AticUtil.convertTimeLong((Long)(System.currentTimeMillis() / 1000L)));
        map.put("createTime", createTimes);
        ArrayList<String> deviceNameList = new ArrayList<String>();
        deviceNameList.add(deviceName);
        map.put("logCollector", deviceNameList);
        map.put("cleanReport", deviceNameList);
        map.put("detectReport", deviceNameList);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "schedule");
        this.schedule = jsonValueItem.get(0).getText();
        ArrayList<String> scheduleList = new ArrayList<String>();
        if (!AticUtil.isNull((String)this.schedule)) {
            scheduleList.add("true");
            map.put("showSchedule", scheduleList);
        } else {
            scheduleList.add("false");
            map.put("showSchedule", scheduleList);
        }
        ArrayList<String> totalSecurityTextList = new ArrayList<String>();
        StringBuffer totalSecurityText = new StringBuffer(TAB_SPACE);
        totalSecurityText.append("\u25cf ");
        String dataTimeAndZoneStr = AticUtil.getText((String)"report.total.zone.summary.dataTimeAndZoneName", (Locale)this.locale);
        Object[] dataTimeAndZoneObjs = new Object[]{datesOfDataStr, zoneName};
        dataTimeAndZoneStr = MessageFormat.format(dataTimeAndZoneStr, dataTimeAndZoneObjs);
        totalSecurityText.append(dataTimeAndZoneStr);
        totalSecurityText.append('\n');
        totalSecurityText.append(TAB_SPACE);
        totalSecurityText.append(' ');
        totalSecurityText.append("\u25cf ");
        int ipCount = this.dataList.get("ipCount") == null ? 0 : this.dataList.get("ipCount");
        String attackIpCountStr = "";
        attackIpCountStr = this.deviceType == 1 ? AticUtil.getText((String)"report.total.summary.abnormalIpCount", (Locale)this.locale) : AticUtil.getText((String)"report.total.summary.attackIpCount", (Locale)this.locale);
        Object[] ipCountObjs = new Object[]{this.transFormNumber(ipCount)};
        attackIpCountStr = MessageFormat.format(attackIpCountStr, ipCountObjs);
        totalSecurityText.append(attackIpCountStr);
        FlowCompareChartDataSet flowCompareChartDataSet = new FlowCompareChartDataSet();
        flowCompareChartDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
        List<FlowCompareView> flowCompareViewList = flowCompareChartDataSet.fetchData(0L, 0L, null, dataSourceId, sessionId);
        TransmitFlowCompareData.getInstance().removeData(sessionId);
        totalSecurityText.append('\n');
        totalSecurityText.append(TAB_SPACE);
        totalSecurityText.append(' ');
        totalSecurityText.append("\u25cf ");
        AttackLogDataSet attackLogDataSet = new AttackLogDataSet();
        attackLogDataSet.prepareData(reportId, dataSourceId, queryCond, sessionId);
        List<AttackLog> attackLogDataSetViewList = attackLogDataSet.fetchData(0L, 0L, null, dataSourceId, sessionId);
        String attackCountStr = this.processAttackLogDataFormat4ThirdSummary(queryCond, attackLogDataSetViewList);
        totalSecurityText.append(attackCountStr);
        totalSecurityText.append('\n');
        totalSecurityText.append(TAB_SPACE);
        totalSecurityText.append(' ');
        totalSecurityText.append("\u25cf ");
        String attackTypeFormat = this.processAttackDataFormat4FourthSummary(sessionId);
        totalSecurityText.append(attackTypeFormat);
        totalSecurityText.append('\n');
        totalSecurityText.append(TAB_SPACE);
        totalSecurityText.append(' ');
        totalSecurityText.append("\u25cf ");
        String attackDataFormat = this.processAttackDataFormat4FiveSummary(sessionId, flowCompareViewList, datastatConditionForm);
        totalSecurityText.append(attackDataFormat);
        String attackInfoFormat = ReportAnalysisUtil.processAttackDataFormat4SixSummary(this.attackCountList, this.deviceType, sessionId, this.locale);
        if (!ReportAticUtil.isNull(attackInfoFormat)) {
            totalSecurityText.append(attackInfoFormat);
        }
        totalSecurityText.append('\n');
        totalSecurityTextList.add(totalSecurityText.toString());
        map.put("totalSecurityText", totalSecurityTextList);
        Integer abnormalCount = this.dataList.get("abnormalCount") == null ? Integer.valueOf(0) : this.dataList.get("abnormalCount");
        this.processSummary(map, abnormalCount);
        ReportAnalysisUtil.processChapterContent(map, queryCond, sessionId, this.locale, this.deviceType);
        return map;
    }

    private String processAttackDataFormat4FourthSummary(long sessionId) {
        double factor;
        Integer attackCount;
        List<AtackTypeDistribute> dataListTemp = null;
        dataListTemp = TransmitAttackCountData.getInstance().getDataList(sessionId);
        TransmitAttackCountData.getInstance().removeData(sessionId);
        this.attackCountList = dataListTemp;
        int topnTemp = dataListTemp.size() < 3 ? dataListTemp.size() : 3;
        Long countNum = 0L;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < topnTemp; ++i) {
            buf.append(dataListTemp.get(i).getAttackTypeName());
            if (i < topnTemp - 1) {
                buf.append(',');
            } else {
                buf.append(';');
            }
            countNum = countNum + dataListTemp.get(i).getCount();
        }
        String attackTypeStr = buf.toString();
        String percenet = "0%";
        Integer abnormalCount = this.dataList.get("abnormalCount") == null ? Integer.valueOf(0) : this.dataList.get("abnormalCount");
        Integer n = attackCount = this.dataList.get("attackCount") == null ? Integer.valueOf(0) : this.dataList.get("attackCount");
        if (this.deviceType == 1) {
            if (abnormalCount > 0) {
                factor = Math.pow(10.0, 1.0);
                percenet = Math.floor(countNum.doubleValue() / abnormalCount.doubleValue() * 100.0 * factor + 0.5) / factor + "%";
            }
        } else if (attackCount > 0) {
            factor = Math.pow(10.0, 1.0);
            percenet = Math.floor(countNum.doubleValue() / attackCount.doubleValue() * 100.0 * factor + 0.5) / factor + "%";
        }
        if (AticUtil.isNull((String)attackTypeStr)) {
            return AticUtil.getText((String)"report.total.zone.summary.noabnormal", (Locale)this.locale);
        }
        String attackTypeFormat = "";
        attackTypeFormat = this.deviceType == 1 ? AticUtil.getText((String)"report.total.summary.abnormalTypeCount", (Locale)this.locale) : AticUtil.getText((String)"report.total.summary.attackTypeCount", (Locale)this.locale);
        Object[] attackTypeObjs = new Object[]{attackTypeStr, percenet};
        attackTypeFormat = MessageFormat.format(attackTypeFormat, attackTypeObjs);
        return attackTypeFormat;
    }

    private String processAttackLogDataFormat4ThirdSummary(Map<?, ?> queryCond, List<AttackLog> attackLogDataSetViewList) {
        Integer abnormalCount = this.dataList.get("abnormalCount") == null ? Integer.valueOf(0) : this.dataList.get("abnormalCount");
        Integer attackCount = this.dataList.get("attackCount") == null ? Integer.valueOf(0) : this.dataList.get("attackCount");
        FlowCompareConditionForm flowCompareConditionForm = new FlowCompareConditionForm();
        ReportAnalysisUtil.processTimeParams(queryCond, flowCompareConditionForm);
        Long totalDropBps = 0L;
        for (AttackLog temp : attackLogDataSetViewList) {
            totalDropBps = totalDropBps + temp.getDropBytes();
        }
        if (this.deviceType == 1) {
            String abnormalCountStr = AticUtil.getText((String)"report.total.summary.abnormalEventCount", (Locale)this.locale);
            Object[] abnormalCountObjs = new Object[]{this.transFormNumber(abnormalCount)};
            abnormalCountStr = MessageFormat.format(abnormalCountStr, abnormalCountObjs);
            return abnormalCountStr;
        }
        String attackCountStr = AticUtil.getText((String)"report.total.summary.attackEventCount", (Locale)this.locale);
        double totalDropBps4Com = totalDropBps.longValue();
        String totalDropFlow = ReportAnalysisUtil.conversionFlowUnit(totalDropBps4Com);
        Object[] attackCountObjs = new Object[]{this.transFormNumber(abnormalCount), this.transFormNumber(attackCount), totalDropFlow + "B"};
        attackCountStr = MessageFormat.format(attackCountStr, attackCountObjs);
        return attackCountStr;
    }

    private String processAttackDataFormat4FiveSummary(long sessionId, List<FlowCompareView> flowCompareViewList, DataStatConditionForm datastatConditionForm) {
        Long maxInFlow = 0L;
        Long maxAttackFlow = 0L;
        Long maxMaxInFlow = 0L;
        Long maxMaxAttackFlow = 0L;
        for (FlowCompareView temp : flowCompareViewList) {
            maxInFlow = maxInFlow < temp.getInFlow() ? temp.getInFlow() : maxInFlow;
            maxAttackFlow = maxAttackFlow < temp.getAttackFlow() ? temp.getAttackFlow() : maxAttackFlow;
            maxMaxInFlow = maxMaxInFlow < temp.getMaxInFlow() ? temp.getMaxInFlow() : maxMaxInFlow;
            maxMaxAttackFlow = maxMaxAttackFlow < temp.getMaxAttackFlow() ? temp.getMaxAttackFlow() : maxMaxAttackFlow;
        }
        List<ZoneOrIpTopNView> zoneOrIpTopNViewTemp = null;
        zoneOrIpTopNViewTemp = TransmitZoneOrIpTopNViewData.getInstance().getDataList(sessionId);
        TransmitZoneOrIpTopNViewData.getInstance().removeData(sessionId);
        if (this.checkQueryPeakValue) {
            maxInFlow = maxMaxInFlow;
            maxAttackFlow = maxMaxAttackFlow;
        }
        String unit = "bps";
        String maxInFlow4Com = ReportAnalysisUtil.conversionFlowUnit(maxInFlow.longValue());
        String maxAttackFlow4Com = ReportAnalysisUtil.conversionFlowUnit(maxAttackFlow.longValue());
        if (this.deviceType == 1) {
            String attackDataFormat = AticUtil.getText((String)"report.total.zone.summary.noAttackData", (Locale)this.locale);
            if (this.checkQueryPeakValue) {
                attackDataFormat = AticUtil.getText((String)"report.total.zone.summary.noAttackData.peakFlow", (Locale)this.locale);
            }
            Object[] attackDataObjs = new Object[]{maxInFlow4Com + unit};
            attackDataFormat = MessageFormat.format(attackDataFormat, attackDataObjs);
            return attackDataFormat;
        }
        String attackDataFormat = "";
        String attackTimeAndCountStr = ReportAnalysisUtil.getAttackTime4SysAndZoneReport(sessionId, datastatConditionForm, this.locale);
        String attackTime = "";
        String attackCount = "";
        if (!AticUtil.isNull((String)attackTimeAndCountStr)) {
            attackTime = attackTimeAndCountStr.split("#")[0];
            attackCount = attackTimeAndCountStr.split("#")[1];
        }
        if (null != zoneOrIpTopNViewTemp && !zoneOrIpTopNViewTemp.isEmpty()) {
            attackDataFormat = AticUtil.getText((String)"report.total.zone.summary.attackData", (Locale)this.locale);
            if (this.checkQueryPeakValue) {
                attackDataFormat = AticUtil.getText((String)"report.total.zone.summary.attackData.peakFlow", (Locale)this.locale);
            }
            String attackIp = zoneOrIpTopNViewTemp.get(0).getName();
            String attackDuraData = zoneOrIpTopNViewTemp.get(0).getDisTotalDate();
            Long ipAttackCount = zoneOrIpTopNViewTemp.get(0).getAttackTimes();
            Object[] attackDataObjs = new Object[]{maxInFlow4Com + unit, maxAttackFlow4Com + unit, attackTime, attackCount, attackIp, ipAttackCount, attackDuraData};
            attackDataFormat = MessageFormat.format(attackDataFormat, attackDataObjs);
        } else if (AticUtil.isNull((String)attackTimeAndCountStr)) {
            attackDataFormat = AticUtil.getText((String)"report.total.zone.summary.attackDataOnlyFlow", (Locale)this.locale);
            if (this.checkQueryPeakValue) {
                attackDataFormat = AticUtil.getText((String)"report.total.zone.summary.attackDataOnlyFlow.peakFlow", (Locale)this.locale);
            }
            Object[] attackDataObjs = new Object[]{maxInFlow4Com + unit, maxAttackFlow4Com + unit};
            attackDataFormat = MessageFormat.format(attackDataFormat, attackDataObjs);
        } else {
            attackDataFormat = AticUtil.getText((String)"report.total.zone.summary.attackDataNoAttackIp", (Locale)this.locale);
            if (this.checkQueryPeakValue) {
                attackDataFormat = AticUtil.getText((String)"report.total.zone.summary.attackDataNoAttackIp.peakFlow", (Locale)this.locale);
            }
            Object[] attackDataObjs = new Object[]{maxInFlow4Com + unit, maxAttackFlow4Com + unit, attackTime, attackCount};
            attackDataFormat = MessageFormat.format(attackDataFormat, attackDataObjs);
        }
        return attackDataFormat;
    }

    private void processSummary(Map<String, List<String>> map, Integer abnormalCount) {
        StringBuffer summaryText = new StringBuffer(TAB_SPACE);
        summaryText.append("1) ");
        if (abnormalCount > 0) {
            if (this.deviceType == 1) {
                summaryText.append(AticUtil.getText((String)"report.total.zone.summary.abnormal", (Locale)this.locale));
            } else {
                summaryText.append(AticUtil.getText((String)"report.total.zone.summary1", (Locale)this.locale));
            }
            summaryText.append('\n');
            summaryText.append(TAB_SPACE);
            summaryText.append(' ');
            summaryText.append("2) ");
            summaryText.append(AticUtil.getText((String)"report.total.zone.summary2", (Locale)this.locale));
            summaryText.append('\n');
        } else {
            summaryText.append(AticUtil.getText((String)"report.total.zone.summary.noAbnormal", (Locale)this.locale));
        }
        ArrayList<String> summaryTextList = new ArrayList<String>();
        summaryTextList.add(summaryText.toString());
        map.put("summaryDetail", summaryTextList);
    }

    private String transFormNumber(int ipCount) {
        return CommonUtil.transformNumber((String)String.valueOf(ipCount), (String)"");
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public static Integer getTotalAbnormalCount() {
        return totalAbnormalCount;
    }

    public static void setTotalAbnormalCount(Integer totalAbnormalCount) {
        TotalZoneSecurityDs.totalAbnormalCount = totalAbnormalCount;
    }
}

