/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.report.action;

import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.DataSourceStub;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.report.model.DeviceListForm;
import com.hs.atic.report.model.ReportCondModel;
import com.hs.atic.report.model.ReportFileType;
import com.hs.atic.report.model.SelectForm;
import com.hs.atic.report.model.TaskLogForm;
import com.hs.atic.report.model.TaskScheduleForm;
import com.hs.atic.report.model.TaskStateForm;
import com.hs.atic.report.model.TaskWeekForm;
import com.hs.atic.report.model.TimeTaskForm;
import com.hs.atic.report.util.ReportConditionUtil;
import com.hs.atic.report.util.ReportConstants;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.util.LegoDataProtectorWrapper;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogResultLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import com.hs.lego.ui.plat.common.util.OperateLocker;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.ireport.form.ReportEmailInfoForm;
import com.hs.vsm.common.sdk.ireport.service.IReportEmailInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.engine.exception.ParaException;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.model.vo.OperateResult;
import com.security.ireport.model.vo.PageInfo;
import com.security.ireport.model.vo.ParamPage;
import com.security.ireport.model.vo.ReportTemplate;
import com.security.ireport.model.vo.SysOptLog;
import com.security.ireport.model.vo.TaskCondition;
import com.security.ireport.model.vo.TaskLogVO;
import com.security.ireport.model.vo.TemplateCondition;
import com.security.ireport.model.vo.TimeTask;
import com.security.ireport.service.ReportTemplateService;
import com.security.ireport.service.ResultReportService;
import com.security.ireport.service.TimeTaskService;
import com.security.ireport.service.impl.ReportTemplateServiceImpl;
import com.security.ireport.service.impl.ResultReportServiceImpl;
import com.security.ireport.service.impl.TimeTaskServiceImpl;
import com.security.ireport.task.IRTimeTaskMgr;
import com.security.ireport.util.ActionUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportLogManager;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.logserver.module.condition.util.Pair;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ReportTaskAction
extends BaseAction {
    private static final long serialVersionUID = -474216707739491939L;
    private static final String SYSTEM_REPORT = "system";
    private static final String ZONE_REPORT = "zone";
    private static final int TASK_MAX_LIST_NUM = 10000;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private String queryReportTaskName;
    private String queryContent;
    private transient TaskLogVO taskLogVO = null;
    private transient List<TaskLogVO> tempResults;
    private transient List<TaskLogForm> taskLog;
    private transient List<TimeTaskForm> tempTasks;
    private transient List<TaskScheduleForm> taskScheduleList;
    private transient TaskScheduleForm taskScheduleForm;
    private transient List<DeviceListForm> zoneDeviceList;
    private transient DeviceListForm deviceListForm;
    private String taskSchedule;
    private transient TaskStateForm taskStateForm;
    private String taskState;
    private transient List<TaskWeekForm> taskWeekList;
    private transient List<ReportFileType> reportFileTypeList;
    private List<DeviceListForm> initDeviceList;
    private String defaultDevice;
    private String defaultDeviceId;
    private transient TaskWeekForm taskWeekForm;
    private String startTime;
    private String endTime;
    private String taskStartTime;
    private String taskEndTime;
    private String synthesisReportType;
    private String systemDeviceId;
    private String zoneDeviceId;
    private String systemDeviceName;
    private String zoneDeviceName;
    private String directionSystem;
    private String directionZone;
    private String systemReportIds;
    private String zoneReportIds;
    private String systemTopNValues;
    private String zoneTopNValues;
    private String deviceType;
    private Long zoneId;
    private String zoneName;
    private String reportForm;
    private Integer taskId;
    private String batchTaskId;
    private String batchTaskName;
    private String taskName;
    private String taskDesc;
    private String runTime;
    private transient SelectForm selectMinute;
    private transient SelectForm selectHour;
    private transient SelectForm selectDay;
    private transient SelectForm selectMonth;
    private String systemReportIdTopNs;
    private String zoneReportIdTopNs;
    private Integer schedule;
    private transient TimeTask timeTaskVO = null;
    private transient TimeTaskService timeTaskService = new TimeTaskServiceImpl();
    private transient ReportTemplateService reportTemplateService = new ReportTemplateServiceImpl();
    private transient ResultReportService resultReportService = new ResultReportServiceImpl();
    private String defaultDeviceName;
    private List<LangPair> taskScheduleData;
    private List<LangPair> reportStatusData;
    private boolean isSupportOutbound;
    private transient IReportEmailInfoService reportEmailInfoService = ReportAnalysisUtil.getReportEmailInfoService();
    private String systemEmailInfo;
    private String otherEmailInfo;
    private int checkZoneEmail;
    private int checkOtherEmail;
    private String reportType;
    private Boolean zoneReportEnable;
    private Boolean systemReportEnable;
    private String dateStartTime;
    private String dateEndTime;
    private String scheduleType;
    private String startDate;
    private String endDate;
    private String[] logId;

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void initTaskWeekList() {
        if (null == this.taskWeekList) {
            this.taskWeekList = new ArrayList<TaskWeekForm>();
            TaskWeekForm weekForm7 = new TaskWeekForm();
            weekForm7.setName(this.getText("atic.report.task.sunday"));
            weekForm7.setWeek(7);
            this.taskWeekList.add(weekForm7);
            TaskWeekForm weekForm1 = new TaskWeekForm();
            weekForm1.setName(this.getText("atic.report.task.monday"));
            weekForm1.setWeek(1);
            this.taskWeekList.add(weekForm1);
            TaskWeekForm weekForm2 = new TaskWeekForm();
            weekForm2.setName(this.getText("atic.report.task.tuesday"));
            weekForm2.setWeek(2);
            this.taskWeekList.add(weekForm2);
            TaskWeekForm weekForm3 = new TaskWeekForm();
            weekForm3.setName(this.getText("atic.report.task.wednesday"));
            weekForm3.setWeek(3);
            this.taskWeekList.add(weekForm3);
            TaskWeekForm weekForm4 = new TaskWeekForm();
            weekForm4.setName(this.getText("atic.report.task.thursday"));
            weekForm4.setWeek(4);
            this.taskWeekList.add(weekForm4);
            TaskWeekForm weekForm5 = new TaskWeekForm();
            weekForm5.setName(this.getText("atic.report.task.friday"));
            weekForm5.setWeek(5);
            this.taskWeekList.add(weekForm5);
            TaskWeekForm weekForm6 = new TaskWeekForm();
            weekForm6.setName(this.getText("atic.report.task.saturday"));
            weekForm6.setWeek(6);
            this.taskWeekList.add(weekForm6);
        }
        if (null == this.taskWeekForm) {
            this.taskWeekForm = new TaskWeekForm();
            this.taskWeekForm.setName(this.getText("atic.report.task.sunday"));
            this.taskWeekForm.setWeek(7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryReportTask() {
        try {
            TimeTask timeTask = new TimeTask();
            User currentUser = (User)this.getSession().getAttribute("currentUser");
            timeTask.setUserName(currentUser.getUserName());
            timeTask.setAuthId("VSM_ATIC");
            if (this.queryReportTaskName != null && !this.queryReportTaskName.trim().equals("")) {
                boolean isReportTaskNamePass = AticUtil.isValidReportTaskName((String)this.queryReportTaskName.trim());
                if (!isReportTaskNamePass) {
                    logger.error((Object)("queryReportTask failed, because queryReportTaskName is invalid, queryReportTaskName:" + ReportTaskAction.getcleanedMessage(this.queryReportTaskName)));
                    throw new LegoCheckedException(570712L);
                }
                timeTask.setTaskName(this.queryReportTaskName.trim());
            }
            if (null != this.taskStateForm && this.taskStateForm.getState() != -1) {
                timeTask.setState(Integer.valueOf(this.taskStateForm.getState()));
            }
            if (null != this.taskScheduleForm && this.taskScheduleForm.getSchedule() != -1) {
                timeTask.setSchedule(Integer.valueOf(this.taskScheduleForm.getSchedule()));
            }
            PageInfo pageInfo = this.timeTaskService.queryTask(new ParamPage(this.getStart(), this.getPageSize()), timeTask);
            this.setTotal(pageInfo.getTotal());
            List taskLists = pageInfo.getResults();
            if (null == this.tempTasks) {
                this.tempTasks = new ArrayList<TimeTaskForm>();
            }
            TimeTaskForm timeTaskForm = null;
            for (int i = 0; i < taskLists.size(); ++i) {
                timeTaskForm = new TimeTaskForm();
                timeTaskForm.setTaskId(((TimeTask)taskLists.get(i)).getTaskId());
                timeTaskForm.setTaskName(((TimeTask)taskLists.get(i)).getTaskName());
                timeTaskForm.setTaskDesc(((TimeTask)taskLists.get(i)).getTaskDesc());
                timeTaskForm.setSchedule(((TimeTask)taskLists.get(i)).getSchedule());
                timeTaskForm.setStartDate(AticUtil.convertTimeLong((Long)((TimeTask)taskLists.get(i)).getStartDate()));
                timeTaskForm.setEndDate(AticUtil.convertTimeLong((Long)((TimeTask)taskLists.get(i)).getEndDate()));
                timeTaskForm.setState(((TimeTask)taskLists.get(i)).getState());
                timeTaskForm.setResultType(((TimeTask)taskLists.get(i)).getResultType());
                this.tempTasks.add(timeTaskForm);
            }
            this.initCombData();
        }
        catch (RuntimeException e) {
            logger.error((Object)("unknow error in queryReportTask function: " + e.getMessage()));
        }
        finally {
            if (this.taskScheduleForm != null && this.taskStateForm != null) {
                this.taskSchedule = this.getText(ReportConstants.getMapReportSchedule().get(this.taskScheduleForm.getSchedule()));
                this.taskState = this.getText(ReportConstants.getMapReportStatus().get(this.taskStateForm.getState()));
            } else {
                this.taskSchedule = this.getText("atic.analysis.common.all");
                this.taskState = this.getText("atic.analysis.common.all");
            }
        }
        return "list";
    }

    public boolean validateQueryReportTaskName() {
        if (this.queryReportTaskName != null && !this.queryReportTaskName.trim().equals("")) {
            if (this.queryReportTaskName.trim().equalsIgnoreCase("null")) {
                return false;
            }
            return AticUtil.isValidReportTaskName((String)this.queryReportTaskName.trim());
        }
        return true;
    }

    public boolean validateScheduleFormSchedule() {
        if (null != this.taskScheduleForm) {
            int scheduleNum = this.taskScheduleForm.getSchedule();
            return scheduleNum >= -1 && scheduleNum <= 4;
        }
        return true;
    }

    public boolean validateStateFormState() {
        if (null != this.taskStateForm) {
            int state = this.taskStateForm.getState();
            return state >= -1 && state <= 2;
        }
        return true;
    }

    private void isCurrentuserHasPermissionForLogReport(List<Integer> logIds) {
        String userName = ProductFaceUtil.getInstance().getUserName();
        if ("admin".equals(userName)) {
            return;
        }
        List<TimeTask> taskList = this.getTimeTaskByUsername(userName);
        ArrayList<Integer> allLogIds = new ArrayList<Integer>();
        if (null != taskList && !taskList.isEmpty()) {
            for (TimeTask temp : taskList) {
                List taskLogVOList = this.timeTaskService.getLogInfo(temp.getTaskId());
                if (null == taskLogVOList || taskLogVOList.isEmpty()) continue;
                for (TaskLogVO tempTaskLog : taskLogVOList) {
                    allLogIds.add(tempTaskLog.getPkId());
                }
            }
            for (Integer logIdTemp : logIds) {
                if (allLogIds.contains(logIdTemp)) continue;
                logger.info((Object)"yue quan operation");
                throw new LegoCheckedException(630114L);
            }
        } else {
            logger.info((Object)"TimeTask is null or current user have no permission.");
            throw new LegoCheckedException(630114L);
        }
    }

    private void checkReportTaskSecurity(List<Integer> taskIds) {
        String userName = ProductFaceUtil.getInstance().getUserName();
        if ("admin".equals(userName)) {
            return;
        }
        if (this.timeTaskService.queryTaskNumInId(taskIds) == 0) {
            return;
        }
        List<TimeTask> taskList = this.getTimeTaskByUsername(userName);
        if (null != taskList && !taskList.isEmpty()) {
            ArrayList<Integer> allTaskIds = new ArrayList<Integer>();
            for (TimeTask temp : taskList) {
                allTaskIds.add(temp.getTaskId());
            }
            for (Integer taskIdTemp : taskIds) {
                if (allTaskIds.contains(taskIdTemp)) continue;
                logger.info((Object)"yue quan operation");
                throw new LegoCheckedException(630114L);
            }
        } else {
            logger.info((Object)"Time Task is null");
            throw new LegoCheckedException(630114L);
        }
    }

    public List<TimeTask> getTimeTaskByUsername(String userName) {
        List taskList = null;
        TimeTask timeTask = new TimeTask();
        try {
            timeTask.setUserName(userName);
            timeTask.setAuthId("VSM_ATIC");
            PageInfo pageInfo = this.timeTaskService.queryTask(new ParamPage(0, Integer.MAX_VALUE), timeTask);
            taskList = pageInfo.getResults();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get time task of user \"" + userName + "\": " + e.getMessage()));
        }
        return taskList;
    }

    public void delTask() {
        if (this.taskId < 0) {
            throw new LegoCheckedException(570505L);
        }
        String userName = ProductFaceUtil.getInstance().getUserName();
        int level = 2;
        HttpServletResponse response = (HttpServletResponse)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        response.setContentType("application/xml;charset=UTF-8");
        TimeTask delTask = null;
        ArrayList<Integer> taskIds = new ArrayList<Integer>();
        taskIds.add(this.taskId);
        this.checkReportTaskSecurity(taskIds);
        try {
            delTask = this.timeTaskService.getTimeTask(this.taskId);
            if (null == delTask) {
                response.getWriter().write("success");
            } else {
                List deleteFileNameList = this.timeTaskService.getLogPathInfo(taskIds);
                OperateResult delResult = this.timeTaskService.delTimeTask(this.taskId);
                this.resultReportService.updateResultReportByTaskId(taskIds);
                if (null != delResult) {
                    ArrayList<OperateResult> resultList = new ArrayList<OperateResult>();
                    resultList.add(delResult);
                    String result = ActionUtil.setDeleteResult(resultList);
                    response.getWriter().write(result);
                    IReportLogManager.getInstance().printSysLog(new SysOptLog("time.task.module", "module.del.time.task", delTask.getTaskName(), 1, "del.time.task.fail", userName, level));
                } else {
                    IReportUtil.deleteFile((String)IReportMgrUtil.getExportPath(), (List)deleteFileNameList);
                    response.getWriter().write("success");
                    IReportLogManager.getInstance().printSysLog(new SysOptLog("time.task.module", "module.del.time.task", delTask.getTaskName(), "del.time.task.success", userName, level));
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"delTask IOException error");
            IReportLogManager.getInstance().printSysLog(new SysOptLog("time.task.module", "module.del.time.task", null != delTask ? delTask.getTaskName() : null, 1, "del.time.task.fail", userName, level));
        }
    }

    public void batchDelReports() {
        ArrayList<Integer> logIds = new ArrayList<Integer>();
        for (String logIdTemp : this.logId) {
            logIds.add(Integer.parseInt(logIdTemp));
        }
        this.isCurrentuserHasPermissionForLogReport(logIds);
        String userName = ProductFaceUtil.getInstance().getUserName();
        int level = 2;
        HttpServletResponse response = (HttpServletResponse)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        response.setContentType("charset=UTF-8");
        List delResultInfo = this.resultReportService.getResults(this.logId);
        OperateResult delResult = this.resultReportService.delResultReport(this.logId);
        String deleteResult = ActionUtil.setDeleteResult((OperateResult)delResult);
        String module = "result.report";
        String operation = "del.task.log";
        String detail = "del.task.log.success";
        int result = 0;
        try {
            response.getWriter().write(deleteResult);
        }
        catch (IOException e) {
            logger.error((Object)"batchDelReports IOException");
            result = 1;
            detail = "del.task.log.fail";
        }
        ActionUtil.printSysLog((List)delResultInfo, (String)module, (String)operation, (int)result, (String)detail, (String)userName, (int)level);
    }

    public void batchDelTask() {
        block9: {
            boolean checkTaskIds = this.validateBatchTaskIds();
            if (!checkTaskIds) {
                throw new LegoCheckedException(570505L);
            }
            String userName = ProductFaceUtil.getInstance().getUserName();
            int level = 2;
            HttpServletResponse response = (HttpServletResponse)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            response.setContentType("application/xml;charset=UTF-8");
            ArrayList<Integer> tasksDel = new ArrayList<Integer>();
            List timeTaskDel = null;
            List delResult = null;
            try {
                timeTaskDel = this.timeTaskService.getTimeTasks(this.batchTaskId);
                if (timeTaskDel.isEmpty()) {
                    response.getWriter().write("success");
                    return;
                }
                for (int i = 0; i < timeTaskDel.size(); ++i) {
                    tasksDel.add(((TimeTask)timeTaskDel.get(i)).getTaskId());
                }
                this.checkReportTaskSecurity(tasksDel);
                List deleteFileNameList = this.timeTaskService.getLogPathInfo(tasksDel);
                delResult = this.timeTaskService.delTimeTask(tasksDel);
                this.resultReportService.updateResultReportByTaskId(tasksDel);
                if (null != delResult && !delResult.isEmpty()) {
                    String result = ActionUtil.setDeleteResult((List)delResult);
                    response.getWriter().write(result);
                } else {
                    IReportUtil.deleteFile((String)IReportMgrUtil.getExportPath(), (List)deleteFileNameList);
                    response.getWriter().write("success");
                }
                if (timeTaskDel.isEmpty()) break block9;
                for (TimeTask timeTask : timeTaskDel) {
                    IReportLogManager.getInstance().printSysLog(new SysOptLog("time.task.module", "module.del.time.task", timeTask.getTaskName(), "del.time.task.success", userName, level));
                }
            }
            catch (IOException e) {
                logger.error((Object)"batchDelTask IOException");
                if (null == timeTaskDel || timeTaskDel.isEmpty()) break block9;
                for (TimeTask timeTask : timeTaskDel) {
                    IReportLogManager.getInstance().printSysLog(new SysOptLog("time.task.module", "module.del.time.task", timeTask.getTaskName(), 1, "del.time.task.fail", userName, level));
                }
            }
        }
    }

    public String queryReportResult() {
        logger.info((Object)"Begin ReportTaskAction queryReportResult function");
        try {
            boolean isReportTaskNamePass;
            this.taskLogVO = new TaskLogVO();
            if (this.queryContent != null && !this.queryContent.trim().equals("") && (isReportTaskNamePass = AticUtil.isValidReportTaskName((String)this.queryContent.trim()))) {
                this.taskLogVO.setReportName(this.queryContent.trim());
            }
            User currentUser = (User)this.getSession().getAttribute("currentUser");
            this.taskLogVO.setUserName(currentUser.getUserName());
            this.taskLogVO.setAuthId("VSM_ATIC");
            PageInfo pageInfo = this.resultReportService.queryTask(new ParamPage(this.getStart(), this.getPageSize()), this.taskLogVO);
            this.setTotal(pageInfo.getTotal());
            this.tempResults = pageInfo.getResults();
            logger.info((Object)"End ReportTaskAction queryReportResult function");
        }
        catch (Exception e) {
            logger.error((Object)("ReportTaskAction queryReportResult query is fail: " + e.getMessage()));
        }
        return "success";
    }

    public boolean validateQueryContent() {
        if (this.queryContent != null && !this.queryContent.trim().equals("")) {
            if (this.queryContent.trim().equalsIgnoreCase("null")) {
                return false;
            }
            return AticUtil.isValidReportTaskName((String)this.queryContent.trim());
        }
        return true;
    }

    private void initTaskScheduleList() {
        if (null == this.taskScheduleList) {
            this.taskScheduleList = new ArrayList<TaskScheduleForm>();
            TaskScheduleForm scheduleForm1 = new TaskScheduleForm();
            scheduleForm1.setName(this.getText("atic.report.task.scheduleDay"));
            scheduleForm1.setSchedule(1);
            this.taskScheduleList.add(scheduleForm1);
            TaskScheduleForm scheduleForm2 = new TaskScheduleForm();
            scheduleForm2.setName(this.getText("atic.report.task.scheduleWeek"));
            scheduleForm2.setSchedule(2);
            this.taskScheduleList.add(scheduleForm2);
            TaskScheduleForm scheduleForm3 = new TaskScheduleForm();
            scheduleForm3.setName(this.getText("atic.report.task.scheduleMonth"));
            scheduleForm3.setSchedule(3);
            this.taskScheduleList.add(scheduleForm3);
            TaskScheduleForm scheduleForm4 = new TaskScheduleForm();
            scheduleForm4.setName(this.getText("atic.report.task.scheduleYear"));
            scheduleForm4.setSchedule(4);
            this.taskScheduleList.add(scheduleForm4);
        }
        if (null == this.taskScheduleForm) {
            this.taskScheduleForm = new TaskScheduleForm();
            this.taskScheduleForm.setName(this.getText("atic.report.task.scheduleDay"));
            this.taskScheduleForm.setSchedule(1);
        }
    }

    private void initTaskDevList(Long zoneID) {
        if (null == this.zoneDeviceList) {
            AticDevice firewall;
            this.zoneDeviceList = new ArrayList<DeviceListForm>();
            HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
            IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
            ArrayList<AticDevice> fwList = new ArrayList<AticDevice>();
            if (null != zoneID) {
                IZoneDeviceDeployStatusService zoneDeviceDeployStatusService = (IZoneDeviceDeployStatusService)ServiceContext.getInstance().getService("zoneDeviceDeployStatusService", IZoneDeviceDeployStatusService.class);
                List lstDevId = zoneDeviceDeployStatusService.getDevByZone4Secutity(zoneID, isAdmin, Long.valueOf(currentUser.getUserID()));
                for (Long devId : lstDevId) {
                    firewall = firewallService.getDeviceByMoid(devId.longValue());
                    if (null == firewall) continue;
                    fwList.add(firewall);
                }
            }
            boolean hasCleanDev = false;
            boolean hasDetectDev = false;
            DeviceListForm deviceListForms = null;
            for (int i = 0; i < fwList.size(); ++i) {
                deviceListForms = new DeviceListForm();
                firewall = (AticDevice)fwList.get(i);
                if (null == firewall) continue;
                String fireName = firewall.getName();
                String moId = String.valueOf(firewall.getMoId());
                int deviceTypeInt = ReportAnalysisUtil.getDeviceDdos(firewall);
                if (0 == deviceTypeInt) {
                    fireName = fireName + this.getText("atic.analysis.common.clean");
                    moId = moId + "_0";
                    hasCleanDev = true;
                } else if (1 == deviceTypeInt) {
                    fireName = fireName + this.getText("atic.analysis.common.detect");
                    moId = moId + "_1";
                    hasDetectDev = true;
                } else if (2 == deviceTypeInt) {
                    DeviceListForm deviceListFormTemp = new DeviceListForm();
                    String fireNameClean = fireName + this.getText("atic.analysis.common.clean");
                    String moIdClean = moId + "_" + 0;
                    deviceListFormTemp.setZoneDeviceId(moIdClean);
                    deviceListFormTemp.setZoneDeviceName(fireNameClean);
                    this.zoneDeviceList.add(deviceListFormTemp);
                    fireName = fireName + this.getText("atic.analysis.common.detect");
                    moId = moId + "_1";
                    hasCleanDev = true;
                    hasDetectDev = true;
                }
                deviceListForms.setZoneDeviceId(moId);
                deviceListForms.setZoneDeviceName(fireName);
                this.zoneDeviceList.add(deviceListForms);
            }
            this.processDevList4DevType(hasCleanDev, hasDetectDev);
        }
    }

    private void processDevList4DevType(boolean hasCleanDev, boolean hasDetectDev) {
        DeviceListForm deviceListFormAll = new DeviceListForm();
        deviceListFormAll.setZoneDeviceId("0");
        deviceListFormAll.setZoneDeviceName(this.getText("ips.analysis.common.netdevice.all"));
        DeviceListForm deviceListFormClean = new DeviceListForm();
        deviceListFormClean.setZoneDeviceId("-1");
        deviceListFormClean.setZoneDeviceName(this.getText("atic.analysis.common.netdevice.clean.nobracket"));
        DeviceListForm deviceListFormDetect = new DeviceListForm();
        deviceListFormDetect.setZoneDeviceId("-2");
        deviceListFormDetect.setZoneDeviceName(this.getText("atic.analysis.common.netdevice.detect.nobracket"));
        if (hasCleanDev && hasDetectDev) {
            this.zoneDeviceList.add(0, deviceListFormAll);
            this.zoneDeviceList.add(1, deviceListFormClean);
            this.zoneDeviceList.add(2, deviceListFormDetect);
        } else if (hasCleanDev && !hasDetectDev) {
            this.zoneDeviceList.add(0, deviceListFormClean);
        } else if (!hasCleanDev && hasDetectDev) {
            this.zoneDeviceList.add(0, deviceListFormDetect);
        }
    }

    public String addReportTaskInit() {
        this.initTaskWeekList();
        this.initTaskScheduleList();
        this.initExportFileTypeList();
        this.initDeviceList();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        request.setAttribute("isTask", (Object)"1");
        ILicenseOutboundService licenseOutboundService = ReportBisUtil.getLicenseOutboundService();
        this.isSupportOutbound = licenseOutboundService.isSupportOutbound();
        request.getSession().setAttribute("isSupportOutbound", (Object)this.isSupportOutbound);
        this.defaultDeviceName = this.getText("ips.analysis.common.netdevice.all");
        return "success";
    }

    private void initDeviceList() {
        DataSourceStub dataSourceStub = new DataSourceStub();
        List<Pair<String, String>> listDevice = dataSourceStub.getDeviceListAndNFA();
        this.initDeviceList = new ArrayList<DeviceListForm>();
        if (listDevice.size() == 1) {
            String devId = (String)listDevice.get(0).getKey();
            String devModel = ReportConditionUtil.getDeviceModelByCombId(devId);
            if (devId.contains("_")) {
                devId = devId + '_' + devModel;
            } else {
                String devType = ReportConditionUtil.getDeviceTypeByCombId(devId);
                devId = devId + '_' + devType + '_' + devModel;
            }
            DeviceListForm deviceForm = new DeviceListForm();
            deviceForm.setSystemDeviceId(devId);
            deviceForm.setSystemDeviceName((String)listDevice.get(0).getValue());
            this.initDeviceList.add(deviceForm);
            this.defaultDevice = (String)listDevice.get(0).getValue();
            this.defaultDeviceId = devId;
        } else {
            Pair pairClean = new Pair();
            Pair allClean = new Pair();
            Pair alldetect = new Pair();
            pairClean.setKey((Object)String.valueOf(0));
            pairClean.setValue((Object)this.getText("ips.analysis.common.netdevice.all"));
            allClean.setKey((Object)String.valueOf(-1));
            allClean.setValue((Object)this.getText("ips.analysis.common.netdevice.clean.nobracket"));
            alldetect.setKey((Object)String.valueOf(-2));
            alldetect.setValue((Object)this.getText("ips.analysis.common.netdevice.detect.nobracket"));
            listDevice.add(0, (Pair<String, String>)pairClean);
            listDevice.add(1, (Pair<String, String>)allClean);
            listDevice.add(2, (Pair<String, String>)alldetect);
            for (Pair<String, String> device : listDevice) {
                String devId = (String)device.getKey();
                if (this.checkSingleDev(devId)) {
                    String devModel = ReportConditionUtil.getDeviceModelByCombId(devId);
                    if (devId.contains("_")) {
                        devId = devId + '_' + devModel;
                    } else {
                        String devType = ReportConditionUtil.getDeviceTypeByCombId(devId);
                        devId = devId + '_' + devType + '_' + devModel;
                    }
                }
                if ("-1".equals(devId)) {
                    device.setValue((Object)this.getText("atic.analysis.common.netdevice.clean.nobracket"));
                }
                if ("-2".equals(devId)) {
                    device.setValue((Object)this.getText("atic.analysis.common.netdevice.detect.nobracket"));
                }
                if ("0".equals(devId)) {
                    device.setValue((Object)this.getText("ips.analysis.common.netdevice.all"));
                }
                DeviceListForm deviceForm = new DeviceListForm();
                deviceForm.setSystemDeviceId(devId);
                deviceForm.setSystemDeviceName((String)device.getValue());
                this.initDeviceList.add(deviceForm);
            }
            this.defaultDevice = this.getText("ips.analysis.common.netdevice.all");
            this.defaultDeviceId = "0";
        }
    }

    private boolean checkSingleDev(String devId) {
        return !"-1".equals(devId) && !"-2".equals(devId) && !"0".equals(devId);
    }

    public void addTimeTaskValidate() {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/html;charset=UTF-8");
        SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String alertStr = this.getText("time.task.validate.endtime");
        try {
            Date endTimeDate = smpDateFormat.parse(this.endDate);
            Date startTimeDate = smpDateFormat.parse(this.startDate);
            long nextRunTime = IReportMgrUtil.getTaskNextRunTime((int)this.schedule, (String)this.runTime, (long)startTimeDate.getTime(), (long)endTimeDate.getTime());
            if (nextRunTime <= 0L) {
                response.getWriter().write(alertStr);
            } else {
                response.getWriter().write("success");
            }
        }
        catch (Exception e) {
            logger.error((Object)("addTimeTaskValidate error!" + e.getMessage()));
        }
    }

    public void checkTaskName() {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/html;charset=UTF-8");
        try {
            if (!this.checkTaskNum()) {
                response.getWriter().write("571996");
            } else if (this.timeTaskService.checkName(this.taskName)) {
                response.getWriter().write("error");
            } else {
                response.getWriter().write("success");
            }
        }
        catch (Exception e) {
            logger.error((Object)("checkTaskName error!" + e.getMessage()));
        }
    }

    public boolean checkTaskNum() {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/html;charset=UTF-8");
        TimeTask timeTask = new TimeTask();
        PageInfo pageInfo = this.timeTaskService.queryTask(new ParamPage(this.getStart(), this.getPageSize()), timeTask);
        int sum = pageInfo.getTotal();
        if (9999 < sum) {
            logger.error((Object)("task_list_num exceed 10000, task_list_num=" + sum));
            User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
            com.hs.lego.core.system.syslog.sdk.model.SysOptLog oOptLog = new com.hs.lego.core.system.syslog.sdk.model.SysOptLog();
            oOptLog.setDate(new Date());
            oOptLog.setTarget("add.time.task");
            oOptLog.setTargetLocal(Boolean.valueOf(true));
            oOptLog.setLevel(SysoplogLevel.normal.getValue());
            oOptLog.setModule("report.timeTask");
            oOptLog.setOperation("add.time.task");
            oOptLog.setDetail("lego.err.571996");
            oOptLog.setDetailPara(null);
            oOptLog.setResult(SysoplogResultLevel.failed.getValue());
            oOptLog.setOperator(currentUser.getUserName());
            oOptLog.setTerminalIp(currentUser.getIpAdr());
            ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
            if (null != sysOpLog) {
                sysOpLog.writeOptLog(oOptLog);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showReport() {
        BufferedOutputStream output;
        BufferedInputStream input;
        block16: {
            block15: {
                if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.showReport)) {
                    throw new LegoCheckedException(570516L);
                }
                input = null;
                output = null;
                String userName = ProductFaceUtil.getInstance().getUserName();
                int level = 3;
                String fileName = "";
                if (this.logId == null || this.logId.length <= 0) {
                    logger.error((Object)"logId is null or isEmpty.");
                    SysOptLog errorLog = new SysOptLog("report.manager", "report.download", "lego.report", 1, "report.download.fail", userName, level);
                    errorLog.setTargetLocal(Boolean.valueOf(true));
                    IReportLogManager.getInstance().printSysLog(errorLog);
                    return;
                }
                ArrayList<Integer> logIds = new ArrayList<Integer>();
                for (String logIdTemp : this.logId) {
                    logIds.add(Integer.parseInt(logIdTemp));
                }
                this.isCurrentuserHasPermissionForLogReport(logIds);
                User user = (User)this.fetchRequest().getSession().getAttribute("currentUser");
                com.hs.lego.core.system.syslog.sdk.model.SysOptLog logout = new com.hs.lego.core.system.syslog.sdk.model.SysOptLog();
                logout.setLevel(SysoplogLevel.info.getValue());
                logout.setResult(1);
                logout.setModule("lego.dic.module.user");
                logout.setOperation("lego.lab.com.loginout");
                logout.setOperator(user.getUserName());
                logout.setTerminalIp(user.getIpAdr());
                logout.setTarget(user.getUserName());
                logout.setDetail("atic.system.devsyslog.export.error");
                ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
                try {
                    ActionContext ctx = ActionContext.getContext();
                    TaskLogVO tasksLog = this.resultReportService.getResult(this.logId[0]);
                    if (null == tasksLog) {
                        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
                        String ext = IReportConfigUtil.getInstance().getIReportExtConfig();
                        request.setAttribute("action", (Object)("listResultByPage" + ext));
                        logger.error((Object)"logId is not exist.");
                        SysOptLog errorLog = new SysOptLog("report.manager", "report.download", "lego.report", 1, "report.download.fail", userName, level);
                        errorLog.setTargetLocal(Boolean.valueOf(true));
                        IReportLogManager.getInstance().printSysLog(errorLog);
                        return;
                    }
                    fileName = tasksLog.getResultFile();
                    String suffix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
                    HttpServletResponse response = (HttpServletResponse)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
                    response.setContentType("application/x-download");
                    response.setHeader("Content-Disposition", "attachment;filename=" + new String((tasksLog.getReportName() + suffix).getBytes("gb2312"), "ISO-8859-1"));
                    String filePath = IReportMgrUtil.getExportPath();
                    String filePathAndName = filePath + File.separator + fileName;
                    if (!AticUtil.checkFilePath((String)filePath, (String)filePathAndName)) {
                        sysOptLog.writeOptLog(logout);
                        this.fetchRequest().getSession().invalidate();
                        return;
                    }
                    File file = FileUtils.getFile((String[])new String[]{filePathAndName});
                    if (file.exists() && !AticUtil.checkFileType((File)file, (String)"504B0304")) {
                        sysOptLog.writeOptLog(logout);
                        this.fetchRequest().getSession().invalidate();
                        this.closeInputStream(input);
                        this.closeOutputStream(output);
                        break block15;
                    }
                    input = new BufferedInputStream(new FileInputStream(filePathAndName));
                    output = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    byte[] b = new byte[1024];
                    int len = 0;
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    IReportLogManager.getInstance().printSysLog(new SysOptLog("report.manager", "report.download", fileName, 0, "report.download.success", userName, level));
                    this.closeInputStream(input);
                    break block16;
                }
                catch (IOException e) {
                    logger.error((Object)"download report error");
                    IReportLogManager.getInstance().printSysLog(new SysOptLog("report.manager", "report.download", fileName, 1, "report.download.fail", userName, level));
                    return;
                }
            }
            OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.showReport);
            return;
        }
        this.closeOutputStream(output);
        OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.showReport);
        return;
        finally {
            this.closeInputStream(input);
            this.closeOutputStream(output);
            OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.showReport);
        }
    }

    public boolean validateShowReport() {
        String[] whiteList = new String[]{"logId"};
        return AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList);
    }

    private void closeInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile closeInputStream error");
            }
            finally {
                input = null;
            }
        }
    }

    private void closeOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile closeOutputStream error");
            }
            finally {
                output = null;
            }
        }
    }

    private void initExportFileTypeList() {
        if (null == this.reportFileTypeList) {
            this.reportFileTypeList = new ArrayList<ReportFileType>();
            ReportFileType fileTypePdf = new ReportFileType();
            fileTypePdf.setExportTypeName("PDF");
            fileTypePdf.setExportTypeValue("pdf");
            this.reportFileTypeList.add(fileTypePdf);
            ReportFileType fileTypeHtml = new ReportFileType();
            fileTypeHtml.setExportTypeName("HTML");
            fileTypeHtml.setExportTypeValue("html");
            this.reportFileTypeList.add(fileTypeHtml);
            ReportFileType fileTypeExcel = new ReportFileType();
            fileTypeExcel.setExportTypeName("EXCEL");
            fileTypeExcel.setExportTypeValue("excel");
            this.reportFileTypeList.add(fileTypeExcel);
        }
    }

    private void getReportIdAndTopN(List<String> zoneReportIdList, List<String> sysReportIdList, List<String> zoneReportTopNList, List<String> sysReportTopNList) {
        try {
            List taskConditionLists = this.timeTaskService.getTaskCondition(this.taskId);
            for (TaskCondition temp : taskConditionLists) {
                ReportTemplate reportTemplate = this.reportTemplateService.getTemplateById(temp.getTemplateId().toString());
                if (null == reportTemplate) {
                    return;
                }
                List templates = this.reportTemplateService.getConditionByTemId(temp.getTemplateId().toString());
                for (TemplateCondition templateCondition : templates) {
                    String topNValue;
                    Map keyMap;
                    if (reportTemplate.getDesc().equals(SYSTEM_REPORT)) {
                        sysReportIdList.add(templateCondition.getReportId());
                        keyMap = JSONUtil.transformKeyValueObjMap((String)templateCondition.getReportCondition());
                        topNValue = this.getJsonValueItemList(keyMap, "TOPN").get(0).getValue();
                        topNValue = this.processTopNValue(topNValue);
                        sysReportTopNList.add(topNValue);
                        continue;
                    }
                    zoneReportIdList.add(templateCondition.getReportId());
                    keyMap = JSONUtil.transformKeyValueObjMap((String)templateCondition.getReportCondition());
                    topNValue = this.getJsonValueItemList(keyMap, "TOPN").get(0).getValue();
                    topNValue = this.processTopNValue(topNValue);
                    zoneReportTopNList.add(topNValue);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"ReportTaskAction getReportIdAndTopN is fail");
        }
        catch (Exception e) {
            logger.error((Object)("ReportTaskAction getReportIdAndTopN is fail: " + e.getMessage()));
        }
    }

    private String processTopNValue(String topNValue) {
        if (AticUtil.isNull((String)topNValue)) {
            topNValue = "0";
        }
        return topNValue;
    }

    private boolean checkReportEdit(List<String> reportIdList, List<String> reportTopNList, boolean systemReport) {
        String[] reportTopns;
        String[] reportIds;
        boolean checkReportEdit = false;
        if (systemReport) {
            reportIds = this.systemReportIds.split(",");
            reportTopns = this.systemTopNValues.split(",");
        } else {
            reportIds = this.zoneReportIds.split(",");
            reportTopns = this.zoneTopNValues.split(",");
        }
        HashMap<String, String> zoneReportIdMap = new HashMap<String, String>();
        for (int j = 0; j < reportIdList.size(); ++j) {
            zoneReportIdMap.put(reportIdList.get(j), reportTopNList.get(j));
        }
        if (reportIds.length != reportIdList.size()) {
            return true;
        }
        for (int i = 0; i < reportIds.length; ++i) {
            if (zoneReportIdMap.containsKey(reportIds[i])) {
                String tempTopN = (String)zoneReportIdMap.get(reportIds[i]);
                if (reportTopns[i].equals(tempTopN)) continue;
                checkReportEdit = true;
                break;
            }
            checkReportEdit = true;
            break;
        }
        return checkReportEdit;
    }

    private String getTaskScheduleForOperaLog() {
        String taskScheduleStr = "atic.report.task.scheduleDay";
        taskScheduleStr = 2 == this.schedule ? "atic.report.task.scheduleWeek" : (3 == this.schedule ? "atic.report.task.scheduleMonth" : (4 == this.schedule ? "atic.report.task.scheduleYear" : "atic.report.task.scheduleDay"));
        return taskScheduleStr;
    }

    private void addOperaLogForAddAndEditTask() {
        String taskScheduleForLog = this.getTaskScheduleForOperaLog();
        boolean checkAll = false;
        if (!AticUtil.isNull((String)this.systemReportIds) && !AticUtil.isNull((String)this.zoneReportIds)) {
            checkAll = true;
        }
        if (null == this.taskId) {
            this.addOperaLogForAddTask(checkAll, taskScheduleForLog);
        } else {
            TimeTask timeTaskCheck = this.timeTaskService.getTimeTask(this.taskId);
            if (null != timeTaskCheck) {
                ArrayList<String> paraDetailList = new ArrayList<String>();
                this.checkTaskInfoEdit(paraDetailList, timeTaskCheck, taskScheduleForLog);
                ArrayList<String> zoneReportIdList = new ArrayList<String>();
                ArrayList<String> sysReportIdList = new ArrayList<String>();
                ArrayList<String> zoneReportTopNList = new ArrayList<String>();
                ArrayList<String> sysReportTopNList = new ArrayList<String>();
                this.getReportIdAndTopN(zoneReportIdList, sysReportIdList, zoneReportTopNList, sysReportTopNList);
                boolean checkZoneReportEdit = false;
                boolean checkSysReportEdit = false;
                if (!AticUtil.isNull((String)this.zoneReportIds)) {
                    checkZoneReportEdit = this.checkReportEdit(zoneReportIdList, zoneReportTopNList, false);
                }
                if (!AticUtil.isNull((String)this.systemReportIds)) {
                    checkSysReportEdit = this.checkReportEdit(sysReportIdList, sysReportTopNList, true);
                }
                this.addOperaLogForEditTask(checkSysReportEdit, checkZoneReportEdit, paraDetailList);
            }
        }
    }

    private void checkTaskInfoEdit(List<String> paraDetailList, TimeTask timeTaskCheck, String taskScheduleForLog) {
        if (!this.taskName.equals(timeTaskCheck.getTaskName())) {
            paraDetailList.add("atic.reportTask.editPart.name");
            paraDetailList.add(this.taskName);
        }
        if (!this.schedule.equals(timeTaskCheck.getSchedule())) {
            paraDetailList.add("atic.reportTask.editPart.schedule");
            paraDetailList.add(taskScheduleForLog);
        }
        String checkStartTime = AticUtil.convertTimeLong((Long)timeTaskCheck.getStartDate());
        String checkEndTime = AticUtil.convertTimeLong((Long)timeTaskCheck.getEndDate());
        if (!this.taskStartTime.equals(checkStartTime) || !this.taskEndTime.equals(checkEndTime)) {
            paraDetailList.add("atic.reportTask.editPart.duration");
            paraDetailList.add(this.taskStartTime + " - " + this.taskEndTime);
        }
    }

    private void addOperaLogForAddTask(boolean checkAll, String taskScheduleForLog) {
        if (checkAll) {
            String[] paraDetail = new String[]{this.taskName, taskScheduleForLog, this.taskStartTime + " - " + this.taskEndTime, "atic.report.task.systemReport", "atic.report.task.zoneReport"};
            this.getOperateLog().normal("atic.report.task.addTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.addTaskSummary.sysAndZone", paraDetail);
        } else {
            String reportTypeStr = "atic.report.task.systemReport";
            if (!AticUtil.isNull((String)this.zoneReportIds)) {
                reportTypeStr = "atic.report.task.zoneReport";
            }
            String[] paraDetail = new String[]{this.taskName, taskScheduleForLog, this.taskStartTime + " - " + this.taskEndTime, reportTypeStr};
            this.getOperateLog().normal("atic.report.task.addTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.addTaskSummary", paraDetail);
        }
    }

    private void addOperaLogForEditTask(boolean checkSysReportEdit, boolean checkZoneReportEdit, List<String> paraDetailList) {
        if (2 == paraDetailList.size()) {
            this.addOperaLogForTwoParameterEdit(checkSysReportEdit, checkZoneReportEdit, paraDetailList);
        } else if (4 == paraDetailList.size()) {
            this.addOperaLogForFourParameterEdit(checkSysReportEdit, checkZoneReportEdit, paraDetailList);
        } else if (6 == paraDetailList.size()) {
            this.addOperaLogForSixParameterEdit(checkSysReportEdit, checkZoneReportEdit, paraDetailList);
        } else {
            this.addOperaLogForReportEdit(checkSysReportEdit, checkZoneReportEdit, paraDetailList);
        }
    }

    private void addOperaLogForReportEdit(boolean checkSysReportEdit, boolean checkZoneReportEdit, List<String> paraDetailList) {
        if (checkSysReportEdit && checkZoneReportEdit) {
            paraDetailList.add("atic.report.task.systemReport");
            paraDetailList.add("atic.report.task.zoneReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysAndZone", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (checkSysReportEdit) {
            paraDetailList.add("atic.report.task.systemReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysOrZone", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (checkZoneReportEdit) {
            paraDetailList.add("atic.report.task.zoneReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysOrZone", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else {
            paraDetailList.add("atic.report.task.systemReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysOrZone", paraDetailList.toArray(new String[paraDetailList.size()]));
        }
    }

    private void addOperaLogForSixParameterEdit(boolean checkSysReportEdit, boolean checkZoneReportEdit, List<String> paraDetailList) {
        if (checkSysReportEdit && checkZoneReportEdit) {
            paraDetailList.add("atic.report.task.systemReport");
            paraDetailList.add("atic.report.task.zoneReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysAndZone.three", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (checkSysReportEdit) {
            paraDetailList.add("atic.report.task.systemReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysOrZone.three", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (checkZoneReportEdit) {
            paraDetailList.add("atic.report.task.zoneReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysOrZone.three", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else {
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.three", paraDetailList.toArray(new String[paraDetailList.size()]));
        }
    }

    private void addOperaLogForTwoParameterEdit(boolean checkSysReportEdit, boolean checkZoneReportEdit, List<String> paraDetailList) {
        if (checkSysReportEdit && checkZoneReportEdit) {
            paraDetailList.add("atic.report.task.systemReport");
            paraDetailList.add("atic.report.task.zoneReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysAndZone.one", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (checkSysReportEdit) {
            paraDetailList.add("atic.report.task.systemReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysOrZone.one", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (checkZoneReportEdit) {
            paraDetailList.add("atic.report.task.zoneReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysOrZone.one", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else {
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.one", paraDetailList.toArray(new String[paraDetailList.size()]));
        }
    }

    private void addOperaLogForFourParameterEdit(boolean checkSysReportEdit, boolean checkZoneReportEdit, List<String> paraDetailList) {
        if (checkSysReportEdit && checkZoneReportEdit) {
            paraDetailList.add("atic.report.task.systemReport");
            paraDetailList.add("atic.report.task.zoneReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysAndZone.two", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (checkSysReportEdit) {
            paraDetailList.add("atic.report.task.systemReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysOrZone.two", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (checkZoneReportEdit) {
            paraDetailList.add("atic.report.task.zoneReport");
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.sysOrZone.two", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else {
            this.getOperateLog().normal("atic.report.task.editTask", "lego.dic.module.AticAnalysis", this.taskName, false, "atic.reportTask.editTaskSummary.two", paraDetailList.toArray(new String[paraDetailList.size()]));
        }
    }

    private List<JsonValueItem> getJsonValueItemList(Map<?, ?> queryCond, String queryKey) {
        JsonValueObj obj = (JsonValueObj)queryCond.get(queryKey);
        ArrayList<JsonValueItem> list = null;
        if (null == obj || obj.getValueList().isEmpty()) {
            list = new ArrayList<JsonValueItem>();
            list.add(new JsonValueItem());
            return list;
        }
        list = obj.getValueList();
        return list;
    }

    private void getQueryCondition4Inte(List<String> systemReportIdList, List<Map<String, JsonValueObj>> systemReportQueryCondList, List<String> zoneReportIdList, List<Map<String, JsonValueObj>> zoneReportQueryCondList) {
        ReportCondModel systemQueryCond = new ReportCondModel();
        ReportCondModel zoneQueryCond = new ReportCondModel();
        long curTime = System.currentTimeMillis() / 1000L;
        String dateStartTimeStr = AticUtil.convertTime2DayString((long)curTime) + " 00:00:00";
        String dateEndTimeStr = AticUtil.convertTime2DayString((long)curTime) + " 23:59:59";
        if (1 != this.schedule) {
            dateEndTimeStr = AticUtil.convertTime2DayString((long)(curTime + (long)AnalysisConstants.SEVEN_DAY_BY_SECOND.intValue())) + " 23:59:59";
        }
        String scheduleTypeStr = "";
        if (1 == this.schedule) {
            scheduleTypeStr = "day";
        } else if (2 == this.schedule) {
            scheduleTypeStr = "week";
        } else if (3 == this.schedule) {
            scheduleTypeStr = "month";
        } else if (4 == this.schedule) {
            scheduleTypeStr = "year";
        }
        String localLanguageType = LocaleUtil.getInstance().getCurrentUserLocale().toString();
        JsonValueObj localeObj = new JsonValueObj("", localLanguageType, localLanguageType);
        if (this.systemReportEnable.booleanValue()) {
            systemQueryCond.setZoneId(0L);
            systemQueryCond.setZoneName("");
            systemQueryCond.setStartTime(dateStartTimeStr);
            systemQueryCond.setEndTime(dateEndTimeStr);
            systemQueryCond.setDeviceId(this.systemDeviceId);
            systemQueryCond.setDeviceName(this.systemDeviceName);
            String deviceTypeStr = ReportConditionUtil.getDeviceTypeByCombId(this.systemDeviceId);
            systemQueryCond.setDeviceType(deviceTypeStr);
            systemQueryCond.setScheduleType(scheduleTypeStr);
            Map<String, JsonValueObj> sysConditionMap = ReportConditionUtil.prepareReportList4Inte(systemQueryCond);
            sysConditionMap.put("localLanguageType", localeObj);
            systemReportQueryCondList.add(sysConditionMap);
            systemReportIdList.add("systemReport");
        }
        if (this.zoneReportEnable.booleanValue() && this.zoneId != null && this.zoneId > 0L) {
            zoneQueryCond.setZoneName(this.zoneName);
            zoneQueryCond.setZoneId(this.zoneId);
            zoneQueryCond.setStartTime(dateStartTimeStr);
            zoneQueryCond.setEndTime(dateEndTimeStr);
            zoneQueryCond.setDeviceId(this.zoneDeviceId);
            zoneQueryCond.setDeviceName(this.zoneDeviceName);
            String zoneDeviceType = ReportConditionUtil.getDeviceTypeByCombId(this.zoneDeviceId);
            zoneQueryCond.setDeviceType(zoneDeviceType);
            zoneQueryCond.setScheduleType(scheduleTypeStr);
            Map<String, JsonValueObj> zoneConditionMap = ReportConditionUtil.prepareReportList4Inte(zoneQueryCond);
            zoneConditionMap.put("localLanguageType", localeObj);
            zoneReportQueryCondList.add(zoneConditionMap);
            zoneReportIdList.add("zoneReport");
        }
    }

    private void getQueryCondition4SelectInte(List<String> systemReportIdList, List<Map<String, JsonValueObj>> systemReportQueryCondList, List<String> zoneReportIdList, List<Map<String, JsonValueObj>> zoneReportQueryCondList) {
        long curTime = System.currentTimeMillis() / 1000L;
        this.dateStartTime = AticUtil.convertTime2DayString((long)curTime) + " 00:00:00";
        this.dateEndTime = AticUtil.convertTime2DayString((long)curTime) + " 23:59:59";
        if (1 != this.schedule) {
            this.dateEndTime = AticUtil.convertTime2DayString((long)(curTime + (long)AnalysisConstants.SEVEN_DAY_BY_SECOND.intValue())) + " 23:59:59";
        }
        this.scheduleType = "";
        if (1 == this.schedule) {
            this.scheduleType = "day";
        } else if (2 == this.schedule) {
            this.scheduleType = "week";
        } else if (3 == this.schedule) {
            this.scheduleType = "month";
        } else if (4 == this.schedule) {
            this.scheduleType = "year";
        }
        this.processSystemReport(systemReportQueryCondList, systemReportIdList);
        this.processZoneReport(zoneReportQueryCondList, zoneReportIdList);
    }

    private void processZoneReport(List<Map<String, JsonValueObj>> zoneReportQueryCondList, List<String> zoneReportIdList) {
        if (AticUtil.isNull((String)this.zoneReportIds)) {
            return;
        }
        if (null != this.zoneId && this.zoneId > 0L) {
            if ("0".equals(this.zoneDeviceId) || "-1".equals(this.zoneDeviceId) || "-2".equals(this.zoneDeviceId)) {
                JsonValueObj zoneDev4EditObj = new JsonValueObj("zoneDev4Edit", this.zoneDeviceId, this.zoneDeviceName);
                List<AticDevice> zoneDevList = this.getAllCleanOrDetectDevList(this.zoneDeviceId);
                ArrayList<AticDevice> devList = new ArrayList<AticDevice>();
                User currentUser = (User)this.getSession().getAttribute("currentUser");
                Long currentLogUserId = 1L;
                Boolean isAdmin = true;
                if (null != currentUser) {
                    currentLogUserId = currentUser.getUserID();
                    isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
                }
                IZoneDeviceDeployStatusService zoneDeviceDeployStatusService = (IZoneDeviceDeployStatusService)ServiceContext.getInstance().getService("zoneDeviceDeployStatusService", IZoneDeviceDeployStatusService.class);
                List lstDevId = zoneDeviceDeployStatusService.getDevByZone4Secutity(this.zoneId, isAdmin, currentLogUserId);
                for (AticDevice aticDevice : zoneDevList) {
                    Long devIdTemp = aticDevice.getMoId();
                    if (!lstDevId.contains(devIdTemp)) continue;
                    devList.add(aticDevice);
                }
                if (!devList.isEmpty()) {
                    for (AticDevice aticDevice : devList) {
                        String deviceIdTemp = String.valueOf(aticDevice.getMoId());
                        String devModel = ReportConditionUtil.getDeviceModelByCombId(deviceIdTemp);
                        int devType = aticDevice.getDdosType();
                        this.zoneDeviceId = deviceIdTemp = deviceIdTemp + '_' + devType + '_' + devModel;
                        String name = "";
                        if (0 == devType) {
                            name = this.getText("atic.analysis.common.clean");
                        } else if (1 == devType) {
                            name = this.getText("atic.analysis.common.detect");
                        }
                        this.zoneDeviceName = aticDevice.getName() + name;
                        this.processZoneReportIdAndQuery(zoneReportQueryCondList, zoneReportIdList, "zoneReport", zoneDev4EditObj);
                    }
                }
            } else {
                this.processZoneReportIdAndQuery(zoneReportQueryCondList, zoneReportIdList, "zoneReport", null);
            }
        }
    }

    private List<AticDevice> getAllCleanOrDetectDevList(String sysOrZoneDeviceId) {
        List<Object> devList = new ArrayList();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Long currentLogUserId = 1L;
        if (null != currentUser) {
            currentLogUserId = currentUser.getUserID();
        }
        Long devId = Long.parseLong(sysOrZoneDeviceId);
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        datastatConditionForm.setDeviceId(devId);
        if (-2L == devId) {
            devList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            if (!devList.isEmpty()) {
                for (AticDevice aticDevice : devList) {
                    aticDevice.setDdosType(1);
                }
            }
        } else if (-1L == devId) {
            devList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            if (!devList.isEmpty()) {
                for (AticDevice aticDevice : devList) {
                    aticDevice.setDdosType(0);
                }
            }
        } else if (0L == devId) {
            datastatConditionForm.setDeviceId(-1L);
            List<AticDevice> cleanDevList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            datastatConditionForm.setDeviceId(-2L);
            List<AticDevice> list = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            if (!cleanDevList.isEmpty()) {
                for (AticDevice temp : cleanDevList) {
                    temp.setDdosType(0);
                    devList.add(temp);
                }
            }
            if (!list.isEmpty()) {
                for (AticDevice temp : list) {
                    temp.setDdosType(1);
                    devList.add(temp);
                }
            }
        }
        devList = this.getDevListNotSyslog(devList);
        return devList;
    }

    private List<AticDevice> getDevListNotSyslog(List<AticDevice> devList) {
        ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
        if (null == devList || devList.isEmpty()) {
            return deviceList;
        }
        for (AticDevice temp : devList) {
            if (3 == temp.getDeviceType()) continue;
            deviceList.add(temp);
        }
        return deviceList;
    }

    private void processSystemReport(List<Map<String, JsonValueObj>> systemReportQueryCondList, List<String> systemReportIdList) {
        if (!AticUtil.isNull((String)this.systemReportIds)) {
            if ("0".equals(this.systemDeviceId) || "-1".equals(this.systemDeviceId) || "-2".equals(this.systemDeviceId)) {
                JsonValueObj sysDev4Edit = new JsonValueObj("sysDev4Edit", this.systemDeviceId, this.systemDeviceName);
                List<AticDevice> devList = this.getAllCleanOrDetectDevList(this.systemDeviceId);
                if (!devList.isEmpty()) {
                    for (AticDevice aticDevice : devList) {
                        String deviceIdTemp = String.valueOf(aticDevice.getMoId());
                        String devModel = ReportConditionUtil.getDeviceModelByCombId(deviceIdTemp);
                        int devType = aticDevice.getDdosType();
                        this.systemDeviceId = deviceIdTemp = deviceIdTemp + '_' + devType + '_' + devModel;
                        String name = "";
                        if (0 == devType) {
                            name = this.getText("atic.analysis.common.clean");
                        } else if (1 == devType) {
                            name = this.getText("atic.analysis.common.detect");
                        }
                        this.systemDeviceName = aticDevice.getName() + name;
                        this.processSystemReportIdAndQuery(systemReportQueryCondList, systemReportIdList, "systemReport", sysDev4Edit);
                    }
                }
            } else {
                this.processSystemReportIdAndQuery(systemReportQueryCondList, systemReportIdList, "systemReport", null);
            }
        }
    }

    private void processZoneReportIdAndQuery(List<Map<String, JsonValueObj>> zoneReportQueryCondList, List<String> zoneReportIdList, String reportId, JsonValueObj zoneDev4EditObj) {
        String localLanguageType = LocaleUtil.getInstance().getCurrentUserLocale().toString();
        JsonValueObj localeObj = new JsonValueObj("", localLanguageType, localLanguageType);
        ReportCondModel zoneQueryCond = new ReportCondModel();
        zoneQueryCond.setZoneName(this.zoneName);
        zoneQueryCond.setZoneId(this.zoneId);
        zoneQueryCond.setStartTime(this.dateStartTime);
        zoneQueryCond.setEndTime(this.dateEndTime);
        zoneQueryCond.setDeviceId(this.zoneDeviceId);
        zoneQueryCond.setDeviceName(this.zoneDeviceName);
        String zoneDeviceType = ReportConditionUtil.getDeviceTypeByCombId(this.zoneDeviceId);
        zoneQueryCond.setDeviceType(zoneDeviceType);
        zoneQueryCond.setScheduleType(this.scheduleType);
        zoneQueryCond.setTopNValues(this.zoneTopNValues);
        zoneQueryCond.setReportIds(this.zoneReportIds);
        int directionId = this.directionZone.equals("Inbound") ? 1 : 2;
        zoneQueryCond.setDirectionId(directionId);
        if (null != zoneDev4EditObj) {
            zoneQueryCond.setSelectAllDevice(true);
        }
        Map<String, JsonValueObj> zoneConditionMap = ReportConditionUtil.prepareReportList4SelectInte(zoneQueryCond, this.getSessionUser());
        zoneConditionMap.put("localLanguageType", localeObj);
        if (null != zoneDev4EditObj) {
            zoneConditionMap.put("zoneDev4Edit", zoneDev4EditObj);
        }
        zoneReportQueryCondList.add(zoneConditionMap);
        zoneReportIdList.add(reportId);
    }

    private void processSystemReportIdAndQuery(List<Map<String, JsonValueObj>> systemReportQueryCondList, List<String> systemReportIdList, String reportId, JsonValueObj sysDevice) {
        String localLanguageType = LocaleUtil.getInstance().getCurrentUserLocale().toString();
        JsonValueObj localeObj = new JsonValueObj("", localLanguageType, localLanguageType);
        ReportCondModel systemQueryCond = new ReportCondModel();
        systemQueryCond.setZoneId(0L);
        systemQueryCond.setZoneName("");
        systemQueryCond.setStartTime(this.dateStartTime);
        systemQueryCond.setEndTime(this.dateEndTime);
        systemQueryCond.setDeviceId(this.systemDeviceId);
        systemQueryCond.setDeviceName(this.systemDeviceName);
        String deviceTypeStr = ReportConditionUtil.getDeviceTypeByCombId(this.systemDeviceId);
        systemQueryCond.setDeviceType(deviceTypeStr);
        systemQueryCond.setScheduleType(this.scheduleType);
        systemQueryCond.setTopNValues(this.systemTopNValues);
        systemQueryCond.setReportIds(this.systemReportIds);
        int directionId = this.directionSystem.equals("Inbound") ? 1 : 2;
        systemQueryCond.setDirectionId(directionId);
        if (null != sysDevice) {
            systemQueryCond.setSelectAllDevice(true);
        }
        Map<String, JsonValueObj> sysConditionMap = ReportConditionUtil.prepareReportList4SelectInte(systemQueryCond, this.getSessionUser());
        sysConditionMap.put("localLanguageType", localeObj);
        if (null != sysDevice) {
            sysConditionMap.put("sysDev4Edit", sysDevice);
        }
        systemReportQueryCondList.add(sysConditionMap);
        systemReportIdList.add(reportId);
    }

    public void addReportTask4Inte() {
        logger.info((Object)"Begin ReportTaskAction addReportTask function");
        this.addOperaLogForAddAndEditTask();
        Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
        ArrayList<String> systemReportIdList = new ArrayList<String>();
        ArrayList<Map<String, JsonValueObj>> systemReportQueryCondList = new ArrayList<Map<String, JsonValueObj>>();
        ArrayList<String> zoneReportIdList = new ArrayList<String>();
        ArrayList<Map<String, JsonValueObj>> zoneReportQueryCondList = new ArrayList<Map<String, JsonValueObj>>();
        this.getQueryCondition4Inte(systemReportIdList, systemReportQueryCondList, zoneReportIdList, zoneReportQueryCondList);
        TimeTask timeTask = new TimeTask();
        timeTask.setStartDate(Long.valueOf(AticUtil.convertTimeString((String)this.taskStartTime)));
        timeTask.setEndDate(Long.valueOf(AticUtil.convertTimeString((String)this.taskEndTime)));
        timeTask.setResultType(this.reportForm);
        timeTask.setRunTime(this.runTime);
        timeTask.setSchedule(this.schedule);
        timeTask.setState(Integer.valueOf(1));
        timeTask.setTaskDesc(this.taskDesc);
        timeTask.setLocale(locale.toString());
        timeTask.setTaskName(this.taskName);
        timeTask.setUserName(ProductFaceUtil.getInstance().getUserName());
        timeTask.setAuthId("VSM_ATIC");
        Integer taskID = this.timeTaskService.addTimeTask(timeTask);
        timeTask.setTaskId(taskID);
        if (taskID < 1) {
            throw new LegoCheckedException(571805L);
        }
        ArrayList<ReportEmailInfoForm> emailInfoList = new ArrayList<ReportEmailInfoForm>();
        HashMap<String, List<String>> idMap = new HashMap<String, List<String>>();
        HashMap<String, List<Map<String, JsonValueObj>>> condMap = new HashMap<String, List<Map<String, JsonValueObj>>>();
        idMap.put("systemReportIdList", systemReportIdList);
        idMap.put("zoneReportIdList", zoneReportIdList);
        condMap.put("systemReportQueryCondList", systemReportQueryCondList);
        condMap.put("zoneReportQueryCondList", zoneReportQueryCondList);
        boolean isSuccess = this.addReportTaskTemplateAndCondition(idMap, condMap, taskID, emailInfoList);
        this.reportEmailInfoService.saveReportEmailInfo(emailInfoList);
        if (1 == timeTask.getState() && isSuccess) {
            IRTimeTaskMgr.getInstance().addTimeTask(timeTask);
        }
        logger.info((Object)"End ReportTaskAction addReportTask function");
    }

    public void addReportTask4SelectInte() {
        logger.info((Object)"Begin ReportTaskAction addReportTask4SelectInte function");
        this.addOperaLogForAddAndEditTask();
        ArrayList<Long> moIDList = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)this.zoneDeviceId) && ReportConditionUtil.getLongDeviceId(this.zoneDeviceId) > 0L) {
            moIDList.add(ReportConditionUtil.getLongDeviceId(this.zoneDeviceId));
        }
        if (StringUtils.isNotBlank((CharSequence)this.systemDeviceId) && ReportConditionUtil.getLongDeviceId(this.systemDeviceId) > 0L) {
            moIDList.add(ReportConditionUtil.getLongDeviceId(this.systemDeviceId));
        }
        if (null != this.zoneId) {
            moIDList.add(ReportBisUtil.getMoidByZoneid(this.zoneId));
        }
        ReportBisUtil.checkUserSecurity(moIDList);
        Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
        ArrayList<String> systemReportIdList = new ArrayList<String>();
        ArrayList<Map<String, JsonValueObj>> systemReportQueryCondList = new ArrayList<Map<String, JsonValueObj>>();
        ArrayList<String> zoneReportIdList = new ArrayList<String>();
        ArrayList<Map<String, JsonValueObj>> zoneReportQueryCondList = new ArrayList<Map<String, JsonValueObj>>();
        this.getQueryCondition4SelectInte(systemReportIdList, systemReportQueryCondList, zoneReportIdList, zoneReportQueryCondList);
        TimeTask timeTask = new TimeTask();
        timeTask.setStartDate(Long.valueOf(AticUtil.convertTimeString((String)this.taskStartTime)));
        timeTask.setEndDate(Long.valueOf(AticUtil.convertTimeString((String)this.taskEndTime)));
        timeTask.setResultType(this.reportForm);
        timeTask.setRunTime(this.runTime);
        timeTask.setSchedule(this.schedule);
        timeTask.setState(Integer.valueOf(1));
        timeTask.setTaskDesc(this.taskDesc);
        timeTask.setLocale(locale.toString());
        timeTask.setTaskName(this.taskName);
        timeTask.setUserName(ProductFaceUtil.getInstance().getUserName());
        timeTask.setAuthId("VSM_ATIC");
        Integer taskID = this.timeTaskService.addTimeTask(timeTask);
        timeTask.setTaskId(taskID);
        if (taskID < 1) {
            throw new LegoCheckedException(571805L);
        }
        ArrayList<ReportEmailInfoForm> emailInfoList = new ArrayList<ReportEmailInfoForm>();
        HashMap<String, List<String>> idMap = new HashMap<String, List<String>>();
        HashMap<String, List<Map<String, JsonValueObj>>> condMap = new HashMap<String, List<Map<String, JsonValueObj>>>();
        idMap.put("systemReportIdList", systemReportIdList);
        idMap.put("zoneReportIdList", zoneReportIdList);
        condMap.put("systemReportQueryCondList", systemReportQueryCondList);
        condMap.put("zoneReportQueryCondList", zoneReportQueryCondList);
        boolean isSuccess = this.addReportTaskTemplateAndCondition(idMap, condMap, taskID, emailInfoList);
        this.reportEmailInfoService.saveReportEmailInfo(emailInfoList);
        if (1 == timeTask.getState() && isSuccess) {
            IRTimeTaskMgr.getInstance().addTimeTask(timeTask);
        }
        logger.info((Object)"End ReportTaskAction addReportTask4SelectInte function");
    }

    public boolean processPara() {
        String taskNameTemp = this.taskName.trim();
        if (AticUtil.isNull((String)taskNameTemp) || taskNameTemp.length() > 32) {
            return false;
        }
        String taskNameRegex = "^[\\u4e00-\\u9fa5a-zA-Z0-9\\@\\.\\_\\-]{1,}$";
        if (!taskNameTemp.matches(taskNameRegex) || taskNameTemp.contains("..") || taskNameTemp.trim().toLowerCase().contains("null")) {
            return false;
        }
        if (this.taskDesc == null || "".equals(this.taskDesc)) {
            return true;
        }
        if (this.taskDesc.length() > 255) {
            return false;
        }
        String descRegex = "^(?!(?i)\\s*null$)(?!(?i)[\\s\\S]*[\\s]+null$)(?!(?i)\\s*null\\s{1}[\\s\\S]*$)(?!(?i)[\\s\\S]*[\\s]+null[\\s]+[\\s\\S]*$)[\\u4E00-\\u9FA5\u3002\uff0c\uff1a\uff1b\uff01\uff1f\u3001\u300a\u300b\u201c\u201d\u2018\u2019\uffe5\uff08\uff09\u3010\u3011\u2026|\\w|\\s!@#$%^*_+\\-=\\[\\]{};\\\\\\:\\|,.\\/?\\r\\n]*$";
        return this.taskDesc.matches(descRegex) && !this.taskDesc.trim().equalsIgnoreCase("null");
    }

    public boolean validateRunTime() {
        if (null == this.runTime || "".equals(this.runTime.trim())) {
            return false;
        }
        if (this.schedule < 0 || this.schedule > 4) {
            return false;
        }
        if (this.schedule == 1) {
            String dayRegex = "^([3-9]|1[0-9]|2[0-3]):(0|00|05|1[0|5]|2[0|5]|3[0|5]|4[0|5]|5[0|5]):00$";
            return this.runTime.matches(dayRegex);
        }
        if (this.schedule == 2) {
            String weekRegex = "^([1-7]),([3-9]|1[0-9]|2[0-3]):(0|00|05|1[0|5]|2[0|5]|3[0|5]|4[0|5]|5[0|5]):00$";
            return this.runTime.matches(weekRegex);
        }
        if (this.schedule == 3) {
            String monthRegex = "^([1-9]|1[0-9]|2[0-8]),([3-9]|1[0-9]|2[0-3]):(0|00|05|1[0|5]|2[0|5]|3[0|5]|4[0|5]|5[0|5]):00$";
            return this.runTime.matches(monthRegex);
        }
        String yearRegex = "^([1-9]|1[0-2]),([1-9]|1[0-9]|2[0-9]|3[0-1]),([3-9]|1[0-9]|2[0-3]):(0|00|05|1[0|5]|2[0|5]|3[0|5]|4[0|5]|5[0|5]):00$";
        if (!this.runTime.matches(yearRegex)) {
            return false;
        }
        String[] dateString = this.runTime.split(",");
        return this.checkDayInMonth(Integer.valueOf(dateString[0]), Integer.valueOf(dateString[1]));
    }

    private boolean checkDayInMonth(int month, int day) {
        return 1 == month || 3 == month || 5 == month || 7 == month || 8 == month || 10 == month || 12 == month ? 0 < day && day < 32 : (4 == month || 6 == month || 9 == month || 11 == month ? 0 < day && day < 31 : 0 < day && day < 29);
    }

    private boolean addReportTaskTemplateAndCondition(Map<String, List<String>> idMap, Map<String, List<Map<String, JsonValueObj>>> condMap, Integer taskIdInt, List<ReportEmailInfoForm> emailInfoList) {
        logger.info((Object)"start ReportTaskAction addReportTaskTemplateAndCondition function");
        boolean isSuccess = true;
        try {
            TemplateCondition templateCondition;
            int i;
            Integer templateId;
            ReportTemplate reportTemplate;
            List<String> systemReportIdList = idMap.get("systemReportIdList");
            List<String> zoneReportIdList = idMap.get("zoneReportIdList");
            List<Map<String, JsonValueObj>> systemReportQueryCondList = condMap.get("systemReportQueryCondList");
            List<Map<String, JsonValueObj>> zoneReportQueryCondList = condMap.get("zoneReportQueryCondList");
            if (null != systemReportIdList && !systemReportIdList.isEmpty()) {
                reportTemplate = new ReportTemplate();
                reportTemplate.setName(this.taskName + "_" + this.getText("atic.report.task.systemReport4TaskName"));
                reportTemplate.setDesc(SYSTEM_REPORT);
                templateId = 0;
                templateId = this.reportTemplateService.addTemplate(reportTemplate);
                if (templateId > 0) {
                    for (i = 0; i < systemReportIdList.size(); ++i) {
                        templateCondition = new TemplateCondition();
                        templateCondition.setReportId(systemReportIdList.get(i));
                        templateCondition.setReportCondition(JSONUtil.mapToJson(systemReportQueryCondList.get(i)));
                        templateCondition.setTemplateId(templateId);
                        this.reportTemplateService.addReportCondition(templateCondition);
                    }
                    isSuccess = this.addSystemCondition(taskIdInt, emailInfoList, isSuccess, templateId);
                } else {
                    logger.info((Object)("template" + reportTemplate.getName() + " exit"));
                }
            }
            if (null != zoneReportIdList && !zoneReportIdList.isEmpty()) {
                reportTemplate = new ReportTemplate();
                reportTemplate.setName(this.taskName + "_" + this.getText("atic.report.task.zoneReport4TaskName") + "_" + this.zoneName);
                reportTemplate.setDesc(ZONE_REPORT);
                templateId = 0;
                templateId = this.reportTemplateService.addTemplate(reportTemplate);
                if (templateId > 0) {
                    for (i = 0; i < zoneReportIdList.size(); ++i) {
                        templateCondition = new TemplateCondition();
                        templateCondition.setReportId(zoneReportIdList.get(i));
                        templateCondition.setReportCondition(JSONUtil.mapToJson(zoneReportQueryCondList.get(i)));
                        templateCondition.setTemplateId(templateId);
                        this.reportTemplateService.addReportCondition(templateCondition);
                    }
                    isSuccess = this.addZoneCondition(taskIdInt, emailInfoList, isSuccess, templateId);
                } else {
                    logger.info((Object)("template" + reportTemplate.getName() + " exit"));
                }
            }
            logger.info((Object)"End ReportTaskAction addReportTaskTemplateAndCondition function");
        }
        catch (SQLException e) {
            isSuccess = false;
            logger.error((Object)"ReportTaskAction addReportTaskTemplateAndCondition is fail");
        }
        return isSuccess;
    }

    private boolean addZoneCondition(Integer taskIdInt, List<ReportEmailInfoForm> emailInfoList, boolean isSuccess, Integer templateId) {
        this.checkIsSend();
        TaskCondition condition = new TaskCondition();
        condition.setTemplateId(templateId);
        condition.setTaskId(taskIdInt);
        ArrayList<TaskCondition> taskConditionList = new ArrayList<TaskCondition>();
        taskConditionList.add(condition);
        String conditionId = this.timeTaskService.addTaskCondition(taskConditionList);
        if (!AticUtil.isNull((String)conditionId) && !"error".equals(conditionId)) {
            ReportEmailInfoForm reportEmailInfoForm = new ReportEmailInfoForm();
            reportEmailInfoForm.setTaskId(taskIdInt);
            reportEmailInfoForm.setConditionId(Integer.valueOf(conditionId));
            reportEmailInfoForm.setAuthId("VSM_ATIC");
            if (this.checkZoneEmail == 1) {
                reportEmailInfoForm.setZoneId(this.zoneId);
            } else {
                reportEmailInfoForm.setZoneId(Long.valueOf(0L));
            }
            if (this.checkOtherEmail == 1) {
                String otherEmailInfoTemp = LegoDataProtectorWrapper.sdpEncryptLocal((String)this.otherEmailInfo);
                reportEmailInfoForm.setEmailInfo(otherEmailInfoTemp);
            } else {
                reportEmailInfoForm.setEmailInfo("");
            }
            emailInfoList.add(reportEmailInfoForm);
        } else {
            isSuccess = false;
        }
        return isSuccess;
    }

    private boolean addSystemCondition(Integer taskIdInt, List<ReportEmailInfoForm> emailInfoList, boolean isSuccess, Integer templateId) {
        TaskCondition condition = new TaskCondition();
        condition.setTemplateId(templateId);
        condition.setTaskId(taskIdInt);
        ArrayList<TaskCondition> taskConditionList = new ArrayList<TaskCondition>();
        taskConditionList.add(condition);
        String conditionId = this.timeTaskService.addTaskCondition(taskConditionList);
        if (!AticUtil.isNull((String)conditionId) && !"error".equals(conditionId)) {
            ReportEmailInfoForm reportEmailInfoForm = new ReportEmailInfoForm();
            reportEmailInfoForm.setTaskId(taskIdInt);
            reportEmailInfoForm.setConditionId(Integer.valueOf(conditionId));
            reportEmailInfoForm.setAuthId("VSM_ATIC");
            reportEmailInfoForm.setZoneId(Long.valueOf(0L));
            String systemEmailInfoTemp = LegoDataProtectorWrapper.sdpEncryptLocal((String)this.systemEmailInfo);
            reportEmailInfoForm.setEmailInfo(systemEmailInfoTemp);
            emailInfoList.add(reportEmailInfoForm);
        } else {
            isSuccess = false;
        }
        return isSuccess;
    }

    private void setSelectValue(int state, String runTiime) {
        if (null == this.selectMinute) {
            this.selectMinute = new SelectForm();
        }
        if (null == this.selectHour) {
            this.selectHour = new SelectForm();
        }
        if (null == this.selectDay) {
            this.selectDay = new SelectForm();
        }
        if (null == this.selectMonth) {
            this.selectMonth = new SelectForm();
        }
        this.taskScheduleForm.setSchedule(state);
        if (state == 1) {
            this.taskScheduleForm.setName(this.getText("atic.report.task.scheduleDay"));
            String[] timeStr = runTiime.split(":");
            this.selectHour.setSelectValue(timeStr[0]);
            this.selectHour.setSelectName(timeStr[0]);
            this.selectMinute.setSelectValue(timeStr[1]);
            this.selectMinute.setSelectName(timeStr[1]);
            this.taskWeekForm.setWeek(7);
            this.taskWeekForm.setName(this.getText("atic.report.task.sunday"));
            this.selectDay.setSelectValue("1");
            this.selectDay.setSelectName("1");
            this.selectMonth.setSelectValue("1");
            this.selectMonth.setSelectName("1");
        } else if (state == 2) {
            this.taskScheduleForm.setName(this.getText("atic.report.task.scheduleWeek"));
            String[] weekStr = this.runTime.split(",");
            String[] timeStr = weekStr[1].split(":");
            this.taskWeekForm.setWeek(Integer.parseInt(weekStr[0]));
            this.processWeekFormName(weekStr[0]);
            this.selectHour.setSelectValue(timeStr[0]);
            this.selectHour.setSelectName(timeStr[0]);
            this.selectMinute.setSelectValue(timeStr[1]);
            this.selectMinute.setSelectName(timeStr[1]);
            this.selectDay.setSelectValue("1");
            this.selectDay.setSelectName("1");
            this.selectMonth.setSelectValue("1");
            this.selectMonth.setSelectName("1");
        } else if (state == 3) {
            this.taskScheduleForm.setName(this.getText("atic.report.task.scheduleMonth"));
            String[] monthStr = this.runTime.split(",");
            String[] timeStr = monthStr[1].split(":");
            this.selectDay.setSelectValue(monthStr[0]);
            this.selectDay.setSelectName(monthStr[0]);
            this.selectHour.setSelectValue(timeStr[0]);
            this.selectHour.setSelectName(timeStr[0]);
            this.selectMinute.setSelectValue(timeStr[1]);
            this.selectMinute.setSelectName(timeStr[1]);
            this.taskWeekForm.setWeek(7);
            this.taskWeekForm.setName(this.getText("atic.report.task.sunday"));
            this.selectMonth.setSelectValue("1");
            this.selectMonth.setSelectName("1");
        } else {
            this.taskScheduleForm.setName(this.getText("atic.report.task.scheduleYear"));
            String[] monthStr = this.runTime.split(",");
            String[] timeStr = monthStr[2].split(":");
            this.selectMonth.setSelectValue(monthStr[0]);
            this.selectMonth.setSelectName(monthStr[0]);
            this.selectDay.setSelectValue(monthStr[1]);
            this.selectDay.setSelectName(monthStr[1]);
            this.selectHour.setSelectValue(timeStr[0]);
            this.selectHour.setSelectName(timeStr[0]);
            this.selectMinute.setSelectValue(timeStr[1]);
            this.selectMinute.setSelectName(timeStr[1]);
            this.taskWeekForm.setWeek(7);
            this.taskWeekForm.setName(this.getText("atic.report.task.sunday"));
        }
    }

    private void processWeekFormName(String weekStr) {
        switch (Integer.parseInt(weekStr)) {
            case 1: {
                this.taskWeekForm.setName(this.getText("atic.report.task.monday"));
                break;
            }
            case 2: {
                this.taskWeekForm.setName(this.getText("atic.report.task.tuesday"));
                break;
            }
            case 3: {
                this.taskWeekForm.setName(this.getText("atic.report.task.wednesday"));
                break;
            }
            case 4: {
                this.taskWeekForm.setName(this.getText("atic.report.task.thursday"));
                break;
            }
            case 5: {
                this.taskWeekForm.setName(this.getText("atic.report.task.friday"));
                break;
            }
            case 6: {
                this.taskWeekForm.setName(this.getText("atic.report.task.saturday"));
                break;
            }
            default: {
                this.taskWeekForm.setName(this.getText("atic.report.task.sunday"));
            }
        }
    }

    public String editReportTaskInit4Inte() {
        logger.info((Object)"Begin ReportTaskAction editReportTaskInit function");
        this.timeTaskVO = this.timeTaskService.getTimeTask(this.taskId);
        if (null == this.timeTaskVO) {
            logger.error((Object)("timeTask is not exist, id: " + this.taskId));
            throw new LegoCheckedException(571701L);
        }
        try {
            this.initTaskScheduleList();
            this.initTaskWeekList();
            this.initExportFileTypeList();
            HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            request.setAttribute("isTask", (Object)"1");
            this.taskName = this.timeTaskVO.getTaskName();
            this.taskDesc = this.timeTaskVO.getTaskDesc();
            this.reportForm = this.timeTaskVO.getResultType();
            this.schedule = this.timeTaskVO.getSchedule();
            this.runTime = this.timeTaskVO.getRunTime();
            this.setSelectValue(this.schedule, this.runTime);
            this.taskStartTime = AticUtil.convertTimeLong((Long)this.timeTaskVO.getStartDate());
            this.taskEndTime = AticUtil.convertTimeLong((Long)this.timeTaskVO.getEndDate());
            List taskCondition = this.timeTaskService.getTaskCondition(this.taskId);
            for (TaskCondition taskConditionItem : taskCondition) {
                if (taskConditionItem.getTemplateId() == 0) continue;
                HashMap<String, JsonValueObj> condMap = new HashMap<String, JsonValueObj>();
                this.processTaskCondition(condMap, taskConditionItem);
                this.processReportTypeName(condMap, taskConditionItem);
            }
            if ("ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType())) {
                this.defaultDeviceName = this.getText("ips.analysis.common.netdevice.all");
                request.setAttribute("isIps", (Object)"1");
            } else {
                this.defaultDeviceName = this.getText("atic.analysis.common.netdevice.clean");
                request.setAttribute("isIps", (Object)"0");
            }
            logger.info((Object)"End ReportTaskAction editReportTaskInit function");
        }
        catch (Exception e) {
            logger.error((Object)("ReportTaskAction editReportTaskInit is fail: " + e.getMessage()));
        }
        return "success";
    }

    public String editReportTaskInit4SelectInte() {
        logger.info((Object)"Begin ReportTaskAction editReportTask4SelectInte function");
        ArrayList<Integer> taskIds = new ArrayList<Integer>();
        taskIds.add(this.taskId);
        this.checkReportTaskSecurity(taskIds);
        this.timeTaskVO = this.timeTaskService.getTimeTask(this.taskId);
        if (null == this.timeTaskVO) {
            logger.error((Object)("timeTask is not exist, id: " + this.taskId));
            throw new LegoCheckedException(571701L);
        }
        try {
            this.initTaskScheduleList();
            this.initTaskWeekList();
            this.initExportFileTypeList();
            this.initDeviceList();
            HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            request.setAttribute("isTask", (Object)"1");
            ILicenseOutboundService licenseOutboundService = ReportBisUtil.getLicenseOutboundService();
            this.isSupportOutbound = licenseOutboundService.isSupportOutbound();
            request.getSession().setAttribute("isSupportOutbound", (Object)this.isSupportOutbound);
            this.taskName = this.timeTaskVO.getTaskName();
            this.taskDesc = this.timeTaskVO.getTaskDesc();
            this.reportForm = this.timeTaskVO.getResultType();
            this.schedule = this.timeTaskVO.getSchedule();
            this.runTime = this.timeTaskVO.getRunTime();
            this.setSelectValue(this.schedule, this.runTime);
            this.taskStartTime = AticUtil.convertTimeLong((Long)this.timeTaskVO.getStartDate());
            this.taskEndTime = AticUtil.convertTimeLong((Long)this.timeTaskVO.getEndDate());
            List taskCondition = this.timeTaskService.getTaskCondition(this.taskId);
            this.systemReportIdTopNs = "";
            this.zoneReportIdTopNs = "";
            for (TaskCondition taskConditionItem : taskCondition) {
                String reportTypeName = SYSTEM_REPORT;
                String tempReportIdTopNs = "";
                if (taskConditionItem.getTemplateId() != 0) {
                    HashMap<String, JsonValueObj> condMap = new HashMap<String, JsonValueObj>();
                    tempReportIdTopNs = this.processTaskCondition4SelectInte(condMap, taskConditionItem);
                    reportTypeName = this.processReportTypeName(condMap, taskConditionItem);
                }
                if (reportTypeName.equals(SYSTEM_REPORT)) {
                    this.systemReportIdTopNs = tempReportIdTopNs;
                }
                if (!reportTypeName.equals(ZONE_REPORT)) continue;
                this.zoneReportIdTopNs = tempReportIdTopNs;
            }
            this.defaultDeviceName = this.getText("ips.analysis.common.netdevice.all");
            logger.info((Object)"End ReportTaskAction editReportTask4SelectInte function");
        }
        catch (SQLException e) {
            logger.error((Object)"ReportTaskAction editReportTask4SelectInte is fail");
        }
        return "success";
    }

    private String processTaskCondition4SelectInte(Map<String, JsonValueObj> condMap, TaskCondition taskConditionItem) {
        String tempReportIdTopNs = "[";
        String tempJson = "";
        StringBuffer buf = new StringBuffer();
        try {
            List tempCondition = this.reportTemplateService.getConditionByTemId(taskConditionItem.getTemplateId().toString());
            if (null != tempCondition) {
                for (TemplateCondition templateCondition : tempCondition) {
                    tempJson = "";
                    String condJson = templateCondition.getReportCondition();
                    condMap.clear();
                    condMap.putAll(JSONUtil.transformKeyValueObjMap((String)condJson));
                    String[] topNs = null;
                    if (null != condMap.get("reportTopns")) {
                        topNs = ((JsonValueItem)condMap.get("reportTopns").getValueList().get(0)).getValue().split(",");
                    }
                    String[] ids = null;
                    if (null != condMap.get("reportIds")) {
                        ids = ((JsonValueItem)condMap.get("reportIds").getValueList().get(0)).getValue().split(",");
                    }
                    if (null == topNs || null == ids) continue;
                    for (int i = 0; i < ids.length; ++i) {
                        buf.append("{'reportId':'");
                        buf.append(ids[i]);
                        buf.append("','topN':'");
                        buf.append(topNs[i]);
                        buf.append("'},");
                    }
                    tempJson = buf.toString();
                }
            }
            if (!AticUtil.isNull((String)tempJson)) {
                tempJson = tempJson.substring(0, tempJson.length() - 1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"ReportTaskAction processTaskCondition is fail.");
            return "";
        }
        catch (ParaException e) {
            logger.error((Object)"ReportTaskAction processTaskCondition is fail.");
            return "";
        }
        tempReportIdTopNs = tempReportIdTopNs + tempJson + "]";
        return tempReportIdTopNs;
    }

    public String editReportTaskInit() {
        logger.info((Object)"Begin ReportTaskAction editReportTaskInit function");
        this.timeTaskVO = this.timeTaskService.getTimeTask(this.taskId);
        if (null == this.timeTaskVO) {
            logger.error((Object)("timeTask is not exist, id: " + this.taskId));
            throw new LegoCheckedException(571701L);
        }
        try {
            this.initTaskScheduleList();
            this.initTaskWeekList();
            this.initExportFileTypeList();
            HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            request.setAttribute("isTask", (Object)"1");
            this.taskName = this.timeTaskVO.getTaskName();
            this.taskDesc = this.timeTaskVO.getTaskDesc();
            this.reportForm = this.timeTaskVO.getResultType();
            this.schedule = this.timeTaskVO.getSchedule();
            this.runTime = this.timeTaskVO.getRunTime();
            this.setSelectValue(this.schedule, this.runTime);
            this.taskStartTime = AticUtil.convertTimeLong((Long)this.timeTaskVO.getStartDate());
            this.taskEndTime = AticUtil.convertTimeLong((Long)this.timeTaskVO.getEndDate());
            List taskCondition = this.timeTaskService.getTaskCondition(this.taskId);
            this.systemReportIdTopNs = "";
            this.zoneReportIdTopNs = "";
            for (TaskCondition taskConditionItem : taskCondition) {
                String reportTypeName = SYSTEM_REPORT;
                String tempReportIdTopNs = "";
                if (taskConditionItem.getTemplateId() != 0) {
                    HashMap<String, JsonValueObj> condMap = new HashMap<String, JsonValueObj>();
                    tempReportIdTopNs = this.processTaskCondition(condMap, taskConditionItem);
                    reportTypeName = this.processReportTypeName(condMap, taskConditionItem);
                }
                if (reportTypeName.equals(SYSTEM_REPORT)) {
                    this.systemReportIdTopNs = tempReportIdTopNs;
                }
                if (!reportTypeName.equals(ZONE_REPORT)) continue;
                this.zoneReportIdTopNs = tempReportIdTopNs;
            }
            if (!this.systemReportIdTopNs.equals("")) {
                this.systemReportIdTopNs = this.systemReportIdTopNs.substring(0, this.systemReportIdTopNs.length() - 1);
                this.systemReportIdTopNs = this.systemReportIdTopNs + "]";
            }
            if (!this.zoneReportIdTopNs.equals("")) {
                this.zoneReportIdTopNs = this.zoneReportIdTopNs.substring(0, this.zoneReportIdTopNs.length() - 1);
                this.zoneReportIdTopNs = this.zoneReportIdTopNs + "]";
            }
            if ("ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType())) {
                this.defaultDeviceName = this.getText("ips.analysis.common.netdevice.all");
                request.setAttribute("isIps", (Object)"1");
            } else {
                this.defaultDeviceName = this.getText("atic.analysis.common.netdevice.clean");
                request.setAttribute("isIps", (Object)"0");
            }
            logger.info((Object)"End ReportTaskAction editReportTaskInit function");
        }
        catch (SQLException e) {
            logger.error((Object)"ReportTaskAction editReportTaskInit is fail");
        }
        return "success";
    }

    private String processTaskCondition(Map<String, JsonValueObj> condMap, TaskCondition taskConditionItem) {
        String tempReportIdTopNs = "[";
        try {
            List tempCondition = this.reportTemplateService.getConditionByTemId(taskConditionItem.getTemplateId().toString());
            StringBuffer buf = new StringBuffer();
            for (TemplateCondition templateCondition : tempCondition) {
                String condJson = templateCondition.getReportCondition();
                condMap.clear();
                condMap.putAll(JSONUtil.transformKeyValueObjMap((String)condJson));
                String topN = "";
                if (null != condMap.get("TOPN")) {
                    topN = ((JsonValueItem)condMap.get("TOPN").getValueList().get(0)).getValue();
                }
                buf.append("{'reportId':'");
                buf.append(templateCondition.getReportId());
                buf.append("','topN':'");
                buf.append(topN);
                buf.append("'},");
            }
            tempReportIdTopNs = buf.toString();
        }
        catch (SQLException e) {
            logger.error((Object)"ReportTaskAction processTaskCondition is fail");
            return "";
        }
        catch (Exception e) {
            logger.error((Object)("ReportTaskAction processTaskCondition is fail: " + e.getMessage()));
            return "";
        }
        return tempReportIdTopNs;
    }

    private String processReportTypeName(Map<String, JsonValueObj> condMap, TaskCondition taskConditionItem) {
        String reportTypeName = SYSTEM_REPORT;
        try {
            String templateId = taskConditionItem.getTemplateId().toString();
            String templateType = "";
            if (!AticUtil.isNull((String)templateId)) {
                ReportTemplate template = this.reportTemplateService.getTemplateById(templateId);
                if (null != template) {
                    templateType = template.getDesc();
                } else {
                    logger.error((Object)"templateType is null!");
                    templateType = null;
                }
                if (AticUtil.isNull((String)templateType)) {
                    templateType = "";
                }
            }
            String sysDeviceConditionName = "sysDev4Edit";
            String zoneDeviceConditionName = "zoneDev4Edit";
            String sysAndZoneCondtionName = "netDevice_combobox";
            String zoneConditionName = "zone_combobox";
            ReportEmailInfoForm emailForm = new ReportEmailInfoForm();
            emailForm.setTaskId(taskConditionItem.getTaskId());
            emailForm.setConditionId(taskConditionItem.getPkId());
            emailForm.setAuthId("VSM_ATIC");
            emailForm = this.reportEmailInfoService.findByCondition(emailForm);
            if (StringUtils.equals((CharSequence)ZONE_REPORT, (CharSequence)templateType)) {
                reportTypeName = ZONE_REPORT;
                this.directionZone = null != condMap.get("direction_combobox") ? ((JsonValueItem)condMap.get("direction_combobox").getValueList().get(0)).getValue() : "1";
                JsonValueObj tempZoneItem = condMap.get(zoneDeviceConditionName);
                if (null != tempZoneItem) {
                    this.zoneDeviceName = ((JsonValueItem)tempZoneItem.getValueList().get(0)).getText();
                    this.zoneDeviceId = ((JsonValueItem)tempZoneItem.getValueList().get(0)).getValue();
                } else {
                    this.zoneDeviceName = ((JsonValueItem)condMap.get(sysAndZoneCondtionName).getValueList().get(0)).getText();
                    this.zoneDeviceId = ((JsonValueItem)condMap.get(sysAndZoneCondtionName).getValueList().get(0)).getValue();
                }
                this.zoneDeviceName = this.processDeviceName(this.zoneDeviceId, this.zoneDeviceName);
                this.deviceListForm = new DeviceListForm();
                this.deviceListForm.setZoneDeviceId(this.zoneDeviceId);
                this.deviceListForm.setZoneDeviceName(this.zoneDeviceName);
                this.zoneName = ((JsonValueItem)condMap.get(zoneConditionName).getValueList().get(0)).getText();
                this.zoneId = Long.parseLong(((JsonValueItem)condMap.get(zoneConditionName).getValueList().get(0)).getValue());
                this.initTaskDevList(this.zoneId);
                this.modifyZoneEmailInfo(emailForm);
                this.zoneReportEnable = true;
            } else {
                this.directionSystem = null != condMap.get("direction_combobox") ? ((JsonValueItem)condMap.get("direction_combobox").getValueList().get(0)).getValue() : "1";
                JsonValueObj tempSysItem = condMap.get(sysDeviceConditionName);
                if (null != tempSysItem) {
                    this.systemDeviceName = ((JsonValueItem)tempSysItem.getValueList().get(0)).getText();
                    this.systemDeviceId = ((JsonValueItem)tempSysItem.getValueList().get(0)).getValue();
                } else {
                    this.systemDeviceName = ((JsonValueItem)condMap.get(sysAndZoneCondtionName).getValueList().get(0)).getText();
                    this.systemDeviceId = ((JsonValueItem)condMap.get(sysAndZoneCondtionName).getValueList().get(0)).getValue();
                }
                this.defaultDevice = this.systemDeviceName = this.processDeviceName(this.systemDeviceId, this.systemDeviceName);
                this.defaultDeviceId = this.systemDeviceId;
                this.modifySystemEmailInfo(emailForm);
                this.systemReportEnable = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"ReportTaskAction processReportTypeName is fail");
            return reportTypeName;
        }
        return reportTypeName;
    }

    private String processDeviceName(String deviceId, String deviceName) {
        if (!deviceId.contains("_")) {
            if (-2L == Long.parseLong(deviceId)) {
                deviceName = this.getText("atic.analysis.common.netdevice.detect.nobracket");
            } else if (-1L == Long.parseLong(deviceId)) {
                deviceName = "ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType()) ? this.getText("ips.analysis.common.netdevice.all") : this.getText("atic.analysis.common.netdevice.clean.nobracket");
            }
            if (0L == Long.parseLong(deviceId)) {
                deviceName = this.getText("ips.analysis.common.netdevice.all");
            }
        }
        if (deviceName.contains("(") || deviceName.contains(")")) {
            deviceName = deviceName.replace("(", "-").replace(")", "");
        }
        return deviceName;
    }

    private void modifyZoneEmailInfo(ReportEmailInfoForm emailForm) {
        if (null != emailForm) {
            if (emailForm.getZoneId() > 0L) {
                this.checkZoneEmail = 1;
            }
            if (StringUtils.isNotEmpty((CharSequence)emailForm.getEmailInfo())) {
                this.checkOtherEmail = 1;
                this.otherEmailInfo = LegoDataProtectorWrapper.sdpDecryptLocal((String)emailForm.getEmailInfo());
            }
        }
    }

    private void modifySystemEmailInfo(ReportEmailInfoForm emailForm) {
        if (null != emailForm) {
            this.systemEmailInfo = LegoDataProtectorWrapper.sdpDecryptLocal((String)emailForm.getEmailInfo());
        }
    }

    public String editReportTask4Inte() {
        Boolean isEditSuccess = true;
        this.addOperaLogForAddAndEditTask();
        logger.info((Object)"Begin ReportTaskAction editReportTask function");
        Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
        ArrayList<String> systemReportIdList = new ArrayList<String>();
        ArrayList<Map<String, JsonValueObj>> systemReportQueryCondList = new ArrayList<Map<String, JsonValueObj>>();
        ArrayList<String> zoneReportIdList = new ArrayList<String>();
        ArrayList<Map<String, JsonValueObj>> zoneReportQueryCondList = new ArrayList<Map<String, JsonValueObj>>();
        this.getQueryCondition4Inte(systemReportIdList, systemReportQueryCondList, zoneReportIdList, zoneReportQueryCondList);
        try {
            List taskConditionList = this.timeTaskService.getTaskCondition(this.taskId);
            ArrayList<ReportEmailInfoForm> delEmailInfoList = new ArrayList<ReportEmailInfoForm>();
            for (TaskCondition temp : taskConditionList) {
                this.reportTemplateService.delConditionByTemId(temp.getTemplateId().toString());
                this.reportTemplateService.delTemplate(temp.getTemplateId().toString());
                this.timeTaskService.delTaskConditionByTemId(temp.getTemplateId().toString());
                ReportEmailInfoForm emailForm = new ReportEmailInfoForm();
                emailForm.setTaskId(temp.getTaskId());
                emailForm.setConditionId(temp.getPkId());
                emailForm.setAuthId("VSM_ATIC");
                delEmailInfoList.add(emailForm);
            }
            this.reportEmailInfoService.removeReportEmailInfo(delEmailInfoList);
            TimeTask timeTask = this.timeTaskService.getTimeTask(this.taskId);
            if (null == timeTask) {
                throw new LegoCheckedException(571701L);
            }
            timeTask.setStartDate(Long.valueOf(AticUtil.convertTimeString((String)this.taskStartTime)));
            timeTask.setEndDate(Long.valueOf(AticUtil.convertTimeString((String)this.taskEndTime)));
            long nextRunTime = IReportMgrUtil.getTaskNextRunTime((int)this.schedule, (String)this.runTime, (long)(AticUtil.convertTimeString((String)this.taskStartTime) * 1000L), (long)(AticUtil.convertTimeString((String)this.taskEndTime) * 1000L));
            if (nextRunTime <= 0L) {
                timeTask.setState(Integer.valueOf(2));
            } else {
                timeTask.setState(Integer.valueOf(1));
            }
            timeTask.setResultType(this.reportForm);
            timeTask.setRunTime(this.runTime);
            timeTask.setSchedule(this.schedule);
            timeTask.setTaskDesc(this.taskDesc);
            timeTask.setLocale(locale.toString());
            timeTask.setTaskName(this.taskName);
            timeTask.setAuthId("VSM_ATIC");
            this.timeTaskService.updateTimeTask(timeTask, this.taskId);
            ArrayList<ReportEmailInfoForm> emailInfoList = new ArrayList<ReportEmailInfoForm>();
            HashMap<String, List<String>> idMap = new HashMap<String, List<String>>();
            HashMap<String, List<Map<String, JsonValueObj>>> condMap = new HashMap<String, List<Map<String, JsonValueObj>>>();
            idMap.put("systemReportIdList", systemReportIdList);
            idMap.put("zoneReportIdList", zoneReportIdList);
            condMap.put("systemReportQueryCondList", systemReportQueryCondList);
            condMap.put("zoneReportQueryCondList", zoneReportQueryCondList);
            boolean isSuccess = this.addReportTaskTemplateAndCondition(idMap, condMap, this.taskId, emailInfoList);
            this.reportEmailInfoService.saveReportEmailInfo(emailInfoList);
            if (1 == timeTask.getState() && isSuccess) {
                IRTimeTaskMgr.getInstance().addTimeTask(timeTask);
            }
            logger.info((Object)"End ReportTaskAction editReportTask function");
        }
        catch (LegoCheckedException legoException) {
            logger.error((Object)("ReportTaskAction editReportTask is fail:" + legoException.getErrorCode() + ". " + legoException.getMessage()));
            throw legoException;
        }
        catch (Exception e) {
            logger.error((Object)("ReportTaskAction editReportTask is fail:" + e.getMessage()));
            isEditSuccess = false;
        }
        if (!isEditSuccess.booleanValue()) {
            throw new LegoCheckedException(571805L);
        }
        return "success";
    }

    public String editReportTask4SelectInte() {
        Boolean isEditSuccess = true;
        this.addOperaLogForAddAndEditTask();
        ArrayList<Integer> taskIds = new ArrayList<Integer>();
        taskIds.add(this.taskId);
        this.checkReportTaskSecurity(taskIds);
        ArrayList<Long> moIDList = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)this.zoneDeviceId) && ReportConditionUtil.getLongDeviceId(this.zoneDeviceId) > 0L) {
            moIDList.add(ReportConditionUtil.getLongDeviceId(this.zoneDeviceId));
        }
        if (StringUtils.isNotBlank((CharSequence)this.systemDeviceId) && ReportConditionUtil.getLongDeviceId(this.systemDeviceId) > 0L) {
            moIDList.add(ReportConditionUtil.getLongDeviceId(this.systemDeviceId));
        }
        if (null != this.zoneId) {
            moIDList.add(ReportBisUtil.getMoidByZoneid(this.zoneId));
        }
        ReportBisUtil.checkUserSecurity(moIDList);
        logger.info((Object)"Begin ReportTaskAction editReportTask4SelectInte function");
        Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
        ArrayList<String> systemReportIdList = new ArrayList<String>();
        ArrayList<Map<String, JsonValueObj>> systemReportQueryCondList = new ArrayList<Map<String, JsonValueObj>>();
        ArrayList<String> zoneReportIdList = new ArrayList<String>();
        ArrayList<Map<String, JsonValueObj>> zoneReportQueryCondList = new ArrayList<Map<String, JsonValueObj>>();
        this.getQueryCondition4SelectInte(systemReportIdList, systemReportQueryCondList, zoneReportIdList, zoneReportQueryCondList);
        try {
            List taskConditionList = this.timeTaskService.getTaskCondition(this.taskId);
            ArrayList<ReportEmailInfoForm> delEmailInfoList = new ArrayList<ReportEmailInfoForm>();
            for (TaskCondition temp : taskConditionList) {
                this.reportTemplateService.delConditionByTemId(temp.getTemplateId().toString());
                this.reportTemplateService.delTemplate(temp.getTemplateId().toString());
                this.timeTaskService.delTaskConditionByTemId(temp.getTemplateId().toString());
                ReportEmailInfoForm emailForm = new ReportEmailInfoForm();
                emailForm.setTaskId(temp.getTaskId());
                emailForm.setConditionId(temp.getPkId());
                emailForm.setAuthId("VSM_ATIC");
                delEmailInfoList.add(emailForm);
            }
            this.reportEmailInfoService.removeReportEmailInfo(delEmailInfoList);
            TimeTask timeTask = this.timeTaskService.getTimeTask(this.taskId);
            if (null == timeTask) {
                throw new LegoCheckedException(571701L);
            }
            timeTask.setStartDate(Long.valueOf(AticUtil.convertTimeString((String)this.taskStartTime)));
            timeTask.setEndDate(Long.valueOf(AticUtil.convertTimeString((String)this.taskEndTime)));
            long nextRunTime = IReportMgrUtil.getTaskNextRunTime((int)this.schedule, (String)this.runTime, (long)(AticUtil.convertTimeString((String)this.taskStartTime) * 1000L), (long)(AticUtil.convertTimeString((String)this.taskEndTime) * 1000L));
            if (nextRunTime <= 0L) {
                timeTask.setState(Integer.valueOf(2));
            } else {
                timeTask.setState(Integer.valueOf(1));
            }
            timeTask.setResultType(this.reportForm);
            timeTask.setRunTime(this.runTime);
            timeTask.setSchedule(this.schedule);
            timeTask.setTaskDesc(this.taskDesc);
            timeTask.setLocale(locale.toString());
            timeTask.setTaskName(this.taskName);
            timeTask.setAuthId("VSM_ATIC");
            this.timeTaskService.updateTimeTask(timeTask, this.taskId);
            ArrayList<ReportEmailInfoForm> emailInfoList = new ArrayList<ReportEmailInfoForm>();
            HashMap<String, List<String>> idMap = new HashMap<String, List<String>>();
            HashMap<String, List<Map<String, JsonValueObj>>> condMap = new HashMap<String, List<Map<String, JsonValueObj>>>();
            idMap.put("systemReportIdList", systemReportIdList);
            idMap.put("zoneReportIdList", zoneReportIdList);
            condMap.put("systemReportQueryCondList", systemReportQueryCondList);
            condMap.put("zoneReportQueryCondList", zoneReportQueryCondList);
            boolean isSuccess = this.addReportTaskTemplateAndCondition(idMap, condMap, this.taskId, emailInfoList);
            this.reportEmailInfoService.saveReportEmailInfo(emailInfoList);
            if (1 == timeTask.getState() && isSuccess) {
                IRTimeTaskMgr.getInstance().addTimeTask(timeTask);
            }
            logger.info((Object)"End ReportTaskAction editReportTask4SelectInte function");
        }
        catch (LegoCheckedException legoException) {
            logger.error((Object)("ReportTaskAction editReportTask4SelectInte is fail::" + legoException.getErrorCode() + legoException.getMessage()));
            throw legoException;
        }
        catch (Exception e) {
            logger.error((Object)("ReportTaskAction editReportTask4SelectInte is fail: " + ReportTaskAction.getcleanedMessage(e.getMessage())));
            isEditSuccess = false;
        }
        if (!isEditSuccess.booleanValue()) {
            throw new LegoCheckedException(571805L);
        }
        return "success";
    }

    public String deleteReportTask() {
        logger.info((Object)"Begin ReportTaskAction deleteReportTask function");
        try {
            List taskCond = this.timeTaskService.getTaskCondition(this.taskId);
            ArrayList<ReportEmailInfoForm> emailInfoList = new ArrayList<ReportEmailInfoForm>();
            for (TaskCondition taskCondition : taskCond) {
                if (taskCondition.getTemplateId() == 0) continue;
                this.reportTemplateService.delTemplate(taskCondition.getTemplateId().toString());
                ReportEmailInfoForm emailForm = new ReportEmailInfoForm();
                emailForm.setTaskId(taskCondition.getTaskId());
                emailForm.setConditionId(taskCondition.getPkId());
                emailForm.setAuthId("VSM_ATIC");
                emailInfoList.add(emailForm);
            }
            this.reportEmailInfoService.removeReportEmailInfo(emailInfoList);
            logger.info((Object)"End ReportTaskAction deleteReportTask function");
        }
        catch (Exception e) {
            logger.error((Object)("ReportTaskAction deleteReportTask is fail: " + e.getMessage()));
        }
        return "success";
    }

    public boolean validateDeleteReportTask() {
        String[] whiteList = new String[]{"taskId"};
        return AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList);
    }

    public String deleteAllReportTask() {
        logger.info((Object)"Begin ReportTaskAction deleteAllReportTask function");
        try {
            ArrayList<ReportEmailInfoForm> emailInfoList = new ArrayList<ReportEmailInfoForm>();
            String[] taskIds = this.batchTaskId.split(",");
            for (int i = 0; i < taskIds.length; ++i) {
                List taskCond = this.timeTaskService.getTaskCondition(Integer.valueOf(Integer.parseInt(taskIds[i].trim())));
                for (TaskCondition taskCondition : taskCond) {
                    if (taskCondition.getTemplateId() == 0) continue;
                    this.reportTemplateService.delTemplate(taskCondition.getTemplateId().toString());
                    ReportEmailInfoForm emailForm = new ReportEmailInfoForm();
                    emailForm.setTaskId(taskCondition.getTaskId());
                    emailForm.setConditionId(taskCondition.getPkId());
                    emailForm.setAuthId("VSM_ATIC");
                    emailInfoList.add(emailForm);
                }
            }
            this.reportEmailInfoService.removeReportEmailInfo(emailInfoList);
            logger.info((Object)"End ReportTaskAction deleteAllReportTask function");
        }
        catch (SQLException e) {
            logger.error((Object)"ReportTaskAction deleteAllReportTask is fail");
        }
        return "success";
    }

    public boolean validateDeleteAllReportTask() {
        String[] whiteList = new String[]{"batchTaskId"};
        return AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList);
    }

    private void processOpeLog(Boolean sucess, String taskNameStr, String errorInfo) {
        ISysOptLog sysOptLogMgr = ReportAnalysisUtil.getSysOptLog();
        com.hs.lego.core.system.syslog.sdk.model.SysOptLog sysOptLogLego = new com.hs.lego.core.system.syslog.sdk.model.SysOptLog();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticAnalysis");
        sysOptLogLego.setOperation("atic.reportTask.changeState");
        sysOptLogLego.setTarget(taskNameStr);
        if (sucess.booleanValue()) {
            sysOptLogLego.setResult(1);
            String fromState = "atic.report.task.runState";
            String toState = "atic.report.task.appendState";
            if (this.taskState.equals("0")) {
                fromState = "atic.report.task.appendState";
                toState = "atic.report.task.runState";
            }
            sysOptLogLego.setDetail("atic.reportTask.changeState.success");
            String[] para = new String[]{fromState, toState};
            sysOptLogLego.setDetailPara(para);
        } else {
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail(errorInfo);
        }
        String terminalIp = "127.0.0.1";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            sysOptLogLego.setOperator(currentUser.getUserName());
        }
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }

    private void checkChangeStateSecurity() {
        String[] taskIds;
        ArrayList<Integer> selectTaskIds = new ArrayList<Integer>();
        for (String tempTaskId : taskIds = this.batchTaskId.split(",")) {
            Integer taskIdInt = Integer.parseInt(tempTaskId.trim());
            selectTaskIds.add(taskIdInt);
        }
        this.checkReportTaskSecurity(selectTaskIds);
    }

    public void batchChangeTaskState() {
        logger.info((Object)"Begin ReportTaskAction batchChangeTaskState function");
        HttpServletResponse response = (HttpServletResponse)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        response.setContentType("application/xml;charset=UTF-8");
        String batchChangeState = "";
        String[] taskIds = this.batchTaskId.split(",");
        String[] taskNames = this.batchTaskName.split(",");
        this.checkChangeStateSecurity();
        try {
            for (int i = 0; i < taskIds.length; ++i) {
                TimeTask changeTask = this.timeTaskService.getTimeTask(Integer.valueOf(Integer.parseInt(taskIds[i].trim())));
                if (null == changeTask) {
                    batchChangeState = batchChangeState + this.getText("atic.reportTask.changeState.fail.notExist") + " : " + taskNames[i].trim();
                    this.processOpeLog(false, taskNames[i].trim(), "atic.reportTask.changeState.fail.notExist");
                    continue;
                }
                if (!changeTask.getState().toString().equals(this.taskState)) {
                    this.processOpeLog(true, taskNames[i].trim(), "");
                    continue;
                }
                String result = this.timeTaskService.changeState(Integer.valueOf(Integer.parseInt(taskIds[i].trim())));
                if ("fail".equalsIgnoreCase(result)) {
                    batchChangeState = batchChangeState + this.getText("atic.reportTask.changeState.SQLError") + " : " + taskNames[i].trim();
                    this.processOpeLog(false, taskNames[i].trim(), "atic.reportTask.changeState.SQLError");
                    continue;
                }
                if ("error".equalsIgnoreCase(result)) {
                    batchChangeState = batchChangeState + this.getText("atic.reportTask.changeState.fail.notExist") + " : " + taskNames[i].trim();
                    this.processOpeLog(false, taskNames[i].trim(), "atic.reportTask.changeState.fail.notExist");
                    continue;
                }
                batchChangeState = batchChangeState + "";
                this.processOpeLog(true, taskNames[i].trim(), "");
            }
            if (AticUtil.isNull((String)batchChangeState)) {
                batchChangeState = "success";
            }
            response.getWriter().write(batchChangeState);
            logger.info((Object)"End ReportTaskAction deleteAllReportTask function");
        }
        catch (IOException e) {
            try {
                response.getWriter().write("error");
            }
            catch (IOException e1) {
                logger.error((Object)"batchChangeTaskState IOException ");
            }
            logger.error((Object)("ReportTaskAction batchChangeTaskState is fail: " + e.getMessage()));
        }
    }

    public boolean validateBatchChangeTaskState() {
        String[] whiteList = new String[]{"batchTaskId", "batchTaskName", "taskState"};
        return AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList);
    }

    public String showTaskResult() {
        ArrayList<Integer> taskIds = new ArrayList<Integer>();
        taskIds.add(this.taskId);
        this.checkReportTaskSecurity(taskIds);
        if (null == this.taskLog) {
            this.taskLog = new ArrayList<TaskLogForm>();
        }
        logger.info((Object)"Begin ReportTaskAction showTaskResult function");
        try {
            List taskLogVOList = this.timeTaskService.getLogInfo(this.taskId);
            TaskLogForm taskLogForm = null;
            for (int i = 0; i < taskLogVOList.size(); ++i) {
                taskLogForm = new TaskLogForm();
                taskLogForm.setPkId(((TaskLogVO)taskLogVOList.get(i)).getPkId());
                taskLogForm.setReportName(((TaskLogVO)taskLogVOList.get(i)).getReportName());
                taskLogForm.setResultInfo(((TaskLogVO)taskLogVOList.get(i)).getResultInfo());
                taskLogForm.setRunTime(((TaskLogVO)taskLogVOList.get(i)).getRunTime());
                if (!"".equals(((TaskLogVO)taskLogVOList.get(i)).getEndTime())) {
                    taskLogForm.setCostTime(AticUtil.convertTimeString((String)((TaskLogVO)taskLogVOList.get(i)).getEndTime()) - AticUtil.convertTimeString((String)((TaskLogVO)taskLogVOList.get(i)).getRunTime()));
                    if ("0".equals(((TaskLogVO)taskLogVOList.get(i)).getResultInfo())) {
                        taskLogForm.setState(0);
                    } else {
                        taskLogForm.setState(1);
                    }
                } else {
                    taskLogForm.setCostTime(System.currentTimeMillis() / 1000L - AticUtil.convertTimeString((String)((TaskLogVO)taskLogVOList.get(i)).getRunTime()));
                    taskLogForm.setState(2);
                }
                this.taskLog.add(taskLogForm);
            }
            this.taskName = IReportUtil.getTaskName((Integer)this.taskId);
            logger.info((Object)"End ReportTaskAction showTaskResult function");
        }
        catch (Exception e) {
            logger.error((Object)("ReportTaskAction showTaskResult query is fail: " + e.getMessage()));
        }
        return "success";
    }

    private void initCombData() {
        this.taskScheduleData = ReportConditionUtil.getTaskScheduleCombData();
        this.reportStatusData = ReportConditionUtil.getReportStateCombData();
    }

    public boolean validateLogIds() {
        if (null == this.logId || this.logId.length == 0 || this.logId.length > 100) {
            return false;
        }
        try {
            for (String s : this.logId) {
                if (Integer.parseInt(s) >= 0 && Integer.parseInt(s) <= 65535) continue;
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean validateBatchTaskIds() {
        if (null == this.batchTaskId) {
            return false;
        }
        String[] taskIds = this.batchTaskId.split(",");
        if (taskIds.length > 100) {
            return false;
        }
        try {
            for (String id : taskIds) {
                if (Integer.parseInt(id.trim()) >= 0 && Integer.parseInt(id.trim()) <= 65535) continue;
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean checkParams() {
        if (!AticUtil.isNullForVpn((String)this.otherEmailInfo) && !ReportTaskAction.checkEmail(this.otherEmailInfo)) {
            return false;
        }
        if (!AticUtil.isNullForVpn((String)this.systemEmailInfo) && !ReportTaskAction.checkEmail(this.systemEmailInfo)) {
            return false;
        }
        if (!AticUtil.validateSpecialStr((String)this.zoneName)) {
            return false;
        }
        String reportFormRegex = "^(pdf|html|excel)?$";
        if (null == this.reportForm) {
            return false;
        }
        String[] reportTypes = this.reportForm.split(",");
        for (int i = 0; i < reportTypes.length; ++i) {
            if (reportTypes[i].matches(reportFormRegex)) continue;
            return false;
        }
        if (this.schedule < 1 || this.schedule > 5) {
            return false;
        }
        if (!AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.taskStartTime) || !AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.taskEndTime)) {
            return false;
        }
        if (!AticUtil.validateSpecialStr((String)this.systemReportIds)) {
            return false;
        }
        if (!AticUtil.validateSpecialStr((String)this.zoneReportIds)) {
            return false;
        }
        if (null != this.systemTopNValues && !AticUtil.validateSpecialStr((String)this.systemTopNValues)) {
            return false;
        }
        if (null != this.zoneTopNValues && !AticUtil.validateSpecialStr((String)this.zoneTopNValues)) {
            return false;
        }
        if (!AticUtil.validateSpecialStr((String)this.systemDeviceId)) {
            return false;
        }
        return AticUtil.validateSpecialStr((String)this.zoneDeviceId);
    }

    public boolean checkAddTimeParams() {
        if (this.schedule < 1 || this.schedule > 5) {
            return false;
        }
        SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        smpDateFormat.setLenient(false);
        try {
            smpDateFormat.parse(this.endDate);
            smpDateFormat.parse(this.startDate);
        }
        catch (ParseException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean checkTaskParams() {
        if (StringUtils.isEmpty((CharSequence)this.batchTaskId)) {
            return false;
        }
        String[] taskIds = this.batchTaskId.split(",");
        if (taskIds.length > 100) {
            return false;
        }
        for (String testTaskIdStr : taskIds) {
            if (StringUtils.isEmpty((CharSequence)testTaskIdStr)) {
                return false;
            }
            try {
                int testTaskId;
                if (null == testTaskIdStr || (testTaskId = Integer.parseInt(testTaskIdStr.trim())) >= 0) continue;
                return false;
            }
            catch (NumberFormatException e) {
                logger.error((Object)"Integer format is error");
                return false;
            }
        }
        return true;
    }

    public void checkIsSend() {
        if (this.checkZoneEmail < 0 || this.checkZoneEmail > 1) {
            throw new LegoCheckedException(570505L);
        }
        if (this.checkOtherEmail < 0 || this.checkOtherEmail > 1) {
            throw new LegoCheckedException(570505L);
        }
    }

    public String getStartTime() {
        return this.startTime;
    }

    public List<LangPair> getReportStatusData() {
        return this.reportStatusData;
    }

    public void setReportStatusData(List<LangPair> reportStatusData) {
        this.reportStatusData = reportStatusData;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getTaskStartTime() {
        return this.taskStartTime;
    }

    public void setTaskStartTime(String taskStartTime) {
        this.taskStartTime = taskStartTime;
    }

    public String getTaskEndTime() {
        return this.taskEndTime;
    }

    public void setTaskEndTime(String taskEndTime) {
        this.taskEndTime = taskEndTime;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getReportForm() {
        return this.reportForm;
    }

    public void setReportForm(String reportForm) {
        this.reportForm = reportForm;
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Integer taskId) {
        this.taskId = taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskDesc() {
        return this.taskDesc;
    }

    public void setTaskDesc(String taskDesc) {
        this.taskDesc = taskDesc;
    }

    public String getRunTime() {
        return this.runTime;
    }

    public void setRunTime(String runTime) {
        this.runTime = runTime;
    }

    public Integer getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    public String getBatchTaskId() {
        return this.batchTaskId;
    }

    public void setBatchTaskId(String batchTaskId) {
        this.batchTaskId = batchTaskId;
    }

    public SelectForm getSelectMinute() {
        return this.selectMinute;
    }

    public void setSelectMinute(SelectForm selectMinute) {
        this.selectMinute = selectMinute;
    }

    public SelectForm getSelectHour() {
        return this.selectHour;
    }

    public void setSelectHour(SelectForm selectHour) {
        this.selectHour = selectHour;
    }

    public SelectForm getSelectDay() {
        return this.selectDay;
    }

    public void setSelectDay(SelectForm selectDay) {
        this.selectDay = selectDay;
    }

    public SelectForm getSelectMonth() {
        return this.selectMonth;
    }

    public void setSelectMonth(SelectForm selectMonth) {
        this.selectMonth = selectMonth;
    }

    public TimeTask getTimeTaskVO() {
        return this.timeTaskVO;
    }

    public void setTimeTaskVO(TimeTask timeTaskVO) {
        this.timeTaskVO = timeTaskVO;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public List<TimeTaskForm> getTempTasks() {
        return this.tempTasks;
    }

    public void setTempTasks(List<TimeTaskForm> tempTasks) {
        this.tempTasks = tempTasks;
    }

    public String getQueryReportTaskName() {
        return this.queryReportTaskName;
    }

    public void setQueryReportTaskName(String queryReportTaskName) {
        this.queryReportTaskName = queryReportTaskName;
    }

    public List<TaskLogVO> getTempResults() {
        return this.tempResults;
    }

    public void setTempResults(List<TaskLogVO> tempResults) {
        this.tempResults = tempResults;
    }

    public List<TaskLogForm> getTaskLog() {
        return this.taskLog;
    }

    public void setTaskLog(List<TaskLogForm> taskLog) {
        this.taskLog = taskLog;
    }

    public TaskScheduleForm getTaskScheduleForm() {
        return this.taskScheduleForm;
    }

    public void setTaskScheduleForm(TaskScheduleForm taskScheduleForm) {
        this.taskScheduleForm = taskScheduleForm;
    }

    public TaskStateForm getTaskStateForm() {
        return this.taskStateForm;
    }

    public void setTaskStateForm(TaskStateForm taskStateForm) {
        this.taskStateForm = taskStateForm;
    }

    public List<TaskWeekForm> getTaskWeekList() {
        return this.taskWeekList;
    }

    public void setTaskWeekList(List<TaskWeekForm> taskWeekList) {
        this.taskWeekList = taskWeekList;
    }

    public TaskWeekForm getTaskWeekForm() {
        return this.taskWeekForm;
    }

    public void setTaskWeekForm(TaskWeekForm taskWeekForm) {
        this.taskWeekForm = taskWeekForm;
    }

    public String getTaskSchedule() {
        return this.taskSchedule;
    }

    public void setTaskSchedule(String taskSchedule) {
        this.taskSchedule = taskSchedule;
    }

    public String getTaskState() {
        return this.taskState;
    }

    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }

    public String getQueryContent() {
        return this.queryContent;
    }

    public void setQueryContent(String queryContent) {
        this.queryContent = queryContent;
    }

    public List<TaskScheduleForm> getTaskScheduleList() {
        return this.taskScheduleList;
    }

    public void setTaskScheduleList(List<TaskScheduleForm> taskScheduleList) {
        this.taskScheduleList = taskScheduleList;
    }

    public List<ReportFileType> getReportFileTypeList() {
        return this.reportFileTypeList;
    }

    public void setReportFileTypeList(List<ReportFileType> reportFileTypeList) {
        this.reportFileTypeList = reportFileTypeList;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public String getSynthesisReportType() {
        return this.synthesisReportType;
    }

    public void setSynthesisReportType(String synthesisReportType) {
        this.synthesisReportType = synthesisReportType;
    }

    public String getSystemDeviceId() {
        return this.systemDeviceId;
    }

    public void setSystemDeviceId(String systemDeviceId) {
        this.systemDeviceId = systemDeviceId;
    }

    public String getZoneDeviceId() {
        return this.zoneDeviceId;
    }

    public void setZoneDeviceId(String zoneDeviceId) {
        this.zoneDeviceId = zoneDeviceId;
    }

    public String getSystemDeviceName() {
        return this.systemDeviceName;
    }

    public void setSystemDeviceName(String systemDeviceName) {
        this.systemDeviceName = systemDeviceName;
    }

    public String getZoneDeviceName() {
        return this.zoneDeviceName;
    }

    public void setZoneDeviceName(String zoneDeviceName) {
        this.zoneDeviceName = zoneDeviceName;
    }

    public String getSystemReportIds() {
        return this.systemReportIds;
    }

    public void setSystemReportIds(String systemReportIds) {
        this.systemReportIds = systemReportIds;
    }

    public String getZoneReportIds() {
        return this.zoneReportIds;
    }

    public void setZoneReportIds(String zoneReportIds) {
        this.zoneReportIds = zoneReportIds;
    }

    public String getSystemTopNValues() {
        return this.systemTopNValues;
    }

    public void setSystemTopNValues(String systemTopNValues) {
        this.systemTopNValues = systemTopNValues;
    }

    public String getZoneTopNValues() {
        return this.zoneTopNValues;
    }

    public void setZoneTopNValues(String zoneTopNValues) {
        this.zoneTopNValues = zoneTopNValues;
    }

    public String getSystemReportIdTopNs() {
        return this.systemReportIdTopNs;
    }

    public void setSystemReportIdTopNs(String systemReportIdTopNs) {
        this.systemReportIdTopNs = systemReportIdTopNs;
    }

    public String getZoneReportIdTopNs() {
        return this.zoneReportIdTopNs;
    }

    public void setZoneReportIdTopNs(String zoneReportIdTopNs) {
        this.zoneReportIdTopNs = zoneReportIdTopNs;
    }

    public String getDefaultDeviceName() {
        return this.defaultDeviceName;
    }

    public void setDefaultDeviceName(String defaultDeviceName) {
        this.defaultDeviceName = defaultDeviceName;
    }

    public List<LangPair> getTaskScheduleData() {
        return this.taskScheduleData;
    }

    public void setTaskScheduleData(List<LangPair> taskScheduleData) {
        this.taskScheduleData = taskScheduleData;
    }

    public String getSystemEmailInfo() {
        return this.systemEmailInfo;
    }

    public void setSystemEmailInfo(String systemEmailInfo) {
        this.systemEmailInfo = systemEmailInfo;
    }

    public String getOtherEmailInfo() {
        return this.otherEmailInfo;
    }

    public void setOtherEmailInfo(String otherEmailInfo) {
        this.otherEmailInfo = otherEmailInfo;
    }

    public int getCheckZoneEmail() {
        return this.checkZoneEmail;
    }

    public void setCheckZoneEmail(int checkZoneEmail) {
        this.checkZoneEmail = checkZoneEmail;
    }

    public int getCheckOtherEmail() {
        return this.checkOtherEmail;
    }

    public void setCheckOtherEmail(int checkOtherEmail) {
        this.checkOtherEmail = checkOtherEmail;
    }

    public String getBatchTaskName() {
        return this.batchTaskName;
    }

    public void setBatchTaskName(String batchTaskName) {
        this.batchTaskName = batchTaskName;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public Boolean getZoneReportEnable() {
        return this.zoneReportEnable;
    }

    public void setZoneReportEnable(Boolean zoneReportEnable) {
        this.zoneReportEnable = zoneReportEnable;
    }

    public Boolean getSystemReportEnable() {
        return this.systemReportEnable;
    }

    public void setSystemReportEnable(Boolean systemReportEnable) {
        this.systemReportEnable = systemReportEnable;
    }

    public String getDateStartTime() {
        return this.dateStartTime;
    }

    public void setDateStartTime(String dateStartTime) {
        this.dateStartTime = dateStartTime;
    }

    public String getDateEndTime() {
        return this.dateEndTime;
    }

    public void setDateEndTime(String dateEndTime) {
        this.dateEndTime = dateEndTime;
    }

    public String getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(String scheduleType) {
        this.scheduleType = scheduleType;
    }

    public List<DeviceListForm> getZoneDeviceList() {
        return this.zoneDeviceList;
    }

    public void setZoneDeviceList(List<DeviceListForm> zoneDeviceList) {
        this.zoneDeviceList = zoneDeviceList;
    }

    public DeviceListForm getDeviceListForm() {
        return this.deviceListForm;
    }

    public void setDeviceListForm(DeviceListForm deviceListForm) {
        this.deviceListForm = deviceListForm;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String[] getLogId() {
        if (null != this.logId) {
            return (String[])this.logId.clone();
        }
        return new String[0];
    }

    public void setLogId(String[] logId) {
        this.logId = null != logId ? (String[])logId.clone() : null;
    }

    public IReportEmailInfoService getReportEmailInfoService() {
        return this.reportEmailInfoService;
    }

    public void setReportEmailInfoService(IReportEmailInfoService reportEmailInfoService) {
        this.reportEmailInfoService = reportEmailInfoService;
    }

    public boolean validateSystemReportIds() {
        String[] allReports = new String[]{"AttackDisCount", "FluxCompareBPS", "AttackTrend", "AbnormalOrAttackTopN", "AttackEventTopN", "FlowTopN", "ConnCompare", "IpLocationTopN"};
        ArrayList<String> allReportsList = new ArrayList<String>(Arrays.asList(allReports));
        if (AticUtil.isNullForVpn((String)this.systemReportIds)) {
            return true;
        }
        String[] testReports = this.systemReportIds.substring(0, this.systemReportIds.length() - 1).split(",");
        if (testReports.length == 0 || testReports.length > 100) {
            return false;
        }
        return allReportsList.containsAll(new ArrayList<String>(Arrays.asList(testReports)));
    }

    public boolean validateSystemTopNValues() {
        String[] reportValue0 = new String[]{"AttackDisCount", "FluxCompareBPS", "AttackTrend", "ConnCompare"};
        String[] reportValue50 = new String[]{"AbnormalOrAttackTopN", "AttackEventTopN", "FlowTopN", "IpLocationTopN"};
        if (AticUtil.isNullForVpn((String)this.systemReportIds)) {
            return true;
        }
        String[] testReportNames = this.systemReportIds.substring(0, this.systemReportIds.length() - 1).split(",");
        if (testReportNames.length == 0 || testReportNames.length > 100) {
            return false;
        }
        if (AticUtil.isNull((String)this.systemTopNValues)) {
            return false;
        }
        String[] testTopNValuess = this.systemTopNValues.substring(0, this.systemTopNValues.length() - 1).split(",");
        if (testTopNValuess.length == 0 || testTopNValuess.length > 100) {
            return false;
        }
        if (testReportNames.length != testTopNValuess.length) {
            return false;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < testReportNames.length; ++i) {
            try {
                map.put(testReportNames[i], Integer.valueOf(testTopNValuess[i]));
                continue;
            }
            catch (NumberFormatException e) {
                logger.error((Object)"Integer format is error");
                return false;
            }
        }
        for (String keyStr : reportValue0) {
            if (null == map.get(keyStr) || (Integer)map.get(keyStr) == 0) continue;
            return false;
        }
        for (String keyStr : reportValue50) {
            Integer testValue = (Integer)map.get(keyStr);
            if (null == testValue || testValue >= 1 && testValue <= 50) continue;
            return false;
        }
        return true;
    }

    public boolean validateZoneReportIds() {
        String[] allReports = new String[]{"AttackDisCount", "FluxCompareBPS", "AttackTrend", "AbnormalOrAttackTopN", "AttackEventTopN", "FlowTopN", "ConnCompare", "IpLocationTopN"};
        ArrayList<String> allReportsList = new ArrayList<String>(Arrays.asList(allReports));
        if (AticUtil.isNullForVpn((String)this.zoneReportIds)) {
            return true;
        }
        String[] testReports = this.zoneReportIds.substring(0, this.zoneReportIds.length() - 1).split(",");
        if (testReports.length == 0 || testReports.length > 100) {
            return false;
        }
        return allReportsList.containsAll(new ArrayList<String>(Arrays.asList(testReports)));
    }

    public boolean validateZoneTopNValues() {
        String[] reportValue0 = new String[]{"AttackDisCount", "FluxCompareBPS", "AttackTrend", "ConnCompare"};
        String[] reportValue50 = new String[]{"AbnormalOrAttackTopN", "AttackEventTopN", "FlowTopN", "IpLocationTopN"};
        if (AticUtil.isNullForVpn((String)this.zoneReportIds)) {
            return true;
        }
        String[] testReportNames = this.zoneReportIds.substring(0, this.zoneReportIds.length() - 1).split(",");
        if (testReportNames.length == 0 || testReportNames.length > 100) {
            return false;
        }
        if (AticUtil.isNull((String)this.zoneTopNValues)) {
            return false;
        }
        String[] testTopNValuess = this.zoneTopNValues.substring(0, this.zoneTopNValues.length() - 1).split(",");
        if (testTopNValuess.length == 0 || testTopNValuess.length > 100) {
            return false;
        }
        if (testReportNames.length != testTopNValuess.length) {
            return false;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < testReportNames.length; ++i) {
            try {
                map.put(testReportNames[i], Integer.valueOf(testTopNValuess[i]));
                continue;
            }
            catch (NumberFormatException e) {
                logger.error((Object)"Integer format is error");
                return false;
            }
        }
        for (String keyStr : reportValue0) {
            if (null == map.get(keyStr) || (Integer)map.get(keyStr) == 0) continue;
            return false;
        }
        for (String keyStr : reportValue50) {
            Integer testValue = (Integer)map.get(keyStr);
            if (null == testValue || testValue >= 1 && testValue <= 50) continue;
            return false;
        }
        return true;
    }

    public boolean validateBatchBatchTaskName() {
        if (AticUtil.isNull((String)this.batchTaskName)) {
            return false;
        }
        String[] tempName = this.batchTaskName.split(",");
        if (tempName.length > 100) {
            return false;
        }
        for (int i = 0; i < tempName.length; ++i) {
            if (tempName[i].trim().equalsIgnoreCase("null")) {
                return false;
            }
            if (AticUtil.isValidReportTaskName((String)tempName[i].trim())) continue;
            return false;
        }
        return true;
    }

    public boolean validateDate(String date) {
        return AticUtil.isNullForVpn((String)date) || AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    private static boolean checkEmail(String otherEmailInfo) {
        String[] each;
        for (String tempeach : each = otherEmailInfo.split(";")) {
            if (tempeach.length() <= 64 && tempeach.matches("^\\w+([-\\.]\\w+)*@\\w+([-\\.]\\w+)*\\.\\w+([-\\.]\\w+)*$")) continue;
            return false;
        }
        return true;
    }

    private User getSessionUser() {
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        return currentUser;
    }

    public String getDirectionSystem() {
        return this.directionSystem;
    }

    public void setDirectionSystem(String directionSystem) {
        this.directionSystem = directionSystem;
    }

    public String getDirectionZone() {
        return this.directionZone;
    }

    public void setDirectionZone(String directionZone) {
        this.directionZone = directionZone;
    }

    public List<DeviceListForm> getInitDeviceList() {
        return this.initDeviceList;
    }

    public void setInitDeviceList(List<DeviceListForm> initDeviceList) {
        this.initDeviceList = initDeviceList;
    }

    public String getDefaultDevice() {
        return this.defaultDevice;
    }

    public void setDefaultDevice(String defaultDevice) {
        this.defaultDevice = defaultDevice;
    }

    public String getDefaultDeviceId() {
        return this.defaultDeviceId;
    }

    public void setDefaultDeviceId(String defaultDeviceId) {
        this.defaultDeviceId = defaultDeviceId;
    }
}

