/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.report.model;

import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.report.action.SystemReportAction;
import com.hs.atic.report.model.ReportCondModel;
import com.hs.atic.report.model.SelectForm;
import com.hs.atic.report.model.TaskScheduleForm;
import com.hs.atic.report.util.ReportConditionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import com.hs.lego.ui.plat.common.util.OperateLocker;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.huawei.atic.device.model.AticDevice;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.ReportSessionManager;
import com.security.ireport.engine.output.ExportReport;
import com.security.ireport.model.vo.JsonValueObj;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SubTransDataRunnable
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private ActionContext ctx = null;
    private HttpServletRequest request = null;
    private String contextPath = "";
    private String remoteAddr = "";
    private HttpSession session = null;
    private String tempReportFileName = "";
    private String requestSessionId = "";
    private String downloadFilePath = "";
    private String systemDeviceId;
    private String systemDeviceName;
    private String synthesisReportType;
    private String zoneDeviceId;
    private String directionSystem;
    private String zoneDeviceName;
    private String directionZone;
    private Long zoneId;
    private String zoneName;
    private int isSchedule;
    private String startTime;
    private String endTime;
    private String topNValues;
    private String reportIds;
    private String formType;
    private int schedule;
    private TaskScheduleForm taskScheduleForm;
    private String scheduleTime;
    private SelectForm selectYear;
    private SelectForm selectMonth;
    private String selectYearValue;
    private String selectMonthValue;
    private ActionSupport action;
    private String reportId4Inte;
    private String commonCleanText;
    private String commonDetectText;

    public SubTransDataRunnable(String reportId4Inte, ActionContext ctx, HttpServletRequest request, HttpSession session, String tempReportFileName, String requestSessionId, String downloadFilePath, String commonCleanText, String commonDetectText, String contextPath, String remoteAddr) {
        ctx.put("com.opensymphony.xwork2.dispatcher.HttpServletRequest", (Object)request);
        ActionContext.setContext((ActionContext)ctx);
        this.reportId4Inte = reportId4Inte;
        this.ctx = ctx;
        this.request = request;
        this.session = session;
        this.tempReportFileName = tempReportFileName;
        this.requestSessionId = requestSessionId;
        this.downloadFilePath = downloadFilePath;
        this.commonCleanText = commonCleanText;
        this.commonDetectText = commonDetectText;
        this.contextPath = contextPath;
        this.remoteAddr = remoteAddr;
    }

    public void init(ActionSupport actionSupport) {
        this.action = actionSupport;
        if (null != this.action && this.action instanceof SystemReportAction) {
            SystemReportAction systemReportActionObj = (SystemReportAction)this.action;
            this.systemDeviceId = systemReportActionObj.getSystemDeviceId();
            this.systemDeviceName = systemReportActionObj.getSystemDeviceName();
            this.synthesisReportType = systemReportActionObj.getSynthesisReportType();
            this.zoneDeviceId = systemReportActionObj.getZoneDeviceId();
            this.directionSystem = systemReportActionObj.getDirectionSystem();
            this.zoneDeviceName = systemReportActionObj.getZoneDeviceName();
            this.directionZone = systemReportActionObj.getDirectionZone();
            this.zoneId = systemReportActionObj.getZoneId();
            this.zoneName = systemReportActionObj.getZoneName();
            this.isSchedule = systemReportActionObj.getIsSchedule();
            this.startTime = systemReportActionObj.getStartTime();
            this.endTime = systemReportActionObj.getEndTime();
            this.topNValues = systemReportActionObj.getTopNValues();
            this.reportIds = systemReportActionObj.getReportIds();
            this.formType = systemReportActionObj.getFormType();
            this.schedule = systemReportActionObj.getSchedule();
            this.taskScheduleForm = systemReportActionObj.getTaskScheduleForm();
            this.scheduleTime = systemReportActionObj.getScheduleTime();
            this.selectYear = systemReportActionObj.getSelectYear();
            this.selectMonth = systemReportActionObj.getSelectMonth();
            this.selectYearValue = systemReportActionObj.getSelectYearValue();
            this.selectMonthValue = systemReportActionObj.getSelectMonthValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String reportType = "";
        reportType = this.synthesisReportType.equalsIgnoreCase("system") ? "atic.report.task.systemReport" : "atic.report.task.zoneReport";
        try {
            User currentUser = (User)this.session.getAttribute("currentUser");
            this.ctx.put("com.opensymphony.xwork2.dispatcher.HttpServletRequest", (Object)this.request);
            this.ctx.put("currentUser", (Object)currentUser);
            this.ctx.put("contextPath", (Object)this.contextPath);
            this.ctx.put("remoteAddr", (Object)this.remoteAddr);
            ActionContext.setContext((ActionContext)this.ctx);
            ArrayList<ReportSession> reportSessionList = new ArrayList<ReportSession>();
            if (!this.checkSelectAllDevice()) {
                if (this.synthesisReportType.equalsIgnoreCase("system")) {
                    this.processSingleReport(reportSessionList, this.reportId4Inte, false, this.systemDeviceId, this.systemDeviceName);
                } else {
                    this.processSingleReport(reportSessionList, this.reportId4Inte, false, this.zoneDeviceId, this.zoneDeviceName);
                }
            } else {
                if ("zoneReport".equals(this.reportId4Inte)) {
                    this.reportId4Inte = "zoneReportNoSupplement";
                }
                this.processAllDeviceReport(reportSessionList, this.reportId4Inte);
            }
            HttpServletResponse response = (HttpServletResponse)this.ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            ExportReport exportReport = new ExportReport(reportSessionList, this.request, response);
            Boolean exportStatus = null;
            exportStatus = exportReport.export(this.formType, this.tempReportFileName, this.downloadFilePath);
            if (null != exportStatus && null != this.action && this.action instanceof SystemReportAction) {
                SystemReportAction.setReportExportStatus(this.requestSessionId, "finished");
                if (!exportStatus.booleanValue()) {
                    SystemReportAction.setReportExportStatus(this.requestSessionId, "exportError");
                    LOGGER.error((Object)"exportReport error!");
                    if (this.action instanceof SystemReportAction) {
                        SystemReportAction systemReportActionObj = (SystemReportAction)this.action;
                        systemReportActionObj.recordSysOptLog((User)this.session.getAttribute("currentUser"), reportType, "atic.report.synthesisReport", this.formType, false, false, SysoplogLevel.normal, "export.report.fail", new String[0]);
                    }
                }
            }
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            String errorMsg = this.action.getText("lego.err." + errorCode);
            SystemReportAction.setReportExportStatus(this.requestSessionId, errorMsg);
            LOGGER.error((Object)String.format("ExportReport errorCode : [%s].", errorCode));
            if (this.action instanceof SystemReportAction) {
                SystemReportAction systemReportActionObj = (SystemReportAction)this.action;
                systemReportActionObj.recordSysOptLog((User)this.session.getAttribute("currentUser"), reportType, "atic.report.synthesisReport", this.formType, false, false, SysoplogLevel.normal, "lego.err." + errorCode, new String[0]);
            }
        }
        finally {
            OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.EXPORT_SYSTEM_REPORT);
        }
    }

    private boolean checkSelectAllDevice() {
        if (this.synthesisReportType.equalsIgnoreCase("system") && ("0".equals(this.systemDeviceId) || "-1".equals(this.systemDeviceId)) || "-2".equals(this.systemDeviceId)) {
            return true;
        }
        return this.synthesisReportType.equalsIgnoreCase("zone") && ("0".equals(this.zoneDeviceId) || "-1".equals(this.zoneDeviceId)) || "-2".equals(this.zoneDeviceId);
    }

    private void processSingleReport(List<ReportSession> reportSessionList, String reportId4Intel, boolean isSelectAllDevice, String curDeviceId, String curDeviceName) {
        Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
        ReportCondModel queryCond = new ReportCondModel();
        queryCond.setSelectAllDevice(isSelectAllDevice);
        queryCond.setDeviceId(curDeviceId);
        queryCond.setDeviceName(curDeviceName);
        String deviceTypeStr = ReportConditionUtil.getDeviceTypeByCombId(curDeviceId);
        queryCond.setDeviceType(deviceTypeStr);
        int directionId = this.synthesisReportType.equalsIgnoreCase("system") ? (AticUtil.isNull((String)this.directionSystem) || this.directionSystem.equals("Inbound") ? 1 : 2) : (AticUtil.isNull((String)this.directionZone) || this.directionZone.equals("Inbound") ? 1 : 2);
        queryCond.setDirectionId(directionId);
        queryCond.setZoneId(this.zoneId);
        queryCond.setZoneName(this.zoneName);
        queryCond.setIsSchedule(this.isSchedule);
        if (this.isSchedule == 0) {
            queryCond.setStartTime(this.startTime);
            queryCond.setEndTime(this.endTime);
        } else {
            String scheduleType = this.processScheduleType(queryCond);
            queryCond.setScheduleType(scheduleType);
        }
        queryCond.setTopNValues(this.topNValues);
        queryCond.setReportIds(this.reportIds);
        User currentUser = (User)this.session.getAttribute("currentUser");
        Map<String, JsonValueObj> conditionMap = ReportConditionUtil.prepareReportList4SelectInte(queryCond, currentUser);
        ReportSession reportSession = ReportSessionManager.getInstance().createReportSession(reportId4Intel, null, locale);
        if (null == reportSession) {
            throw new LegoCheckedException(570507L);
        }
        boolean isPrepare = reportSession.prepare(conditionMap, true);
        if (isPrepare) {
            reportSession.prepareJasper();
            reportSessionList.add(reportSession);
        }
    }

    private String processScheduleType(ReportCondModel queryCond) {
        int scheduleInt = this.schedule;
        if (null != this.taskScheduleForm) {
            scheduleInt = this.taskScheduleForm.getSchedule();
        }
        String scheduleType = "";
        if (1 == scheduleInt) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(AticUtil.convertTimeString((String)(this.scheduleTime + " 00:00:00")) * 1000L);
            queryCond.setStartTime(this.scheduleTime + " 00:00:00");
            queryCond.setEndTime(this.scheduleTime + " 23:59:59");
            scheduleType = "day";
        } else if (2 == scheduleInt) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(AticUtil.convertTimeString((String)(this.scheduleTime + " 00:00:00")) * 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            int dayWeek = calendar.get(7);
            if (1 == dayWeek) {
                calendar.add(5, -1);
            }
            calendar.setFirstDayOfWeek(2);
            int day = calendar.get(7);
            calendar.add(5, calendar.getFirstDayOfWeek() - day);
            String imptimeBegin = sdf.format(calendar.getTime());
            calendar.add(5, 6);
            String imptimeEnd = sdf.format(calendar.getTime());
            queryCond.setStartTime(imptimeBegin + " 00:00:00");
            queryCond.setEndTime(imptimeEnd + " 23:59:59");
            scheduleType = "week";
        } else if (3 == scheduleInt) {
            String timeStrTemp = "";
            timeStrTemp = null != this.selectYear ? this.selectYear.getSelectValue() + "-" + this.selectMonth.getSelectValue() + "-01 00:00:00" : this.selectYearValue + "-" + this.selectMonthValue + "-01 00:00:00";
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(AticUtil.convertTimeString((String)(timeStrTemp + " 00:00:00")) * 1000L);
            String startStr = "";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            calendar.set(5, 1);
            startStr = sdf.format(calendar.getTime());
            String endStr = "";
            calendar.set(5, 1);
            calendar.add(2, 1);
            calendar.add(5, -1);
            endStr = sdf.format(calendar.getTime());
            queryCond.setStartTime(startStr + " 00:00:00");
            queryCond.setEndTime(endStr + " 23:59:59");
            scheduleType = "month";
        } else if (4 == scheduleInt) {
            String startTimeStr = "";
            String endTimeStr = "";
            if (null != this.selectYear) {
                startTimeStr = this.selectYear.getSelectValue() + "-01-01 00:00:00";
                endTimeStr = this.selectYear.getSelectValue() + "-12-31 23:59:59";
            } else {
                startTimeStr = this.selectYearValue + "-01-01 00:00:00";
                endTimeStr = this.selectYearValue + "-12-31 23:59:59";
            }
            queryCond.setStartTime(startTimeStr);
            queryCond.setEndTime(endTimeStr);
            scheduleType = "year";
        }
        return scheduleType;
    }

    private void processAllDeviceReport(List<ReportSession> reportSessionList, String reportId4Intel) {
        List<AticDevice> devList = this.getDevlist();
        if (null == devList || devList.isEmpty()) {
            throw new LegoCheckedException(571003L);
        }
        ArrayList<Future<Integer>> list = new ArrayList<Future<Integer>>();
        ExecutorService executorService = Executors.newFixedThreadPool(2, new ThreadFactory(){
            private AtomicInteger increment = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "processAllDevice-" + this.increment.getAndIncrement());
            }
        });
        if (!devList.isEmpty()) {
            for (AticDevice aticDevice : devList) {
                if ("Syslog".equals(aticDevice.getDeviceModel())) continue;
                String deviceIdTemp = String.valueOf(aticDevice.getMoId());
                String devModel = ReportConditionUtil.getDeviceModelByCombId(deviceIdTemp);
                int devType = aticDevice.getDdosType();
                String deviceIdTempx = deviceIdTemp = deviceIdTemp + '_' + devType + '_' + devModel;
                String name = "";
                if (0 == devType) {
                    name = this.commonCleanText;
                } else if (1 == devType) {
                    name = this.commonDetectText;
                }
                String namex = aticDevice.getName() + name;
                list.add(executorService.submit(() -> {
                    ActionContext.setContext((ActionContext)this.ctx);
                    this.processSingleReport(reportSessionList, reportId4Intel, true, deviceIdTempx, namex);
                    return 0;
                }));
            }
        }
        executorService.shutdown();
        for (Future future : list) {
            try {
                Integer in = (Integer)future.get();
                LOGGER.info((Object)("each processSingleReport result : " + in));
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"each processSingleReport get result error : InterruptedException");
            }
            catch (ExecutionException e) {
                LOGGER.error((Object)"each processSingleReport get result error : ExecutionException");
            }
        }
    }

    private List<AticDevice> getDevlist() {
        List<Object> devList = new ArrayList();
        Long currentLogUserId = 1L;
        Boolean isAdmin = true;
        if (null != this.session) {
            User currentUser = (User)this.session.getAttribute("currentUser");
            currentLogUserId = currentUser.getUserID();
            isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        }
        Long devId = 0L;
        if (this.synthesisReportType.equalsIgnoreCase("system")) {
            devId = Long.parseLong(this.systemDeviceId);
        } else if (this.synthesisReportType.equalsIgnoreCase("zone")) {
            devId = Long.parseLong(this.zoneDeviceId);
        }
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        datastatConditionForm.setDeviceId(devId);
        if (-2L == devId) {
            devList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            if (!devList.isEmpty()) {
                for (AticDevice aticDevice : devList) {
                    aticDevice.setDdosType(1);
                }
            }
        } else if (-1L == devId) {
            devList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            if (!devList.isEmpty()) {
                for (AticDevice aticDevice : devList) {
                    aticDevice.setDdosType(0);
                }
            }
        } else if (0L == devId) {
            datastatConditionForm.setDeviceId(-1L);
            List<AticDevice> cleanDevList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            datastatConditionForm.setDeviceId(-2L);
            List<AticDevice> list = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
            if (!cleanDevList.isEmpty()) {
                for (AticDevice temp : cleanDevList) {
                    temp.setDdosType(0);
                    devList.add(temp);
                }
            }
            if (!list.isEmpty()) {
                for (AticDevice temp : list) {
                    temp.setDdosType(1);
                    devList.add(temp);
                }
            }
        }
        if (this.synthesisReportType.equalsIgnoreCase("zone") && !devList.isEmpty()) {
            ArrayList<AticDevice> zoneDevList = new ArrayList<AticDevice>();
            IZoneDeviceDeployStatusService iZoneDeviceDeployStatusService = (IZoneDeviceDeployStatusService)ServiceContext.getInstance().getService("zoneDeviceDeployStatusService", IZoneDeviceDeployStatusService.class);
            List lstDevId = iZoneDeviceDeployStatusService.getDevByZone4Secutity(this.zoneId, isAdmin, currentLogUserId);
            for (AticDevice aticDevice : devList) {
                Long devIdTemp = aticDevice.getMoId();
                if (!lstDevId.contains(devIdTemp)) continue;
                zoneDevList.add(aticDevice);
            }
            return zoneDevList;
        }
        return devList;
    }

    public String getRequestSessionId() {
        return this.requestSessionId;
    }
}

