/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.report.util;

import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.DataSourceStub;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.report.model.ReportCondModel;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.CommonUtil;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.logserver.module.condition.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public final class ReportConditionUtil {
    private ReportConditionUtil() {
    }

    public static void prepareReportList(ReportCondModel condition, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList) {
        String[] reportId = condition.getReportIds().split(",");
        String[] topNValue = condition.getTopNValues().split(",");
        JsonValueObj deviceObj = new JsonValueObj(AticUtil.getText((String)"atic.analysis.common.netdevice"), condition.getDeviceId() + "", condition.getDeviceName());
        JsonValueItem startTimeObj = new JsonValueItem(AticUtil.convertTimeString((String)condition.getStartTime()) + "", condition.getStartTime());
        JsonValueItem endTimeObj = new JsonValueItem(AticUtil.convertTimeString((String)condition.getEndTime()) + "", condition.getEndTime());
        ArrayList<JsonValueItem> dateRangeList = new ArrayList<JsonValueItem>();
        dateRangeList.add(startTimeObj);
        dateRangeList.add(endTimeObj);
        JsonValueObj dateRangeObj = new JsonValueObj();
        dateRangeObj.setSubGroupLabel(LocaleUtil.getInstance().getText("atic.analysis.common.date"));
        dateRangeObj.setValueList(dateRangeList);
        dateRangeObj.setType("dateRange");
        String zoneName = condition.getZoneName();
        Long zoneId = condition.getZoneId();
        if (AticUtil.isNull((String)zoneName)) {
            zoneName = LocaleUtil.getInstance().getText("atic.analysis.common.all");
        }
        if (null == zoneId) {
            zoneId = 0L;
        }
        JsonValueObj zoneObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.zone"), zoneId + "", zoneName);
        JsonValueObj unitObjPps = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.unit"), "1", LocaleUtil.getInstance().getText("atic.analysis.common.unit.pps"));
        JsonValueObj unitObjKbps = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.unit"), "0", LocaleUtil.getInstance().getText("atic.analysis.common.unit.kbps"));
        JsonValueObj bisObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.bis"), "0", LocaleUtil.getInstance().getText("atic.analysis.common.all"));
        JsonValueObj protocolObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.protocol"), "0", LocaleUtil.getInstance().getText("atic.analysis.common.all"));
        JsonValueObj switchOptionObjCommon = new JsonValueObj("switchOption", "1", "1");
        JsonValueObj ipObjCommon = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.ip.address"), "", "");
        HashMap<String, JsonValueObj> commonConditionPps = new HashMap<String, JsonValueObj>();
        commonConditionPps.put("deviceObj", deviceObj);
        commonConditionPps.put("zoneObj", zoneObj);
        commonConditionPps.put("bisObj", bisObj);
        commonConditionPps.put("protocolObj", protocolObj);
        commonConditionPps.put("dateRangeObj", dateRangeObj);
        commonConditionPps.put("unitObj", unitObjPps);
        commonConditionPps.put("switchOptionObjCommon", switchOptionObjCommon);
        commonConditionPps.put("ipObjCommon", ipObjCommon);
        HashMap<String, JsonValueObj> commonConditionKbps = new HashMap<String, JsonValueObj>();
        commonConditionKbps.put("deviceObj", deviceObj);
        commonConditionKbps.put("zoneObj", zoneObj);
        commonConditionKbps.put("bisObj", bisObj);
        commonConditionKbps.put("protocolObj", protocolObj);
        commonConditionKbps.put("dateRangeObj", dateRangeObj);
        commonConditionKbps.put("unitObj", unitObjKbps);
        commonConditionKbps.put("switchOptionObjCommon", switchOptionObjCommon);
        commonConditionKbps.put("ipObjCommon", ipObjCommon);
        for (int i = 0; i < reportId.length; ++i) {
            JsonValueObj topNObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.report.system.topn"), topNValue[i], topNValue[i]);
            commonConditionPps.put("topNObj", topNObj);
            commonConditionKbps.put("topNObj", topNObj);
            ReportConditionUtil.getCompareCondtion(reportId[i], condition, reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getCompareCondtion(reportId[i], condition, reportIdList, reportQueryCondList, commonConditionKbps);
            ReportConditionUtil.getAttackTypeDistributeCondtion(reportId[i], condition, reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getFluxTopNCondtion(reportId[i], condition, reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getAttackTopNCondtion(reportId[i], reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getFluxDistributeCondtion(reportId[i], condition, reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getSlotFlowCondtion(reportId[i], condition, reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getAttackLogCondtion(reportId[i], condition, reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getAttackEventCondtion(reportId[i], reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getAttackTrendCondtion(reportId[i], reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getDropTrendCondtion(reportId[i], reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getDnsTopNCondtion(reportId[i], reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getConnCompareCondtion(reportId[i], reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getDnsCacheCondtion(reportId[i], reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getRequestTrendCondtion(reportId[i], reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getAnalyzeSuccessRateCondtion(reportId[i], reportIdList, reportQueryCondList, commonConditionPps);
            ReportConditionUtil.getNormalAndExceptionCondtion(reportId[i], reportIdList, reportQueryCondList, commonConditionPps);
        }
    }

    public static Map<String, JsonValueObj> prepareReportList4SelectInte(ReportCondModel condition, User currentUser) {
        JsonValueObj deviceObj = new JsonValueObj(AticUtil.getText((String)"atic.analysis.common.netdevice"), condition.getDeviceId() + "", condition.getDeviceName());
        JsonValueObj directionObj = new JsonValueObj(AticUtil.getText((String)"atic.analysis.common.direction"), condition.getDirectionId() + "", "");
        JsonValueObj isSelectAllDeviceObj = new JsonValueObj(String.valueOf(condition.isSelectAllDevice()), String.valueOf(condition.isSelectAllDevice()), String.valueOf(condition.isSelectAllDevice()));
        JsonValueItem startTimeObj = new JsonValueItem(AticUtil.convertTimeString((String)condition.getStartTime()) + "", condition.getStartTime());
        JsonValueItem endTimeObj = new JsonValueItem(AticUtil.convertTimeString((String)condition.getEndTime()) + "", condition.getEndTime());
        ArrayList<JsonValueItem> dateRangeList = new ArrayList<JsonValueItem>();
        dateRangeList.add(startTimeObj);
        dateRangeList.add(endTimeObj);
        JsonValueObj dateRangeObj = new JsonValueObj();
        dateRangeObj.setSubGroupLabel(LocaleUtil.getInstance().getText("atic.analysis.common.date"));
        dateRangeObj.setValueList(dateRangeList);
        dateRangeObj.setType("dateRange");
        String zoneName = condition.getZoneName();
        Long zoneId = condition.getZoneId();
        if (AticUtil.isNull((String)zoneName)) {
            zoneName = LocaleUtil.getInstance().getText("atic.analysis.common.all");
        }
        if (null == zoneId) {
            zoneId = 0L;
        }
        JsonValueObj zoneObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.zone"), zoneId + "", zoneName);
        JsonValueObj unitObjKbps = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.unit"), "0", LocaleUtil.getInstance().getText("atic.analysis.common.unit.kbps"));
        JsonValueObj bisObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.bis"), "0", LocaleUtil.getInstance().getText("atic.analysis.common.all"));
        JsonValueObj protocolObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.protocol"), "0", LocaleUtil.getInstance().getText("atic.analysis.common.all"));
        int deviceType = ReportAnalysisUtil.getDeviceType(condition.getDeviceId());
        JsonValueObj switchOptionObjCommon = 0 == deviceType ? new JsonValueObj("switchOption", "clean", "clean") : new JsonValueObj("switchOption", "detect", "detect");
        if (ReportConditionUtil.isV1R1(condition.getDeviceId()) && 0 == deviceType) {
            switchOptionObjCommon = new JsonValueObj("switchOption", "clean2", "clean2");
        }
        JsonValueObj ipObjCommon = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.ip.address"), "", "");
        JsonValueObj topNObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.report.system.topn"), "10", "10");
        JsonValueObj isNeedTransmitChartDataObj = new JsonValueObj("", "true", "true");
        JsonValueObj isInteReportObj = new JsonValueObj("", "true", "true");
        JsonValueObj scheduleObj = new JsonValueObj("", condition.getScheduleType(), condition.getScheduleType());
        JsonValueObj dnsTopNStatTypeObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.stat.type"), "1", LocaleUtil.getInstance().getText("atic.analysis.dns.topn.stattype.average"));
        JsonValueObj typeDNSNameObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.type"), "0", LocaleUtil.getInstance().getText("atic.analysis.dns.topn.request.domain"));
        JsonValueObj isBPSObj = new JsonValueObj("", "true", "true");
        HashMap<String, JsonValueObj> conditionMap = new HashMap<String, JsonValueObj>();
        conditionMap.put("netDevice_combobox", deviceObj);
        conditionMap.put("isSelectAllDevice", isSelectAllDeviceObj);
        conditionMap.put("zone_combobox", zoneObj);
        conditionMap.put("bis_combobox", bisObj);
        conditionMap.put("protocol_combobox", protocolObj);
        conditionMap.put("dateRange", dateRangeObj);
        conditionMap.put("unit", unitObjKbps);
        conditionMap.put("switchOption", switchOptionObjCommon);
        conditionMap.put("zone_ip", ipObjCommon);
        conditionMap.put("TOPN", topNObj);
        conditionMap.put("isNeedTransmitChartData", isNeedTransmitChartDataObj);
        conditionMap.put("isInteReport", isInteReportObj);
        conditionMap.put("schedule", scheduleObj);
        conditionMap.put("type_combobox", dnsTopNStatTypeObj);
        conditionMap.put("type", typeDNSNameObj);
        conditionMap.put("isBPS", isBPSObj);
        conditionMap.put("direction_combobox", directionObj);
        ReportConditionUtil.getCurrentLogUserCondition(conditionMap, currentUser);
        JsonValueObj reportIdsObj = new JsonValueObj("", condition.getReportIds(), condition.getReportIds());
        conditionMap.put("reportIds", reportIdsObj);
        JsonValueObj reportTopNsObj = new JsonValueObj("", condition.getTopNValues(), condition.getTopNValues());
        conditionMap.put("reportTopns", reportTopNsObj);
        String[] reportIdStr = condition.getReportIds().split(",");
        String[] topNValueStr = condition.getTopNValues().split(",");
        for (int i = 0; i < reportIdStr.length; ++i) {
            if (topNValueStr[i].equals("0")) continue;
            JsonValueObj reportTopNTemp = new JsonValueObj("", topNValueStr[i], topNValueStr[i]);
            conditionMap.put(reportIdStr[i] + "TOPN", reportTopNTemp);
        }
        return conditionMap;
    }

    public static boolean isV1R1(String deviceIdString) {
        if (AticUtil.isNull((String)deviceIdString)) {
            return false;
        }
        List<Object> neList = new ArrayList();
        if (deviceIdString.contains("_")) {
            int deviceId = Integer.parseInt(deviceIdString.split("_")[0]);
            IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
            AticDevice firewall = firewallService.getDeviceByMoid((long)deviceId);
            if (null != firewall) {
                neList.add(firewall);
            }
        } else {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceIdString);
            neList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, 1L);
        }
        return CommonUtil.includesV1R1(neList);
    }

    public static Map<String, JsonValueObj> prepareReportList4Inte(ReportCondModel condition) {
        JsonValueObj deviceObj = new JsonValueObj(AticUtil.getText((String)"atic.analysis.common.netdevice"), condition.getDeviceId() + "", condition.getDeviceName());
        JsonValueItem startTimeObj = new JsonValueItem(AticUtil.convertTimeString((String)condition.getStartTime()) + "", condition.getStartTime());
        JsonValueItem endTimeObj = new JsonValueItem(AticUtil.convertTimeString((String)condition.getEndTime()) + "", condition.getEndTime());
        ArrayList<JsonValueItem> dateRangeList = new ArrayList<JsonValueItem>();
        dateRangeList.add(startTimeObj);
        dateRangeList.add(endTimeObj);
        JsonValueObj dateRangeObj = new JsonValueObj();
        dateRangeObj.setSubGroupLabel(LocaleUtil.getInstance().getText("atic.analysis.common.date"));
        dateRangeObj.setValueList(dateRangeList);
        dateRangeObj.setType("dateRange");
        String zoneName = condition.getZoneName();
        Long zoneId = condition.getZoneId();
        if (AticUtil.isNull((String)zoneName)) {
            zoneName = LocaleUtil.getInstance().getText("atic.analysis.common.all");
        }
        if (null == zoneId) {
            zoneId = 0L;
        }
        JsonValueObj zoneObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.zone"), zoneId + "", zoneName);
        JsonValueObj unitObjKbps = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.unit"), "0", LocaleUtil.getInstance().getText("atic.analysis.common.unit.kbps"));
        JsonValueObj bisObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.bis"), "0", LocaleUtil.getInstance().getText("atic.analysis.common.all"));
        JsonValueObj protocolObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.protocol"), "0", LocaleUtil.getInstance().getText("atic.analysis.common.all"));
        int deviceType = ReportAnalysisUtil.getDeviceType(condition.getDeviceId());
        JsonValueObj switchOptionObjCommon = 0 == deviceType ? new JsonValueObj("switchOption", "clean", "clean") : new JsonValueObj("switchOption", "detect", "detect");
        JsonValueObj ipObjCommon = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.ip.address"), "", "");
        JsonValueObj topNObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.report.system.topn"), "10", "10");
        JsonValueObj isNeedTransmitChartDataObj = new JsonValueObj("", "true", "true");
        JsonValueObj scheduleObj = new JsonValueObj("", condition.getScheduleType(), condition.getScheduleType());
        JsonValueObj dnsTopNStatTypeObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.stat.type"), "1", LocaleUtil.getInstance().getText("atic.analysis.dns.topn.stattype.average"));
        JsonValueObj typeDNSNameObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.type"), "0", LocaleUtil.getInstance().getText("atic.analysis.dns.topn.request.domain"));
        JsonValueObj isBPSObj = new JsonValueObj("", "true", "true");
        HashMap<String, JsonValueObj> conditionMap = new HashMap<String, JsonValueObj>();
        conditionMap.put("netDevice_combobox", deviceObj);
        conditionMap.put("zone_combobox", zoneObj);
        conditionMap.put("bis_combobox", bisObj);
        conditionMap.put("protocol_combobox", protocolObj);
        conditionMap.put("dateRange", dateRangeObj);
        conditionMap.put("unit", unitObjKbps);
        conditionMap.put("switchOption", switchOptionObjCommon);
        conditionMap.put("zone_ip", ipObjCommon);
        conditionMap.put("TOPN", topNObj);
        conditionMap.put("isNeedTransmitChartData", isNeedTransmitChartDataObj);
        conditionMap.put("schedule", scheduleObj);
        conditionMap.put("type_combobox", dnsTopNStatTypeObj);
        conditionMap.put("type", typeDNSNameObj);
        conditionMap.put("isBPS", isBPSObj);
        ReportConditionUtil.getCurrentLogUserCondition(conditionMap);
        return conditionMap;
    }

    private static void getCurrentLogUserCondition(Map<String, JsonValueObj> commonCondition) {
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        String userId = String.valueOf(currentUser.getUserID());
        JsonValueObj currentLogUserIdObj = new JsonValueObj("currentLogUserId", userId, currentUser.getUserName());
        currentLogUserIdObj.setType("hidden");
        commonCondition.put("currentLogUserId", currentLogUserIdObj);
    }

    private static void getCurrentLogUserCondition(Map<String, JsonValueObj> commonCondition, User currentUser) {
        String userId = String.valueOf(currentUser.getUserID());
        JsonValueObj currentLogUserIdObj = new JsonValueObj("currentLogUserId", userId, currentUser.getUserName());
        currentLogUserIdObj.setType("hidden");
        commonCondition.put("currentLogUserId", currentLogUserIdObj);
    }

    private static void getDnsTopNCondtion(String reportId, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("dnsTopN")) {
            JsonValueObj dnsTopNStatTypeObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.stat.type"), "1", LocaleUtil.getInstance().getText("atic.analysis.dns.topn.stattype.average"));
            HashMap<String, JsonValueObj> reportQueryDNSNameCond = new HashMap<String, JsonValueObj>();
            JsonValueObj typeDNSNameObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.type"), "0", LocaleUtil.getInstance().getText("atic.analysis.dns.topn.request.domain"));
            JsonValueObj switchDNSNameObj = new JsonValueObj("switchOption", "1", "1");
            JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            deviceObj.setOrderInforId("0");
            reportQueryDNSNameCond.put("netDevice_combobox", deviceObj);
            JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            zoneObj.setOrderInforId("1");
            reportQueryDNSNameCond.put("zone_combobox", zoneObj);
            JsonValueObj bisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            bisObj.setOrderInforId("2");
            reportQueryDNSNameCond.put("bis_combobox", bisObj);
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("3");
            reportQueryDNSNameCond.put("dateRange", dateRangeObj);
            typeDNSNameObj.setOrderInforId("4");
            reportQueryDNSNameCond.put("type", typeDNSNameObj);
            dnsTopNStatTypeObj.setOrderInforId("5");
            reportQueryDNSNameCond.put("type_combobox", dnsTopNStatTypeObj);
            JsonValueObj topNObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
            topNObj.setOrderInforId("6");
            reportQueryDNSNameCond.put("TOPN", topNObj);
            switchDNSNameObj.setOrderInforId("7");
            reportQueryDNSNameCond.put("switchOption", switchDNSNameObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryDNSNameCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryDNSNameCond);
            HashMap<String, JsonValueObj> reportQueryIpCond = new HashMap<String, JsonValueObj>();
            JsonValueObj typeIpObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.type"), "1", LocaleUtil.getInstance().getText("atic.analysis.dns.topn.request.ip"));
            JsonValueObj switchIpObj = new JsonValueObj("switchOption", "2", "2");
            JsonValueObj tempDeviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            tempDeviceObj.setOrderInforId("0");
            reportQueryIpCond.put("netDevice_combobox", tempDeviceObj);
            JsonValueObj tempZoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            tempZoneObj.setOrderInforId("1");
            reportQueryIpCond.put("zone_combobox", tempZoneObj);
            JsonValueObj tempBisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            tempBisObj.setOrderInforId("2");
            reportQueryIpCond.put("bis_combobox", tempBisObj);
            JsonValueObj tempDateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            tempDateRangeObj.setOrderInforId("3");
            reportQueryIpCond.put("dateRange", tempDateRangeObj);
            typeIpObj.setOrderInforId("4");
            reportQueryIpCond.put("type", typeIpObj);
            dnsTopNStatTypeObj.setOrderInforId("5");
            reportQueryIpCond.put("type_combobox", dnsTopNStatTypeObj);
            JsonValueObj tempTopNObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
            tempTopNObj.setOrderInforId("6");
            reportQueryIpCond.put("TOPN", tempTopNObj);
            switchIpObj.setOrderInforId("7");
            reportQueryIpCond.put("switchOption", switchIpObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryIpCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryIpCond);
        }
    }

    private static void getConnCompareCondtion(String reportId, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("connCompare")) {
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj statTypeObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.stat.type"), "2", LocaleUtil.getInstance().getText("atic.analysis.common.flux.avg"));
            JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            deviceObj.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", deviceObj);
            JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            zoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", zoneObj);
            JsonValueObj bisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            bisObj.setOrderInforId("2");
            reportQueryCond.put("bis_combobox", bisObj);
            JsonValueObj ipObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("ipObjCommon"));
            ipObjCommon.setOrderInforId("3");
            reportQueryCond.put("zone_ip", ipObjCommon);
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("4");
            reportQueryCond.put("dateRange", dateRangeObj);
            statTypeObj.setOrderInforId("5");
            reportQueryCond.put("type_combobox", statTypeObj);
            JsonValueObj topNObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
            topNObj.setOrderInforId("6");
            reportQueryCond.put("TOPN", topNObj);
            JsonValueObj switchOptionObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("switchOptionObjCommon"));
            switchOptionObjCommon.setOrderInforId("7");
            reportQueryCond.put("switchOption", switchOptionObjCommon);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static void getDnsCacheCondtion(String reportId, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("dnsCache")) {
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            deviceObj.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", deviceObj);
            JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            zoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", zoneObj);
            JsonValueObj bisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            bisObj.setOrderInforId("2");
            reportQueryCond.put("bis_combobox", bisObj);
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("3");
            reportQueryCond.put("dateRange", dateRangeObj);
            JsonValueObj topNObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
            topNObj.setOrderInforId("4");
            reportQueryCond.put("TOPN", topNObj);
            JsonValueObj switchOptionObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("switchOptionObjCommon"));
            switchOptionObjCommon.setOrderInforId("5");
            reportQueryCond.put("switchOption", switchOptionObjCommon);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static void getRequestTrendCondtion(String reportId, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("requestTrend")) {
            List<JsonValueItem> selectType = ReportConditionUtil.getSelectType();
            JsonValueObj selectTypeObj = new JsonValueObj();
            selectTypeObj.setSubGroupLabel(LocaleUtil.getInstance().getText("atic.analysis.common.selectType"));
            selectTypeObj.setValueList(selectType);
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            deviceObj.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", deviceObj);
            JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            zoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", zoneObj);
            JsonValueObj bisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            bisObj.setOrderInforId("2");
            reportQueryCond.put("bis_combobox", bisObj);
            JsonValueObj ipObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("ipObjCommon"));
            ipObjCommon.setOrderInforId("3");
            reportQueryCond.put("zone_ip", ipObjCommon);
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("4");
            reportQueryCond.put("dateRange", dateRangeObj);
            selectTypeObj.setOrderInforId("5");
            reportQueryCond.put("selectType", selectTypeObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static void getAttackTrendCondtion(String reportId, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("attackTrend")) {
            List<JsonValueItem> attackType = ReportConditionUtil.getAllAttackType();
            JsonValueObj selectTypeObj = new JsonValueObj();
            selectTypeObj.setSubGroupLabel(LocaleUtil.getInstance().getText("atic.analysis.report.attack.attackType"));
            selectTypeObj.setValueList(attackType);
            selectTypeObj.setType("hidden");
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            deviceObj.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", deviceObj);
            JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            zoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", zoneObj);
            JsonValueObj bisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            bisObj.setOrderInforId("2");
            reportQueryCond.put("bis_combobox", bisObj);
            JsonValueObj ipObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("ipObjCommon"));
            ipObjCommon.setOrderInforId("3");
            reportQueryCond.put("zone_ip", ipObjCommon);
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("4");
            reportQueryCond.put("dateRange", dateRangeObj);
            selectTypeObj.setOrderInforId("5");
            reportQueryCond.put("selectAttackType", selectTypeObj);
            JsonValueObj directionObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("directionObj"));
            directionObj.setOrderInforId("6");
            reportQueryCond.put("direction_combobox", directionObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static void getDropTrendCondtion(String reportId, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("dropTrend")) {
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            deviceObj.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", deviceObj);
            JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            zoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", zoneObj);
            JsonValueObj bisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            bisObj.setOrderInforId("2");
            reportQueryCond.put("bis_combobox", bisObj);
            JsonValueObj ipObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("ipObjCommon"));
            ipObjCommon.setOrderInforId("3");
            reportQueryCond.put("zone_ip", ipObjCommon);
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("4");
            reportQueryCond.put("dateRange", dateRangeObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static void getAnalyzeSuccessRateCondtion(String reportId, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("analyzeSuccessRate")) {
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            deviceObj.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", deviceObj);
            JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            zoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", zoneObj);
            JsonValueObj ipObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("ipObjCommon"));
            ipObjCommon.setOrderInforId("2");
            reportQueryCond.put("zone_ip", ipObjCommon);
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("3");
            reportQueryCond.put("dateRange", dateRangeObj);
            JsonValueObj topNObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
            topNObj.setOrderInforId("4");
            reportQueryCond.put("TOPN", topNObj);
            JsonValueObj switchOptionObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("switchOptionObjCommon"));
            switchOptionObjCommon.setOrderInforId("5");
            reportQueryCond.put("switchOption", switchOptionObjCommon);
            JsonValueObj directionObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("directionObj"));
            directionObj.setOrderInforId("6");
            reportQueryCond.put("direction_combobox", directionObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static void getNormalAndExceptionCondtion(String reportId, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("normalAndException")) {
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            deviceObj.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", deviceObj);
            JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            zoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", zoneObj);
            JsonValueObj bisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            bisObj.setOrderInforId("2");
            reportQueryCond.put("bis_combobox", bisObj);
            JsonValueObj ipObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("ipObjCommon"));
            ipObjCommon.setOrderInforId("3");
            reportQueryCond.put("zone_ip", ipObjCommon);
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("4");
            reportQueryCond.put("dateRange", dateRangeObj);
            JsonValueObj topNObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
            topNObj.setOrderInforId("5");
            reportQueryCond.put("TOPN", topNObj);
            JsonValueObj switchOptionObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("switchOptionObjCommon"));
            switchOptionObjCommon.setOrderInforId("6");
            reportQueryCond.put("switchOption", switchOptionObjCommon);
            JsonValueObj directionObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("directionObj"));
            directionObj.setOrderInforId("7");
            reportQueryCond.put("direction_combobox", directionObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static void getAttackLogCondtion(String reportId, ReportCondModel condition, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("attackLog")) {
            Boolean showAttackLog = true;
            if (condition.getDeviceId().contains("_")) {
                showAttackLog = true;
            } else if (-2L == Long.parseLong(condition.getDeviceId()) || -1L == Long.parseLong(condition.getDeviceId())) {
                showAttackLog = false;
            }
            if (showAttackLog.booleanValue()) {
                JsonValueObj logTypeObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.type"), "0", LocaleUtil.getInstance().getText("atic.analysis.common.all"));
                HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
                JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
                deviceObj.setOrderInforId("0");
                reportQueryCond.put("netDevice_combobox", deviceObj);
                JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
                zoneObj.setOrderInforId("1");
                reportQueryCond.put("zone_combobox", zoneObj);
                JsonValueObj bisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
                bisObj.setOrderInforId("2");
                reportQueryCond.put("bis_combobox", bisObj);
                JsonValueObj ipObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("ipObjCommon"));
                ipObjCommon.setOrderInforId("3");
                reportQueryCond.put("zone_ip", ipObjCommon);
                JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
                dateRangeObj.setOrderInforId("4");
                reportQueryCond.put("dateRange", dateRangeObj);
                logTypeObj.setOrderInforId("5");
                reportQueryCond.put("logType", logTypeObj);
                JsonValueObj topNObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
                topNObj.setOrderInforId("6");
                reportQueryCond.put("TOPN", topNObj);
                JsonValueObj switchOptionObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("switchOptionObjCommon"));
                switchOptionObjCommon.setOrderInforId("7");
                reportQueryCond.put("switchOption", switchOptionObjCommon);
                JsonValueObj directionObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("directionObj"));
                directionObj.setOrderInforId("8");
                reportQueryCond.put("direction_combobox", directionObj);
                ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
                reportIdList.add(reportId);
                reportQueryCondList.add(reportQueryCond);
            }
        }
    }

    private static void getSlotFlowCondtion(String reportId, ReportCondModel condition, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equalsIgnoreCase("slotFlow")) {
            Boolean showSlotFlow = true;
            if (condition.getDeviceId().contains("_")) {
                showSlotFlow = true;
            } else if (-2L == Long.parseLong(condition.getDeviceId()) || -1L == Long.parseLong(condition.getDeviceId())) {
                showSlotFlow = false;
            }
            if (showSlotFlow.booleanValue()) {
                HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
                String[] switchOption = new String[]{"0", "2"};
                String switchOptionValue = switchOption[Integer.parseInt(condition.getDeviceType())];
                JsonValueObj switchOptionObj = new JsonValueObj("", switchOptionValue, switchOptionValue);
                JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
                deviceObj.setOrderInforId("0");
                reportQueryCond.put("netDevice_combobox", deviceObj);
                JsonValueObj protocolObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("protocolObj"));
                protocolObj.setOrderInforId("1");
                reportQueryCond.put("protocol_combobox", protocolObj);
                JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
                dateRangeObj.setOrderInforId("2");
                reportQueryCond.put("dateRange", dateRangeObj);
                JsonValueObj unitObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("unitObj"));
                unitObj.setOrderInforId("3");
                reportQueryCond.put("unit", unitObj);
                reportQueryCond.put("switchOption", switchOptionObj);
                JsonValueObj directionObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("directionObj"));
                directionObj.setOrderInforId("4");
                reportQueryCond.put("direction_combobox", directionObj);
                ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
                reportIdList.add("slotFlow");
                reportQueryCondList.add(reportQueryCond);
            }
        }
    }

    private static void getAttackEventCondtion(String reportId, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("attackTopnAnalysis")) {
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            deviceObj.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", deviceObj);
            JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            zoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", zoneObj);
            JsonValueObj bisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            bisObj.setOrderInforId("2");
            reportQueryCond.put("bis_combobox", bisObj);
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("3");
            reportQueryCond.put("dateRange", dateRangeObj);
            JsonValueObj topNObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
            topNObj.setOrderInforId("4");
            reportQueryCond.put("TOPN", topNObj);
            JsonValueObj switchOptionObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("switchOptionObjCommon"));
            switchOptionObjCommon.setOrderInforId("5");
            reportQueryCond.put("switchOption", switchOptionObjCommon);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static void getFluxDistributeCondtion(String reportId, ReportCondModel condition, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("fluxDistribute")) {
            String[] switchOption = new String[]{"1", "3"};
            String switchOptionValue = switchOption[Integer.parseInt(condition.getDeviceType())];
            JsonValueObj switchOptionObj = new JsonValueObj("", switchOptionValue, switchOptionValue);
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj deviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            deviceObj.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", deviceObj);
            JsonValueObj zoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            zoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", zoneObj);
            JsonValueObj ipObjCommon = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("ipObjCommon"));
            ipObjCommon.setOrderInforId("2");
            reportQueryCond.put("zone_ip", ipObjCommon);
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("3");
            reportQueryCond.put("dateRange", dateRangeObj);
            JsonValueObj unitObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("unitObj"));
            unitObj.setOrderInforId("4");
            reportQueryCond.put("unit", unitObj);
            switchOptionObj.setOrderInforId("5");
            reportQueryCond.put("switchOption", switchOptionObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static void getAttackTopNCondtion(String reportId, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("zoneAttackTopN") || reportId.equals("ipAttackTopN") || reportId.equals("bisAttackTopN")) {
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj tempDevice = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            tempDevice.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", tempDevice);
            if (!reportId.equals("zoneAttackTopN")) {
                JsonValueObj tempZoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
                tempZoneObj.setOrderInforId("1");
                reportQueryCond.put("zone_combobox", tempZoneObj);
            }
            if (reportId.equals("ipAttackTopN")) {
                JsonValueObj bisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
                bisObj.setOrderInforId("2");
                reportQueryCond.put("bis_combobox", bisObj);
            }
            JsonValueObj dateRangeObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            dateRangeObj.setOrderInforId("3");
            reportQueryCond.put("dateRange", dateRangeObj);
            JsonValueObj topNObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
            topNObj.setOrderInforId("4");
            reportQueryCond.put("TOPN", topNObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static void getFluxTopNCondtion(String reportId, ReportCondModel condition, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equals("zoneFluxTopN") || reportId.equals("ipFluxTopNOne") || reportId.equals("bisFluxTopN")) {
            HashMap<String, JsonValueObj> reportQueryCondInflux = new HashMap<String, JsonValueObj>();
            JsonValueObj typeObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.type"), "1", LocaleUtil.getInstance().getText("atic.analysis.common.flux.in"));
            JsonValueObj typeComboboxObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.stat.type"), "2", LocaleUtil.getInstance().getText("atic.analysis.common.flux.avg"));
            JsonValueObj tempDeviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            tempDeviceObj.setOrderInforId("0");
            reportQueryCondInflux.put("netDevice_combobox", tempDeviceObj);
            if (!reportId.equals("zoneFluxTopN")) {
                JsonValueObj tempZoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
                tempZoneObj.setOrderInforId("1");
                reportQueryCondInflux.put("zone_combobox", tempZoneObj);
            }
            if (reportId.equals("ipFluxTopNOne")) {
                JsonValueObj tempBizObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
                tempBizObj.setOrderInforId("2");
                reportQueryCondInflux.put("bis_combobox", tempBizObj);
            }
            if (!reportId.equals("bisFluxTopN")) {
                JsonValueObj tempProObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("protocolObj"));
                tempProObj.setOrderInforId("3");
                reportQueryCondInflux.put("protocol_combobox", tempProObj);
            }
            JsonValueObj tempDateObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            tempDateObj.setOrderInforId("4");
            reportQueryCondInflux.put("dateRange", tempDateObj);
            typeObj.setOrderInforId("5");
            reportQueryCondInflux.put("type", typeObj);
            typeComboboxObj.setOrderInforId("6");
            reportQueryCondInflux.put("type_combobox", typeComboboxObj);
            JsonValueObj tempUnitObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("unitObj"));
            tempUnitObj.setOrderInforId("7");
            reportQueryCondInflux.put("unit", tempUnitObj);
            JsonValueObj tempTopObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
            tempTopObj.setOrderInforId("8");
            reportQueryCondInflux.put("TOPN", tempTopObj);
            JsonValueObj tempSwitchObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("switchOptionObjCommon"));
            tempSwitchObj.setOrderInforId("9");
            reportQueryCondInflux.put("switchOption", tempSwitchObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCondInflux);
            reportIdList.add(reportId);
            reportQueryCondList.add(reportQueryCondInflux);
            if (0 == Integer.parseInt(condition.getDeviceType())) {
                HashMap<String, JsonValueObj> reportQueryCondDropflux = new HashMap<String, JsonValueObj>();
                JsonValueObj typeObjDrop = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.type"), "2", LocaleUtil.getInstance().getText("atic.analysis.common.flux.attack"));
                JsonValueObj typeComboboxObjDrop = null;
                typeComboboxObjDrop = condition.getDeviceId().contains("_") ? new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.stat.type"), "1", LocaleUtil.getInstance().getText("atic.analysis.common.flux.max")) : (Long.parseLong(condition.getDeviceId()) > 0L ? new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.stat.type"), "1", LocaleUtil.getInstance().getText("atic.analysis.common.flux.max")) : new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.stat.type"), "2", LocaleUtil.getInstance().getText("atic.analysis.common.flux.avg")));
                JsonValueObj tempDevice = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
                tempDevice.setOrderInforId("0");
                reportQueryCondDropflux.put("netDevice_combobox", tempDevice);
                if (!reportId.equals("zoneFluxTopN")) {
                    JsonValueObj tempZone = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
                    tempZone.setOrderInforId("1");
                    reportQueryCondDropflux.put("zone_combobox", tempZone);
                }
                if (reportId.equals("ipFluxTopNOne")) {
                    JsonValueObj tempBiz = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
                    tempBiz.setOrderInforId("2");
                    reportQueryCondDropflux.put("bis_combobox", tempBiz);
                }
                if (!reportId.equals("bisFluxTopN")) {
                    JsonValueObj tempPro = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("protocolObj"));
                    tempPro.setOrderInforId("3");
                    reportQueryCondDropflux.put("protocol_combobox", tempPro);
                }
                JsonValueObj tempDate = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
                tempDate.setOrderInforId("4");
                reportQueryCondDropflux.put("dateRange", tempDate);
                typeObjDrop.setOrderInforId("5");
                reportQueryCondDropflux.put("type", typeObjDrop);
                typeComboboxObjDrop.setOrderInforId("6");
                reportQueryCondDropflux.put("type_combobox", typeComboboxObjDrop);
                JsonValueObj tempUnit = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("unitObj"));
                tempUnit.setOrderInforId("7");
                reportQueryCondDropflux.put("unit", tempUnit);
                JsonValueObj tempTopn = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
                tempTopn.setOrderInforId("8");
                reportQueryCondDropflux.put("TOPN", tempTopn);
                JsonValueObj tempSwith = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("switchOptionObjCommon"));
                tempSwith.setOrderInforId("9");
                reportQueryCondDropflux.put("switchOption", tempSwith);
                ReportConditionUtil.getCurrentLogUserCondition(reportQueryCondDropflux);
                reportIdList.add(reportId);
                reportQueryCondList.add(reportQueryCondDropflux);
            }
        }
    }

    private static void getAttackTypeDistributeCondtion(String reportId, ReportCondModel condition, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equalsIgnoreCase("attackTypeDistribute")) {
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj switchOptionObj = new JsonValueObj("switchOption", condition.getDeviceType(), condition.getDeviceType());
            JsonValueObj tempDeviceObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            tempDeviceObj.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", tempDeviceObj);
            JsonValueObj tempZoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            tempZoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", tempZoneObj);
            JsonValueObj tempBisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            tempBisObj.setOrderInforId("2");
            reportQueryCond.put("bis_combobox", tempBisObj);
            JsonValueObj tempDateObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            tempDateObj.setOrderInforId("3");
            reportQueryCond.put("dateRange", tempDateObj);
            JsonValueObj tempIpObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("ipObjCommon"));
            tempIpObj.setOrderInforId("4");
            reportQueryCond.put("zone_ip", tempIpObj);
            switchOptionObj.setOrderInforId("5");
            reportQueryCond.put("switchOption", switchOptionObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add("attackTypeDistribute");
            reportQueryCondList.add(reportQueryCond);
        }
    }

    private static JsonValueObj copyNewJsonValueObj(JsonValueObj jsonValueObj) {
        JsonValueObj temp = new JsonValueObj(jsonValueObj.getSubGroupLabel());
        temp.setSubGroupId(jsonValueObj.getSubGroupLabel());
        temp.setValueList(jsonValueObj.getValueList());
        temp.setType(jsonValueObj.getType());
        return temp;
    }

    private static void getCompareCondtion(String reportId, ReportCondModel condition, List<String> reportIdList, List<Map<String, JsonValueObj>> reportQueryCondList, Map<String, JsonValueObj> commonCondition) {
        if (reportId.equalsIgnoreCase("flowCompare")) {
            HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
            JsonValueObj typeComboboxObj = new JsonValueObj(LocaleUtil.getInstance().getText("atic.analysis.common.stat.type"), "2", LocaleUtil.getInstance().getText("atic.analysis.common.flux.avg"));
            String[] aDevice = new String[]{"clean", "detect"};
            String[] aTimeType = new String[]{"less1day", "morethan1day"};
            String[] unitType = new String[]{"kbps", "pps"};
            int unit = Integer.parseInt(((JsonValueItem)commonCondition.get("unitObj").getValueList().get(0)).getValue());
            String switchOptionValue = aDevice[Integer.parseInt(condition.getDeviceType())] + "_" + aTimeType[0] + "_" + unitType[unit];
            JsonValueObj switchOptionObj = new JsonValueObj("", switchOptionValue, switchOptionValue);
            JsonValueObj tempDevice = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("deviceObj"));
            tempDevice.setOrderInforId("0");
            reportQueryCond.put("netDevice_combobox", tempDevice);
            JsonValueObj tempzoneObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("zoneObj"));
            tempzoneObj.setOrderInforId("1");
            reportQueryCond.put("zone_combobox", tempzoneObj);
            JsonValueObj tempBisObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("bisObj"));
            tempBisObj.setOrderInforId("2");
            reportQueryCond.put("bis_combobox", tempBisObj);
            JsonValueObj tempIpObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("ipObjCommon"));
            tempIpObj.setOrderInforId("3");
            reportQueryCond.put("zone_ip", tempIpObj);
            JsonValueObj tempProObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("protocolObj"));
            tempProObj.setOrderInforId("4");
            reportQueryCond.put("protocol_combobox", tempProObj);
            JsonValueObj tempDateObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("dateRangeObj"));
            tempDateObj.setOrderInforId("5");
            reportQueryCond.put("dateRange", tempDateObj);
            typeComboboxObj.setOrderInforId("6");
            reportQueryCond.put("type_combobox", typeComboboxObj);
            JsonValueObj tempUnitObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("unitObj"));
            tempUnitObj.setOrderInforId("7");
            reportQueryCond.put("unit", tempUnitObj);
            JsonValueObj tempTopNObj = ReportConditionUtil.copyNewJsonValueObj(commonCondition.get("topNObj"));
            tempTopNObj.setOrderInforId("8");
            reportQueryCond.put("TOPN", tempTopNObj);
            switchOptionObj.setOrderInforId("9");
            reportQueryCond.put("switchOption", switchOptionObj);
            ReportConditionUtil.getCurrentLogUserCondition(reportQueryCond);
            reportIdList.add("flowCompare");
            reportQueryCondList.add(reportQueryCond);
        }
    }

    public static List<JsonValueItem> getSelectType() {
        ArrayList<JsonValueItem> selectTypeJson = new ArrayList<JsonValueItem>();
        JsonValueItem jsonItemTcp = new JsonValueItem("TCP", "TCP");
        JsonValueItem jsonItemUdp = new JsonValueItem("UDP", "UDP");
        selectTypeJson.add(jsonItemTcp);
        selectTypeJson.add(jsonItemUdp);
        return selectTypeJson;
    }

    public static List<JsonValueItem> getAllAttackType() {
        DataSourceStub ds = new DataSourceStub();
        List<Pair<String, String>> attackType = ds.getAllDisplayAttackType();
        ArrayList<JsonValueItem> selectTypeJson = new ArrayList<JsonValueItem>();
        for (Pair<String, String> temp : attackType) {
            JsonValueItem jsonItem = new JsonValueItem((String)temp.getKey(), (String)temp.getValue());
            selectTypeJson.add(jsonItem);
        }
        return selectTypeJson;
    }

    public static String getDeviceTypeByCombId(String reportDeviceId) {
        String deviceType = "0";
        if (reportDeviceId.indexOf(95) >= 0) {
            deviceType = reportDeviceId.split("_")[1];
            return deviceType;
        }
        Long deviceId = ReportConditionUtil.getLongDeviceId(reportDeviceId);
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        if (-1L == deviceId) {
            deviceType = "0";
        } else if (-2L == deviceId) {
            deviceType = "1";
        } else {
            AticDevice firewall = firewallService.getDeviceByMoid(deviceId.longValue());
            if (null != firewall) {
                deviceType = String.valueOf(ReportAnalysisUtil.getDeviceDdos(firewall));
            }
        }
        return deviceType;
    }

    public static String getDeviceModelByCombId(String reportDeviceId) {
        String deviceModel = "0";
        try {
            deviceModel = "ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType()) ? "1" : "0";
        }
        catch (LegoCheckedException e) {
            return "0";
        }
        return deviceModel;
    }

    public static Long getLongDeviceId(String reportDeviceId) {
        String deviceId = null;
        deviceId = reportDeviceId.indexOf(95) >= 0 ? reportDeviceId.split("_")[0] : reportDeviceId;
        Long id = Long.parseLong(deviceId);
        return id;
    }

    public static List<LangPair> getTaskScheduleCombData() {
        ArrayList<LangPair> taskScheduleList = new ArrayList<LangPair>();
        LangPair all = new LangPair(String.valueOf(-1), AticUtil.getText((String)"atic.analysis.common.all"));
        LangPair day = new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.report.task.scheduleDay"));
        LangPair week = new LangPair(String.valueOf(2), AticUtil.getText((String)"atic.report.task.scheduleWeek"));
        LangPair month = new LangPair(String.valueOf(3), AticUtil.getText((String)"atic.report.task.scheduleMonth"));
        LangPair year = new LangPair(String.valueOf(4), AticUtil.getText((String)"atic.report.task.scheduleYear"));
        taskScheduleList.add(all);
        taskScheduleList.add(day);
        taskScheduleList.add(week);
        taskScheduleList.add(month);
        taskScheduleList.add(year);
        return taskScheduleList;
    }

    public static List<LangPair> getReportStateCombData() {
        ArrayList<LangPair> reportStatusList = new ArrayList<LangPair>();
        LangPair all = new LangPair(String.valueOf(-1), AticUtil.getText((String)"atic.analysis.common.all"));
        LangPair appand = new LangPair(String.valueOf(0), AticUtil.getText((String)"atic.report.task.appendState"));
        LangPair run = new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.report.task.runState"));
        LangPair deadLine = new LangPair(String.valueOf(2), AticUtil.getText((String)"atic.report.task.overdueState"));
        reportStatusList.add(all);
        reportStatusList.add(appand);
        reportStatusList.add(run);
        reportStatusList.add(deadLine);
        return reportStatusList;
    }
}

