/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.report.util;

import com.hs.atic.sdk.system.form.LogHoldTimeForm;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.parents.servcice.ILogHoldTimeService;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public final class SystemUtil {
    private static final Long NUM_24 = 24L;
    private static final Long NUM_31 = 31L;
    private static final Long NUM_366 = 366L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    private SystemUtil() {
    }

    public static LogHoldTimeForm getLogHoldTime() {
        try {
            LogHoldTimeForm logHoldTime;
            ServiceContext sc = ServiceContext.getInstance();
            ILogHoldTimeService service = (ILogHoldTimeService)sc.getService("logHoldTimeService", ILogHoldTimeService.class);
            List list = new ArrayList();
            if (null != service) {
                list = service.findLogHoldTime();
            }
            if (null != list && !list.isEmpty()) {
                logHoldTime = (LogHoldTimeForm)list.get(0);
            } else {
                logHoldTime = new LogHoldTimeForm();
                logHoldTime.setHoldTime(1);
                logHoldTime.setTacticsLogTime(90);
                logHoldTime.setHoldOriginal(90);
                logHoldTime.setHoldHour(12);
                logHoldTime.setHoldDay(1);
                logHoldTime.setDayReportTime(60);
                logHoldTime.setWeekReportTime(6);
                logHoldTime.setMonthReportTime(1);
                logHoldTime.setYearReportTime(5);
                logHoldTime.setDivertDelayTime(300);
                logHoldTime.setDevSyslogTime(90);
                logHoldTime.setPageSizeNum(10);
            }
            return logHoldTime;
        }
        catch (Exception e) {
            logger.error((Object)("getLogHoldTime function error!" + e.getMessage()));
            return null;
        }
    }

    public static Long getDataKeepTime(int holdType, int holdTime) {
        long dataKeepTime = 0L;
        switch (holdType) {
            case 2: {
                dataKeepTime = NUM_31 * 24L * 60L * 60L * (long)holdTime;
                break;
            }
            case 3: {
                dataKeepTime = NUM_366 * 24L * 60L * 60L * (long)holdTime;
                break;
            }
            default: {
                dataKeepTime = NUM_24 * 60L * 60L * (long)holdTime;
            }
        }
        return dataKeepTime;
    }

    public static String getExportSuffix(String type) {
        if ("pdf".equals(type) || "print".equals(type)) {
            return ".pdf";
        }
        if ("3".equals(type)) {
            return ".rtf";
        }
        if ("rtf".equals(type)) {
            return ".rtf";
        }
        if ("word".equals(type)) {
            return ".doc";
        }
        if ("excel".equals(type)) {
            return ".xls";
        }
        if ("html".equals(type)) {
            return ".zip";
        }
        if ("csv".equals(type)) {
            return ".zip";
        }
        if ("4".equals(type)) {
            return ".zip";
        }
        return type;
    }

    public static String getContextPath() {
        HttpServletRequest request;
        String contextPath = null;
        ActionContext ctx = ActionContext.getContext();
        if (null != ctx) {
            contextPath = (String)ctx.get("contextPath");
        }
        if (null == contextPath && null != ctx && null != (request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest"))) {
            contextPath = request.getContextPath();
        }
        return null == contextPath ? "" : contextPath;
    }
}

