/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.restful;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import com.security.ireport.action.QueryReportRestful;
import com.security.ireport.util.ProductFaceUtil;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

@Path(value="/ireport")
@Produces(value={"application/json"})
public class RestIreportServiceImpl {
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    private <T> T fromJSON(String json, TypeReference<T> type) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.disableDefaultTyping();
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (JsonParseException e) {
            this.logger.error((Object)e.getMessage());
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)e.getMessage());
        }
        catch (IOException e) {
            this.logger.error((Object)"fromJSON readValue IOException ");
        }
        return null;
    }

    @POST
    @Path(value="/export")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String queryReport(String json) {
        try {
            String remoteAddr = ServletActionContext.getRequest().getRemoteAddr();
            String localAddr = this.getInstallXmlIp();
            if (!remoteAddr.equals(localAddr)) {
                this.logger.error((Object)"remote address is error!");
                throw new LegoCheckedException("remote address is error!");
            }
            this.logger.info((Object)"queryReport restful start");
            this.logger.info((Object)("json" + json));
            Map<String, String> obj = this.fromJSON(json, new MyTypeReference());
            if (null == obj) {
                throw new LegoCheckedException("query params is null!");
            }
            this.logger.info((Object)("obj" + obj));
            String localeStr = obj.get("localeStr");
            Locale locale = Locale.ENGLISH;
            if (null != localeStr && localeStr.contains("zh")) {
                locale = Locale.CHINA;
            }
            QueryReportRestful queryReportRestful = new QueryReportRestful();
            queryReportRestful.setLocale(locale);
            queryReportRestful.setHttpSessionId(String.valueOf(ProductFaceUtil.getInstance().getNextSessionId()));
            queryReportRestful.setReportId(obj.get("reportId"));
            queryReportRestful.setConditionStr(obj.get("condition"));
            queryReportRestful.setType(obj.get("formType"));
            queryReportRestful.setCurUserName(obj.get("userName"));
            queryReportRestful.setUserId(Long.parseLong(obj.get("userId")));
            queryReportRestful.setPath(obj.get("path"));
            queryReportRestful.setUnitText(obj.get("unitText"));
            queryReportRestful.importTurnBackTaskPage();
            queryReportRestful.queryReport();
            queryReportRestful.exportReport();
        }
        catch (LegoCheckedException e) {
            return e.getErrorCode() + "";
        }
        return "success";
    }

    public String getInstallXmlIp() {
        String serverIpAddress = "";
        try {
            String path = AticInstallUtil.getInstance().getLegoPlatInstalledXMLPath();
            SAXReader saxReader = new SAXReader();
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)saxReader);
            Document doc = saxReader.read(new File(path));
            Element element = (Element)doc.selectSingleNode("//entry/string[text()='lego.base.serverIpAddress']");
            serverIpAddress = element.getParent().selectSingleNode("com.huawei.elog.base.model.ContextPropVal").selectSingleNode("value").getText();
        }
        catch (DocumentException e) {
            this.logger.error((Object)"RestIreportServiceImpl getInstallXmlIp error");
        }
        catch (SAXException e) {
            this.logger.error((Object)"RestIreportServiceImpl setFeature error");
        }
        return serverIpAddress;
    }

    private static class MyTypeReference
    extends TypeReference<Map<String, String>> {
    }
}

