/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.dao;

import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.model.IpDomain;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class IpDomainDao
extends CommonDaoImpl {
    private int ipMaxSizeOneQuery = 1000;

    public void remove(long id) {
        String hql = "delete from IpDomain where id = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public IpDomain get(long id) {
        String hql = "from IpDomain where id = ?0 ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(id));
        List ipDomainList = this.findByHql(hql, param);
        if (ipDomainList == null || ipDomainList.isEmpty()) {
            return null;
        }
        return (IpDomain)ipDomainList.get(0);
    }

    public List<IpDomain> getByIps(String zoneIps) {
        ArrayList<IpDomain> result = new ArrayList<IpDomain>();
        if (AticUtil.isNull((String)zoneIps)) {
            return result;
        }
        String[] zoneIp = zoneIps.split(",");
        String ipSet = "";
        int queryIndex = this.ipMaxSizeOneQuery - 1;
        for (int i = 0; i < zoneIp.length; ++i) {
            ipSet = 0 == i ? ipSet + IPUtil4Atic.convert2CompleteIp((String)zoneIp[i]) : ipSet + "," + IPUtil4Atic.convert2CompleteIp((String)zoneIp[i]);
            if (i != zoneIp.length - 1 && i != queryIndex) continue;
            StringBuffer hql = new StringBuffer("from IpDomain where fullFormatIp in ( ");
            Map<Integer, String> queryMap = this.conHqlByParam(hql, ipSet);
            hql.append(')');
            result.addAll(this.findByHql(hql.toString(), queryMap));
            ipSet = "";
            queryIndex += this.ipMaxSizeOneQuery;
        }
        return result;
    }

    private Map<Integer, String> conHqlByParam(StringBuffer hql, String ips) {
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String[] ipList = ips.split(",");
        for (int i = 0; i < ipList.length; ++i) {
            if (0 == i) {
                hql.append("?" + i);
            } else {
                hql.append(",?" + i);
            }
            queryMap.put(i, ipList[i]);
        }
        return queryMap;
    }

    public List<IpDomain> getByIds(String ids) {
        if (AticUtil.isNull((String)ids)) {
            return new ArrayList<IpDomain>();
        }
        String[] idList = ids.split(",");
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        StringBuffer hql = new StringBuffer();
        hql.append("from IpDomain where id in ( ");
        for (int i = 0; i < idList.length; ++i) {
            queryMap.put(i, idList[i]);
            if (0 == i) {
                hql.append("?" + i);
                continue;
            }
            hql.append(",?" + i);
        }
        hql.append(')');
        List result = this.findByHql(hql.toString(), queryMap);
        if (result == null || result.isEmpty()) {
            return new ArrayList<IpDomain>();
        }
        return result;
    }

    public List<IpDomain> getByIpAndId(String zoneIps, Long id) {
        if (AticUtil.isNull((String)zoneIps)) {
            return new ArrayList<IpDomain>();
        }
        String[] zoneIp = zoneIps.split(",");
        StringBuffer hql = new StringBuffer();
        hql.append("from IpDomain where id<>?0 and fullFormatIp in ( ");
        String idString = id == null ? "-1" : id.toString();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, idString);
        for (int i = 0; i < zoneIp.length; ++i) {
            param.put(i + 1, IPUtil4Atic.convert2CompleteIp((String)zoneIp[i]));
            if (0 == i) {
                hql.append("?" + (i + 1));
                continue;
            }
            hql.append(",?" + (i + 1));
        }
        hql.append(')');
        List result = this.findByHql(hql.toString(), param);
        if (result == null || result.isEmpty()) {
            return new ArrayList<IpDomain>();
        }
        return result;
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String domain;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from IpDomain where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String destIp = conditionMap.get("destIp");
        if (!AticUtil.isNull((String)destIp)) {
            hql = hql + " and destIp like ?" + index;
            queryMap.put(index++, "%" + destIp.trim() + "%");
        }
        if (!AticUtil.isNull((String)(domain = conditionMap.get("domain")))) {
            hql = hql + " and lower(domain) like ?" + index;
            queryMap.put(index, "%" + domain.trim().toLowerCase(Locale.ENGLISH) + "%");
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (this.checkParams(sortName, sortType)) {
            if (sortName.trim().equalsIgnoreCase("destIp")) {
                sortName = "fullFormatIp";
            }
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return !AticUtil.isNull((String)type) && !AticUtil.isNull((String)name) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    public void save(List<IpDomain> ipdomains) {
        for (IpDomain ipDomain : ipdomains) {
            ipDomain.setFullFormatIp(IPUtil4Atic.convert2CompleteIp((String)ipDomain.getDestIp()));
            this.saveOrUpdate(ipDomain);
        }
    }
}

