/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.service.impl;

import com.hs.atic.sdk.zone.form.IpDomainForm;
import com.hs.atic.sdk.zone.service.IIpDomainService;
import com.hs.atic.zone.dao.IpDomainDao;
import com.hs.atic.zone.model.IpDomain;
import com.hs.atic.zone.util.ZoneUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpDomainServiceImpl
implements IIpDomainService {
    private static final int DESC_LENGTH = 255;
    private static final int ARRAY_NUMBER = 2;
    private IpDomainDao ipDomainDao;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public void delById(Long id) {
        this.ipDomainDao.remove(id);
    }

    public void editIpDomain(IpDomainForm ipDomainForm) {
        IpDomain ipdomain = (IpDomain)ZoneUtil.copyProperties((Object)ipDomainForm, (Object)new IpDomain());
        ipdomain.setFullFormatIp(IPUtil4Atic.convert2CompleteIp((String)ipdomain.getDestIp()));
        this.ipDomainDao.saveOrUpdate(ipdomain);
    }

    public List<IpDomainForm> findExistIp(String ip) {
        List<IpDomain> ipDomains = this.ipDomainDao.getByIps(ip);
        if (ipDomains.isEmpty()) {
            return null;
        }
        ArrayList<IpDomainForm> formList = new ArrayList<IpDomainForm>();
        for (IpDomain ipDomain : ipDomains) {
            IpDomainForm form = new IpDomainForm();
            ZoneUtil.copyProperties((Object)ipDomain, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    public List<IpDomainForm> getAll() {
        return null;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        this.logger.info((Object)"enter queryByPage");
        Paging page = this.ipDomainDao.queryByPage(queryMap, start, pageSize);
        List list = page.getData();
        ArrayList<IpDomainForm> formList = new ArrayList<IpDomainForm>();
        for (IpDomain ipDomain : list) {
            IpDomainForm form = new IpDomainForm();
            ZoneUtil.copyProperties((Object)ipDomain, (Object)form);
            formList.add(form);
        }
        page.setData(formList);
        this.logger.info((Object)"leave queryByPage");
        return page;
    }

    public void saveIpDomain(IpDomainForm ipDomainForm) {
        IpDomain ipdomain = (IpDomain)ZoneUtil.copyProperties((Object)ipDomainForm, (Object)new IpDomain());
        ipdomain.setFullFormatIp(IPUtil4Atic.convert2CompleteIp((String)ipdomain.getDestIp()));
        this.ipDomainDao.saveOrUpdate(ipdomain);
    }

    public IpDomainDao getIpDomainDao() {
        return this.ipDomainDao;
    }

    public void setIpDomainDao(IpDomainDao ipDomainDao) {
        this.ipDomainDao = ipDomainDao;
    }

    public List<IpDomainForm> getByIps(String zoneIps) {
        ArrayList<IpDomainForm> formList = new ArrayList<IpDomainForm>();
        List<IpDomain> ipDomains = this.ipDomainDao.getByIps(zoneIps);
        for (IpDomain ipDomain : ipDomains) {
            IpDomainForm form = new IpDomainForm();
            ZoneUtil.copyProperties((Object)ipDomain, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    public List<IpDomainForm> getByIds(String ids) {
        List<IpDomain> ipDomains = this.ipDomainDao.getByIds(ids);
        ArrayList<IpDomainForm> formList = new ArrayList<IpDomainForm>();
        for (IpDomain ipDomain : ipDomains) {
            IpDomainForm form = new IpDomainForm();
            ZoneUtil.copyProperties((Object)ipDomain, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    public BatchOperationResult batchDelIpDomain(List<BatchOperation> boList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == boList) {
            return result;
        }
        if (!boList.isEmpty()) {
            for (BatchOperation bo : boList) {
                try {
                    if (null == this.findById(bo.getTargetId())) {
                        this.logger.error((Object)("delete IpDomain : " + this.getcleanedMessage(bo.getTargetName()) + " failed, not exists"));
                        ++fail;
                        bo.setErrorCode(570647L);
                        continue;
                    }
                    this.delById(bo.getTargetId());
                    bo.setOptDetail("atic.zone.ip.domain.delSummary");
                    bo.setDetailParam(new String[]{bo.getTargetName()});
                    this.logger.info((Object)("delete IpDomain : " + this.getcleanedMessage(bo.getTargetName()) + "successfully."));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570601L);
                    this.logger.error((Object)("delete IpDomain : " + this.getcleanedMessage(bo.getTargetName()) + " failed!" + e.getMessage()));
                }
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("batch delete IpDomain result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    public IpDomainForm findById(Long id) {
        IpDomain ipDomain = this.ipDomainDao.get(id);
        IpDomainForm form = (IpDomainForm)ZoneUtil.copyProperties((Object)ipDomain, (Object)new IpDomainForm());
        this.logger.info((Object)("find IpDomain by id : " + id));
        return form;
    }

    public List<IpDomainForm> findEditExistIp(String ip, Long id) {
        List<IpDomain> ipDomains = this.ipDomainDao.getByIpAndId(ip, id);
        if (ipDomains.isEmpty()) {
            return null;
        }
        ArrayList<IpDomainForm> formList = new ArrayList<IpDomainForm>();
        for (IpDomain ipDomain : ipDomains) {
            IpDomainForm form = new IpDomainForm();
            ZoneUtil.copyProperties((Object)ipDomain, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    public BatchOperationResult saveIpDomains(List<BatchOperation> batchOpList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        int boSize = batchOpList.size();
        for (BatchOperation bo : batchOpList) {
            IpDomain ipDomain = new IpDomain();
            String[] datas = bo.getOptDetail().split(",", 2);
            if (0 == datas.length) {
                --boSize;
                continue;
            }
            if (2 > datas.length) {
                ++fail;
                bo.setOptDetail(bo.getOptDetail());
                bo.setErrorCode(570652L);
                bo.setTargetName(datas[0]);
                this.logger.error((Object)("ipDomain data length error:" + datas.length + ";Empty address description."));
                continue;
            }
            if (!IPUtil.isIpv4((String)datas[0].trim()) && !IPUtil.isIpv6((String)datas[0].trim())) {
                ++fail;
                bo.setErrorCode(570651L);
                bo.setTargetName(datas[0].trim());
                this.logger.error((Object)"ipDomain data ipformat error:Incorrect IP address format.");
                continue;
            }
            if (null == datas[1] || "".equals(datas[1].trim()) || "null".equalsIgnoreCase(datas[1].trim())) {
                ++fail;
                bo.setErrorCode(570652L);
                bo.setTargetName(datas[0].trim());
                this.logger.error((Object)"ipDomain data domain null error");
                continue;
            }
            if (!this.checkDomain(datas[1]) || datas[1].length() > 255) {
                ++fail;
                bo.setErrorCode(570654L);
                bo.setTargetName(datas[0].trim());
                this.logger.error((Object)"ipDomain description not legal error:There are illegal characters in the domain description");
                continue;
            }
            ipDomain.setDestIp(datas[0].trim());
            ipDomain.setDomain(datas[1].trim());
            List<IpDomain> ipDomains = this.ipDomainDao.getByIps(datas[0].trim());
            if (ipDomains.isEmpty()) {
                ipDomain.setFullFormatIp(IPUtil4Atic.convert2CompleteIp((String)ipDomain.getDestIp()));
                this.ipDomainDao.saveOrUpdate(ipDomain);
                if (ipDomain.getDestIp() == null || ipDomain.getDestIp().isEmpty()) {
                    ++fail;
                    bo.setErrorCode(570653L);
                    this.logger.error((Object)("batch delete IpDomain result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
                }
                bo.setTargetName(ipDomain.getDestIp());
                bo.setOptDetail("atic.zone.ip.domain.oplog.import.description");
                String[] detailPara = new String[]{ipDomain.getDestIp(), ipDomain.getDomain()};
                bo.setDetailParam(detailPara);
                continue;
            }
            ++fail;
            bo.setTargetName(ipDomain.getDestIp());
            bo.setErrorCode(570648L);
        }
        if (0 == boSize) {
            BatchOperation bo = new BatchOperation();
            bo.setErrorCode(570647L);
            batchOpList.add(bo);
            this.logger.error((Object)"ipDomain data is empty");
            result.setResult(batchOpList);
            result.setFailCount(1);
            result.setTotalCount(1);
            result.setSucceedCount(0);
            return result;
        }
        result.setResult(batchOpList);
        result.setFailCount(fail);
        result.setTotalCount(boSize);
        result.setSucceedCount(boSize - fail);
        this.logger.info((Object)"leave saveIpDomains()");
        return result;
    }

    private boolean checkDomain(String line) {
        String regex = "^(?!(?i)\\s*null$)(?!(?i)[\\s\\S]*[\\s]+null$)(?!(?i)\\s*null\\s{1}[\\s\\S]*$)(?!(?i)[\\s\\S]*[\\s]+null[\\s]+[\\s\\S]*$)[\\u4E00-\\u9FA5\u3002\uff0c\uff1a\uff1b\uff01\uff1f\u3001\u300a\u300b\u201c\u201d\u2018\u2019\uffe5\uff08\uff09\u3010\u3011\u2026|\\w|\\s!@#$%^*_+\\-=\\[\\]{};\\\\\\:\\|,.\\/?]*$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(line);
        return m.matches();
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

