/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.zone.service.impl;

import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageRegister;
import com.hs.lego.comm.internal.jms.MessageTaskManager;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.ireport.form.ReportEmailInfoForm;
import com.hs.vsm.common.sdk.ireport.service.IReportEmailInfoService;
import com.huawei.atic.device.model.AticDeviceForm;
import com.security.ireport.model.vo.TimeTask;
import com.security.ireport.service.ReportTemplateService;
import com.security.ireport.service.ResultReportService;
import com.security.ireport.service.TimeTaskService;
import com.security.ireport.service.impl.ReportTemplateServiceImpl;
import com.security.ireport.service.impl.ResultReportServiceImpl;
import com.security.ireport.service.impl.TimeTaskServiceImpl;
import com.security.ireport.util.ActionUtil;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;

public class ReportReceiveMessageForDelDevice
extends MessageTaskManager
implements InitializingBean {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private transient ReportTemplateService reportTemplateService = new ReportTemplateServiceImpl();
    private transient ResultReportService resultReportService = new ResultReportServiceImpl();
    private transient TimeTaskService timeTaskService = new TimeTaskServiceImpl();
    private transient IReportEmailInfoService reportEmailInfoService;
    private IMessageCenter messageCenter = null;

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(116L);
        return mrs;
    }

    public void onMessage(MessageUnit message) {
        if (null == message) {
            return;
        }
        int messageCode = (int)message.getCmdcode();
        if (116L == (long)messageCode) {
            ArrayList deviceList = (ArrayList)message.getObj();
            List templateIdList = null;
            List taskList = null;
            Integer[] templateIds = null;
            for (AticDeviceForm aticDevice : deviceList) {
                templateIdList = this.reportTemplateService.getTemplateIdByDeviceName(aticDevice.getName());
                this.logger.info((Object)("deviceName is " + aticDevice.getName()));
                if (templateIdList == null || templateIdList.isEmpty()) continue;
                templateIds = new Integer[templateIdList.size()];
                for (int i = 0; i < templateIdList.size(); ++i) {
                    templateIds[i] = Integer.valueOf(((Object[])templateIdList.get(i))[0].toString());
                }
                this.logger.info((Object)("templateId is " + templateIdList.toString()));
                taskList = this.reportTemplateService.getTaskIdByTemplateId(templateIds);
                this.delTem(templateIdList);
                this.delTaskMsg(taskList);
            }
        }
    }

    private void delTem(List<Object[]> templateIdList) {
        Integer[] templateId = null;
        if (!templateIdList.isEmpty()) {
            for (int i = 0; i < templateIdList.size(); ++i) {
                try {
                    templateId = new Integer[templateIdList.size()];
                    templateId[i] = Integer.valueOf(templateIdList.get(i)[0].toString());
                    this.reportTemplateService.delTemplate(templateId[i].toString());
                    continue;
                }
                catch (NumberFormatException e) {
                    this.logger.error((Object)"delete template error");
                    continue;
                }
                catch (SQLException e) {
                    this.logger.error((Object)"delete template error");
                }
            }
        }
    }

    private void delTaskMsg(List<Object[]> taskList) {
        ArrayList<ReportEmailInfoForm> emailInfoList = new ArrayList<ReportEmailInfoForm>();
        StringBuffer taskIdBuffer = new StringBuffer();
        List timeTaskDel = null;
        ArrayList<Integer> tasksDel = new ArrayList<Integer>();
        List delResult = null;
        if (!taskList.isEmpty()) {
            for (int i = 0; i < taskList.size(); ++i) {
                ReportEmailInfoForm emailForm = new ReportEmailInfoForm();
                emailForm.setConditionId(Integer.valueOf(taskList.get(i)[0].toString()));
                emailForm.setTaskId(Integer.valueOf(taskList.get(i)[1].toString()));
                emailForm.setAuthId("VSM_ATIC");
                emailInfoList.add(emailForm);
                taskIdBuffer.append(taskList.get(i)[1].toString());
                taskIdBuffer.append(",");
            }
            this.reportEmailInfoService.removeReportEmailInfo(emailInfoList);
            String strTaskIds = taskIdBuffer.substring(0, taskIdBuffer.length() - 1);
            this.logger.info((Object)("strTaskIds is " + strTaskIds));
            timeTaskDel = this.timeTaskService.getTimeTasks(strTaskIds);
            if (timeTaskDel.isEmpty()) {
                return;
            }
            for (int i = 0; i < timeTaskDel.size(); ++i) {
                tasksDel.add(((TimeTask)timeTaskDel.get(i)).getTaskId());
            }
            this.logger.info((Object)("tasksDel is " + ((Object)tasksDel).toString()));
            List deleteFileNameList = this.timeTaskService.getLogPathInfo(tasksDel);
            delResult = this.timeTaskService.delTimeTask(tasksDel);
            this.resultReportService.updateResultReportByTaskId(tasksDel);
            if (null != delResult && !delResult.isEmpty()) {
                ActionUtil.setDeleteResult((List)delResult);
            } else {
                IReportUtil.deleteFile((String)IReportMgrUtil.getExportPath(), (List)deleteFileNameList);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.messageCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public IReportEmailInfoService getReportEmailInfoService() {
        return this.reportEmailInfoService;
    }

    public void setReportEmailInfoService(IReportEmailInfoService reportEmailInfoService) {
        this.reportEmailInfoService = reportEmailInfoService;
    }
}

