/*
 * Decompiled with CFR 0.152.
 */
package com.restful.service.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hs.atic.analysis.report.attack.attacktype.AtackTypeDistribute;
import com.hs.atic.analysis.report.attack.attacktype.AttackFormType;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.permission.service.IPermissionService;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackFlowPeakTopNForm;
import com.hs.atic.sdk.analysis.form.AttackLogForm;
import com.hs.atic.sdk.analysis.form.AttackTypeDistributeForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DeviceAttackDataForm;
import com.hs.atic.sdk.analysis.form.FlowCompareConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareForm;
import com.hs.atic.sdk.analysis.form.IpLocationTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.cbb.user.service.IUserService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.restful.model.RestAttackTypeDistribution;
import com.restful.model.RestReportDevice;
import com.restful.model.RestReportDeviceAttackData;
import com.restful.model.RestReportDeviceFlow;
import com.restful.model.RestReportInfo;
import com.restful.model.RestReportLocationAttack;
import com.restful.service.RestReportService;
import com.restful.util.JSONUtil;
import com.restful.util.RestAuthUtil;
import com.restful.util.RestLogInfo;
import com.restful.util.RestUtil;
import com.security.ireport.util.ProductFaceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.struts2.ServletActionContext;

@Path(value="v1/ddos")
@Produces(value={"application/json"})
public class RestReportServiceImpl
implements RestReportService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_RESTFUL);
    private static final int DEVICE_IP_LIST_MAX = 5;
    private static final int TOPN_MAX = 50;
    private static final int NUMBER_0 = 0;
    private static final int NUMBER_1 = 1;
    private static final int NUMBER_2 = 2;
    private static final int NUMBER_3 = 3;
    private static final int NUMBER_10 = 10;
    private static final int NUMBER_1000 = 1000;
    private IPermissionService permissionService;
    private IDataStatService dataStatService;

    @Override
    @POST
    @Path(value="/location-attack")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response locationAttack(String locationAttackJson) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        int responseCode = 500;
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"v1/ddos/location-attack");
        String requestMsg = "get location attack flow topn. restful request is null. json string is :" + locationAttackJson + ". ";
        String terminalIp = "";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"v1/ddos/location-attack");
            requestMsg = "restful request url : " + url + ". json string is :" + locationAttackJson + ". ";
            terminalIp = request.getRemoteAddr();
        }
        String responseMsg = "";
        String operationKey = "report.manager";
        String resultJsonKey = "locationattackinfos";
        String jsonOneLine = String.valueOf(locationAttackJson).replaceAll("\r|\n", "");
        logInfo.setUrl(url);
        logInfo.setJson(jsonOneLine);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation(operationKey);
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        LOGGER.info((Object)("is Legal Token " + requestMsg));
        RestReportInfo requestInfo = null;
        try {
            this.checkJson(locationAttackJson);
            requestInfo = (RestReportInfo)JSONUtil.getInstance().fromJSON(locationAttackJson, RestReportInfo.class);
            Response response = this.checkIpList(new ObjectMapper().writeValueAsString((Object)requestInfo.getDeviceIpList()));
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkIpList: IpList is error!");
                return this.logExitFailed(logInfo);
            }
            if (StringUtils.isEmpty((String)requestInfo.getTopN())) {
                requestInfo.setTopN(String.valueOf(10));
            } else {
                response = this.checkTopN(requestInfo.getTopN());
                if (200 != response.getStatus()) {
                    logInfo.setResponseCode(response.getStatus());
                    logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                    logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                    LOGGER.error((Object)"checkTopN: TopN  is error!");
                    return this.logExitFailed(logInfo);
                }
            }
            response = this.checkStartEndTime(requestInfo.getStartTime(), requestInfo.getEndTime());
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkStartEndTime: StartTime or EndTime  is error!");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermission(userName, Arrays.asList(requestInfo.getDeviceIpList()));
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermission: The resource is illegal");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermissionOperation(userName, 2241L);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermissionOperation: Insufficient permissions");
                return this.logExitFailed(logInfo);
            }
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation(operationKey);
            LOGGER.error((Object)("locationAttack Exception :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        String apiName = "locationAttack";
        logInfo.setApiName(apiName);
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            LOGGER.error((Object)"Concurrent is full!");
            return response;
        }
        String errorMessage = "get location attack flow topn happen exception";
        try {
            List<String> deviceIpList = Arrays.asList(requestInfo.getDeviceIpList());
            Map<String, List<String>> collectDevMap = this.getCollectorDeviceIpMap(deviceIpList);
            IDataStatService statService = ReportAnalysisUtil.getDataStatService();
            ArrayList<RestReportLocationAttack> restLocationAttackList = new ArrayList<RestReportLocationAttack>();
            DataStatConditionForm dsc = new DataStatConditionForm();
            dsc.setStartTime(Long.parseLong(requestInfo.getStartTime()));
            dsc.setEndTime(Long.parseLong(requestInfo.getEndTime()));
            dsc.setTopn(Integer.parseInt(requestInfo.getTopN()));
            dsc.setDirection(0);
            dsc.initDataStatCondition();
            if (!"admin".equals(userName)) {
                List<Long> zoneIdList = this.getZoneIdList(userName);
                if (null == zoneIdList || zoneIdList.isEmpty()) {
                    zoneIdList = new ArrayList<Long>();
                    zoneIdList.add(-1L);
                }
                dsc.setZoneIdList(zoneIdList);
                dsc.setSessionId(ProductFaceUtil.getInstance().getNextSessionId());
            }
            List<String> deviceList = null;
            AticDevice device = null;
            String ip = null;
            List<RestReportLocationAttack> restLocationList = null;
            IAticDeviceService deviceService = ZoneBisUtil.getIFirewallService();
            for (Map.Entry<String, List<String>> map : collectDevMap.entrySet()) {
                deviceList = map.getValue();
                for (int i = 0; i < deviceList.size(); ++i) {
                    ip = deviceList.get(i);
                    dsc.setUnit(1);
                    dsc.setDeviceIp(ip);
                    device = deviceService.getDeviceByIp(ip);
                    dsc.setDeviceId(device.getMoId());
                    dsc.setDevSerType(0);
                    Map<String, List<IpLocationTopNForm>> formList = statService.getIpLocationTopNTable(dsc, map.getKey());
                    dsc.setUnit(0);
                    Map<String, List<IpLocationTopNForm>> formList2 = statService.getIpLocationTopNTable(dsc, map.getKey());
                    restLocationList = this.joinLocationTopN(ip, formList.get(ip), formList2.get(ip));
                    restLocationAttackList.addAll(restLocationList);
                }
            }
            responseCode = 200;
            responseMsg = this.concatHeadJson(resultJsonKey, restLocationAttackList);
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(String.valueOf(responseCode));
            logInfo.setOperation(operationKey);
            return this.logExit(logInfo);
        }
        catch (LegoCheckedException e) {
            responseCode = 500;
            responseMsg = errorMessage;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation(operationKey);
            LOGGER.error((Object)("locationAttack LegoCheckedException :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        catch (IOException e) {
            responseCode = 500;
            responseMsg = errorMessage;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation(operationKey);
            LOGGER.error((Object)("locationAttack IOException :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
    }

    private List<RestReportLocationAttack> joinLocationTopN(String deviceIp, List<IpLocationTopNForm> ppsLocation, List<IpLocationTopNForm> kbpsLocation) {
        ArrayList<RestReportLocationAttack> restreportLoctionList = new ArrayList<RestReportLocationAttack>();
        IpLocationTopNForm ppsForm = null;
        IpLocationTopNForm kbpsForm = null;
        RestReportLocationAttack restLocation = null;
        if (null != ppsLocation && null != kbpsLocation) {
            block0: for (int i = 0; i < ppsLocation.size(); ++i) {
                ppsForm = ppsLocation.get(i);
                for (int j = 0; j < kbpsLocation.size(); ++j) {
                    kbpsForm = kbpsLocation.get(j);
                    if (ppsForm.getIpLocationId() != kbpsForm.getIpLocationId()) continue;
                    restLocation = new RestReportLocationAttack();
                    restLocation.setDeviceIp(deviceIp);
                    restLocation.setLocationId(kbpsForm.getIpLocationId());
                    restLocation.setDropPps(ppsForm.getFlowValue());
                    restLocation.setDropKbps(kbpsForm.getFlowValue());
                    restreportLoctionList.add(restLocation);
                    continue block0;
                }
            }
        }
        return restreportLoctionList;
    }

    @Override
    @POST
    @Path(value="/ip-attack-event")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response ipAattackEvent(String ipAttackEventJson) {
        Response response;
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"v1/ddos/ip-attack-event");
        String requestMsg = "ipAattackEvent.json :" + ipAttackEventJson;
        String terminalIp = "";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"v1/ddos/ip-attack-event");
            requestMsg = "ipAattackEvent. url : " + url + ". json :" + ipAttackEventJson;
            terminalIp = request.getRemoteAddr();
        }
        String apiName = "ipAattackEvent";
        logInfo.setApiName(apiName);
        logInfo.setUrl(url);
        logInfo.setJson(ipAttackEventJson.replaceAll("\r|\n|\\s", ""));
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.report.ipAattackEvent");
        int responseCode = 200;
        String responseMsg = "query ipAattackEvent succeed";
        LOGGER.info((Object)("ipAattackEvent. json :" + requestMsg));
        if (AticUtil.isNull((String)userName)) {
            responseMsg = "ip-attack-event illegal token.";
            responseCode = 412;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)"userName is null!");
            return this.logExitFailed(logInfo);
        }
        RestReportInfo listInfo = null;
        int topn = 10;
        try {
            this.checkJson(ipAttackEventJson);
            listInfo = (RestReportInfo)JSONUtil.getInstance().fromJSON(ipAttackEventJson, RestReportInfo.class);
            response = this.checkIpList(new ObjectMapper().writeValueAsString((Object)listInfo.getDeviceIpList()));
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"ipAattackEvent checkIpList: IpList is error!");
                return this.logExitFailed(logInfo);
            }
            if (!AticUtil.isNull((String)listInfo.getTopN())) {
                response = this.checkTopN(listInfo.getTopN());
                if (200 != response.getStatus()) {
                    logInfo.setResponseCode(response.getStatus());
                    logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                    logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                    LOGGER.error((Object)"ipAattackEvent checkTopN: TopN is error!");
                    return this.logExitFailed(logInfo);
                }
                topn = Integer.parseInt(listInfo.getTopN());
            }
            if (200 != (response = this.checkPermission(userName, Arrays.asList(listInfo.getDeviceIpList()))).getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"ipAattackEvent checkPermission: The resource is illegal");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermissionOperation(userName, 2251L);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"ipAattackEvent checkPermissionOperation: Insufficient permissions");
                return this.logExitFailed(logInfo);
            }
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("ipAattackEvent Param Exception :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            response = this.handleOverAPInvokeLimit(logInfo);
            LOGGER.error((Object)"Concurrent is full!");
            return response;
        }
        try {
            List<Object> zoneIdList = new ArrayList();
            if (!"admin".equals(userName) && ((zoneIdList = this.getZoneIdList(userName)) == null || zoneIdList.isEmpty())) {
                responseMsg = "ipAattackEvent current user can zone info null, not query ip-attack-eventn info data.";
                responseCode = 455;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                LOGGER.warn((Object)"this user have not zone!");
                return this.logExitFailed(logInfo);
            }
            ArrayList<AttackLogForm> attackLogForms = new ArrayList<AttackLogForm>();
            Map<String, List<String>> collectDevMap = this.getCollectorDeviceIpMap(Arrays.asList(listInfo.getDeviceIpList()));
            for (Map.Entry<String, List<String>> map : collectDevMap.entrySet()) {
                String collectorIp = map.getKey();
                DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
                datastatConditionForm.setDirection(1);
                datastatConditionForm.setDeviceIpList(map.getValue());
                datastatConditionForm.setTopn(topn);
                datastatConditionForm.setUnit(2);
                datastatConditionForm.setDevSerType(0);
                datastatConditionForm.setZoneIdList(zoneIdList);
                datastatConditionForm.setSessionId(ProductFaceUtil.getInstance().getNextSessionId());
                List<AttackLogForm> attackLogFormList = this.dataStatService.ipAattackEvent(collectorIp, datastatConditionForm);
                attackLogForms.addAll(attackLogFormList);
            }
            StringBuilder resultStr = new StringBuilder();
            resultStr.append("{\"ipattackinfos\":[");
            for (AttackLogForm attackLogForm : attackLogForms) {
                resultStr.append("{\"zone_id\": ").append(attackLogForm.getZoneId());
                resultStr.append(",\"zone_name\":\"").append(this.queryZoneName(attackLogForm.getZoneId()));
                resultStr.append("\",\"attack_type\":\"").append(this.queryAttackTypes(attackLogForm.getAttackType()));
                resultStr.append("\",\"start_time\":\"").append(attackLogForm.getAttackTime());
                resultStr.append("\",\"device_ip\":\"").append(attackLogForm.getDeviceIp());
                resultStr.append("\",\"zone_ip\":\"").append(attackLogForm.getZoneIp());
                resultStr.append("\",\"port\":\"").append(attackLogForm.getPort());
                resultStr.append("\",\"ip_max_drop_kbps\":\"").append(attackLogForm.getIpAttackPeakKbps());
                resultStr.append("\"},");
            }
            if (attackLogForms.size() > 0) {
                responseMsg = resultStr.substring(0, resultStr.length() - 1) + "]}";
            } else {
                resultStr.append("]}");
                responseMsg = resultStr.toString();
            }
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            return this.logExit(logInfo);
        }
        catch (LegoCheckedException e) {
            responseCode = 500;
            responseMsg = "query ipAattackEvent LegoCheckedException";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("ipAattackEvent.LegoCheckedException :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        catch (Exception e) {
            responseCode = 500;
            responseMsg = "query ipAattackEvent Exception";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("ipAattackEvent.Exception :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
    }

    private List<Long> getZoneIdList(String userName) {
        boolean isAdmin = "admin".equals(userName);
        if (isAdmin) {
            return null;
        }
        ArrayList<Long> zoneIdList = new ArrayList<Long>();
        IUserMgr userMgr = ZoneReferUtil.getUserMgr();
        long userId = userMgr.getUserInfoByName(userName).getId();
        IZoneService zoneService = ReportBisUtil.getZoneService();
        List zoneInfoForms = zoneService.getAll(Long.valueOf(userId), Boolean.valueOf(isAdmin));
        for (ZoneInfoForm infoForm : zoneInfoForms) {
            zoneIdList.add(infoForm.getZoneId());
        }
        return zoneIdList;
    }

    private String queryZoneName(Long zoneId) {
        String zoneName = "";
        IZoneService zoneService = ReportBisUtil.getZoneService();
        ZoneInfoForm zoneForm = zoneService.getById(zoneId);
        if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
            LOGGER.info((Object)("the zone not exist,zoneId = " + zoneId));
            zoneName = LocaleUtil.getInstance().getText("atic.analysis.common.unknownZone") + zoneId;
        } else {
            zoneName = zoneForm.getZoneDesc();
        }
        return zoneName;
    }

    private String queryAttackTypes(String attackTypes) {
        if (attackTypes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] str = attackTypes.split(",");
        for (int i = 0; i < str.length; ++i) {
            int attackTypeValue = Integer.parseInt(str[i]);
            long filterId = 0L;
            String attackType = "";
            if (attackTypeValue > 2000 && attackTypeValue < 80000) {
                IFilterService filterService = ReportBisUtil.getFilterService();
                FilterForm filterTemp = filterService.queryFilterName(Long.valueOf(filterId = (long)(attackTypeValue - 2000)));
                attackType = null != filterTemp && !AticUtil.isNull((String)filterTemp.getFilterName()) ? filterTemp.getFilterName() : "Unknown Filter " + filterId;
            } else if (attackTypeValue >= 80000) {
                INpFilterService npFilterService = ReportBisUtil.getNpFilterService();
                if (npFilterService != null) {
                    filterId = attackTypeValue - 80000;
                    NPFilterForm npfilterTemp = npFilterService.queryNPFilterFormByfilterId(filterId);
                    attackType = null != npfilterTemp && !AticUtil.isNull((String)npfilterTemp.getFilterName()) ? npfilterTemp.getFilterName() : LocaleUtil.getInstance().getText("com.hs.atic.alart.attack.attackType.80000");
                    LOGGER.info((Object)("npfilterTemp attackTypeValue : " + attackTypeValue + ";attackType: " + attackType));
                } else {
                    LOGGER.error((Object)"npFilterService service is null!");
                    attackType = LocaleUtil.getInstance().getText("com.hs.atic.alart.attack.attackType.80000");
                }
            } else {
                attackType = LocaleUtil.getInstance().getText("com.hs.atic.alart.attack.attackType." + attackTypeValue);
            }
            sb.append(attackType).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private Map<String, List<String>> getCollectorDeviceIpMap(List<String> deviceIpList) {
        HashMap<String, List<String>> returnMap = new HashMap<String, List<String>>();
        IAticDeviceService aticDeviceService = ZoneBisUtil.getIFirewallService();
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        for (String deviceIp : deviceIpList) {
            AticDevice aticDevice = aticDeviceService.getDeviceByIp(deviceIp);
            if (null == aticDevice) continue;
            Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(aticDevice.getMoId()));
            if (null == collectorId || null == collectorService.getCollectorInfo(collectorId.longValue())) {
                LOGGER.warn((Object)("no collector found, device is : " + aticDevice.getName()));
                continue;
            }
            String collectorIp = collectorService.getCollectorInfo(collectorId.longValue()).getIpAddress();
            if (2 == collectorService.getCollectorInfo(collectorId.longValue()).getStatus()) {
                LOGGER.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + collectorIp));
                continue;
            }
            if (null != returnMap.get(collectorIp)) {
                ((List)returnMap.get(collectorIp)).add(deviceIp);
                continue;
            }
            ArrayList<String> tmpList = new ArrayList<String>();
            tmpList.add(deviceIp);
            returnMap.put(collectorIp, tmpList);
        }
        return returnMap;
    }

    private Response attackCheckIpList(List<String> deviceIpList) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(400);
        if (deviceIpList.isEmpty()) {
            responseBuilder.entity((Object)"deviceipList is null.");
            return responseBuilder.build();
        }
        if (deviceIpList.size() > 5) {
            responseBuilder.entity((Object)"deviceipList is over than max count 5");
            return responseBuilder.build();
        }
        ArrayList<String> deviceList = new ArrayList<String>();
        String ip = null;
        for (int i = 0; i < deviceIpList.size(); ++i) {
            ip = deviceIpList.get(i);
            if (!IPUtil.isIpv4((String)ip)) {
                responseBuilder.entity((Object)("deviceipList ip " + ip + " is not a ip."));
                return responseBuilder.build();
            }
            if (deviceList.contains(ip)) {
                responseBuilder.entity((Object)("deviceipList ip " + ip + " is duplicate."));
                return responseBuilder.build();
            }
            deviceList.add(ip);
        }
        responseBuilder = responseBuilder.status(200);
        responseBuilder.entity((Object)"");
        return responseBuilder.build();
    }

    @Override
    @POST
    @Path(value="/attack-type-distribution")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response attackTypeDistribution(String attackTypeDistributionJson) {
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"v1/ddos/attack-type-distribution");
        String requestMsg = "add attackTypeDistribution. restful request is null. json :" + attackTypeDistributionJson;
        String terminalIp = "";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"v1/ddos/attack-type-distribution");
            requestMsg = "add attackTypeDistribution. restful request url : " + url + ". json :" + attackTypeDistributionJson;
            terminalIp = request.getRemoteAddr();
        }
        String apiName = "attackTypeDistribution";
        logInfo.setApiName(apiName);
        logInfo.setUrl(url);
        logInfo.setJson(attackTypeDistributionJson.replaceAll("\r|\n|\\s", ""));
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.attack.type.distribution");
        int responseCode = 200;
        String responseMsg = "query attackTypeDistribution succeed";
        if (AticUtil.isNull((String)userName)) {
            responseMsg = "attack-type-distribution illegal token.";
            responseCode = 412;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            return this.logExitFailed(logInfo);
        }
        LOGGER.info((Object)("attack-type-distribution is Legal Token " + requestMsg));
        RestAttackTypeDistribution attackTypeDistribution = null;
        try {
            this.checkJson(attackTypeDistributionJson);
            attackTypeDistribution = (RestAttackTypeDistribution)JSONUtil.getInstance().fromJSON(attackTypeDistributionJson, RestAttackTypeDistribution.class);
            if (attackTypeDistribution == null) {
                throw new IllegalArgumentException("listInfo is Null");
            }
            List<String> deviceIpList = attackTypeDistribution.getDeviceIpList();
            Response response = this.attackCheckIpList(deviceIpList);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"attackCheckIpList : ip is error");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermission(userName, deviceIpList);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"attackTypeDistribution checkPermission : ip is error");
                return this.logExitFailed(logInfo);
            }
            response = this.checkStartEndTime(attackTypeDistribution.getStartTime(), attackTypeDistribution.getEndTime());
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"StartTime or EndTime is error");
                return this.logExitFailed(logInfo);
            }
            response = this.checkFlowType(attackTypeDistribution.getFlowType());
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkFlowType : Type is error ");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermissionOperation(userName, 2251L);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermissionOperation: Insufficient permissions");
                return this.logExitFailed(logInfo);
            }
        }
        catch (Exception e) {
            responseMsg = "attack-type-distribution json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("attackTypeDistribution Exception :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            LOGGER.error((Object)"Concurrent is full!");
            return response;
        }
        try {
            HashMap<String, List<AttackTypeDistributeForm>> attackTypeDisFormList = new HashMap<String, List<AttackTypeDistributeForm>>();
            List<Object> zoneIdList = new ArrayList();
            if (!"admin".equals(userName) && ((zoneIdList = this.getZoneIdList(userName)) == null || zoneIdList.isEmpty())) {
                responseMsg = "attackBandwidthDistribution current user can zone info null, not query attack-type-distribution info data.";
                responseCode = 455;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                LOGGER.warn((Object)"this user have not zone!");
                return this.logExitFailed(logInfo);
            }
            Map<String, List<String>> collectDevMap = this.getCollectorDeviceIpMap(attackTypeDistribution.getDeviceIpList());
            for (Map.Entry<String, List<String>> map : collectDevMap.entrySet()) {
                DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
                datastatConditionForm.setDirection(1);
                String collectorIp = map.getKey();
                List<String> deviceIps = map.getValue();
                datastatConditionForm.setDeviceIpList(deviceIps);
                datastatConditionForm.setIsServiceGroup(false);
                datastatConditionForm.setBisId(0L);
                datastatConditionForm.setRestfulType(1);
                datastatConditionForm.setZoneIdList(zoneIdList);
                datastatConditionForm.setAbnormalType(attackTypeDistribution.getFlowType());
                datastatConditionForm.setStartTime(Long.valueOf(attackTypeDistribution.getStartTime()));
                datastatConditionForm.setEndTime(Long.valueOf(attackTypeDistribution.getEndTime()));
                datastatConditionForm.setSessionId(ProductFaceUtil.getInstance().getNextSessionId());
                Map<String, List<AttackTypeDistributeForm>> attackTypeDisFormMap = this.getDeviceCounts(datastatConditionForm, collectorIp);
                if (attackTypeDisFormMap.isEmpty()) continue;
                for (Map.Entry<String, List<AttackTypeDistributeForm>> attackTypeMap : attackTypeDisFormMap.entrySet()) {
                    if (attackTypeDisFormList.containsKey(attackTypeMap.getKey())) {
                        ((List)attackTypeDisFormList.get(attackTypeMap.getKey())).addAll((Collection)attackTypeMap.getValue());
                        continue;
                    }
                    attackTypeDisFormList.put(attackTypeMap.getKey(), attackTypeMap.getValue());
                }
            }
            StringBuilder resultStr = new StringBuilder();
            resultStr.append("{\"attacktypelist\":[");
            for (Map.Entry attackTypeMap : attackTypeDisFormList.entrySet()) {
                List<AtackTypeDistribute> dataList = this.getAttackTypeDisList((List)attackTypeMap.getValue());
                for (AtackTypeDistribute atackTypeDistribute : dataList) {
                    resultStr.append("{\"device_ip\":\"").append((String)attackTypeMap.getKey()).append("\",").append("\"attack_type\":\"").append(atackTypeDistribute.getAttackTypeName()).append("\",").append("\"attack_times\":").append(atackTypeDistribute.getCount()).append("},");
                }
            }
            if (attackTypeDisFormList.isEmpty()) {
                resultStr.append("]}");
                responseMsg = resultStr.toString();
            } else {
                responseMsg = resultStr.substring(0, resultStr.length() - 1) + "]}";
            }
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 570512L) {
                responseMsg = "query attack-type-distribution info no collector exist error.";
                responseCode = 500;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                LOGGER.error((Object)("attackTypeDistribution no collector exist error :" + e.getMessage()));
                return this.logExitFailed(logInfo);
            }
            responseMsg = "query attack-type-distribution error.";
            responseCode = 500;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("attackTypeDistribution query attack-type-distribution error:" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        catch (Exception e) {
            responseMsg = "query attack-type-distribution error.";
            responseCode = 500;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("attackTypeDistribution Exception :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(responseCode + "," + responseMsg);
        return this.logExit(logInfo);
    }

    private List<AtackTypeDistribute> getAttackTypeDisList(List<AttackTypeDistributeForm> attackTypeDisFormList) {
        ArrayList<AtackTypeDistribute> attackTypeDisList = new ArrayList<AtackTypeDistribute>();
        if (attackTypeDisFormList.isEmpty()) {
            return attackTypeDisList;
        }
        ArrayList<AttackTypeDistributeForm> customAttackList = new ArrayList<AttackTypeDistributeForm>();
        HashMap<Long, AttackTypeDistributeForm> attackTypeDisMap = new HashMap<Long, AttackTypeDistributeForm>();
        float totalCount = 0.0f;
        for (AttackTypeDistributeForm attackForm : attackTypeDisFormList) {
            Long attackType = attackForm.getAttackType();
            totalCount += (float)attackForm.getCount().longValue();
            AttackTypeDistributeForm tempForm = null;
            if (attackType < 10L) {
                customAttackList.add(attackForm);
                continue;
            }
            if (attackTypeDisMap.containsKey(attackType)) {
                tempForm = (AttackTypeDistributeForm)attackTypeDisMap.get(attackType);
                long count = tempForm.getCount() + attackForm.getCount();
                tempForm.setCount(count);
                attackTypeDisMap.put(attackType, tempForm);
                continue;
            }
            attackTypeDisMap.put(attackType, attackForm);
        }
        if (totalCount == 0.0f) {
            return attackTypeDisList;
        }
        attackTypeDisList.addAll(this.getCustomAtackTypeList(customAttackList, totalCount));
        attackTypeDisList.addAll(this.getCommonAtackTypeList(attackTypeDisMap, totalCount));
        return attackTypeDisList;
    }

    private List<AtackTypeDistribute> getCommonAtackTypeList(Map<Long, AttackTypeDistributeForm> attackTypeDisMap, float totalCount) {
        ArrayList<AtackTypeDistribute> attackTypeDisList = new ArrayList<AtackTypeDistribute>();
        if (null != attackTypeDisMap) {
            for (Map.Entry<Long, AttackTypeDistributeForm> attackTypeSet : attackTypeDisMap.entrySet()) {
                AtackTypeDistribute distribute = new AtackTypeDistribute();
                long counts = attackTypeSet.getValue().getCount();
                float percent = (float)counts / totalCount;
                distribute.setAttackType(attackTypeSet.getKey());
                distribute.setCount(counts);
                distribute.setCountStr(this.formatCount(counts));
                distribute.setPercent(percent);
                if (distribute.getAttackType() >= 10L) {
                    distribute.setAttackTypeName(ReportAnalysisUtil.getDisplayAttackType(String.valueOf(attackTypeSet.getKey())));
                } else {
                    distribute.setAttackTypeName(ReportAnalysisUtil.getCustomAttackTypeStr(attackTypeSet.getValue().getZoneId(), attackTypeSet.getValue().getDeviceIp(), attackTypeSet.getValue().getProtocol(), attackTypeSet.getValue().getPort()));
                }
                attackTypeDisList.add(distribute);
            }
        }
        return attackTypeDisList;
    }

    private List<AtackTypeDistribute> getCustomAtackTypeList(List<AttackTypeDistributeForm> customAttackList, float totalCount) {
        ArrayList<AtackTypeDistribute> attackTypeList = new ArrayList<AtackTypeDistribute>();
        HashMap<AttackFormType, AttackTypeDistributeForm> map = new HashMap<AttackFormType, AttackTypeDistributeForm>();
        for (AttackTypeDistributeForm attackTypeDistributeForm : customAttackList) {
            AttackFormType attackFormType = new AttackFormType(attackTypeDistributeForm);
            if (map.containsKey(attackFormType)) {
                long count = ((AttackTypeDistributeForm)map.get(attackFormType)).getCount();
                ((AttackTypeDistributeForm)map.get(attackFormType)).setCount(count + attackTypeDistributeForm.getCount());
                continue;
            }
            map.put(attackFormType, attackTypeDistributeForm);
        }
        for (Map.Entry entry : map.entrySet()) {
            AtackTypeDistribute attack = new AtackTypeDistribute();
            attack.setAttackType(((AttackTypeDistributeForm)entry.getValue()).getAttackType());
            attack.setCount(((AttackTypeDistributeForm)entry.getValue()).getCount());
            attack.setAttackTypeName(ReportAnalysisUtil.getCustomAttackTypeStr(((AttackTypeDistributeForm)entry.getValue()).getZoneId(), ((AttackTypeDistributeForm)entry.getValue()).getDeviceIp(), ((AttackTypeDistributeForm)entry.getValue()).getProtocol(), ((AttackTypeDistributeForm)entry.getValue()).getPort()));
            attack.setPercent((float)((AttackTypeDistributeForm)entry.getValue()).getCount().longValue() / totalCount);
            attack.setCountStr(this.formatCount(((AttackTypeDistributeForm)entry.getValue()).getCount()));
            attackTypeList.add(attack);
        }
        return attackTypeList;
    }

    private String formatCount(long count) {
        int comma = 0;
        String countStr = null;
        try {
            countStr = String.valueOf(count);
        }
        catch (Exception e) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int length = countStr.length();
        comma = length % 3 == 0 ? length / 3 - 1 : length / 3;
        int len = length - comma * 3;
        for (int i = 0; i <= comma; ++i) {
            if (i == 0) {
                buffer.append(countStr.substring(0, len));
                buffer.append(',');
                continue;
            }
            buffer.append(countStr.substring(len + (i - 1) * 3, len + i * 3));
            buffer.append(',');
        }
        countStr = buffer.substring(0, buffer.length() - 1);
        return countStr;
    }

    private Map<String, List<AttackTypeDistributeForm>> getDeviceCounts(DataStatConditionForm datastatConditionForm, String collectorIp) {
        HashMap<String, List<AttackTypeDistributeForm>> formMap = new HashMap();
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            formMap = this.dataStatService.restfulGetAttackCountsDis(datastatConditionForm, collectorIp);
        }
        catch (Exception e) {
            LOGGER.error((Object)("attack-type-distribution rmi service error, Failed to connect to the collector,collectorIp = " + this.getcleanedMessage(collectorIp) + ". " + e.getMessage()));
        }
        return formMap;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Response checkFlowType(int flowType) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(400);
        if (flowType != 1 && flowType != 2) {
            responseBuilder.entity((Object)("flow_type = " + flowType + " info error"));
            return responseBuilder.build();
        }
        responseBuilder = responseBuilder.status(200);
        responseBuilder.entity((Object)"");
        return responseBuilder.build();
    }

    @Override
    @POST
    @Path(value="/attack-bandwidth-distribution")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response attackBandwidthDistribution(String attackBandwidthDistributionJson) {
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"v1/ddos/attack-bandwidth-distribution");
        String requestMsg = "add attackBandwidthDistribution. restful request is null. json :" + attackBandwidthDistributionJson;
        String terminalIp = "";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"v1/ddos/attack-bandwidth-distribution");
            requestMsg = "add attackBandwidthDistribution. restful request url : " + url + ". json :" + attackBandwidthDistributionJson;
            terminalIp = request.getRemoteAddr();
        }
        String apiName = "attackBandwidthDistribution";
        logInfo.setApiName(apiName);
        logInfo.setUrl(url);
        logInfo.setJson(attackBandwidthDistributionJson.replaceAll("\r|\n|\\s", ""));
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.attack.bandwidth.distribution");
        int responseCode = 200;
        String responseMsg = "query attackBandwidthDistribution succeed";
        if (AticUtil.isNull((String)userName)) {
            responseMsg = "attackBandwidthDistribution illegal token.";
            responseCode = 412;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            return this.logExitFailed(logInfo);
        }
        LOGGER.info((Object)("attackBandwidthDistribution is Legal Token " + requestMsg));
        RestAttackTypeDistribution attackTypeDistribution = null;
        try {
            this.checkJson(attackBandwidthDistributionJson);
            attackTypeDistribution = (RestAttackTypeDistribution)JSONUtil.getInstance().fromJSON(attackBandwidthDistributionJson, RestAttackTypeDistribution.class);
            if (attackTypeDistribution == null) {
                throw new IllegalArgumentException("listInfo is Null");
            }
            List<String> deviceIpList = attackTypeDistribution.getDeviceIpList();
            Response response = this.attackCheckIpList(deviceIpList);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermission(userName, deviceIpList);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermission: The resource is illegal");
                return this.logExitFailed(logInfo);
            }
            response = this.checkStartEndTime(attackTypeDistribution.getStartTime(), attackTypeDistribution.getEndTime());
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"StartTime or EndTime is error");
                return this.logExitFailed(logInfo);
            }
            response = this.checkFlowType(attackTypeDistribution.getFlowType());
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkFlowType : Type is error ");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermissionOperation(userName, 2251L);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermissionOperation: Insufficient permissions");
                return this.logExitFailed(logInfo);
            }
        }
        catch (Exception e) {
            responseMsg = "attack-bandwidth-distribution json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("attackBandwidthDistribution json format error :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            LOGGER.error((Object)"Concurrent is full!");
            return response;
        }
        try {
            HashMap<String, List<AttackTypeDistributeForm>> attackBandwidthDistributionFormList = new HashMap<String, List<AttackTypeDistributeForm>>();
            Map<String, List<String>> collectDevMap = this.getCollectorDeviceIpMap(attackTypeDistribution.getDeviceIpList());
            List<Object> zoneIdList = new ArrayList();
            if (!"admin".equals(userName) && ((zoneIdList = this.getZoneIdList(userName)) == null || zoneIdList.isEmpty())) {
                responseMsg = "attackBandwidthDistribution current user can zone info null, not query attack-bandwidth-distribution info data.";
                responseCode = 455;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                LOGGER.warn((Object)"this user have not zone!");
                return this.logExitFailed(logInfo);
            }
            for (Map.Entry<String, List<String>> map : collectDevMap.entrySet()) {
                DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
                datastatConditionForm.setDirection(1);
                String collectorIp = map.getKey();
                List<String> deviceIps = map.getValue();
                datastatConditionForm.setDeviceIpList(deviceIps);
                datastatConditionForm.setIsServiceGroup(false);
                datastatConditionForm.setBisId(0L);
                datastatConditionForm.setRestfulType(1);
                datastatConditionForm.setAbnormalType(attackTypeDistribution.getFlowType());
                datastatConditionForm.setStartTime(Long.valueOf(attackTypeDistribution.getStartTime()));
                datastatConditionForm.setEndTime(Long.valueOf(attackTypeDistribution.getEndTime()));
                datastatConditionForm.setZoneIdList(zoneIdList);
                datastatConditionForm.setSessionId(ProductFaceUtil.getInstance().getNextSessionId());
                Map<String, List<AttackTypeDistributeForm>> attackBandwidthDistributionList = this.getDeviceAttackBandwidthDistributionCounts(datastatConditionForm, collectorIp);
                if (null == attackBandwidthDistributionList || attackBandwidthDistributionList.isEmpty()) continue;
                for (Map.Entry<String, List<AttackTypeDistributeForm>> attackBandwidthSet : attackBandwidthDistributionList.entrySet()) {
                    if (attackBandwidthDistributionFormList.containsKey(attackBandwidthSet.getKey())) {
                        ((List)attackBandwidthDistributionFormList.get(attackBandwidthSet.getKey())).addAll((Collection)attackBandwidthSet.getValue());
                        continue;
                    }
                    attackBandwidthDistributionFormList.put(attackBandwidthSet.getKey(), attackBandwidthSet.getValue());
                }
            }
            StringBuilder resultStr = new StringBuilder();
            resultStr.append("{\"attackbandwidthlist\":[");
            for (Map.Entry attackBandwidthSet : attackBandwidthDistributionFormList.entrySet()) {
                List attackBandwidthDisList = (List)attackBandwidthSet.getValue();
                for (AttackTypeDistributeForm attackBandwidthDistributeForm : attackBandwidthDisList) {
                    resultStr.append("{\"device_ip\":\"").append((String)attackBandwidthSet.getKey()).append("\",").append("\"drop_bytes\":\"").append(attackBandwidthDistributeForm.getRestfulBandwidthName()).append("\",").append("\"attack_times\":").append(attackBandwidthDistributeForm.getCount()).append("},");
                }
            }
            if (attackBandwidthDistributionFormList.isEmpty()) {
                resultStr.append("]}");
                responseMsg = resultStr.toString();
            } else {
                responseMsg = resultStr.substring(0, resultStr.length() - 1) + "]}";
            }
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 570512L) {
                responseMsg = "query attack-bandwidth-distribution info no collector exist error.";
                responseCode = 500;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                LOGGER.error((Object)("LegoCheckedException attack-bandwidth-distribution info no collector exist error :" + e.getMessage()));
                return this.logExitFailed(logInfo);
            }
            responseMsg = "query attack-bandwidth-distribution info error.";
            responseCode = 500;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("attack-bandwidth-distribution info error:" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        catch (Exception e) {
            responseMsg = "query attack-bandwidth-distribution info error.";
            responseCode = 500;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("attack-bandwidth-distribution info error :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(responseCode + "," + responseMsg);
        return this.logExit(logInfo);
    }

    private Map<String, List<AttackTypeDistributeForm>> getDeviceAttackBandwidthDistributionCounts(DataStatConditionForm datastatConditionForm, String collectorIp) {
        Map<String, List<AttackTypeDistributeForm>> formListMap = null;
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            formListMap = this.dataStatService.restfulGetAttackBandwidthCountsDis(datastatConditionForm, collectorIp);
        }
        catch (Exception e) {
            LOGGER.error((Object)("attack-bandwidth-distribution rmi service error, Failed to connect to the collector,collectorIp = " + this.getcleanedMessage(collectorIp) + ". " + e.getMessage()));
        }
        return formListMap;
    }

    @Override
    @POST
    @Path(value="/attack-duration-distribution")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response attactDurationDistribution(String attackDurationDistributionJson) {
        LOGGER.info((Object)("attack-duration-distribution json: " + attackDurationDistributionJson));
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"v1/ddos/attack-duration-distribution");
        String requestMsg = "add attackDurationDistribution. restful request is null. json :" + attackDurationDistributionJson;
        String terminalIp = "";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"v1/ddos/attack-duration-distribution");
            requestMsg = "add attackDurationDistribution. restful request url : " + url + ". json :" + attackDurationDistributionJson;
            terminalIp = request.getRemoteAddr();
        }
        String apiName = "attackDurationDistribution";
        logInfo.setApiName(apiName);
        logInfo.setUrl(url);
        logInfo.setJson(attackDurationDistributionJson.replaceAll("\r|\n|\\s", ""));
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.attack.duration.distribution");
        int responseCode = 200;
        String responseMsg = "query attackTypeDistribution succeed";
        if (AticUtil.isNull((String)userName)) {
            responseMsg = "attack-duration-distribution illegal token.";
            responseCode = 412;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            return this.logExitFailed(logInfo);
        }
        LOGGER.info((Object)("attack-duration-distribution is Legal Token " + requestMsg));
        RestAttackTypeDistribution attackTypeDistribution = null;
        try {
            this.checkJson(attackDurationDistributionJson);
            attackTypeDistribution = (RestAttackTypeDistribution)JSONUtil.getInstance().fromJSON(attackDurationDistributionJson, RestAttackTypeDistribution.class);
            if (attackTypeDistribution == null) {
                throw new IllegalArgumentException("listInfo is Null");
            }
            List<String> deviceIpList = attackTypeDistribution.getDeviceIpList();
            Response response = this.attackCheckIpList(deviceIpList);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermission(userName, deviceIpList);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermission: The resource is illegal");
                return this.logExitFailed(logInfo);
            }
            response = this.checkStartEndTime(attackTypeDistribution.getStartTime(), attackTypeDistribution.getEndTime());
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"StartTime or EndTime is error");
                return this.logExitFailed(logInfo);
            }
            response = this.checkFlowType(attackTypeDistribution.getFlowType());
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkFlowType : Type is error ");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermissionOperation(userName, 2251L);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermissionOperation: Insufficient permissions");
                return this.logExitFailed(logInfo);
            }
        }
        catch (Exception e) {
            responseMsg = "attack-duration-distribution json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("attack-duration-distribution json format error :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            LOGGER.error((Object)"Concurrent is full!");
            return response;
        }
        try {
            HashMap<String, List<AttackTypeDistributeForm>> attackDurationDistributionListMap = new HashMap<String, List<AttackTypeDistributeForm>>();
            List<Object> zoneIdList = new ArrayList();
            if (!"admin".equals(userName) && ((zoneIdList = this.getZoneIdList(userName)) == null || zoneIdList.isEmpty())) {
                responseMsg = "attackDurationDistribution current user can zone info null, not query attack-duration-distribution info data.";
                responseCode = 455;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                LOGGER.warn((Object)"this user have not zone!");
                return this.logExitFailed(logInfo);
            }
            Map<String, List<String>> collectDevMap = this.getCollectorDeviceIpMap(attackTypeDistribution.getDeviceIpList());
            for (Map.Entry<String, List<String>> map : collectDevMap.entrySet()) {
                DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
                datastatConditionForm.setDirection(1);
                String collectorIp = map.getKey();
                List<String> deviceIps = map.getValue();
                datastatConditionForm.setDeviceIpList(deviceIps);
                datastatConditionForm.setIsServiceGroup(false);
                datastatConditionForm.setBisId(0L);
                datastatConditionForm.setRestfulType(1);
                datastatConditionForm.setAbnormalType(attackTypeDistribution.getFlowType());
                datastatConditionForm.setStartTime(Long.valueOf(attackTypeDistribution.getStartTime()));
                datastatConditionForm.setEndTime(Long.valueOf(attackTypeDistribution.getEndTime()));
                datastatConditionForm.setZoneIdList(zoneIdList);
                datastatConditionForm.setSessionId(ProductFaceUtil.getInstance().getNextSessionId());
                Map<String, List<AttackTypeDistributeForm>> attackDurationDistributionFormMap = this.getDeviceattAckDurationDistributionCounts(datastatConditionForm, collectorIp);
                if (null == attackDurationDistributionFormMap || attackDurationDistributionFormMap.isEmpty()) continue;
                for (Map.Entry<String, List<AttackTypeDistributeForm>> attackTypeSet : attackDurationDistributionFormMap.entrySet()) {
                    if (attackTypeSet.getValue().isEmpty()) continue;
                    if (attackDurationDistributionListMap.containsKey(attackTypeSet.getKey())) {
                        ((List)attackDurationDistributionListMap.get(attackTypeSet.getKey())).addAll((Collection)attackTypeSet.getValue());
                        continue;
                    }
                    attackDurationDistributionListMap.put(attackTypeSet.getKey(), attackTypeSet.getValue());
                }
            }
            StringBuilder resultStr = new StringBuilder();
            resultStr.append("{\"attackdurationlist\":[");
            for (Map.Entry attackDurationSet : attackDurationDistributionListMap.entrySet()) {
                List attackDurationList = (List)attackDurationSet.getValue();
                for (AttackTypeDistributeForm attackDurationForm : attackDurationList) {
                    resultStr.append("{\"device_ip\":\"").append((String)attackDurationSet.getKey()).append("\",").append("\"duration\":\"").append(attackDurationForm.getRestfulDurationName()).append("\",").append("\"attack_times\":").append(attackDurationForm.getCount()).append("},");
                }
            }
            if (attackDurationDistributionListMap.isEmpty()) {
                resultStr.append("]}");
                responseMsg = resultStr.toString();
            } else {
                responseMsg = resultStr.substring(0, resultStr.length() - 1) + "]}";
            }
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 570512L) {
                responseMsg = "query attack-duration-distribution info no collector exist error.";
                responseCode = 500;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                LOGGER.error((Object)("LegoCheckedException attack-duration-distribution info no collector exist :" + e.getMessage()));
                return this.logExitFailed(logInfo);
            }
            responseMsg = "query attack-duration-distribution info error.";
            responseCode = 500;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("Exception :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        catch (Exception e) {
            responseMsg = "query attack-duration-distribution info error.";
            responseCode = 500;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("attack-duration-distribution info error :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseDetail(responseCode + "," + responseMsg);
        return this.logExit(logInfo);
    }

    private Map<String, List<AttackTypeDistributeForm>> getDeviceattAckDurationDistributionCounts(DataStatConditionForm datastatConditionForm, String collectorIp) {
        Map<String, List<AttackTypeDistributeForm>> attAckDurationFormListMap = null;
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            attAckDurationFormListMap = this.dataStatService.restfulGetAttackDurationCountsDis(datastatConditionForm, collectorIp);
        }
        catch (Exception e) {
            LOGGER.error((Object)("getDeviceattAckDurationDistributionCounts rmi service error, Failed to connect to the collector,collectorIp = " + this.getcleanedMessage(collectorIp) + ". " + e.getMessage()));
        }
        return attAckDurationFormListMap;
    }

    @Override
    @POST
    @Path(value="/topncleanflow")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response topNCleanFlow(String top5CleanFlowJson) {
        Response response;
        LOGGER.info((Object)"begin RestReportServiceImpl.topNCleanFlow()...");
        RestLogInfo logInfo = new RestLogInfo();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"v1/ddos/topncleanflow");
        String requestMsg = "topncleanflow. restful request is null. json :" + top5CleanFlowJson;
        String terminalIp = "";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"v1/ddos/topncleanflow");
            requestMsg = "topncleanflow. restful request url : " + url + ". json :" + top5CleanFlowJson;
            LOGGER.info((Object)("topNCleanFlow requestMsg:" + requestMsg));
            terminalIp = request.getRemoteAddr();
        }
        String apiName = "topNCleanFlow";
        logInfo.setApiName(apiName);
        logInfo.setUrl(url);
        logInfo.setJson(top5CleanFlowJson.replaceAll("\r|\n|\\s", ""));
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("atic.restful.report.attack.topNCleanFlow");
        int responseCode = 200;
        String responseMsg = "query topNCleanFlow succeed";
        if (AticUtil.isNull((String)userName)) {
            responseMsg = "topNCleanFlow illegal token.";
            responseCode = 412;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            return this.logExitFailed(logInfo);
        }
        LOGGER.info((Object)("topNCleanFlow is Legal Token " + requestMsg));
        RestReportInfo listInfo = null;
        int topn = 10;
        try {
            this.checkJson(top5CleanFlowJson);
            listInfo = (RestReportInfo)JSONUtil.getInstance().fromJSON(top5CleanFlowJson, RestReportInfo.class);
            response = this.checkIpList(new ObjectMapper().writeValueAsString((Object)listInfo.getDeviceIpList()));
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkIpList: IpList is error!");
                return this.logExitFailed(logInfo);
            }
            if (!AticUtil.isNull((String)listInfo.getTopN())) {
                response = this.checkTopN(listInfo.getTopN());
                if (200 != response.getStatus()) {
                    logInfo.setResponseCode(response.getStatus());
                    logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                    logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                    LOGGER.error((Object)"checkTopN: TopN is error!");
                    return this.logExitFailed(logInfo);
                }
                topn = Integer.parseInt(listInfo.getTopN());
            }
            if (200 != (response = this.checkStartEndTime(listInfo.getStartTime(), listInfo.getEndTime())).getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"StartTime or EndTime is error");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermission(userName, Arrays.asList(listInfo.getDeviceIpList()));
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermission: The resource is illegal");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermissionOperation(userName, 2251L);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermissionOperation: Insufficient permissions");
                return this.logExitFailed(logInfo);
            }
        }
        catch (IOException e) {
            responseMsg = "topNCleanFlow json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("topNCleanFlow IOException :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            response = this.handleOverAPInvokeLimit(logInfo);
            LOGGER.error((Object)"Concurrent is full!");
            return response;
        }
        try {
            ArrayList<AttackFlowPeakTopNForm> dataList = new ArrayList<AttackFlowPeakTopNForm>();
            Map<String, List<String>> collectDevMap = this.getCollectorDeviceIpMap(Arrays.asList(listInfo.getDeviceIpList()));
            List<Object> zoneIdList = new ArrayList();
            if (!"admin".equals(userName) && (null == (zoneIdList = this.getZoneIdList(userName)) || zoneIdList.isEmpty())) {
                responseMsg = "topNCleanFlow current user can zone info null, not query topncleanflow info data.";
                responseCode = 455;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                LOGGER.warn((Object)"this user have not zone!");
                return this.logExitFailed(logInfo);
            }
            DataStatConditionForm datastatConditionForm = null;
            for (Map.Entry<String, List<String>> map : collectDevMap.entrySet()) {
                String collectorIp = map.getKey();
                datastatConditionForm = new DataStatConditionForm();
                datastatConditionForm.setDirection(1);
                datastatConditionForm.setDeviceIpList(map.getValue());
                datastatConditionForm.setTopn(topn);
                datastatConditionForm.setUnit(2);
                datastatConditionForm.setDevSerType(0);
                datastatConditionForm.setZoneIdList(zoneIdList);
                datastatConditionForm.setStartTime(Long.valueOf(listInfo.getStartTime()));
                datastatConditionForm.setEndTime(Long.valueOf(listInfo.getEndTime()));
                datastatConditionForm.setSessionId(ProductFaceUtil.getInstance().getNextSessionId());
                Map<String, List<AttackFlowPeakTopNForm>> attackTypeDisFormMap = this.dataStatService.getIpAttackFlowPeakTopN(datastatConditionForm, collectorIp);
                dataList.addAll(this.getAttackFlowPeakTopnFormList(attackTypeDisFormMap));
            }
            StringBuilder resultStr = new StringBuilder();
            resultStr.append("{\"topndroplist\":[");
            for (AttackFlowPeakTopNForm atPeakTopNForm : dataList) {
                resultStr.append("{\"device_ip\": \"").append(atPeakTopNForm.getDeviceIp());
                resultStr.append("\",\"ip\":\"").append(atPeakTopNForm.getZoneIp());
                resultStr.append("\",\"drop_kbps\":\"").append(atPeakTopNForm.getAttackFlowPeak());
                resultStr.append("\"},");
            }
            LOGGER.info((Object)("topNCleanFlow  resultStr:" + resultStr));
            if (dataList.size() > 0) {
                responseMsg = resultStr.substring(0, resultStr.length() - 1) + "]}";
            } else {
                resultStr.append("]}");
                responseMsg = resultStr.toString();
            }
            LOGGER.info((Object)("topnCleanFlow responseMsg: " + responseMsg));
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            return this.logExit(logInfo);
        }
        catch (LegoCheckedException e) {
            responseCode = 500;
            responseMsg = "query topNCleanFlow LegoCheckedException";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("topNCleanFlow.LegoCheckedException :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        catch (Exception e) {
            responseCode = 500;
            responseMsg = "query topNCleanFlow Exception";
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            LOGGER.error((Object)("topNCleanFlow.Exception :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
    }

    private List<AttackFlowPeakTopNForm> getAttackFlowPeakTopnFormList(Map<String, List<AttackFlowPeakTopNForm>> attackTypeDisFormMap) {
        ArrayList<AttackFlowPeakTopNForm> formList = new ArrayList<AttackFlowPeakTopNForm>();
        if (null != attackTypeDisFormMap) {
            for (Map.Entry<String, List<AttackFlowPeakTopNForm>> map : attackTypeDisFormMap.entrySet()) {
                formList.addAll((Collection<AttackFlowPeakTopNForm>)map.getValue());
            }
        }
        return formList;
    }

    @Override
    @POST
    @Path(value="/device-flow-info")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deviceFlowInfo(String deviceFlowInfoJson) {
        LOGGER.info((Object)"begin deviceFlowInfo()");
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        int responseCode = 500;
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"v1/ddos/device-flow-info");
        String requestMsg = "get device flow info. restful request is null. json string is :" + deviceFlowInfoJson + ". ";
        String terminalIp = "";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"v1/ddos/device-flow-info");
            requestMsg = "restful request url : " + url + ". json string is :" + deviceFlowInfoJson + ". ";
            terminalIp = request.getRemoteAddr();
            LOGGER.info((Object)("deviceFlowInfo requestMsg: " + requestMsg));
        }
        String responseMsg = "";
        String operationKey = "report.manager";
        String resultJsonKey = "deviceinflowlist";
        String jsonOneLine = String.valueOf(deviceFlowInfoJson).replaceAll("\r|\n", "");
        logInfo.setUrl(url);
        logInfo.setJson(jsonOneLine);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation(operationKey);
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        LOGGER.info((Object)("deviceFlowInfo is Legal Token " + requestMsg));
        RestReportInfo requestInfo = null;
        try {
            this.checkJson(deviceFlowInfoJson);
            requestInfo = (RestReportInfo)JSONUtil.getInstance().fromJSON(deviceFlowInfoJson, RestReportInfo.class);
            Response response = this.checkIpList(new ObjectMapper().writeValueAsString((Object)requestInfo.getDeviceIpList()));
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkIpList: IpList is error!");
                return this.logExitFailed(logInfo);
            }
            response = this.checkStartEndTime(requestInfo.getStartTime(), requestInfo.getEndTime());
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"StartTime or EndTime is error");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermission(userName, Arrays.asList(requestInfo.getDeviceIpList()));
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermission: The resource is illegal");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermissionOperation(userName, 2241L);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermissionOperation: Insufficient permissions");
                return this.logExitFailed(logInfo);
            }
        }
        catch (IOException e) {
            responseMsg = "json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation(operationKey);
            LOGGER.error((Object)("deviceFlowInfo IOException :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        String apiName = "deviceFlowInfo";
        logInfo.setApiName(apiName);
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            LOGGER.error((Object)"Concurrent is full!");
            return response;
        }
        String errorMessage = "get device flow info happen exception";
        try {
            List<String> deviceIpList = Arrays.asList(requestInfo.getDeviceIpList());
            Map<String, List<String>> collectDevMap = this.getCollectorDeviceIpMap(deviceIpList);
            IDataStatService statService = ReportAnalysisUtil.getDataStatService();
            ArrayList<RestReportDeviceFlow> deviceFlowList = new ArrayList<RestReportDeviceFlow>();
            FlowCompareConditionForm flowCompareConditionForm = new FlowCompareConditionForm();
            flowCompareConditionForm.initFlowCompareCondition();
            flowCompareConditionForm.setStartTime(Long.parseLong(requestInfo.getStartTime()));
            flowCompareConditionForm.setEndTime(Long.parseLong(requestInfo.getEndTime()));
            this.processQueryCondition(flowCompareConditionForm);
            flowCompareConditionForm.setUnit(0);
            if (!"admin".equals(userName)) {
                List<Long> zoneIdList = this.getZoneIdList(userName);
                if (null == zoneIdList || zoneIdList.isEmpty()) {
                    zoneIdList = new ArrayList<Long>();
                    zoneIdList.add(-1L);
                }
                flowCompareConditionForm.setZoneIdList(zoneIdList);
                flowCompareConditionForm.setSessionId(ProductFaceUtil.getInstance().getNextSessionId());
            }
            List<String> deviceList = null;
            String devIp = null;
            String collectorIp = null;
            List<FlowCompareForm> flowFormInOutList = null;
            List<FlowCompareForm> flowFormAttackList = null;
            List<RestReportDeviceFlow> flowList = null;
            ArrayList<String> iplist = new ArrayList<String>();
            for (Map.Entry<String, List<String>> map : collectDevMap.entrySet()) {
                deviceList = map.getValue();
                for (int i = 0; i < deviceList.size(); ++i) {
                    devIp = deviceList.get(i);
                    collectorIp = map.getKey();
                    iplist.clear();
                    iplist.add(devIp);
                    flowCompareConditionForm.setDeviceIpList(iplist);
                    flowCompareConditionForm.setDeviceType(1);
                    flowFormInOutList = statService.queryFlowCompare(flowCompareConditionForm, collectorIp);
                    flowCompareConditionForm.setDeviceType(0);
                    flowFormAttackList = statService.queryFlowCompare(flowCompareConditionForm, collectorIp);
                    LOGGER.info((Object)("flowFormInOutList.size=" + deviceFlowList.size() + "flowFormAttackList.size=" + flowFormAttackList.size()));
                    flowList = this.joinDeviceFlowInfo(devIp, flowFormInOutList, flowFormAttackList);
                    deviceFlowList.addAll(flowList);
                }
            }
            responseCode = 200;
            responseMsg = this.concatHeadJson(resultJsonKey, deviceFlowList);
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(String.valueOf(responseCode));
            logInfo.setOperation(operationKey);
            LOGGER.info((Object)("end deviceFlowInfo().size=" + deviceFlowList.size()));
            return this.logExit(logInfo);
        }
        catch (LegoCheckedException e) {
            responseCode = 500;
            responseMsg = errorMessage;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation(operationKey);
            LOGGER.error((Object)("deviceFlowInfo.LegoCheckedException :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        catch (IOException e) {
            responseCode = 500;
            responseMsg = errorMessage;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation(operationKey);
            LOGGER.error((Object)("deviceFlowInfo.IOException :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
    }

    private void processQueryCondition(FlowCompareConditionForm form) {
        Long endTime = this.compareSystemCurrentTime(form.getEndTime());
        Long startTimeTemp = this.compareSystemCurrentTime(form.getStartTime());
        startTimeTemp = startTimeTemp > endTime ? endTime : startTimeTemp;
        Long startTime = ReportAnalysisUtil.getRealStartTime(startTimeTemp, endTime);
        form.setStartTime(startTime);
        form.setEndTime(endTime);
        form.setTimeSpanType(ReportAnalysisUtil.getTimeSpanType(endTime, startTime));
    }

    private Long compareSystemCurrentTime(Long time) {
        Date date = new Date();
        Long currentTime = date.getTime() / 1000L;
        if (time > currentTime) {
            return currentTime;
        }
        return time;
    }

    private List<RestReportDeviceFlow> joinDeviceFlowInfo(String deviceIp, List<FlowCompareForm> inOutFlowList, List<FlowCompareForm> attackList) {
        ArrayList<RestReportDeviceFlow> resfult = new ArrayList<RestReportDeviceFlow>();
        if (inOutFlowList.isEmpty() && !attackList.isEmpty()) {
            for (int i = 0; i < attackList.size(); ++i) {
                RestReportDeviceFlow flow = new RestReportDeviceFlow();
                AticUtil.copyProperties((Object)attackList.get(i), (Object)flow);
                flow.setLogTime(null == flow.getLogTime() ? null : Long.valueOf(flow.getLogTime() / 1000L));
                resfult.add(flow);
            }
            return resfult;
        }
        if (!inOutFlowList.isEmpty() && attackList.isEmpty()) {
            for (int i = 0; i < inOutFlowList.size(); ++i) {
                RestReportDeviceFlow flow = new RestReportDeviceFlow();
                AticUtil.copyProperties((Object)inOutFlowList.get(i), (Object)flow);
                flow.setLogTime(null == flow.getLogTime() ? null : Long.valueOf(flow.getLogTime() / 1000L));
                resfult.add(flow);
            }
            return resfult;
        }
        HashMap<Long, FlowCompareForm> attackTimeFormMap = new HashMap<Long, FlowCompareForm>();
        for (FlowCompareForm flowForm : attackList) {
            attackTimeFormMap.put(flowForm.getLogTime(), flowForm);
        }
        for (int i = 0; i < inOutFlowList.size(); ++i) {
            FlowCompareForm inOutForm = inOutFlowList.get(i);
            RestReportDeviceFlow deviceFlow = new RestReportDeviceFlow();
            AticUtil.copyProperties((Object)inOutFlowList.get(i), (Object)deviceFlow);
            FlowCompareForm form = (FlowCompareForm)attackTimeFormMap.get(inOutForm.getLogTime());
            if (null != form) {
                deviceFlow.setMaxAttackFlow(form.getMaxAttackFlow());
                attackTimeFormMap.remove(inOutForm.getLogTime());
            }
            deviceFlow.setLogTime(null == deviceFlow.getLogTime() ? null : Long.valueOf(deviceFlow.getLogTime() / 1000L));
            resfult.add(deviceFlow);
        }
        for (Map.Entry attackTimeEntry : attackTimeFormMap.entrySet()) {
            FlowCompareForm form = (FlowCompareForm)attackTimeEntry.getValue();
            RestReportDeviceFlow deviceFlow = new RestReportDeviceFlow();
            deviceFlow.setDeviceIp(deviceIp);
            AticUtil.copyProperties((Object)form, (Object)deviceFlow);
            deviceFlow.setLogTime(null == deviceFlow.getLogTime() ? null : Long.valueOf(deviceFlow.getLogTime() / 1000L));
            resfult.add(deviceFlow);
        }
        return resfult;
    }

    @Override
    @POST
    @Path(value="/device-attack-info")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deviceAttackInfo(String deviceAttackInfoJson) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        int responseCode = 500;
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"v1/ddos/device-attack-info");
        String requestMsg = "get device attack info. restful request is null. json string is :" + deviceAttackInfoJson + ". ";
        String terminalIp = "";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"v1/ddos/device-attack-info");
            requestMsg = "restful request url : " + url + ". json string is :" + deviceAttackInfoJson + ". ";
            terminalIp = request.getRemoteAddr();
        }
        LOGGER.info((Object)("deviceAttackInfo requestMsg:" + requestMsg));
        String responseMsg = "";
        String operationKey = "atic.restful.report.attack.deviceAttackInfo";
        String resultJsonKey = "attackinfolist";
        String jsonOneLine = String.valueOf(deviceAttackInfoJson).replaceAll("\r|\n", "");
        logInfo.setUrl(url);
        logInfo.setJson(jsonOneLine);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation(operationKey);
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        LOGGER.info((Object)("deviceAttackInfo is Legal Token " + requestMsg));
        RestReportInfo requestInfo = null;
        try {
            this.checkJson(deviceAttackInfoJson);
            requestInfo = (RestReportInfo)JSONUtil.getInstance().fromJSON(deviceAttackInfoJson, RestReportInfo.class);
            Response response = this.checkIpList(new ObjectMapper().writeValueAsString((Object)requestInfo.getDeviceIpList()));
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkIpList: IpList is error!");
                return this.logExitFailed(logInfo);
            }
            response = this.checkStartEndTime(requestInfo.getStartTime(), requestInfo.getEndTime());
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"StartTime or EndTime is error");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermission(userName, Arrays.asList(requestInfo.getDeviceIpList()));
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermission: The resource is illegal");
                return this.logExitFailed(logInfo);
            }
            response = this.checkPermissionOperation(userName, 2251L);
            if (200 != response.getStatus()) {
                logInfo.setResponseCode(response.getStatus());
                logInfo.setResponseMsg(String.valueOf(response.getEntity()));
                logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
                LOGGER.error((Object)"checkPermissionOperation: Insufficient permissions");
                return this.logExitFailed(logInfo);
            }
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation(operationKey);
            LOGGER.error((Object)("deviceAttackInfo exception :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        String apiName = "deviceAttackInfo";
        logInfo.setApiName(apiName);
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            Response response = this.handleOverAPInvokeLimit(logInfo);
            LOGGER.error((Object)"Concurrent is full!");
            return response;
        }
        String errorMessage = "get device attack info happen exception";
        IAticDeviceService deviceService = ZoneBisUtil.getIFirewallService();
        try {
            List<String> deviceIpList = Arrays.asList(requestInfo.getDeviceIpList());
            Map<String, List<String>> collectDevMap = this.getCollectorDeviceIpMap(deviceIpList);
            List<Object> zoneIdList = new ArrayList();
            if (!"admin".equals(userName) && ((zoneIdList = this.getZoneIdList(userName)) == null || zoneIdList.isEmpty())) {
                responseMsg = "deviceAttackInfo current user can zone info null, not query device attack info data.";
                responseCode = 455;
                logInfo.setResponseMsg(responseMsg);
                logInfo.setResponseCode(responseCode);
                logInfo.setResponseDetail(responseCode + "," + responseMsg);
                LOGGER.warn((Object)"this user have not zone!");
                return this.logExitFailed(logInfo);
            }
            IDataStatService statService = ReportAnalysisUtil.getDataStatService();
            ArrayList<RestReportDeviceAttackData> deviceAttackDataList = new ArrayList<RestReportDeviceAttackData>();
            DataStatConditionForm attackLogConditionForm = new DataStatConditionForm();
            attackLogConditionForm.setStartTime(Long.parseLong(requestInfo.getStartTime()));
            attackLogConditionForm.setEndTime(Long.parseLong(requestInfo.getEndTime()));
            attackLogConditionForm.setTimeSpanType(ReportAnalysisUtil.getTimeSpanType(Long.parseLong(requestInfo.getEndTime()), Long.parseLong(requestInfo.getStartTime())));
            attackLogConditionForm.setDirection(1);
            attackLogConditionForm.setZoneIdList(zoneIdList);
            attackLogConditionForm.setSessionId(ProductFaceUtil.getInstance().getNextSessionId());
            attackLogConditionForm.setUnit(0);
            List<String> deviceList = null;
            String devIp = null;
            String collectorIp = null;
            List<DeviceAttackDataForm> devAttackForms = null;
            AticDevice device = null;
            for (Map.Entry<String, List<String>> map : collectDevMap.entrySet()) {
                deviceList = map.getValue();
                for (int i = 0; i < deviceList.size(); ++i) {
                    devIp = deviceList.get(i);
                    collectorIp = map.getKey();
                    attackLogConditionForm.setDeviceIpList(map.getValue());
                    attackLogConditionForm.setDeviceIp(devIp);
                    device = deviceService.getDeviceByIp(devIp);
                    attackLogConditionForm.setDeviceId(device.getMoId());
                    attackLogConditionForm.setDevSerType(0);
                    devAttackForms = statService.getDeviceAttackData(attackLogConditionForm, collectorIp);
                    for (int j = 0; j < devAttackForms.size(); ++j) {
                        RestReportDeviceAttackData devAttData = new RestReportDeviceAttackData();
                        this.reverseFormToData(devAttackForms.get(j), devAttData, attackLogConditionForm.getTimeSpanType());
                        deviceAttackDataList.add(devAttData);
                    }
                }
            }
            responseCode = 200;
            responseMsg = this.concatHeadJson(resultJsonKey, deviceAttackDataList);
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(String.valueOf(responseCode));
            logInfo.setOperation(operationKey);
            return this.logExit(logInfo);
        }
        catch (LegoCheckedException e) {
            responseCode = 500;
            responseMsg = errorMessage;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation(operationKey);
            LOGGER.error((Object)("deviceAttackInfo LegoCheckedException :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        catch (IOException e) {
            responseCode = 500;
            responseMsg = errorMessage;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation(operationKey);
            LOGGER.error((Object)("deviceAttackInfo IOException:" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
    }

    private void reverseFormToData(DeviceAttackDataForm deviceAttackData, RestReportDeviceAttackData devAttData, Integer timeSpanType) {
        devAttData.setDeviceIp(deviceAttackData.getDeviceIp());
        devAttData.setDateTime(deviceAttackData.getLogTime());
        devAttData.setAttackTimes(deviceAttackData.getAttackCount());
        devAttData.setDropKbps(deviceAttackData.getMaxAttackFlow());
        long bitToByte = 8L;
        switch (timeSpanType) {
            case 0: {
                devAttData.setDropBytes(deviceAttackData.getAttackFlow() * 60L * 5L / bitToByte);
                break;
            }
            case 1: {
                devAttData.setDropBytes(deviceAttackData.getAttackFlow() * 60L * 60L / bitToByte);
                break;
            }
            case 2: {
                devAttData.setDropBytes(deviceAttackData.getAttackFlow() * 60L * 60L * 24L / bitToByte);
                break;
            }
            default: {
                devAttData.setDropBytes(deviceAttackData.getAttackFlow() * 300L / bitToByte);
            }
        }
    }

    @Override
    @GET
    @Path(value="/devices")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deviceList() {
        LOGGER.info((Object)"deviceList begin!");
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestLogInfo logInfo = new RestLogInfo();
        int responseCode = 500;
        HttpServletRequest request = ServletActionContext.getRequest();
        String userName = RestAuthUtil.isLegalToken((HttpServletRequest)request, (String)"v1/ddos/devices");
        String requestMsg = "get device list. restful request is null. ";
        String terminalIp = "";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"v1/ddos/devices");
            requestMsg = "restful request url : " + url + ". ";
            terminalIp = request.getRemoteAddr();
        }
        String jsonOneLine = "";
        String responseMsg = "";
        logInfo.setUrl(url);
        logInfo.setJson(jsonOneLine);
        logInfo.setUserName(userName);
        logInfo.setTerminalIp(terminalIp);
        logInfo.setOperation("lego.dic.module.ResourceApplication");
        if (AticUtil.isNull((String)userName)) {
            responseCode = 412;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"illegal token.");
            responseBuilder = responseBuilder.status(responseCode);
            responseBuilder.entity((Object)"illegal token.");
            return responseBuilder.build();
        }
        LOGGER.info((Object)("is Legal Token " + requestMsg));
        Response response = this.checkPermissionOperation(userName, 2002L);
        if (200 != response.getStatus()) {
            logInfo.setResponseCode(response.getStatus());
            logInfo.setResponseMsg(String.valueOf(response.getEntity()));
            logInfo.setResponseDetail(response.getStatus() + "," + response.getEntity());
            LOGGER.error((Object)"checkPermissionOperation: Insufficient permissions");
            return this.logExitFailed(logInfo);
        }
        String apiName = "deviceList";
        logInfo.setApiName(apiName);
        if (!VsmUtil.getInstance().acquireApiInvoke(apiName).booleanValue()) {
            response = this.handleOverAPInvokeLimit(logInfo);
            return response;
        }
        String getdeviceError = "get device list happen exception";
        IAticDeviceService aticDeviceService = ZoneBisUtil.getIFirewallService();
        try {
            IUserService userService = (IUserService)ServiceContext.getInstance().getService("userService", IUserService.class);
            UserInfo userInfoByName = userService.getUserInfoByName(userName, false);
            ArrayList<RestReportDevice> restReportDevices = new ArrayList<RestReportDevice>();
            List deviceList = aticDeviceService.getAllDevice(userInfoByName.getId().longValue(), userInfoByName.isIsAdmin());
            AticDevice aticDevice = null;
            for (int i = 0; i < deviceList.size(); ++i) {
                RestReportDevice restDevice = new RestReportDevice();
                aticDevice = (AticDevice)deviceList.get(i);
                AticUtil.copyProperties((Object)aticDevice, (Object)restDevice);
                restReportDevices.add(restDevice);
            }
            responseCode = 200;
            responseMsg = this.concatHeadJson("devicelist", restReportDevices);
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(String.valueOf(responseCode));
            logInfo.setOperation("lego.dic.module.ResourceApplication");
            LOGGER.info((Object)"deviceList end!");
            return this.logExit(logInfo);
        }
        catch (LegoCheckedException e) {
            responseCode = 500;
            responseMsg = getdeviceError;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("lego.dic.module.ResourceApplication");
            LOGGER.error((Object)("deviceList LegoCheckedException :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
        catch (Exception e) {
            responseCode = 500;
            responseMsg = getdeviceError;
            logInfo.setResponseMsg(responseMsg);
            logInfo.setResponseCode(responseCode);
            logInfo.setResponseDetail(responseCode + "," + responseMsg);
            logInfo.setOperation("lego.dic.module.ResourceApplication");
            LOGGER.error((Object)("deviceList Exception :" + e.getMessage()));
            return this.logExitFailed(logInfo);
        }
    }

    private void checkJson(String json) {
        if (null != json && json.trim().length() > 5000) {
            throw new IllegalArgumentException("the parameters of json is more than 5000.");
        }
    }

    private String concatHeadJson(String resultKey, Object object) throws IOException {
        String objectJson = JSONUtil.getInstance().toJSON(object);
        return "{\"" + resultKey + "\":" + objectJson + "}";
    }

    private Response handleOverAPInvokeLimit(RestLogInfo logInfo) {
        int responseCode = 423;
        String responseMsg = "exceed concurrent api call limit.";
        logInfo.setResponseCode(responseCode);
        logInfo.setResponseMsg(responseMsg);
        logInfo.setResponseDetail(responseCode + "," + responseMsg);
        return this.logExit(logInfo);
    }

    private Response logExit(RestLogInfo logInfo) {
        VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)logInfo.getResponseCode(), (String)logInfo.getResponseMsg());
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(logInfo.getResponseCode());
        responseBuilder.entity((Object)logInfo.getResponseMsg());
        return responseBuilder.build();
    }

    private Response logExitFailed(RestLogInfo logInfo) {
        if (null != logInfo.getApiName()) {
            VsmUtil.getInstance().releaseApiInvoke(logInfo.getApiName());
        }
        RestUtil.processSysLog((String)logInfo.getRequestMsg(), (int)logInfo.getResponseCode(), (String)logInfo.getResponseMsg());
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(logInfo.getResponseCode());
        HashMap<String, String> responseObj = new HashMap<String, String>();
        responseObj.put("errorCode", logInfo.getResponseCode() + "");
        responseObj.put("errorMsg", logInfo.getResponseMsg());
        try {
            responseBuilder.entity((Object)JSONUtil.getInstance().toJSON(responseObj));
        }
        catch (IOException e) {
            LOGGER.error((Object)("logExitThird obj to json error obj : " + responseObj));
        }
        return responseBuilder.build();
    }

    private Response checkIpList(String deviceIpList) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(400);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.disableDefaultTyping();
        List array = null;
        try {
            array = (List)mapper.readValue(deviceIpList, List.class);
        }
        catch (IOException io) {
            responseBuilder.entity((Object)"json format error.");
            return responseBuilder.build();
        }
        if (array.isEmpty()) {
            responseBuilder.entity((Object)"deviceipList is null.");
            return responseBuilder.build();
        }
        if (array.size() > 5) {
            responseBuilder.entity((Object)"deviceipList is over than max count 5");
            return responseBuilder.build();
        }
        ArrayList<String> deviceList = new ArrayList<String>();
        String ip = null;
        for (int i = 0; i < array.size(); ++i) {
            ip = (String)array.get(i);
            if (!IPUtil.isIpv4((String)ip)) {
                responseBuilder.entity((Object)("deviceipList ip " + ip + " is not a ip."));
                return responseBuilder.build();
            }
            if (deviceList.contains(ip)) {
                responseBuilder.entity((Object)("deviceipList ip " + ip + " is duplicate."));
                return responseBuilder.build();
            }
            deviceList.add(ip);
        }
        responseBuilder = responseBuilder.status(200);
        responseBuilder.entity((Object)"");
        return responseBuilder.build();
    }

    private Response checkTopN(String topN) {
        String regex;
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(400);
        if (StringUtils.isEmpty((String)topN)) {
            responseBuilder.entity((Object)"topN is null.");
            return responseBuilder.build();
        }
        if (!(topN = topN.trim()).matches(regex = "^\\d+$")) {
            responseBuilder.entity((Object)"topN is not a number.");
            return responseBuilder.build();
        }
        Integer number = Integer.parseInt(topN);
        if (1 > number || number > 50) {
            responseBuilder.entity((Object)"topN is not range 1 to 50.");
            return responseBuilder.build();
        }
        responseBuilder = responseBuilder.status(200);
        responseBuilder.entity((Object)"");
        return responseBuilder.build();
    }

    private Response checkTimeLong(String currentTime) {
        String regex;
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(400);
        if (StringUtils.isEmpty((String)currentTime)) {
            responseBuilder.entity((Object)"time is null.");
            return responseBuilder.build();
        }
        if (!(currentTime = currentTime.trim()).matches(regex = "^\\d+$")) {
            responseBuilder.entity((Object)"time is not a number.");
            return responseBuilder.build();
        }
        Long number = Long.parseLong(currentTime);
        if (0L > number) {
            responseBuilder.entity((Object)"time is samaller than zero.");
            return responseBuilder.build();
        }
        responseBuilder = responseBuilder.status(200);
        responseBuilder.entity((Object)"");
        return responseBuilder.build();
    }

    private Response checkStartEndTime(String startTime, String endTime) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(400);
        Response startTimeResponse = this.checkTimeLong(startTime);
        if (200 != startTimeResponse.getStatus()) {
            responseBuilder.entity((Object)("start " + startTimeResponse.getEntity()));
            return responseBuilder.build();
        }
        Response endTimeResponse = this.checkTimeLong(endTime);
        if (200 != endTimeResponse.getStatus()) {
            responseBuilder.entity((Object)("end " + endTimeResponse.getEntity()));
            return responseBuilder.build();
        }
        if (Long.parseLong(startTime) > Long.parseLong(endTime)) {
            responseBuilder.entity((Object)"start time is bigger than end time");
            return responseBuilder.build();
        }
        responseBuilder = responseBuilder.status(200);
        responseBuilder.entity((Object)"");
        return responseBuilder.build();
    }

    private Response checkPermission(String userName, List<String> ipList) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(200);
        IAticDeviceService aticDeviceService = ZoneBisUtil.getIFirewallService();
        try {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            AticDevice aticDevice = null;
            String ip = null;
            for (int i = 0; i < ipList.size(); ++i) {
                ip = ipList.get(i);
                aticDevice = aticDeviceService.getDeviceByIp(ip);
                if (null == aticDevice) {
                    responseBuilder.status(404);
                    responseBuilder.entity((Object)("device " + ip + " is not existed."));
                    return responseBuilder.build();
                }
                moIdList.add(aticDevice.getMoId());
            }
            IUserService userService = (IUserService)ServiceContext.getInstance().getService("userService", IUserService.class);
            UserInfo userInfoByName = userService.getUserInfoByName(userName, false);
            if (!userInfoByName.isIsAdmin()) {
                BisUtil.checkRestfulUserSecurity(moIdList, (long)userInfoByName.getId(), (boolean)userInfoByName.isIsAdmin());
            }
        }
        catch (LegoCheckedException e) {
            responseBuilder.status(455);
            responseBuilder.entity((Object)"The current user does not have the resources for this.");
            return responseBuilder.build();
        }
        return responseBuilder.build();
    }

    private Response checkPermissionOperation(String userName, Long operationId) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder = responseBuilder.status(200);
        if (!"admin".equals(userName)) {
            if (null == this.permissionService) {
                responseBuilder.status(500);
                responseBuilder.entity((Object)"permission service null.");
                LOGGER.error((Object)"permission service null.");
                return responseBuilder.build();
            }
            List operationIds = this.permissionService.queryUserOperationId(userName);
            if (null == operationIds || !operationIds.contains(operationId)) {
                responseBuilder.status(455);
                responseBuilder.entity((Object)"current user can not permission query");
                LOGGER.error((Object)"current user can not permission query");
                return responseBuilder.build();
            }
        }
        return responseBuilder.build();
    }

    public IPermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(IPermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public IDataStatService getDataStatService() {
        return this.dataStatService;
    }

    public void setDataStatService(IDataStatService dataStatService) {
        this.dataStatService = dataStatService;
    }
}

