/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.alarm.entity;

import com.hs.atic.collector.entity.alarm.AbnormalAlarmEntity;
import com.hs.atic.collector.entity.alarm.DynBlistAlarmEntity;
import com.hs.atic.collector.entity.alarm.IPReputationEntity;
import com.hs.atic.collector.entity.alarm.IpAlarmEntity;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class ZoneAlarmEntityBuffer {
    private static final int CURRENT_SIZE = 100;
    private static final int MAX_SIZE = 10000;
    protected ReentrantLock lock = new ReentrantLock();
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private List<IpAlarmEntity> zoneAlarmList = new ArrayList<IpAlarmEntity>();
    private List<IpAlarmEntity> zoneBlackholeAlarmList = new ArrayList<IpAlarmEntity>();
    private List<IpAlarmEntity> zoneDivertAlarmList = new ArrayList<IpAlarmEntity>();
    private List<DynBlistAlarmEntity> dynBlackAlarmList = new ArrayList<DynBlistAlarmEntity>();
    private List<AbnormalAlarmEntity> advancedAlarmList = new ArrayList<AbnormalAlarmEntity>();
    private List<IPReputationEntity> ipReputationList = new ArrayList<IPReputationEntity>();

    public List<IpAlarmEntity> getZoneAlarmList() {
        this.lock.lock();
        try {
            ArrayList<IpAlarmEntity> result = new ArrayList<IpAlarmEntity>();
            if (this.zoneAlarmList.size() <= 100) {
                result = this.zoneAlarmList;
                this.zoneAlarmList = new ArrayList<IpAlarmEntity>();
            } else {
                result.addAll(this.zoneAlarmList.subList(0, 100));
                this.zoneAlarmList.subList(0, 100).clear();
            }
            ArrayList<IpAlarmEntity> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<IpAlarmEntity> getZoneBlackholeAlarmList() {
        this.lock.lock();
        try {
            List<IpAlarmEntity> result = this.zoneBlackholeAlarmList;
            this.zoneBlackholeAlarmList = new ArrayList<IpAlarmEntity>();
            List<IpAlarmEntity> list = result;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<AbnormalAlarmEntity> getAdvancedAlarmList() {
        this.lock.lock();
        try {
            List<AbnormalAlarmEntity> result = this.advancedAlarmList;
            this.advancedAlarmList = new ArrayList<AbnormalAlarmEntity>();
            List<AbnormalAlarmEntity> list = result;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<IpAlarmEntity> getZoneDivertAlarmList() {
        this.lock.lock();
        try {
            List<IpAlarmEntity> result = this.zoneDivertAlarmList;
            this.zoneDivertAlarmList = new ArrayList<IpAlarmEntity>();
            List<IpAlarmEntity> list = result;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addZoneAlarmList(List<IpAlarmEntity> entities) {
        List<IpAlarmEntity> list = this.zoneAlarmList;
        synchronized (list) {
            if (this.zoneAlarmList.size() + entities.size() > 10000) {
                this.zoneAlarmList.addAll(entities.subList(0, 10000 - this.zoneAlarmList.size()));
                this.logger.warn((Object)("the entities has been over 10000, zoneAlarmList size is: " + this.zoneAlarmList.size() + "entities size is " + entities.size() + entities.subList(entities.size() + this.zoneAlarmList.size() - 10000, entities.size())));
            } else {
                this.zoneAlarmList.addAll(entities);
                this.logger.warn((Object)("the zoneAlarmList size is," + this.zoneAlarmList.size() + "the entities size is," + entities.size()));
            }
        }
    }

    public List<DynBlistAlarmEntity> getDynBlackAlarmList() {
        this.lock.lock();
        try {
            List<DynBlistAlarmEntity> result = this.dynBlackAlarmList;
            this.dynBlackAlarmList = new ArrayList<DynBlistAlarmEntity>();
            List<DynBlistAlarmEntity> list = result;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDynBlackAlarmList(List<DynBlistAlarmEntity> dynBlackAlarmList) {
        this.dynBlackAlarmList = dynBlackAlarmList;
    }

    public void addDynBlackList(List<DynBlistAlarmEntity> entities) {
        this.dynBlackAlarmList.addAll(entities);
    }

    public void addZoneBlackholeAlarmList(List<IpAlarmEntity> alarmList) {
        this.lock.lock();
        try {
            this.zoneBlackholeAlarmList.addAll(alarmList);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addAdvancedAlarmList(List<AbnormalAlarmEntity> alarmList) {
        this.lock.lock();
        try {
            this.advancedAlarmList.addAll(alarmList);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addZoneDivertAlarmList(List<IpAlarmEntity> alarmList) {
        this.lock.lock();
        try {
            this.zoneDivertAlarmList.addAll(alarmList);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addIpreputationList(List<IPReputationEntity> ipReputationEntitys) {
        this.lock.lock();
        try {
            this.ipReputationList.addAll(ipReputationEntitys);
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<IPReputationEntity> getIpReputationList() {
        this.lock.lock();
        try {
            List<IPReputationEntity> result = this.ipReputationList;
            this.ipReputationList = new ArrayList<IPReputationEntity>();
            List<IPReputationEntity> list = result;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }
}

