/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.intelligentdefense.entity.LogicOperator;
import com.hs.atic.intelligentdefense.entity.Operator;
import com.hs.atic.intelligentdefense.entity.StreamMonitorMeasureName;
import com.hs.atic.intelligentdefense.entity.StreamMonitorRule;
import com.hs.atic.intelligentdefense.entity.StreamMonitorRuleConditionRelationship;
import com.hs.atic.intelligentdefense.entity.StreamMonitorRuleDetail;
import com.hs.atic.intelligentdefense.impl.StreamMonitorRuleManager;
import com.hs.atic.sdk.util.StringUtils;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.opensymphony.xwork2.ActionContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MissFaultDefenseAction
extends BaseAction {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final long serialVersionUID = 2608554002049862812L;
    private static final String SESSION_MISS_DEFENSE_KEY = "missDefenseKeyList";
    private static final String SESSION_FAULT_DEFENSE_KEY = "faultDefenseKeyList";
    private static final int MODE_MISS = 0;
    private static final int MODE_FAULT = 1;
    private static final String FAILED_NOTIFY_COLLECTOR = "failNotify";
    private static final String FAILED_WITH_RULE_EXISTED = "isExist";
    private static final String OPERATION_ADD = "add";
    private static final String OPERATION_EDIT = "edit";
    private static final String OPERATION_DELETE = "delete";
    private transient StreamMonitorRuleManager streamMonitorRuleManager = null;
    private transient IZonePolicyApplyService zonePolicyApplyService;
    private transient ISysOptLog sysLogService;
    private List<StreamMonitorRule> missFaultDefenseList = new ArrayList<StreamMonitorRule>();
    private List<StreamMonitorRule> missFaultRuleForZoneList = new ArrayList<StreamMonitorRule>();
    private String ruleIds;
    private List<StreamMonitorRuleConditionRelationship> streamMonitorRuleConditionForms = new ArrayList<StreamMonitorRuleConditionRelationship>();
    private StreamMonitorRule streamMonitorRule = null;
    private List<LangPair> modeList;
    private Integer mode = 0;
    private List<LangPair> measureNameList;
    private String measureNameListString;
    private String attackIdArray;
    private List<LangPair> operatorList;
    private List<LangPair> ralationList;
    private List<LangPair> groupIndexList;
    private int operator = 0;
    private String relation = "AND";
    private int id = 0;
    private String itemLogicRelationResult;
    private String itemLogicRelationResultSave;
    private String itemData;
    private String itemGgroupData;
    private List<ZonePolicyApplyForm> zonePolicyFormList;
    private String zoneIds;
    private Integer[] ids;
    private String[] names;
    private String ruleName;

    public String listMissFaultDefense() {
        List rules;
        Paging page = this.streamMonitorRuleManager.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.missFaultDefenseList = rules = page.getData();
        this.total = page.getCount();
        return "success";
    }

    public String listMissFaultDefenseForZone() {
        List<StreamMonitorRule> rules = this.streamMonitorRuleManager.getAllRules();
        if (null != this.ruleIds && !this.ruleIds.isEmpty()) {
            String[] currentIds = this.ruleIds.split(",");
            this.missFaultRuleForZoneList = new ArrayList<StreamMonitorRule>();
            if (0 < rules.size()) {
                for (StreamMonitorRule ruleForm : rules) {
                    boolean isExist = false;
                    for (String currentId : currentIds) {
                        if (!ruleForm.getId().toString().equals(currentId)) continue;
                        isExist = true;
                    }
                    if (isExist) continue;
                    this.missFaultRuleForZoneList.add(ruleForm);
                }
            }
        } else {
            this.missFaultRuleForZoneList = rules;
        }
        this.total = this.missFaultRuleForZoneList.size();
        return "success";
    }

    private Map<String, String> createQueryMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("ruleName", this.ruleName);
        return queryMap;
    }

    public String pagingDefenseKey() {
        List<StreamMonitorRuleConditionRelationship> temp = this.getSessionDefenseKey(this.mode);
        if (temp != null) {
            this.total = temp.size();
            this.streamMonitorRuleConditionForms = temp;
            String[] arr = this.generateRelationResult(this.mode, temp);
            this.itemLogicRelationResult = arr[0];
            this.itemLogicRelationResultSave = arr[1];
        } else {
            this.total = 0;
        }
        return "success";
    }

    private List<StreamMonitorRuleConditionRelationship> getSessionDefense() {
        String sessionId = this.getSession().getId();
        ArrayList<StreamMonitorRuleConditionRelationship> ships = new ArrayList<StreamMonitorRuleConditionRelationship>();
        List missList = (List)this.getSession().getAttribute(SESSION_MISS_DEFENSE_KEY + sessionId);
        List faultList = (List)this.getSession().getAttribute(SESSION_FAULT_DEFENSE_KEY + sessionId);
        if (null != missList && missList.size() > 0) {
            ships.addAll(missList);
        }
        if (null != faultList && faultList.size() > 0) {
            ships.addAll(faultList);
        }
        return ships;
    }

    private List<StreamMonitorRuleConditionRelationship> getSessionDefenseKey(int modeType) {
        String sessionId = this.getSession().getId();
        if (0 == modeType) {
            return (List)this.getSession().getAttribute(SESSION_MISS_DEFENSE_KEY + sessionId);
        }
        return (List)this.getSession().getAttribute(SESSION_FAULT_DEFENSE_KEY + sessionId);
    }

    public void checkDefenseKeyHasData() {
        List<StreamMonitorRuleConditionRelationship> ships = null;
        ships = 0 == this.mode ? this.getSessionDefenseKey(1) : this.getSessionDefenseKey(0);
        if (null != ships && ships.size() > 0) {
            this.responseResult("true");
        } else {
            this.responseResult("false");
        }
    }

    public String createMissFaultDefenseConfig() {
        this.initSessionDefenseKey();
        this.streamMonitorRule = new StreamMonitorRule();
        return "success";
    }

    private void sortRuleRelationshipByGroup(StreamMonitorRuleDetail detail) {
        Comparator comparator = (r1, r2) -> r1.getGroupId() - r2.getGroupId();
        comparator = comparator.thenComparing((r1, r2) -> r1.getConditionInGroupId() - r2.getConditionInGroupId());
        Collections.sort(detail.getConditionRelationships(), comparator);
    }

    public String editMissFaultDefenseConfig() {
        StreamMonitorRuleDetail detail = this.streamMonitorRuleManager.getRuleDetail(this.id);
        this.sortRuleRelationshipByGroup(detail);
        this.streamMonitorRule = new StreamMonitorRule();
        this.streamMonitorRule.setId(detail.getRuleId());
        this.streamMonitorRule.setRuleName(detail.getRuleName());
        this.streamMonitorRule.setDescription(detail.getDescription());
        List<StreamMonitorRuleConditionRelationship> relationshipList = detail.getConditionRelationships();
        if (null != relationshipList && relationshipList.size() > 0) {
            this.streamMonitorRuleConditionForms.addAll(relationshipList);
        }
        this.zonePolicyApplyService = (IZonePolicyApplyService)ServiceContext.getInstance().getService("zonePolicyApplyService", IZonePolicyApplyService.class);
        List<Long> zoneIdList = detail.getZoneIds();
        if (null != zoneIdList && zoneIdList.size() > 0) {
            this.zonePolicyFormList = new ArrayList<ZonePolicyApplyForm>();
            for (int i = 0; i < zoneIdList.size(); ++i) {
                ZonePolicyApplyForm f = this.zonePolicyApplyService.queryOnlyZonePolicy(zoneIdList.get(i));
                this.zonePolicyFormList.add(f);
            }
        }
        this.total = this.streamMonitorRuleConditionForms.size();
        this.initSessionDefenseKey();
        return "success";
    }

    private void initSessionDefenseKey() {
        if (this.streamMonitorRuleConditionForms.size() > 0) {
            ArrayList<StreamMonitorRuleConditionRelationship> missList = new ArrayList<StreamMonitorRuleConditionRelationship>();
            ArrayList<StreamMonitorRuleConditionRelationship> faultList = new ArrayList<StreamMonitorRuleConditionRelationship>();
            for (int i = 0; i < this.streamMonitorRuleConditionForms.size(); ++i) {
                StreamMonitorRuleConditionRelationship ship;
                ship.setOperatorString(Operator.LessEqualThan == (ship = this.streamMonitorRuleConditionForms.get(i)).getOperator() ? "<=" : ">=");
                if (null != ship.getType() && 0 == ship.getType()) {
                    missList.add(ship);
                    continue;
                }
                faultList.add(ship);
            }
            this.setSessionMissKey(missList);
            this.setSessionFaultKey(faultList);
        } else {
            this.clearSessionDefenseKey();
        }
    }

    public boolean validateNames() {
        if (null != this.names) {
            if (this.names.length > 100) {
                return false;
            }
            for (int i = 0; i < this.names.length; ++i) {
                String nameRegex = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}[\\s|\\w]*$";
                if (null == this.names[i] || this.names[i].matches(nameRegex)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean validateRuleName(String strRuleName) {
        if (null != strRuleName) {
            if (strRuleName.length() > 64) {
                return false;
            }
            String nameRegex = "^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}[\\s|\\w]*$";
            return strRuleName.matches(nameRegex);
        }
        return false;
    }

    public boolean validateRuleIds() {
        if (StringUtils.isBlank(this.ruleIds)) {
            return true;
        }
        String Regex = "^[0-9,]*$";
        if (!this.ruleIds.matches(Regex)) {
            return false;
        }
        return this.ruleIds.split(",").length <= 10000;
    }

    private void clearSessionDefenseKey() {
        this.setSessionMissKey(null);
        this.setSessionFaultKey(null);
    }

    private void setSessionMissKey(List<StreamMonitorRuleConditionRelationship> list) {
        String sessionId = this.getSession().getId();
        this.getSession().setAttribute(SESSION_MISS_DEFENSE_KEY + sessionId, list);
    }

    private void setSessionFaultKey(List<StreamMonitorRuleConditionRelationship> list) {
        String sessionId = this.getSession().getId();
        this.getSession().setAttribute(SESSION_FAULT_DEFENSE_KEY + sessionId, list);
    }

    public String configMissFaultDefenseItem() {
        List<StreamMonitorMeasureName> ship = this.streamMonitorRuleManager.getMeasuresByType(this.mode);
        this.initMeasure(ship);
        return "success";
    }

    public void saveMissFaultDefenseItem() {
        ArrayList<StreamMonitorRuleConditionRelationship> temp = null;
        ArrayList<String> groupIds = new ArrayList<String>();
        String[] itemGgroupDataArr = null;
        if (null != this.itemGgroupData) {
            itemGgroupDataArr = this.itemGgroupData.split("!|,|;");
            for (int i = 0; i < itemGgroupDataArr.length; ++i) {
                if ("".equals(itemGgroupDataArr[i]) || i % 2 == 0) continue;
                groupIds.add(itemGgroupDataArr[i]);
            }
        }
        String[] itemsDataArr = null;
        String[] itemDataArr = null;
        String logicChar = null;
        if (null != this.itemData && !"".equals(this.itemData)) {
            HashMap<String, String> idNameMap = new HashMap<String, String>();
            List<StreamMonitorMeasureName> ship = this.streamMonitorRuleManager.getMeasuresByType(this.mode);
            for (StreamMonitorMeasureName mesure : ship) {
                idNameMap.put(mesure.getId() + "", mesure.getName());
            }
            temp = new ArrayList<StreamMonitorRuleConditionRelationship>();
            StreamMonitorRuleConditionRelationship smrc = null;
            itemsDataArr = this.itemData.split("!");
            for (int i = 0; i < itemsDataArr.length; ++i) {
                logicChar = null;
                boolean isNeedGroupChar = true;
                int lastGroupId = 0;
                itemDataArr = itemsDataArr[i].split(";");
                Integer conditionIndex = 1;
                for (int j = 0; j < itemDataArr.length; ++j) {
                    if (j % 2 == 0) {
                        Integer n;
                        Integer n2;
                        smrc = new StreamMonitorRuleConditionRelationship();
                        String[] itemElement = itemDataArr[j].split(",");
                        if (isNeedGroupChar) {
                            String string = null == itemGgroupDataArr ? "" : itemGgroupDataArr[i * 2];
                            LogicOperator logicOperator = "OR".equalsIgnoreCase(string) ? LogicOperator.OR : LogicOperator.AND;
                            smrc.setLogicOperator(logicOperator);
                            isNeedGroupChar = false;
                        } else {
                            smrc.setLogicOperator("OR".equalsIgnoreCase(logicChar) ? LogicOperator.OR : LogicOperator.AND);
                        }
                        smrc.setMeasureName((String)idNameMap.get(itemElement[0]));
                        smrc.setOperator("0".equals(itemElement[1]) ? Operator.GreaterEqualThan : Operator.LessEqualThan);
                        smrc.setOperatorString("0".equals(itemElement[1]) ? ">=" : "<=");
                        smrc.setTargetValue(itemElement[2]);
                        int curGroupId = Integer.parseInt(itemElement[3]);
                        if (0 == curGroupId) {
                            curGroupId = lastGroupId;
                            smrc.setConditionInGroupId(conditionIndex);
                            n2 = conditionIndex;
                            n = conditionIndex = Integer.valueOf(conditionIndex + 1);
                        } else {
                            lastGroupId = curGroupId;
                            conditionIndex = 1;
                            smrc.setConditionInGroupId(conditionIndex);
                            n2 = conditionIndex;
                            n = conditionIndex = Integer.valueOf(conditionIndex + 1);
                        }
                        smrc.setGroupId(curGroupId);
                        smrc.setType(this.mode);
                        temp.add(smrc);
                        continue;
                    }
                    logicChar = itemDataArr[j];
                }
            }
        }
        if (temp != null) {
            ArrayList<StreamMonitorRuleConditionRelationship> newlist = new ArrayList<StreamMonitorRuleConditionRelationship>();
            for (int i = 0; i < groupIds.size(); ++i) {
                int curId = Integer.parseInt((String)groupIds.get(i));
                boolean isFirstElement = true;
                for (int j = 0; j < temp.size(); ++j) {
                    StreamMonitorRuleConditionRelationship ship = (StreamMonitorRuleConditionRelationship)temp.get(j);
                    if (curId != ship.getGroupId()) continue;
                    if (isFirstElement) {
                        ship.setLogicOperator("OR".equalsIgnoreCase(itemGgroupDataArr[i * 2]) ? LogicOperator.OR : LogicOperator.AND);
                        isFirstElement = false;
                    }
                    newlist.add(ship);
                }
            }
            if (0 == this.mode) {
                this.setSessionMissKey(newlist);
            } else {
                this.setSessionFaultKey(newlist);
            }
            this.total = temp.size();
            this.itemLogicRelationResult = this.generateRelationResult(this.mode, temp)[0];
            String[] arr = this.generateRelationResult(this.mode, temp);
            this.itemLogicRelationResult = arr[0];
            this.itemLogicRelationResultSave = arr[1];
        } else {
            this.clearSessionDefenseKey();
            this.itemLogicRelationResult = null;
            this.itemLogicRelationResultSave = null;
            this.total = 0;
        }
        this.responseResult("success");
    }

    private String[] generateRelationResult(int type, List<StreamMonitorRuleConditionRelationship> ships) {
        if (null != ships && ships.size() > 0) {
            HashMap<String, String> nameIdMap = new HashMap<String, String>();
            List<StreamMonitorMeasureName> measureNames = this.streamMonitorRuleManager.getMeasuresByType(type);
            for (StreamMonitorMeasureName mesure : measureNames) {
                nameIdMap.put(mesure.getName(), mesure.getId() + "");
            }
            StringBuffer saveGroupInfo = new StringBuffer();
            StringBuffer saveRelation = new StringBuffer();
            StringBuffer sBuffer = new StringBuffer();
            int lastGroupId = 0;
            sBuffer.append("(");
            for (int i = 0; i < ships.size(); ++i) {
                StreamMonitorRuleConditionRelationship ship = ships.get(i);
                if (0 == i) {
                    saveGroupInfo.append((String)nameIdMap.get(ship.getMeasureName()) + ",");
                    saveGroupInfo.append(Operator.GreaterEqualThan == ship.getOperator() ? "0," : "1,");
                    saveGroupInfo.append(ship.getTargetValue() + ",");
                    saveGroupInfo.append(ship.getGroupId() + ";");
                    saveRelation.append("@," + ship.getGroupId() + ";");
                } else {
                    if (lastGroupId != ship.getGroupId()) {
                        String info = saveGroupInfo.toString().substring(0, saveGroupInfo.toString().length() - 1) + "!";
                        saveGroupInfo.delete(0, saveGroupInfo.length());
                        saveGroupInfo.append(info);
                        saveRelation.append((Object)((Object)ship.getLogicOperator()) + "," + ship.getGroupId() + ";");
                    }
                    if (!"!".equals(saveGroupInfo.toString().subSequence(saveGroupInfo.toString().length() - 1, saveGroupInfo.toString().length()))) {
                        saveGroupInfo.append((Object)((Object)ship.getLogicOperator()) + ";");
                    }
                    saveGroupInfo.append((String)nameIdMap.get(ship.getMeasureName()) + ",");
                    saveGroupInfo.append(Operator.GreaterEqualThan == ship.getOperator() ? "0," : "1,");
                    saveGroupInfo.append(ship.getTargetValue() + ",");
                    if (lastGroupId != ship.getGroupId()) {
                        saveGroupInfo.append(ship.getGroupId() + ";");
                    } else {
                        saveGroupInfo.append("0;");
                    }
                }
                if (0 == i) {
                    sBuffer.append(this.getText(this.getMesureResourcePrefix(type) + ship.getMeasureName()));
                    lastGroupId = ship.getGroupId();
                    continue;
                }
                if (lastGroupId == ship.getGroupId()) {
                    sBuffer.append(" " + (Object)((Object)ship.getLogicOperator()));
                    sBuffer.append(" " + this.getText(this.getMesureResourcePrefix(type) + ship.getMeasureName()));
                    continue;
                }
                sBuffer.append(" )");
                sBuffer.append(" " + (Object)((Object)ship.getLogicOperator()));
                sBuffer.append(" (");
                sBuffer.append(" " + this.getText(this.getMesureResourcePrefix(type) + ship.getMeasureName()));
                lastGroupId = ship.getGroupId();
            }
            sBuffer.append(")");
            String[] arr = new String[2];
            arr[0] = sBuffer.toString();
            String info = saveGroupInfo.toString().substring(0, saveGroupInfo.toString().length() - 1);
            String currRelation = saveRelation.toString().substring(0, saveRelation.toString().length() - 1);
            arr[1] = info + currRelation;
            return arr;
        }
        return new String[]{"", ""};
    }

    public void saveMissFaultDefense() {
        List<Long> zoneIdList = MissFaultDefenseAction.string2LongList(this.zoneIds, ",");
        if (!zoneIdList.isEmpty()) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            for (int i = 0; i < zoneIdList.size(); ++i) {
                Long moId = ZoneBisUtil.getMoidByZoneid(zoneIdList.get(i));
                moIdList.add(moId);
            }
            BisUtil.checkUserSecurity(moIdList);
        }
        boolean actionEdit = false;
        String operation = OPERATION_ADD;
        if (null != this.streamMonitorRule.getId() && 0 < this.streamMonitorRule.getId()) {
            actionEdit = true;
            operation = OPERATION_EDIT;
        }
        try {
            StreamMonitorRuleDetail ruleDetail = new StreamMonitorRuleDetail();
            if (actionEdit) {
                ruleDetail.setRuleId(this.streamMonitorRule.getId());
            }
            ruleDetail.setRuleName(this.streamMonitorRule.getRuleName());
            ruleDetail.setDescription(this.streamMonitorRule.getDescription());
            List<StreamMonitorRuleConditionRelationship> conditionForm = this.getSessionDefense();
            if (conditionForm.size() > 0) {
                ruleDetail.setConditionRelationships(conditionForm);
            }
            if (StringUtils.isNotEmpty(this.zoneIds)) {
                ruleDetail.setZoneIds(MissFaultDefenseAction.string2LongList(this.zoneIds, ","));
            }
            boolean isSavedSucess = false;
            if (actionEdit) {
                try {
                    this.streamMonitorRuleManager.updateRule(ruleDetail);
                    isSavedSucess = true;
                }
                catch (RemoteException e) {
                    LOGGER.error((Object)("filed to update rule. " + e.getMessage()));
                }
            } else {
                try {
                    int resultId = this.streamMonitorRuleManager.addRule(ruleDetail);
                    if (0 == resultId) {
                        isSavedSucess = true;
                    } else if (0 < resultId) {
                        this.responseResult(FAILED_WITH_RULE_EXISTED);
                        return;
                    }
                }
                catch (RemoteException e) {
                    LOGGER.error((Object)("filed to add rule." + e.getMessage()));
                }
            }
            if (isSavedSucess) {
                this.clearSessionDefenseKey();
                this.processOperateLog(operation, new String[]{ruleDetail.getRuleName()}, true);
                this.responseResult("success");
            } else {
                this.processOperateLog(operation, new String[]{ruleDetail.getRuleName()}, false);
                this.responseResult(FAILED_NOTIFY_COLLECTOR);
            }
        }
        catch (LegoCheckedException ex) {
            String operationValue = OPERATION_ADD.equals(operation) ? "atic.bis.missFaultDefense.create.tip" : (OPERATION_EDIT.equals(operation) ? "atic.bis.missFaultDefense.edit.tip" : "atic.bis.missFaultDefense.delete.tip");
            this.systemOpeLog(operationValue, "lego.dic.module.AticBis", true, null, null, "atic.bis.missFaultDefense.panle.title", SysoplogLevel.normal.getValue(), false, (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            String operationValue = OPERATION_ADD.equals(operation) ? "atic.bis.missFaultDefense.create.tip" : (OPERATION_EDIT.equals(operation) ? "atic.bis.missFaultDefense.edit.tip" : "atic.bis.missFaultDefense.delete.tip");
            this.systemOpeLog(operationValue, "lego.dic.module.AticBis", true, null, null, "atic.bis.missFaultDefense.panle.title", SysoplogLevel.normal.getValue(), false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    private void processOperateLog(String operation, String[] params, boolean isSuccess) {
        SysOptLog sysOptLogLego = new SysOptLog();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String terminalIp = "127.0.0.1";
        String sysOperator = "";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            sysOperator = currentUser.getUserName();
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        String currentRuleName = null;
        currentRuleName = null != params && params.length > 0 ? params[0] : " ";
        if (OPERATION_ADD.equals(operation)) {
            sysOptLogLego.setOperation("atic.bis.missFaultDefense.create.tip");
        } else if (OPERATION_EDIT.equals(operation)) {
            sysOptLogLego.setOperation("atic.bis.missFaultDefense.edit.tip");
        } else {
            sysOptLogLego.setOperation("atic.bis.missFaultDefense.delete.tip");
        }
        sysOptLogLego.setOperator(sysOperator);
        sysOptLogLego.setTarget("atic.bis.missFaultDefense.panle.title");
        sysOptLogLego.setTargetLocal(Boolean.valueOf(true));
        if (isSuccess) {
            sysOptLogLego.setResult(1);
        } else {
            sysOptLogLego.setResult(0);
        }
        String[] para = new String[]{currentRuleName};
        sysOptLogLego.setDetailPara(para);
        if (isSuccess) {
            if (OPERATION_DELETE.equals(operation)) {
                sysOptLogLego.setDetail("atic.bis.missFaultDefense.system.operate.delete.success");
            } else {
                sysOptLogLego.setDetail("atic.bis.missFaultDefense.system.operate.save.success");
            }
        } else if (OPERATION_DELETE.equals(operation)) {
            sysOptLogLego.setDetail("atic.bis.missFaultDefense.system.operate.delete.failed");
        } else {
            sysOptLogLego.setDetail("atic.bis.missFaultDefense.system.operate.save.failed");
        }
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogLego.setDetailPara(para);
        this.sysLogService.writeOptLog(sysOptLogLego);
    }

    private static List<Long> string2LongList(String str, String splitChar) {
        if (StringUtils.isNotEmpty(str) && StringUtils.isNotEmpty(splitChar)) {
            String[] strArray = str.split(splitChar);
            ArrayList<Long> arr = new ArrayList<Long>();
            for (int i = 0; i < strArray.length; ++i) {
                if (!StringUtils.isNotEmpty(strArray[i])) continue;
                arr.add(Long.parseLong(strArray[i]));
            }
            return arr;
        }
        return new ArrayList<Long>();
    }

    private void initMeasure(List<StreamMonitorMeasureName> measure) {
        String name;
        this.measureNameList = new ArrayList<LangPair>();
        StringBuffer sbBufferName = new StringBuffer();
        if (null != measure && !measure.isEmpty()) {
            this.attackIdArray = ",13,14,15,17,18,19,27,28,29,30";
            for (int i = 0; i < measure.size(); ++i) {
                StreamMonitorMeasureName currMeasure = measure.get(i);
                int curId = currMeasure.getId();
                String name2 = currMeasure.getName();
                name2 = this.getMesureResourcePrefix(currMeasure.getType()) + name2;
                LangPair miss = new LangPair("" + curId, this.getText(name2));
                this.measureNameList.add(miss);
                sbBufferName.append("[\"" + curId + "\",\"" + this.getText(name2) + "\"],");
            }
        }
        this.measureNameListString = !(name = sbBufferName.toString()).isEmpty() ? "[" + name.substring(0, name.length() - 1) + "]" : "";
    }

    private String getMesureResourcePrefix(int type) {
        if (0 == type) {
            return "atic.bis.missFaultDefense.miss.";
        }
        return "atic.bis.missFaultDefense.fault.";
    }

    public void deleteMissFaultDefense() {
        if (null != this.ids && this.ids.length > 0) {
            int i;
            String ruleNames = null;
            StringBuffer namesBuffer = new StringBuffer();
            if (null != this.names && this.names.length > 0) {
                for (i = 0; i < this.names.length; ++i) {
                    namesBuffer.append(this.names[i] + ",");
                }
                ruleNames = namesBuffer.toString();
                ruleNames = ruleNames.substring(0, ruleNames.length() - 1);
            } else {
                ruleNames = " ";
            }
            for (i = 0; i < this.ids.length; ++i) {
                try {
                    this.streamMonitorRuleManager.removeRule(this.ids[i]);
                    continue;
                }
                catch (RemoteException e) {
                    LOGGER.error((Object)("delete rule failed." + e.getMessage()));
                    this.responseResult(FAILED_NOTIFY_COLLECTOR);
                    this.processOperateLog(OPERATION_DELETE, new String[]{ruleNames}, false);
                    return;
                }
            }
            this.processOperateLog(OPERATION_DELETE, new String[]{ruleNames}, true);
        }
        this.responseResult("success");
    }

    public boolean validateIds() {
        if (null == this.ids) {
            return false;
        }
        if (this.ids.length > 100) {
            return false;
        }
        Integer[] integerArray = this.ids;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int testId = integerArray[i];
            if (testId >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean validateZoneIds() {
        String zoneIdsTemp = this.zoneIds;
        if ("".equals(zoneIdsTemp) || null == zoneIdsTemp) {
            return true;
        }
        String[] arrayId = zoneIdsTemp.split(",");
        if (arrayId.length > 10000) {
            return false;
        }
        for (int i = 0; i < arrayId.length; ++i) {
            long singleId = 0L;
            try {
                singleId = Long.parseLong(arrayId[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (singleId >= 1L) continue;
            return false;
        }
        return true;
    }

    public List<StreamMonitorRule> getMissFaultDefenseList() {
        return this.missFaultDefenseList;
    }

    public void setMissFaultDefenseList(List<StreamMonitorRule> missFaultDefenseList) {
        this.missFaultDefenseList = missFaultDefenseList;
    }

    public StreamMonitorRule getStreamMonitorRule() {
        return this.streamMonitorRule;
    }

    public void setStreamMonitorRule(StreamMonitorRule streamMonitorRule) {
        this.streamMonitorRule = streamMonitorRule;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<LangPair> getModeList() {
        return this.modeList;
    }

    public void setModeList(List<LangPair> modeList) {
        this.modeList = modeList;
    }

    public List<StreamMonitorRuleConditionRelationship> getStreamMonitorRuleConditionForms() {
        return this.streamMonitorRuleConditionForms;
    }

    public void setStreamMonitorRuleConditionForms(List<StreamMonitorRuleConditionRelationship> streamMonitorRuleConditionForms) {
        this.streamMonitorRuleConditionForms = streamMonitorRuleConditionForms;
    }

    public List<LangPair> getMeasureNameList() {
        return this.measureNameList;
    }

    public void setMeasureNameList(List<LangPair> measureNameList) {
        this.measureNameList = measureNameList;
    }

    public List<LangPair> getOperatorList() {
        return this.operatorList;
    }

    public void setOperatorList(List<LangPair> operatorList) {
        this.operatorList = operatorList;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public List<LangPair> getRalationList() {
        return this.ralationList;
    }

    public void setRalationList(List<LangPair> ralationList) {
        this.ralationList = ralationList;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public Integer getMode() {
        return this.mode;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public List<LangPair> getGroupIndexList() {
        return this.groupIndexList;
    }

    public void setGroupIndexList(List<LangPair> groupIndexList) {
        this.groupIndexList = groupIndexList;
    }

    public String getItemLogicRelationResult() {
        return this.itemLogicRelationResult;
    }

    public void setItemLogicRelationResult(String itemLogicRelationResult) {
        this.itemLogicRelationResult = itemLogicRelationResult;
    }

    public String getMeasureNameListString() {
        return this.measureNameListString;
    }

    public void setMeasureNameListString(String measureNameListString) {
        this.measureNameListString = measureNameListString;
    }

    public String getAttackIdArray() {
        return this.attackIdArray;
    }

    public void setAttackIdArray(String attackIdArray) {
        this.attackIdArray = attackIdArray;
    }

    public String getItemLogicRelationResultSave() {
        return this.itemLogicRelationResultSave;
    }

    public void setItemLogicRelationResultSave(String itemLogicRelationResultSave) {
        this.itemLogicRelationResultSave = itemLogicRelationResultSave;
    }

    public String getItemData() {
        return this.itemData;
    }

    public void setItemData(String itemData) {
        this.itemData = itemData;
    }

    public String getItemGgroupData() {
        return this.itemGgroupData;
    }

    public void setItemGgroupData(String itemGgroupData) {
        this.itemGgroupData = itemGgroupData;
    }

    public List<ZonePolicyApplyForm> getZonePolicyFormList() {
        return this.zonePolicyFormList;
    }

    public void setZonePolicyFormList(List<ZonePolicyApplyForm> zonePolicyFormList) {
        this.zonePolicyFormList = zonePolicyFormList;
    }

    public String getZoneIds() {
        return this.zoneIds;
    }

    public void setZoneIds(String zoneIds) {
        this.zoneIds = zoneIds;
    }

    public StreamMonitorRuleManager getStreamMonitorRuleManager() {
        return this.streamMonitorRuleManager;
    }

    public void setStreamMonitorRuleManager(StreamMonitorRuleManager streamMonitorRuleManager) {
        this.streamMonitorRuleManager = streamMonitorRuleManager;
    }

    public Integer[] getIds() {
        if (null != this.ids) {
            return (Integer[])this.ids.clone();
        }
        return new Integer[0];
    }

    public void setIds(Integer[] ids) {
        this.ids = null != ids ? (Integer[])ids.clone() : null;
    }

    public String[] getNames() {
        if (null != this.names) {
            return (String[])this.names.clone();
        }
        return new String[0];
    }

    public void setNames(String[] names) {
        this.names = null != names ? (String[])names.clone() : null;
    }

    public ISysOptLog getSysLogService() {
        return this.sysLogService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public List<StreamMonitorRule> getMissFaultRuleForZoneList() {
        return this.missFaultRuleForZoneList;
    }

    public void setMissFaultRuleForZoneList(List<StreamMonitorRule> missFaultRuleForZoneList) {
        this.missFaultRuleForZoneList = missFaultRuleForZoneList;
    }

    public String getRuleIds() {
        return this.ruleIds;
    }

    public void setRuleIds(String ruleIds) {
        this.ruleIds = ruleIds;
    }
}

