/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.dao;

import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.model.FaultSeverityRule;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;

public class FaultSeverityRuleDao
extends CommonDaoImpl {
    public FaultSeverityRuleForm listRule() {
        List loadAll = this.getHibernateTemplate().loadAll(FaultSeverityRule.class);
        FaultSeverityRuleForm form = new FaultSeverityRuleForm();
        for (FaultSeverityRule rule : loadAll) {
            if (4 == rule.getSeverity()) {
                form.setCriticalRule(rule);
                continue;
            }
            if (3 == rule.getSeverity()) {
                form.setMajorRule(rule);
                continue;
            }
            if (2 == rule.getSeverity()) {
                form.setMinorRule(rule);
                continue;
            }
            if (1 != rule.getSeverity()) continue;
            form.setWarningRule(rule);
        }
        return form;
    }

    public FaultSeverityRuleForm listRuleByZoneId(Long zoneId, Integer direction) {
        String hql = "from FaultSeverityRule where zoneId = ?0 and direction = ?1";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        param.put(1, direction.toString());
        List result = this.findByHql(hql, param);
        if (null == result || result.isEmpty()) {
            return null;
        }
        List loadAll = result;
        FaultSeverityRuleForm form = new FaultSeverityRuleForm();
        for (FaultSeverityRule rule : loadAll) {
            if (4 == rule.getSeverity()) {
                form.setCriticalRule(rule);
                continue;
            }
            if (3 == rule.getSeverity()) {
                form.setMajorRule(rule);
                continue;
            }
            if (2 == rule.getSeverity()) {
                form.setMinorRule(rule);
                continue;
            }
            if (1 != rule.getSeverity()) continue;
            form.setWarningRule(rule);
        }
        return form;
    }

    public void saveRule(FaultSeverityRuleForm form) {
        this.getHibernateTemplate().merge((Object)form.getCriticalRule());
        this.getHibernateTemplate().merge((Object)form.getMajorRule());
        this.getHibernateTemplate().merge((Object)form.getMinorRule());
        this.getHibernateTemplate().merge((Object)form.getWarningRule());
    }

    public void saveOrUpdateRule(FaultSeverityRuleForm form) {
        this.saveOrUpdate(form.getCriticalRule());
        this.saveOrUpdate(form.getMajorRule());
        this.saveOrUpdate(form.getMinorRule());
        this.saveOrUpdate(form.getWarningRule());
    }

    public void deleteAllByZoneId(List<Long> zoneIds) {
        String hql = "DELETE FROM FaultSeverityRule WHERE zone_id IN (:ids)";
        InnerClassDelete innerClass = new InnerClassDelete(hql, zoneIds);
        super.getHibernateTemplate().execute((HibernateCallback)innerClass);
    }

    private static class InnerClassDelete
    implements HibernateCallback {
        private String hql;
        private List<Long> zoneIds;

        public InnerClassDelete(String hql, List<Long> zoneIds) {
            this.hql = hql;
            this.zoneIds = zoneIds;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.hql);
            q.setParameterList("ids", this.zoneIds);
            return q.executeUpdate();
        }
    }
}

