/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.lus;

import com.hs.atic.bis.lus.SecDownLoadUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Properties;

public class AutoSecDownloadThread
extends Thread {
    private static final int SLEEP_FOR_A_WHILE = 10;
    private final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private int autoTime = 4;
    private boolean autoSyncSwith = false;
    private boolean isAlive = true;
    private SecDownLoadUtil secDownLoadUtil;
    private static AutoSecDownloadThread instance = new AutoSecDownloadThread();
    private final String configPath = File.separator + "vsm_conf" + File.separator + "policy" + File.separator + "autoSecDownload.conf";
    private final String filePath = AticInstallUtil.getInstance().getAticInstallPath() + this.configPath;

    public static AutoSecDownloadThread getInstance() {
        return instance;
    }

    public AutoSecDownloadThread() {
        this.initConf();
    }

    @Override
    public void run() {
        this.LOGGER.info((Object)"Download secLibFile is running.");
        if (null == this.secDownLoadUtil) {
            this.secDownLoadUtil = new SecDownLoadUtil();
        }
        this.secDownLoadUtil.changeLibFileDeployingToFail();
        while (this.isAlive) {
            if (this.isTimeRun().booleanValue()) {
                try {
                    if (null == this.secDownLoadUtil) {
                        this.secDownLoadUtil = new SecDownLoadUtil();
                    }
                    if (this.getAutoSyncSwith()) {
                        this.LOGGER.info((Object)"download file start!");
                        this.secDownLoadUtil.downloadSecLibFile();
                        this.LOGGER.info((Object)"keepLastIPReputationLibFile start!");
                        this.secDownLoadUtil.keepLastThreeIPReputationLibFile();
                        this.LOGGER.info((Object)"keepLastIPReputationLibFile start!");
                        this.secDownLoadUtil.deployIPRPULibFile();
                        this.LOGGER.info((Object)"deployIPRPULibFile run end!");
                    }
                    this.secDownLoadUtil.checkLibFileAndSendAlarm();
                }
                catch (Exception e) {
                    this.LOGGER.error((Object)("download file some errors happend." + e.getMessage()));
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                this.LOGGER.error((Object)("download file InterruptedException error: " + e.getMessage()));
            }
        }
        this.LOGGER.info((Object)"Download secLibFile stop!");
    }

    private Boolean isTimeRun() {
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        int minute = cal.get(12);
        int scond = cal.get(13);
        if (hour == this.autoTime && 0 == minute && 10 > scond) {
            return true;
        }
        return false;
    }

    private void initConf() {
        Properties conf = this.openPropertyFile();
        try {
            this.autoTime = Integer.parseInt(conf.getProperty("downLoadTime"));
            this.autoSyncSwith = Boolean.parseBoolean(conf.getProperty("autoSyncSwith"));
        }
        catch (Exception e) {
            this.autoTime = 4;
            this.autoSyncSwith = false;
            this.LOGGER.error((Object)("initConf error AutoSecDownloadThread! " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties openPropertyFile() {
        FileInputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = new FileInputStream(this.filePath);
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            this.LOGGER.error((Object)"autoSecDownload.conf FileNotFoundException.");
        }
        catch (IOException e) {
            this.LOGGER.error((Object)"execute AutoSecDownloadThread.openPropertyFile() failed, IOException");
        }
        finally {
            if (null != inputStream) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    this.LOGGER.error((Object)"execute AutoSecDownloadThread.openPropertyFile() failed! ");
                }
            }
        }
        return properties;
    }

    public void setAlive(boolean isAliveBool) {
        this.LOGGER.info((Object)("AutoSecDownloadThread isAlive: " + isAliveBool));
        this.isAlive = isAliveBool;
    }

    public void setAutoSyncSwith(boolean autoSyncSwith) throws LegoCheckedException {
        this.LOGGER.info((Object)("AutoSecDownloadThread setAutoSyncSwith: " + autoSyncSwith));
        Properties conf = this.openPropertyFile();
        this.autoSyncSwith = autoSyncSwith;
        FileOutputStream outPut = null;
        try {
            conf.setProperty("autoSyncSwith", String.valueOf(autoSyncSwith));
            conf.setProperty("downLoadTime", String.valueOf(this.autoTime));
            outPut = new FileOutputStream(this.filePath);
            conf.store(outPut, "autoSecDownload.conf");
        }
        catch (IOException e) {
            throw new LegoCheckedException(571631L);
        }
        finally {
            try {
                if (outPut != null) {
                    outPut.close();
                }
            }
            catch (IOException e) {
                this.LOGGER.error((Object)"reader.close() IOException", (Throwable)e);
            }
        }
    }

    public boolean getAutoSyncSwith() {
        this.LOGGER.info((Object)("AutoSecDownloadThread getAutoSyncSwith: " + this.autoSyncSwith));
        Properties conf = this.openPropertyFile();
        try {
            this.autoSyncSwith = Boolean.valueOf(conf.getProperty("autoSyncSwith"));
        }
        catch (Exception e) {
            this.LOGGER.error((Object)("setAutoSyncSwith error AutoSecDownloadThread! " + e.getMessage()));
            this.autoSyncSwith = false;
        }
        return this.autoSyncSwith;
    }
}

