/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.lus;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class MacUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final String MAC_PATTERN_FORWIN = "[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}-[0-9a-fA-F]{2}";
    private static final String MAC_PATTERN_FORLIN = "[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}";
    private static final String MAC_PRE_INDEX_WIN = ":";
    private static final String MAC_PRE_INDEX_LIN = " ";
    private static final String MAC_NAME_PREINDEX_SOLARIS = ": ";

    public static List<String> getLocalMacsByCommand() throws SocketException {
        String os = System.getProperty("os.name");
        ArrayList<String> macsList = new ArrayList<String>();
        HashMap<String, String> macs = new HashMap<String, String>();
        if (os.startsWith("Windows")) {
            MacUtil.getWinLocalMacByCommand(macs);
        } else if (os.startsWith("Linux")) {
            MacUtil.getLinuxLocalMacByCommand(macs);
        } else {
            MacUtil.getSolarisLocalMacByCommand(macs);
        }
        for (Map.Entry entry : macs.entrySet()) {
            macsList.add((String)entry.getValue());
        }
        return macsList;
    }

    private static void getWinLocalMacByCommand(Map<String, String> macs) {
        String ipConfigResponse = null;
        try {
            ipConfigResponse = MacUtil.runConsoleCommand("ipconfig /all");
        }
        catch (IOException e) {
            LOGGER.error((Object)"Excute ipconfig /all failed.");
            return;
        }
        MacUtil.convertIpConfigResponse(ipConfigResponse, MAC_PRE_INDEX_WIN, MAC_PATTERN_FORWIN, macs);
    }

    private static void getLinuxLocalMacByCommand(Map<String, String> macs) {
        String ipConfigResponse = null;
        try {
            ipConfigResponse = MacUtil.runConsoleCommand("/sbin/ifconfig");
        }
        catch (Exception e) {
            LOGGER.error((Object)("Linux Excute /sbin/ifconfig error." + e.getMessage()));
            try {
                ipConfigResponse = MacUtil.runConsoleCommand("ifconfig");
            }
            catch (Exception e1) {
                LOGGER.error((Object)("Excute ifconfig error." + e1.getMessage()));
                return;
            }
        }
        MacUtil.convertIpConfigResponse(ipConfigResponse, MAC_PRE_INDEX_LIN, MAC_PATTERN_FORLIN, macs);
    }

    private static void getSolarisLocalMacByCommand(Map<String, String> macs) {
        String ipConfigResponse = null;
        HashMap<String, String> macNameMaps = new HashMap();
        try {
            macNameMaps = MacUtil.getLocalMacByStandard();
            ipConfigResponse = MacUtil.runConsoleCommand("/sbin/ifconfig -au");
        }
        catch (SocketException e) {
            LOGGER.error((Object)("Solaris get LocalMac By Standard JDK SocketException:" + e.getMessage()));
            return;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Solaris Excute /sbin/ifconfig -au error." + e.getMessage()));
            try {
                ipConfigResponse = MacUtil.runConsoleCommand("ifconfig -au");
            }
            catch (Exception e1) {
                LOGGER.error((Object)("Solaris Excute ifconfig -au error." + e1.getMessage()));
                return;
            }
        }
        MacUtil.convertSolarisIpConfigResponse(ipConfigResponse, MAC_NAME_PREINDEX_SOLARIS, macNameMaps, macs);
    }

    private static Map<String, String> getLocalMacByStandard() throws SocketException {
        HashMap<String, String> macs = new HashMap<String, String>();
        Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
        if (networks == null) {
            LOGGER.error((Object)"No network interfaces could be found on this machine,getLocalMacByStandard error");
            return macs;
        }
        while (networks.hasMoreElements()) {
            String mac;
            NetworkInterface ni = networks.nextElement();
            if (ni.isVirtual() || ni.isLoopback() || !ni.supportsMulticast() || ni.isPointToPoint()) continue;
            String niName = ni.getName();
            byte[] data = ni.getHardwareAddress();
            if (data == null || data.length <= 0 || macs.containsValue(mac = MacUtil.parseMac(data))) continue;
            LOGGER.error((Object)("add one mac by jdk standard, mac:" + MacUtil.partDesensitizeKey(mac)));
            macs.put(niName, mac);
        }
        return macs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runConsoleCommand(String command) throws IOException {
        Process p = Runtime.getRuntime().exec(command);
        String outputText = "";
        try (BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());){
            int c;
            StringBuffer buffer = new StringBuffer();
            while ((c = ((InputStream)stdoutStream).read()) != -1) {
                buffer.append((char)c);
            }
            outputText = buffer.toString();
            MacUtil.threadDealStream(p.getErrorStream(), true);
        }
        return outputText;
    }

    public static String parseMac(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sb.append(String.format("%02X%s", data[i], "-"));
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static void convertSolarisIpConfigResponse(String ipConfigResponse, String preIndex, Map<String, String> macNameMaps, Map<String, String> macs) {
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        while (tokenizer.hasMoreTokens()) {
            String macName;
            String mac;
            String line = tokenizer.nextToken().trim();
            int macAddressPosition = line.indexOf(preIndex);
            if (macAddressPosition <= 0 || (mac = macNameMaps.get(macName = line.substring(0, macAddressPosition).trim())) == null || !macNameMaps.containsKey(macName) || macs.containsValue(mac)) continue;
            LOGGER.error((Object)("Add one mac by command, mac:" + MacUtil.partDesensitizeKey(mac)));
            macs.put(mac, mac);
        }
    }

    private static void convertIpConfigResponse(String ipConfigResponse, String preIndex, String pattern, Map<String, String> macs) {
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        while (tokenizer.hasMoreTokens()) {
            String mac;
            String line = tokenizer.nextToken().trim();
            int macAddressPosition = line.lastIndexOf(preIndex);
            if (macAddressPosition == 0 || !(mac = line.substring(macAddressPosition + 1).trim()).matches(pattern) || !MacUtil.isMacAddOSX(mac = mac.replace(MAC_PRE_INDEX_WIN, "-")) || macs.containsValue(mac)) continue;
            LOGGER.error((Object)("Add one mac by command, mac:" + MacUtil.partDesensitizeKey(mac)));
            macs.put(mac, mac);
        }
    }

    private static String partDesensitizeKey(String macAddress) {
        if (StringUtils.isEmpty((CharSequence)macAddress)) {
            return macAddress;
        }
        if (macAddress.length() == 1) {
            return "*";
        }
        if (macAddress.length() < 6) {
            return macAddress.substring(0, macAddress.length() - 2) + "*" + macAddress.substring(macAddress.length() - 1);
        }
        return macAddress.substring(0, macAddress.length() - 5) + "***" + macAddress.substring(macAddress.length() - 2);
    }

    private static boolean isMacAddOSX(String macAddressCandidate) {
        return macAddressCandidate.length() == 17;
    }

    private static void threadDealStream(final InputStream input, final boolean errLevel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader bf = new BufferedReader(new InputStreamReader(input, System.getProperty("file.encoding")));
                    String line = null;
                    LOGGER.info((Object)"readStreamBufferLine");
                    while ((line = bf.readLine()) != null) {
                        if (errLevel) {
                            LOGGER.error((Object)line);
                            continue;
                        }
                        LOGGER.info((Object)line);
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)("threadDealStream Exception: " + e.getMessage()));
                }
            }
        }).start();
    }
}

