/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.lus;

import com.hs.atic.alarm.entity.ZoneAlarmEntityBuffer;
import com.hs.atic.bis.model.SCPFeedBackInfo;
import com.hs.atic.bis.util.SCPX509TrustManager;
import com.hs.atic.collector.entity.alarm.IPReputationEntity;
import com.hs.atic.sdk.bis.form.BlackListForm;
import com.hs.atic.sdk.bis.service.IBlackListService;
import com.hs.atic.system.SysConfigManager;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.parents.servcice.IFWDefenceAbnormalParentService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.Constant;
import com.restful.util.HttpsConnection;
import com.restful.util.JSONUtil;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class SCPFeedBackThread
extends Thread {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final String PRODUCT_CTRLITEM = "FEEDBACK_SERVER";
    private static final String LOG_TYPE_BLACKWHILE = "ad_antiddos_blacklist";
    private static final String LOG_TYPE_IP_STAT = "antiddos_iprpu_hit_rec";
    private static final String CONFIG_FILE = "/datetable.properties";
    private static final int BUFFER_B = 1024;
    private static final int SLEEP_FOR_A_WHILE = 10;
    private int blackListTime = 86400000;
    private static int SCP_MESSAGE_SIZE = 480;
    private static int SCP_MESSAGE_NUMBER = 240;
    private static int IP_REPUTATION_ATK_DESTIP1 = 1;
    private static int IP_REPUTATION_ATK_DESTIP2 = 2;
    private static int IP_REPUTATION_PEACE_DESTIP1 = 3;
    private static int IP_REPUTATION_PEACE_DESTIP2 = 4;
    private ZoneAlarmEntityBuffer entityBuffer;
    private IFWDefenceAbnormalParentService iFWDefenceAbnormalService;
    private IBlackListService blackListService;
    private IAticDeviceService aticDeviceService;
    private SysConfigManager sysConfigManager;

    public SCPFeedBackThread() {
        this.init();
    }

    @Override
    public void run() {
        long lastTime = 1L;
        while (true) {
            long currTime;
            List<IPReputationEntity> ipReputationList;
            if ((ipReputationList = this.entityBuffer.getIpReputationList()).size() > 0) {
                this.sendIpReputation(ipReputationList);
            }
            if ((currTime = System.currentTimeMillis()) - lastTime >= (long)this.blackListTime) {
                LOGGER.info((Object)"send blackWhile start ...");
                this.sendBlackWhile(lastTime / 1000L);
                lastTime = currTime;
                LOGGER.info((Object)"send blackWhile end ...");
            }
            this.sleep(10000);
        }
    }

    public void sendBlackWhile(long lastTime) {
        List deviceIps = this.iFWDefenceAbnormalService.getAllDeviceByStatistics(Constant.NUMBER_ONE.intValue());
        for (String deviceIp : deviceIps) {
            try {
                List<BlackListForm> blackListForms = this.blackListService.getBlackListByDeviceIp(deviceIp, lastTime);
                LOGGER.info((Object)("send blackListForms count is " + blackListForms.size()));
                if (blackListForms.size() <= 0) continue;
                List<Map<String, Object>> logContentList = this.assemblyBlackListData(blackListForms);
                this.sendFeedBackByDeviceIp(deviceIp, LOG_TYPE_BLACKWHILE, logContentList);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)("send blackWhile LegoCheckedException, error = " + e.getMessage()));
            }
        }
    }

    private List<Map<String, Object>> assemblyBlackListData(List<BlackListForm> blackListForms) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (BlackListForm form : blackListForms) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("black_ip", form.getBlackIp());
            map.put("start_time", form.getStartTimeStr());
            map.put("end_time", form.getEndTimeStr());
            map.put("protocol", form.getProtocol());
            map.put("port", form.getPort());
            map.put("black_type", form.getBlackType());
            map.put("zone_ip", form.getZoneIp());
            map.put("zone_name", form.getZoneName());
            map.put("device_ip", form.getDeviceIp());
            mapList.add(map);
        }
        return mapList;
    }

    public void sendIpReputation(List<IPReputationEntity> forms) {
        HashMap maps = new HashMap();
        for (IPReputationEntity iPReputationEntity : forms) {
            Map<String, Object> logContentMap = this.assemblyIpReputationData(iPReputationEntity);
            if (null == logContentMap) continue;
            if (null != maps.get(iPReputationEntity.getDeviceIp())) {
                ((List)maps.get(iPReputationEntity.getDeviceIp())).add(logContentMap);
                continue;
            }
            ArrayList<Map<String, Object>> logContentList = new ArrayList<Map<String, Object>>();
            logContentList.add(logContentMap);
            maps.put(iPReputationEntity.getDeviceIp(), logContentList);
        }
        if (maps.size() > 0) {
            LOGGER.info((Object)("send ipReputation count is " + maps.size()));
            for (Map.Entry entry : maps.entrySet()) {
                this.sendFeedBackByDeviceIp((String)entry.getKey(), LOG_TYPE_IP_STAT, (List)entry.getValue());
            }
        }
    }

    private Map<String, Object> assemblyIpReputationData(IPReputationEntity form) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("report_time", form.getReportTime());
            map.put("sip", form.getSrcIp());
            map.put("iprptn_enable_time", form.getZoneIpRptnEnableTime1());
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("hit_time", form.getAtkHitTime1());
            map1.put("hit_count", form.getAtkHitCount());
            map1.put("block_time", form.getAtkBlockTime1());
            map1.put("block_count", form.getAtkBlockCount());
            ArrayList<Map<String, Object>> atkDip = new ArrayList<Map<String, Object>>();
            if (!AticUtil.isNull((String)form.getAtkDestIp1())) {
                atkDip.add(this.queryDip(IP_REPUTATION_ATK_DESTIP1, form));
            }
            if (!AticUtil.isNull((String)form.getAtkDestIp2())) {
                atkDip.add(this.queryDip(IP_REPUTATION_ATK_DESTIP2, form));
            }
            map1.put("dip", JSONUtil.getInstance().toJSON(atkDip));
            map.put("hit_under_atk", JSONUtil.getInstance().toJSON(map1));
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("hit_time", form.getPeaceHitTime1());
            map2.put("hit_count", form.getPeaceHitCount());
            ArrayList<Map<String, Object>> peaceDip = new ArrayList<Map<String, Object>>();
            if (!AticUtil.isNull((String)form.getPeaceDestIp1())) {
                peaceDip.add(this.queryDip(IP_REPUTATION_PEACE_DESTIP1, form));
            }
            if (!AticUtil.isNull((String)form.getPeaceDestIp2())) {
                peaceDip.add(this.queryDip(IP_REPUTATION_PEACE_DESTIP2, form));
            }
            map2.put("dip", JSONUtil.getInstance().toJSON(peaceDip));
            map.put("hit_under_peace", JSONUtil.getInstance().toJSON(map2));
            return map;
        }
        catch (IOException e) {
            LOGGER.error((Object)("ipReputationAssemblyData to Json error," + e.getMessage()));
            return null;
        }
    }

    private Map<String, Object> queryDip(int number, IPReputationEntity form) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (IP_REPUTATION_ATK_DESTIP1 == number) {
            map.put("ip", form.getAtkDestIp1());
            map.put("svc_type", form.getAtkSvcType1());
            map.put("atk_type", form.getAtkType1());
        } else if (IP_REPUTATION_ATK_DESTIP2 == number) {
            map.put("ip", form.getAtkDestIp2());
            map.put("svc_type", form.getAtkSvcType2());
            map.put("atk_type", form.getAtkType2());
        } else if (IP_REPUTATION_PEACE_DESTIP1 == number) {
            map.put("ip", form.getPeaceDestIp1());
            map.put("svc_type", form.getPeaceSvcType1());
        } else if (IP_REPUTATION_PEACE_DESTIP2 == number) {
            map.put("ip", form.getPeaceDestIp2());
            map.put("svc_type", form.getPeaceSvcType2());
        }
        return map;
    }

    public void sendFeedBackByDeviceIp(String deviceIp, String logType, List<Map<String, Object>> logContentList) {
        String detail = "";
        String[] detailPara = null;
        String feedbackIp = this.sysConfigManager.getSystemValue("scpFeedbackServerIP");
        String feedbackPort = this.sysConfigManager.getSystemValue("scpFeedbackServerPort");
        if (AticUtil.isNull((String)feedbackIp) || AticUtil.isNull((String)feedbackPort)) {
            LOGGER.info((Object)"feedbackServer or productmap is empty");
            detail = "com.hs.vsm.secservice.policy.scpfeedback.log.deail01";
            detailPara = new String[]{deviceIp};
            this.saveLog(false, logType, detail, detailPara);
            return;
        }
        AticDevice aticDevice = this.aticDeviceService.getDeviceByIp(deviceIp);
        if (null == aticDevice) {
            LOGGER.info((Object)("aticDevcive is empty,deviceIP = " + deviceIp));
            return;
        }
        String productName = aticDevice.getDeviceModel();
        String productVersion = aticDevice.getVersion();
        String productEsn = aticDevice.getDeviceEsn();
        if (AticUtil.isNull((String)productName) || AticUtil.isNull((String)productVersion) || AticUtil.isNull((String)productEsn)) {
            LOGGER.info((Object)"productEsn or productName or productVersion is empty");
            detail = "com.hs.vsm.secservice.policy.scpfeedback.log.deail02";
            detailPara = new String[]{deviceIp, feedbackIp, feedbackPort};
            this.saveLog(false, logType, detail, detailPara);
            return;
        }
        SCPFeedBackInfo scpFeedBackInfo = new SCPFeedBackInfo();
        scpFeedBackInfo.setProducName(productName);
        scpFeedBackInfo.setProductVersion(productVersion);
        scpFeedBackInfo.setProductESN(productEsn);
        scpFeedBackInfo.setProductCtrlItem(PRODUCT_CTRLITEM);
        scpFeedBackInfo.setLogType(logType);
        ArrayList<Map<String, Object>> newData = new ArrayList<Map<String, Object>>();
        String errorDetail = "";
        int count = 0;
        boolean isFeedBackSuccess = false;
        for (int i = 0; i < logContentList.size(); ++i) {
            newData.add(logContentList.get(i));
            if (i != logContentList.size() - 1 && ((Object)newData).toString().length() + logContentList.get(i + 1).toString().length() <= SCP_MESSAGE_SIZE * 1024) continue;
            try {
                ++count;
                scpFeedBackInfo.setLogContent(newData);
                HttpResponse response = this.executeFeedback(feedbackIp, feedbackPort, scpFeedBackInfo, 3);
                LOGGER.info((Object)("executeFeedback response = " + response));
                if (null != response && response.getStatusLine().getStatusCode() == 200) {
                    isFeedBackSuccess = true;
                }
                errorDetail = response != null ? String.valueOf(response.getStatusLine().getStatusCode()) : " ";
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)("send SCP LegoCheckedException, error " + e.getErrorCode()));
                errorDetail = "lego.err." + e.getErrorCode();
            }
            catch (Exception e) {
                LOGGER.error((Object)("send SCP Exception, error " + e.getMessage()));
            }
            detail = "com.hs.vsm.secservice.policy.scpfeedback.log.deail03";
            detailPara = new String[]{deviceIp, feedbackIp, feedbackPort, productName, productVersion, productEsn, errorDetail};
            this.saveLog(isFeedBackSuccess, logType, detail, detailPara);
            newData.clear();
            if (count != SCP_MESSAGE_NUMBER) continue;
            count = 0;
            this.sleep(10000);
        }
    }

    private HttpResponse executeFeedback(String ip, String port, SCPFeedBackInfo scpFeedBackInfo, int times) {
        if (times > 3) {
            times = 3;
        }
        try {
            String url = "https://" + ip + ":" + port + "/dfs/authorizationFeedback";
            HttpResponse response = this.post(url, scpFeedBackInfo);
            return response;
        }
        catch (LegoCheckedException e) {
            if (times > 0) {
                this.sleep(100);
                return this.executeFeedback(ip, port, scpFeedBackInfo, --times);
            }
            throw e;
        }
    }

    private HttpResponse post(String url, SCPFeedBackInfo scpFeedBackInfo) {
        CloseableHttpResponse closeableHttpResponse;
        CloseableHttpClient client = null;
        try {
            HttpPost httppost = new HttpPost(url);
            httppost.setHeader("product_name", scpFeedBackInfo.getProducName());
            httppost.setHeader("product_version", scpFeedBackInfo.getProductVersion());
            httppost.setHeader("product_ESN", scpFeedBackInfo.getProductESN());
            httppost.setHeader("product_ctrlItem", scpFeedBackInfo.getProductCtrlItem());
            StringEntity stringEntity = new StringEntity(JSONUtil.getInstance().toJSON((Object)scpFeedBackInfo));
            stringEntity.setContentType("application/json; charset=utf-8");
            httppost.setEntity((HttpEntity)stringEntity);
            client = this.getHttpsClient(url);
            closeableHttpResponse = client.execute((HttpUriRequest)httppost);
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)("send scp feedback post IOException,error is " + e.getMessage()));
                throw new LegoCheckedException(733049L);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(client);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)client);
        return closeableHttpResponse;
    }

    private CloseableHttpClient getHttpsClient(String url) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{new SCPX509TrustManager()}, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)("scp getHttpsClient NoSuchAlgorithmException error " + e.getMessage()));
        }
        catch (KeyManagementException e) {
            LOGGER.error((Object)("scp getHttpsClient KeyManagementException error" + e.getMessage()));
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, AticConstants.getHttpSslSupportCiphersuites(), (HostnameVerifier)new HttpsConnection.HttpsConnectionHostnameVerifier(url));
        Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setDefaultCookieStore((CookieStore)new BasicCookieStore()).setConnectionManager((HttpClientConnectionManager)cm);
        return httpClientBuilder.build();
    }

    private void saveLog(boolean isSuccess, String logType, String detail, String[] detailPara) {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setDate(new Date());
        oOptLog.setModule("lego.dic.module.AticBis");
        oOptLog.setOperation("com.hs.vsm.secservice.policy.scpfeedback");
        oOptLog.setTarget(logType);
        oOptLog.setDetail(detail);
        oOptLog.setDetailPara(detailPara);
        oOptLog.setOperator("system");
        oOptLog.setTerminalIp("127.0.0.1");
        oOptLog.setTargetLocal(Boolean.valueOf(false));
        oOptLog.setLevel(3);
        if (isSuccess) {
            oOptLog.setResult(1);
        } else {
            oOptLog.setResult(0);
        }
        ServiceContext context = ServiceContext.getInstance();
        ISysOptLog sysOptLog = (ISysOptLog)context.getService("sysLogService", ISysOptLog.class);
        if (null != sysOptLog) {
            sysOptLog.writeOptLog(oOptLog);
        }
    }

    private void sleep(int times) {
        try {
            Thread.sleep(times);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("sleep error: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = this.getClass().getResourceAsStream(CONFIG_FILE);
            properties.load(inputStream);
            SCP_MESSAGE_SIZE = Integer.parseInt(properties.getProperty("scp.message.size"));
            SCP_MESSAGE_NUMBER = Integer.parseInt(properties.getProperty("scp.message.number"));
            this.blackListTime = Integer.parseInt(properties.getProperty("blackListTime"));
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"query SCPFeedBackServiceImpl.openPropertyFile failed FileNotFoundException!");
        }
        catch (IOException e) {
            LOGGER.error((Object)"query SCPFeedBackServiceImpl.openPropertyFile failed IOException!");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"query defense.openPropertyFile failed! ");
                }
            }
        }
    }

    public ZoneAlarmEntityBuffer getEntityBuffer() {
        return this.entityBuffer;
    }

    public void setEntityBuffer(ZoneAlarmEntityBuffer entityBuffer) {
        this.entityBuffer = entityBuffer;
    }

    public IFWDefenceAbnormalParentService getiFWDefenceAbnormalService() {
        return this.iFWDefenceAbnormalService;
    }

    public void setiFWDefenceAbnormalService(IFWDefenceAbnormalParentService iFWDefenceAbnormalService) {
        this.iFWDefenceAbnormalService = iFWDefenceAbnormalService;
    }

    public IBlackListService getBlackListService() {
        return this.blackListService;
    }

    public void setBlackListService(IBlackListService blackListService) {
        this.blackListService = blackListService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public SysConfigManager getSysConfigManager() {
        return this.sysConfigManager;
    }

    public void setSysConfigManager(SysConfigManager sysConfigManager) {
        this.sysConfigManager = sysConfigManager;
    }
}

