/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.lus;

import com.hs.atic.bis.lus.ServerEsnBuilder;
import com.hs.atic.bis.lus.model.FeatureModel;
import com.hs.atic.bis.lus.model.FsmProductParam;
import com.hs.atic.bis.lus.model.FsmProxyParam;
import com.hs.atic.bis.lus.model.FsmServerParam;
import com.hs.atic.bis.lus.model.FsmUpdateParam;
import com.hs.atic.bis.lus.model.LatestVersionTag;
import com.hs.atic.bis.lus.model.UpdateModel;
import com.hs.atic.bis.lus.util.AppSumCbbLibrary;
import com.hs.atic.bis.lus.util.DownloadSignature;
import com.hs.atic.bis.lus.util.SHA256Digester;
import com.hs.atic.bis.model.LibraryFile;
import com.hs.atic.bis.util.DeployLibFileThread;
import com.hs.atic.sdk.bis.form.LibraryFileForm;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.atic.util.LibFilePathUtil;
import com.hs.atic.util.XmlUtil;
import com.hs.lego.cbb.fault.sdk.model.FaultVO;
import com.hs.lego.cbb.fault.sdk.service.FaultService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.service.impl.AticDeviceServiceImpl;
import com.huawei.fds.util.PackUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class SecDownLoadUtil {
    private static final String ANTI_DDOS = "AntiDDoS";
    private static final String OFFLINE = "offline";
    private static String regist = "";
    private final Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private transient ILibraryFileService libraryFileService;
    private int allLibFileNum = 40;
    private int libFileSizeUnit = 1024;
    private int libFileSize = 50;
    private long deployedOutTime = -1702967296L;
    private long autoDeployTime = 600000L;
    private String libFilePath;
    private Map<String, String> ipsEngFileName = new HashMap<String, String>();
    private String ipsLibFileName;
    private String ipsOfflineIniFileName;
    private Map<String, String> ipsOfflineFileName = new HashMap<String, String>();
    public static final String ALARM_IPREPUTATION_WORKING = "0x10010016";
    private transient IAticDeviceService aticDeviceService;

    public Map<String, String> getIpsOfflineFileName() {
        return this.ipsOfflineFileName;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getRegist() {
        this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        String esn = this.getEsn4LibFileUpdate();
        regist = AticUtil.isNull((String)esn) ? UUID.randomUUID().toString().replaceAll("-", "") : esn;
    }

    private String getEsn4LibFileUpdate() {
        StringBuffer esn = new StringBuffer();
        List<String> esnList = ServerEsnBuilder.getInstance().getServerEsns();
        if (null != esnList && !esnList.isEmpty()) {
            for (String tempEsn : esnList) {
                esn.append(tempEsn);
            }
        }
        return esn.toString();
    }

    private void createIPReputationAlarm(List<String> params) {
        String[] faultParams = new String[params.size()];
        params.toArray(faultParams);
        FaultVO fault = new FaultVO();
        fault.setFaultDefineId(ALARM_IPREPUTATION_WORKING);
        fault.setMoId(Long.valueOf(-1L));
        fault.setSource("System");
        fault.setParam(faultParams);
        FaultService faultService = (FaultService)ServiceContext.getInstance().getService("faultService", FaultService.class);
        faultService.createFault(fault);
    }

    public void checkLibFileAndSendAlarm() {
        this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        LibraryFile libFile = this.libraryFileService.getDeployedIPReputationLibFile();
        if (libFile != null && libFile.getDeployTime() < System.currentTimeMillis() - this.deployedOutTime) {
            ArrayList<String> alarmParams = new ArrayList<String>();
            alarmParams.add(libFile.getLibName());
            this.createIPReputationAlarm(alarmParams);
        }
    }

    public void keepLastThreeIPReputationLibFile() {
        this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        List<LibraryFile> liFileList = this.libraryFileService.getAutoIPReputationLibFile();
        for (int i = 3; liFileList != null && i < liFileList.size(); ++i) {
            String libFilePath = LibFilePathUtil.getLibFilePath() + liFileList.get(i).getLibName();
            File file = new File(libFilePath);
            if (!file.exists() || !file.isFile() || !file.delete()) continue;
            this.libraryFileService.delById(liFileList.get(i).getPkId());
        }
    }

    private Map<String, String> createDeployuConditionMap(LibraryFile libFile) {
        HashMap<String, String> condtionMap = new HashMap<String, String>();
        condtionMap.put("ddosVersion", libFile.getDdosVersion());
        condtionMap.put("objectId", String.valueOf(libFile.getPkId()));
        condtionMap.put("objectType", String.valueOf(libFile.getLibType()));
        condtionMap.put("libFilePath", LibFilePathUtil.getLibFilePath() + libFile.getLibName());
        return condtionMap;
    }

    public void deployIPRPULibFile() {
        this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        LibraryFile newLibFile = this.libraryFileService.getLastAutoIPReputationLibFile();
        LibraryFile deployLibFile = this.libraryFileService.getDeployIPReputationLibFile();
        if (newLibFile != null && newLibFile.getDeployTime() == 0L && (deployLibFile == null || newLibFile.getImportTime() > deployLibFile.getImportTime())) {
            try {
                DeployLibFileThread deployLibFileThread = new DeployLibFileThread(this.createDeployuConditionMap(newLibFile), this.aticDeviceService.getAntiDDoSDevice());
                deployLibFileThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
                deployLibFileThread.start();
            }
            catch (Exception e) {
                this.log.error((Object)("deployLibFileThread start error " + e.toString()));
            }
        }
    }

    public void downloadSecLibFile() {
        List<UpdateModel> updateInfoList = this.syncloadLibFile();
        List<UpdateModel> umList = this.getLibraryFileUpdateModelInfo();
        for (UpdateModel um : umList) {
            this.addLibFileToSyncList(updateInfoList, um);
        }
    }

    public List<UpdateModel> syncloadLibFile() {
        Map<String, List<UpdateModel>> updateInfoMap = this.getUpdateInfo();
        if (updateInfoMap.isEmpty()) {
            this.log.info((Object)"updateInfoMap is null or Empty");
            return null;
        }
        Set<Map.Entry<String, List<UpdateModel>>> restAuthSet = updateInfoMap.entrySet();
        ArrayList<UpdateModel> updateInfoList = new ArrayList<UpdateModel>();
        this.setLibraryFileService((ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class));
        int countLibraryFile = this.libraryFileService.getLibFileCount();
        block0: for (Map.Entry<String, List<UpdateModel>> updateListEntry : restAuthSet) {
            boolean isIps = updateListEntry.getKey().startsWith("IPS");
            List<UpdateModel> updateList = updateListEntry.getValue();
            if (null == updateList) {
                this.log.info((Object)("updateInfoList is null. updateListEntry.getKey() is :" + SecDownLoadUtil.getcleanedMessage(updateListEntry.getKey())));
            }
            Map<UpdateModel, Boolean> checkResult = this.checkDownload(updateList);
            for (Map.Entry<UpdateModel, Boolean> entry : checkResult.entrySet()) {
                String libFileName = "";
                if (null != entry.getKey()) {
                    int mapIndex;
                    libFileName = isIps ? ((mapIndex = updateListEntry.getKey().indexOf(ANTI_DDOS)) < 0 ? "" : this.ipsOfflineFileName.get(updateListEntry.getKey().substring(mapIndex))) : this.getLibFileNameFromUpdateInfo(entry.getKey());
                }
                if (this.libraryFileService.isExists(libFileName) || !entry.getValue().booleanValue()) {
                    entry.getKey().setMessageCode("420");
                    updateInfoList.add(entry.getKey());
                    continue;
                }
                if (++countLibraryFile > this.allLibFileNum) {
                    entry.getKey().setMessageCode("571903");
                    updateInfoList.add(entry.getKey());
                    continue;
                }
                if (entry.getValue().booleanValue()) {
                    boolean isDownload = false;
                    if (isIps) {
                        UpdateModel updateModel;
                        int mapIndex = updateListEntry.getKey().indexOf(ANTI_DDOS);
                        String ipsEngName = "";
                        ipsEngName = mapIndex < 0 ? "" : this.ipsEngFileName.get(updateListEntry.getKey().substring(mapIndex));
                        if (null == updateList) {
                            this.log.info((Object)"updateList is null.");
                            continue block0;
                        }
                        Iterator<UpdateModel> iterator = updateList.iterator();
                        while (iterator.hasNext() && (isDownload = this.download(updateModel = iterator.next()))) {
                        }
                        if (isDownload && (isDownload = this.creatOfflineIniFile(entry.getKey()))) {
                            isDownload = this.packSecIpsLib(libFileName, ipsEngName);
                        }
                        if (!isDownload) {
                            entry.getKey().setMessageCode("421");
                        }
                        this.deleteIpsFile(ipsEngName);
                    } else {
                        isDownload = this.download(entry.getKey());
                    }
                    if (isDownload) {
                        entry.getKey().setDownLoad(true);
                    } else {
                        --countLibraryFile;
                    }
                }
                updateInfoList.add(entry.getKey());
            }
        }
        return updateInfoList;
    }

    public Map<String, List<UpdateModel>> getUpdateInfo() {
        this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        FsmServerParam.ByReference fsmServerParam = new FsmServerParam.ByReference();
        try {
            fsmServerParam.setSzRemoteAddr(this.libraryFileService.getSecDownHttpUrl());
        }
        catch (UnsupportedEncodingException e1) {
            this.log.error((Object)("RemoteAddr i18n is error." + e1.getMessage()));
        }
        fsmServerParam.setUsRemotePort(Short.parseShort(this.libraryFileService.getSecDownHttpPort()));
        FsmProxyParam.ByReference fsmProxyParam = new FsmProxyParam.ByReference();
        FsmProductParam.ByReference fsmProductParam = new FsmProductParam.ByReference();
        HashMap<String, List<UpdateModel>> updateMap = new HashMap<String, List<UpdateModel>>();
        if (AticUtil.isNull((String)this.libFilePath)) {
            this.libFilePath = LibFilePathUtil.getLibFilePath();
        }
        List<UpdateModel> needUpdata = this.getLibraryFileUpdateModelInfo();
        for (UpdateModel updateModel : needUpdata) {
            String ipsFileDDoSVer = "";
            ArrayList<UpdateModel> updateList = new ArrayList<UpdateModel>();
            String modeName = updateModel.getModeName();
            FsmUpdateParam.ByReference fsmUpdateParam = new FsmUpdateParam.ByReference();
            LatestVersionTag.ByReference latestVersionTag = new LatestVersionTag.ByReference();
            try {
                fsmUpdateParam.setSzLocalPath(this.libFilePath);
                fsmProductParam.setSzPrdName(updateModel.getProductName());
                fsmProductParam.setSzPrdVer(updateModel.getProductVersion());
                fsmProductParam.setSzDevEsn(updateModel.getEsn());
                fsmUpdateParam.setSzSdbCtrlItem(updateModel.getModeName());
            }
            catch (UnsupportedEncodingException e1) {
                this.log.error((Object)"SzLocalPath or SzPrdName or SzPrdVer or SzDevEsn SzSdbCtrlItem i18n error");
            }
            AppSumCbbLibrary library = AppSumCbbLibrary.SYNC_INSTANCE;
            int result = library.libGetVersion(fsmServerParam, fsmProxyParam, fsmProductParam, fsmUpdateParam, latestVersionTag);
            String szLatestVer = "";
            String szIpsEngineVer = "";
            try {
                szLatestVer = new String(latestVersionTag.getSzLatestVer(), "utf-8").trim();
                szIpsEngineVer = new String(latestVersionTag.getSzIpsEngineVer(), "utf-8").trim();
            }
            catch (UnsupportedEncodingException e) {
                this.log.error((Object)("connectServerfailed!" + e.getMessage()));
            }
            if (0 != result || szLatestVer.isEmpty()) {
                this.log.info((Object)("no version exist or query result failed. result=" + result));
                continue;
            }
            HashMap<String, FeatureModel> featureMap = new HashMap<String, FeatureModel>();
            FeatureModel versionFeatureModel = new FeatureModel();
            versionFeatureModel.setFeatureVersion(szLatestVer);
            versionFeatureModel.setFeatureType("LIBRARY");
            featureMap.put(szLatestVer, versionFeatureModel);
            if (updateModel.getModeName().startsWith("IPS")) {
                this.ipsLibFileName = this.getFileNameByFeatureModel(updateModel, versionFeatureModel);
                this.log.info((Object)("ipsLibFileName:" + SecDownLoadUtil.getcleanedMessage(this.ipsLibFileName)));
            }
            String ipsEngineVersion = szIpsEngineVer.trim();
            versionFeatureModel.setEngineVersion(ipsEngineVersion);
            if (!ipsEngineVersion.isEmpty()) {
                FeatureModel ipsEngineFeatureModel = new FeatureModel();
                ipsEngineFeatureModel.setFeatureVersion(szIpsEngineVer);
                ipsEngineFeatureModel.setFeatureType("ENGINE");
                ipsEngineFeatureModel.setEngineVersion(ipsEngineVersion);
                featureMap.put(szIpsEngineVer, ipsEngineFeatureModel);
                this.ipsEngFileName.put(updateModel.getProductName(), this.getFileNameByFeatureModel(updateModel, ipsEngineFeatureModel));
                this.log.info((Object)("ipsEngFileName:" + SecDownLoadUtil.getcleanedMessage(this.ipsEngFileName.get(updateModel.getProductName())) + ":ProductName" + updateModel.getProductName()));
                ipsFileDDoSVer = this.getIPSFileNameByFeatureModel(updateModel, ipsEngineFeatureModel);
                Integer dotLastIndex = ipsFileDDoSVer.lastIndexOf(46);
                if (dotLastIndex != -1) {
                    this.ipsOfflineFileName.put(updateModel.getProductName(), ipsFileDDoSVer.substring(0, dotLastIndex) + "_" + OFFLINE + ".zip");
                } else {
                    this.ipsOfflineFileName.put(updateModel.getProductName(), "");
                }
                this.log.info((Object)("ipsOfflineFileName:" + SecDownLoadUtil.getcleanedMessage(this.ipsOfflineFileName.get(updateModel.getProductName())) + ":updateModel.getProductName():" + updateModel.getProductName()));
            }
            updateModel.setFeatureMap(featureMap);
            updateModel.setMessageCode(String.valueOf(0));
            updateList.add(updateModel);
            updateMap.put(modeName + updateModel.getProductName(), updateList);
        }
        return updateMap;
    }

    private void deleteIpsFile(String ipsEngName) {
        if (AticUtil.isNull((String)this.libFilePath)) {
            this.libFilePath = LibFilePathUtil.getLibFilePath();
        }
        if (null != this.ipsEngFileName) {
            this.deleteFile(this.libFilePath + ipsEngName);
        }
        if (null != this.ipsLibFileName) {
            this.deleteFile(this.libFilePath + this.ipsLibFileName);
        }
        if (null != this.ipsOfflineIniFileName) {
            this.deleteFile(this.libFilePath + this.ipsOfflineIniFileName);
        }
    }

    private void deleteFile(String fileAllpath) {
        File file = new File(fileAllpath);
        if (file.exists() && !file.delete()) {
            this.log.error((Object)"file.delete() failed");
        }
    }

    private void addLibFileToSyncList(List<UpdateModel> updateInfoList, UpdateModel um) {
        SysOptLog syncSysLog = new SysOptLog();
        syncSysLog.setOperation("atic.bis.libraryFile.autosecdownload");
        syncSysLog.setModule("lego.dic.module.AticBis");
        syncSysLog.setLevel(SysoplogLevel.normal.getValue());
        syncSysLog.setOperator("system");
        syncSysLog.setTerminalIp("127.0.0.1");
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        String modeName = um.getModeName().trim();
        if (null != updateInfoList) {
            for (UpdateModel updateModel : updateInfoList) {
                if (!updateModel.getModeName().trim().equals(modeName) || !updateModel.getProductName().trim().equals(um.getProductName().trim())) continue;
                if (updateModel.getMessageCode().equals(String.valueOf(0))) {
                    boolean isSave = false;
                    String libFilePathStr = LibFilePathUtil.getLibFilePath();
                    String libFileName = "";
                    libFileName = updateModel.getModeName().startsWith("IPS") ? this.getIpsOfflineFileName().get(updateModel.getProductName()) : this.getLibFileNameFromUpdateInfo(updateModel);
                    String sha256 = this.getLibFileSHA256FromUpdateInfo(updateModel);
                    File libFile = new File(libFilePathStr + libFileName);
                    if (!AticUtil.isNull((String)libFileName) && libFile.exists()) {
                        isSave = this.saveLibFile(libFileName, libFile, sha256, updateModel);
                    }
                    if (isSave) {
                        syncSysLog.setResult(1);
                        syncSysLog.setTarget(libFileName);
                        syncSysLog.setDetail("atic.bis.libraryFile.autosecdownload.success");
                        sysOptLog.writeOptLog(syncSysLog);
                        continue;
                    }
                    syncSysLog.setResult(0);
                    syncSysLog.setTarget(libFileName);
                    syncSysLog.setDetail("atic.bis.libraryFile.autosecdownload.fail");
                    sysOptLog.writeOptLog(syncSysLog);
                    continue;
                }
                String messageCode = "atic.bis.libraryFile.sync.error." + updateModel.getMessageCode();
                if ("420".equals(updateModel.getMessageCode())) {
                    String remotelibFileName = this.getLibFileNameFromUpdateInfo(updateModel);
                    this.log.info((Object)("remotelibFileName:" + remotelibFileName + ";" + updateModel.getProductName()));
                    syncSysLog.setResult(1);
                    syncSysLog.setTarget(remotelibFileName);
                    syncSysLog.setDetail(messageCode);
                    sysOptLog.writeOptLog(syncSysLog);
                    continue;
                }
                String message = AticUtil.getText((String)messageCode);
                if (message.equals(messageCode)) {
                    syncSysLog.setResult(0);
                    syncSysLog.setTarget(modeName);
                    syncSysLog.setDetail("atic.bis.libraryFile.sync.error.unkonw");
                    sysOptLog.writeOptLog(syncSysLog);
                    continue;
                }
                syncSysLog.setResult(0);
                syncSysLog.setTarget(modeName);
                syncSysLog.setDetail(messageCode);
                sysOptLog.writeOptLog(syncSysLog);
            }
        } else {
            this.log.warn((Object)"updateInfoList is null");
            syncSysLog.setResult(0);
            syncSysLog.setTarget(modeName);
            syncSysLog.setDetail("lego.err.571917");
            sysOptLog.writeOptLog(syncSysLog);
        }
    }

    private boolean saveLibFile(String libFileName, File libFile, String sha256, UpdateModel updateModel) {
        try {
            String libType = this.getLibType(libFileName);
            int libSize = (int)(libFile.length() / (long)this.libFileSizeUnit + 1L);
            long importTime = System.currentTimeMillis() / 1000L;
            String importType = "Update";
            String deployStatus = "undeployed";
            if (libSize > this.libFileSize * this.libFileSizeUnit) {
                throw new LegoCheckedException(571912L);
            }
            this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
            if (this.libraryFileService.isExists(libFileName)) {
                throw new LegoCheckedException(571901L);
            }
            if (this.libraryFileService.getLibFileCount() >= this.allLibFileNum) {
                throw new LegoCheckedException(571903L);
            }
            LibraryFileForm libraryFileForm = new LibraryFileForm();
            if (updateModel.getModeName().startsWith("IPS")) {
                libraryFileForm.setDdosVersion(updateModel.getProductName());
            } else {
                libraryFileForm.setDdosVersion("--");
            }
            if (updateModel.getLibFileVersion() == "") {
                libraryFileForm.setLibVersion("--");
            } else {
                libraryFileForm.setDdosVersion(updateModel.getLibFileVersion());
            }
            libraryFileForm.setLibType(libType);
            libraryFileForm.setLibName(libFileName);
            libraryFileForm.setLibSize(libSize);
            libraryFileForm.setImportTime(importTime);
            libraryFileForm.setImportType(importType);
            libraryFileForm.setDeployStatus(deployStatus);
            libraryFileForm.setDeployTime(0L);
            if (null == sha256 || "".equals(sha256)) {
                libraryFileForm.setHashCode(SHA256Digester.getInstance().digest(libFileName));
            } else {
                libraryFileForm.setHashCode(sha256);
            }
            Long pkid = this.libraryFileService.saveLibraryFile(libraryFileForm);
            if (pkid > 0L) {
                return true;
            }
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)("autoSecDownload.saveLibFile4DBAndFirstInstall LegoCheckedException" + e.getErrorCode()));
            return false;
        }
        catch (Exception e) {
            this.log.error((Object)("autoSecDownload.saveLibFile4DBAndFirstInstall Exception." + e.getMessage()));
            return false;
        }
        return false;
    }

    public String getLibType(String libName) {
        String libType = "";
        if (libName.startsWith("location_sdb") && libName.endsWith(".zip")) {
            libType = "Lib_Location";
        } else if (libName.startsWith("REGION_H") && libName.endsWith(".zip")) {
            libType = "Lib_Location";
        } else if (libName.startsWith("IPS_H") && libName.endsWith(".zip")) {
            libType = "Lib_IPS";
        } else if (libName.startsWith("CNC_H") && libName.endsWith(".zip")) {
            libType = "Lib_CNC";
        } else if (libName.startsWith("IPRPU_H") && libName.endsWith(".zip")) {
            libType = "Lib_IpReputation";
        } else if (libName.startsWith("CSG_H") && libName.endsWith(".mod")) {
            libType = "Lib_SSLDetec";
        }
        return libType;
    }

    public String getLibFileNameFromUpdateInfo(UpdateModel updateModel) {
        ArrayList<String> libFileNameList = new ArrayList<String>();
        if (null != updateModel && null != updateModel.getFeatureMap()) {
            for (FeatureModel featureModel : updateModel.getFeatureMap().values()) {
                String libFileTemp = this.getFileNameByFeatureModel(updateModel, featureModel);
                libFileNameList.add(libFileTemp);
            }
            if (!libFileNameList.isEmpty()) {
                return (String)libFileNameList.get(0);
            }
        }
        return "";
    }

    public String getLibFileSHA256FromUpdateInfo(UpdateModel updateModel) {
        ArrayList<String> sha256List = new ArrayList<String>();
        if (null != updateModel) {
            for (FeatureModel featureModel : updateModel.getFeatureMap().values()) {
                String sha256 = featureModel.getFeatureSHA256();
                sha256List.add(sha256);
            }
            if (!sha256List.isEmpty()) {
                return (String)sha256List.get(0);
            }
        }
        return "";
    }

    public boolean download(UpdateModel updateModel) {
        boolean downLoadResult;
        block13: {
            UpdateModel um;
            FsmProductParam.ByReference fsmProductParam;
            FsmProxyParam.ByReference fsmProxyParam;
            FsmServerParam.ByReference fsmServerParam;
            AppSumCbbLibrary library;
            block12: {
                this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
                library = AppSumCbbLibrary.SYNC_INSTANCE;
                fsmServerParam = new FsmServerParam.ByReference();
                fsmServerParam.setUsRemotePort(Short.parseShort(this.libraryFileService.getSecDownHttpPort()));
                fsmProxyParam = new FsmProxyParam.ByReference();
                fsmProductParam = new FsmProductParam.ByReference();
                FsmUpdateParam.ByReference fsmUpdateParam = new FsmUpdateParam.ByReference();
                try {
                    fsmServerParam.setSzRemoteAddr(this.libraryFileService.getSecDownHttpUrl());
                    fsmProductParam.setSzPrdName(updateModel.getProductName());
                    fsmProductParam.setSzPrdVer(updateModel.getProductVersion());
                    fsmProductParam.setSzDevEsn(updateModel.getEsn());
                    fsmUpdateParam.setSzLocalPath(LibFilePathUtil.getLibFilePath());
                    fsmUpdateParam.setSzSdbCtrlItem(updateModel.getModeName());
                }
                catch (UnsupportedEncodingException e1) {
                    this.log.error((Object)("SzRemoteAddr or SzPrdName or SzPrdVer or SzDevEsn or SzLocalPath or SzSdbCtrlItem i18n error." + e1.getMessage()));
                }
                um = updateModel;
                downLoadResult = true;
                if (updateModel.getModeName().startsWith("IPS")) break block12;
                int downloadStatus = 0;
                try {
                    downloadStatus = library.libUpdate(fsmServerParam, fsmProxyParam, fsmProductParam, fsmUpdateParam);
                }
                catch (RuntimeException e) {
                    this.log.error((Object)"download fail");
                    downLoadResult = false;
                }
                if (downloadStatus == 0) break block13;
                this.log.error((Object)("download fail downloadStatus:" + downloadStatus));
                downLoadResult = false;
                break block13;
            }
            for (FeatureModel featureModel : um.getFeatureMap().values()) {
                int downloadStatus = 0;
                FsmUpdateParam.ByReference fsmParam = new FsmUpdateParam.ByReference();
                try {
                    fsmParam.setSzLocalPath(LibFilePathUtil.getLibFilePath());
                    fsmParam.setSzSdbCtrlItem(updateModel.getModeName());
                }
                catch (UnsupportedEncodingException e1) {
                    this.log.error((Object)"SzRemoteAddr or SzPrdName or SzPrdVer or SzDevEsn or SzLocalPath or SzSdbCtrlItem i18n error");
                }
                if ("LIBRARY".equalsIgnoreCase(featureModel.getFeatureType())) {
                    try {
                        fsmParam.setSzEngName("IPS");
                        fsmParam.setUlP2sType(1);
                        fsmParam.setSzEngVer(featureModel.getEngineVersion());
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.error((Object)("SzEngName or SzEngVer i18n error." + e.getMessage()));
                    }
                }
                try {
                    downloadStatus = library.libUpdate(fsmServerParam, fsmProxyParam, fsmProductParam, fsmParam);
                }
                catch (Exception e) {
                    this.log.error((Object)("download error:" + e.getMessage()));
                    downLoadResult = false;
                    break;
                }
                if (downloadStatus == 0) continue;
                this.log.error((Object)("download fail,downloadStatus:" + downloadStatus));
                downLoadResult = false;
                break;
            }
        }
        return downLoadResult;
    }

    private boolean creatOfflineIniFile(UpdateModel updateModel) {
        this.ipsOfflineIniFileName = this.ipsLibFileName.substring(0, this.ipsLibFileName.lastIndexOf(46)) + "_" + OFFLINE + ".ini";
        this.log.info((Object)("ipsOfflineIniFileName:" + SecDownLoadUtil.getcleanedMessage(this.ipsOfflineIniFileName)));
        DownloadSignature downloadSignature = new DownloadSignature();
        return downloadSignature.writeNewIniFile(updateModel, this.libFilePath, this.ipsOfflineIniFileName);
    }

    private boolean packSecIpsLib(String libFileName, String ipsEngName) {
        boolean isSuccess = false;
        File sdbFile = new File(this.libFilePath + this.ipsLibFileName);
        File engineFile = new File(this.libFilePath + ipsEngName);
        File newIniFile = new File(this.libFilePath + this.ipsOfflineIniFileName);
        String zipFilePath = this.libFilePath + libFileName;
        File zipFile = new File(zipFilePath);
        ArrayList<File> resFileList = new ArrayList<File>();
        resFileList.add(sdbFile);
        resFileList.add(engineFile);
        resFileList.add(newIniFile);
        try {
            PackUtil.zipFiles(resFileList, zipFile);
            isSuccess = true;
        }
        catch (IOException e) {
            this.log.error((Object)("packSecIpsLib filed IOException" + e.getMessage()));
        }
        return isSuccess;
    }

    public Map<UpdateModel, Boolean> checkDownload(List<UpdateModel> updateList) {
        HashMap<UpdateModel, Boolean> checkResult = new HashMap<UpdateModel, Boolean>();
        if (null == updateList || updateList.isEmpty()) {
            return checkResult;
        }
        ILibraryFileService libraryFileServices = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        boolean isActive = false;
        for (UpdateModel um : updateList) {
            if (um.getMessageCode().equals(String.valueOf(0))) {
                Iterator<Map.Entry<String, FeatureModel>> it = um.getFeatureMap().entrySet().iterator();
                while (it.hasNext()) {
                    int libraryFileCount = libraryFileServices.queryByPage(this.createCondition(um, it.next()), 0, 0).getCount();
                    if (libraryFileCount <= 0) continue;
                    this.log.info((Object)"atic has the last lib file.");
                }
                if (um.getFeatureMap().isEmpty()) {
                    this.log.info((Object)"no lib file to down.");
                } else {
                    this.log.info((Object)("has lib file to down, productName : " + SecDownLoadUtil.getcleanedMessage(um.getProductName())));
                    isActive = true;
                }
            }
            checkResult.put(um, isActive);
        }
        return checkResult;
    }

    private Map<String, String> createCondition(UpdateModel um, Map.Entry<String, FeatureModel> entry) {
        String libName = "";
        libName = um.getModeName().startsWith("IPS") ? this.getIPSFileNameByFeatureModel(um, entry.getValue()) : this.getFileNameByFeatureModel(um, entry.getValue());
        String libType = "";
        libType = ANTI_DDOS.equals(um.getProductName()) ? "Lib_BOT" : "Lib_Location";
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("libName", libName);
        queryMap.put("libType", libType);
        queryMap.put("importType", "Update");
        return queryMap;
    }

    private String getFileNameByFeatureModel(UpdateModel um, FeatureModel featureModel) {
        um.setLibFileVersion(featureModel.getFeatureVersion());
        if ("ENGINE".equalsIgnoreCase(featureModel.getFeatureType())) {
            return um.getModeName() + "_" + featureModel.getFeatureVersion() + ".zip";
        }
        if (um.getLibFileType().contains("SSLDetec")) {
            return featureModel.getFeatureVersion() + ".mod";
        }
        if (um.getProductName().startsWith("AntiDDoS18") && um.getModeName().startsWith("IPRPU")) {
            this.log.info((Object)"get IPRPU_H10010001");
            return "IPRPU_H10010001_" + featureModel.getFeatureVersion() + ".zip";
        }
        if (um.getProductName().startsWith("AntiDDoS8") && um.getModeName().startsWith("IPRPU")) {
            this.log.info((Object)"get IPRPU_H10010000");
            return "IPRPU_H20010000_" + featureModel.getFeatureVersion() + ".zip";
        }
        this.log.info((Object)("other ModeName():" + um.getModeName()));
        return um.getModeName().replaceAll("_E", "_H") + "_" + featureModel.getFeatureVersion() + ".zip";
    }

    private String getIPSFileNameByFeatureModel(UpdateModel um, FeatureModel featureModel) {
        this.log.info((Object)("get IPS " + um.getProductName()));
        return um.getModeName().replaceAll("_E", "_H") + "_" + um.getProductName().substring(ANTI_DDOS.length()) + "_" + featureModel.getFeatureVersion() + ".zip";
    }

    public List<String> getLibraryIPSDDoSVersion() {
        this.log.info((Object)"get ddosmodel start");
        Document document = this.openXML("/libraryFile.xml");
        ArrayList<String> umList = new ArrayList<String>();
        if (null == document) {
            this.log.info((Object)"document is null.");
            return umList;
        }
        List list = document.selectNodes("//libraryFiles/libraryFile");
        for (Node node : list) {
            String productName = "";
            String modeName = node.selectSingleNode("@modeName").getText();
            if (!modeName.toUpperCase(Locale.US).startsWith("IPS")) continue;
            productName = node.selectSingleNode("@productName").getText();
            umList.add(productName);
        }
        return umList;
    }

    public List<UpdateModel> getLibraryFileUpdateModelInfo() {
        this.log.info((Object)"get ddosmodel start");
        AticDeviceServiceImpl aticDeviceService = (AticDeviceServiceImpl)ServiceContext.getInstance().getService("aticDeviceService", AticDeviceServiceImpl.class);
        Boolean hasAntiDDoS1825 = false;
        Boolean hasAntiDDoS80 = false;
        Boolean hasAntiDDoS1820 = false;
        List allDdosFirewall = aticDeviceService.getAntiDDoSDevice();
        HashSet<String> ddosModelSet = new HashSet<String>();
        for (AticDevice firewall : allDdosFirewall) {
            ddosModelSet.add(firewall.getDeviceModel().toUpperCase(Locale.US));
            if (firewall.getDeviceModel().toUpperCase(Locale.US).startsWith("ANTIDDOS8")) {
                hasAntiDDoS80 = true;
                continue;
            }
            if (firewall.getDeviceModel().toUpperCase(Locale.US).startsWith("ANTIDDOS1825")) {
                hasAntiDDoS1825 = true;
                continue;
            }
            if (!firewall.getDeviceModel().toUpperCase(Locale.US).startsWith("ANTIDDOS18")) continue;
            hasAntiDDoS1820 = true;
        }
        this.log.info((Object)"get ddosmodel end");
        Document document = this.openXML("/libraryFile.xml");
        ArrayList<UpdateModel> umList = new ArrayList<UpdateModel>();
        if (null == document) {
            this.log.info((Object)"document is null.");
            return umList;
        }
        List list = document.selectNodes("//libraryFiles/libraryFile");
        for (Node node : list) {
            String type = node.selectSingleNode("@type").getText();
            String productName = node.selectSingleNode("@productName").getText();
            String productVersion = node.selectSingleNode("@productVersion").getText();
            String modeName = node.selectSingleNode("@modeName").getText();
            if (modeName.toUpperCase(Locale.US).startsWith("IPRPU")) {
                if (!(hasAntiDDoS80.booleanValue() || hasAntiDDoS1820.booleanValue() || hasAntiDDoS1825.booleanValue())) {
                    this.log.debug((Object)"without antiddos device,so download all IPRPU");
                } else if (productName.toUpperCase(Locale.US).startsWith("ANTIDDOS8") && !hasAntiDDoS80.booleanValue() || productName.toUpperCase(Locale.US).startsWith("ANTIDDOS18") && !hasAntiDDoS1820.booleanValue() && !hasAntiDDoS1825.booleanValue()) continue;
            }
            if (modeName.toUpperCase(Locale.US).startsWith("IPS")) {
                if (ddosModelSet.isEmpty()) {
                    this.log.debug((Object)"without antiddos device,so not download IPS");
                    continue;
                }
                if (!ddosModelSet.contains(productName.toUpperCase(Locale.US))) continue;
            }
            UpdateModel um = new UpdateModel();
            um.setLibFileType(type);
            um.setModeName(modeName);
            um.setCurVer(this.findLibFileMaxVer(type, productName));
            if (AticUtil.isNull((String)regist)) {
                this.getRegist();
            }
            um.setEsn(regist);
            um.setLac(regist + "_" + type);
            um.setProductName(productName);
            um.setProductVersion(productVersion);
            umList.add(um);
        }
        return umList;
    }

    private String findLibFileMaxVer(String libFileType, String productName) {
        String libFileMaxVer = "";
        this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        LibraryFileForm libFileForm = this.libraryFileService.getMaxVerLibFile(libFileType, productName);
        if (null != libFileForm && libFileType.equalsIgnoreCase("Lib_BOT")) {
            String maxVer = libFileForm.getLibName().split("_")[2];
            libFileMaxVer = maxVer.substring(0, maxVer.length() - 4);
        }
        return libFileMaxVer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document openXML(String path) {
        Document document = null;
        InputStream inputStream = null;
        try {
            inputStream = SecDownLoadUtil.class.getResourceAsStream(path);
            SAXReader reader = new SAXReader();
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)reader);
            document = reader.read(inputStream);
        }
        catch (DocumentException e) {
            this.log.error((Object)"openXML() read failed DocumentException");
        }
        catch (SAXException e) {
            this.log.error((Object)"openXML() read failed SAXException");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"openXML() inputStream.close() Exception");
                }
            }
        }
        return document;
    }

    public void changeLibFileDeployingToFail() {
        this.libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        List<LibraryFile> files = this.libraryFileService.queryByDeployStatus("deploying");
        for (LibraryFile file : files) {
            this.libraryFileService.setLibFileDepolyStatus("failure", file.getPkId());
        }
    }

    public ILibraryFileService getLibraryFileService() {
        return this.libraryFileService;
    }

    public void setLibraryFileService(ILibraryFileService libraryFileService) {
        this.libraryFileService = libraryFileService;
    }
}

