/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.lus.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SHA256Digester {
    private static final int TWO = 2;
    private static final int OXFF = 255;
    private static SHA256Digester instance = null;
    private static Lock lock = new ReentrantLock();
    private MessageDigest sha256 = null;
    private transient Log log = LogFactory.getLog(this.getClass());

    private SHA256Digester() {
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)e.getMessage());
        }
    }

    public static SHA256Digester getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new SHA256Digester();
            }
            SHA256Digester sHA256Digester = instance;
            return sHA256Digester;
        }
        finally {
            lock.unlock();
        }
    }

    public String digest(String str) throws UnsupportedEncodingException {
        lock.lock();
        try {
            String string = this.digest(str.getBytes("UTF-8"));
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String digest(byte[] raw) {
        lock.lock();
        try {
            byte[] digest = this.sha256.digest(raw);
            String string = this.byteArr2HexStr(digest);
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private String byteArr2HexStr(byte[] raw) {
        int iLen = raw.length;
        StringBuilder sb = new StringBuilder(raw.length * 2);
        String stmp = null;
        for (int i = 0; i < iLen; ++i) {
            stmp = Integer.toHexString(raw[i] & 0xFF);
            if (stmp.length() == 1) {
                sb.append('0').append(stmp);
                continue;
            }
            sb.append(stmp);
        }
        return sb.toString();
    }
}

