/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.collector.entity.alarm.AbnormalAlarmEntity;
import com.hs.atic.highdefense.domain.model.DefenseSwitchHistory;
import com.hs.atic.highdefense.domain.model.form.DefenseConfigForm;
import com.hs.atic.highdefense.domain.service.IDefenseConfigService;
import com.hs.atic.highdefense.domain.service.IHuaweiCloudIdentityService;
import com.hs.atic.highdefense.domain.util.LocalDateTimeUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.atic.device.license.service.ILicenseManagementService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AdvancedAlarmHandler {
    private static final int LOG_RESULT_SUCCESS = 1;
    private static final int LOG_RESULT_FAILED = 0;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    @Autowired
    @Qualifier(value="licenseManagementServiceImpl")
    private ILicenseManagementService licenseManagementService;
    @Autowired
    @Qualifier(value="defenseConfigService")
    private IDefenseConfigService defenseConfigService;
    @Autowired
    @Qualifier(value="huaweiCloudIdentityService")
    private IHuaweiCloudIdentityService huaweiCloudIdentityService;
    private long maxCheckTime = 6L;
    private long maxInternalTime = 10000L;
    private List<String> advancedIpList = new ArrayList<String>();

    private long isSwitchHighDefense(DefenseConfigForm configForm, boolean isAadAccount) {
        if (!isAadAccount) {
            boolean checkLicense = this.licenseManagementService.checkLicenseByDevIp(configForm.getDeviceIp());
            if (!checkLicense) {
                this.logger.error((Object)("highDefenseLinkSwitch check License false deviceIp = " + configForm.getDeviceIp() + " zoneIp = " + configForm.getZoneIp()));
                return 50004L;
            }
            boolean checkConCur = this.defenseConfigService.concurOnlineDefenseCheckByDevIp(configForm.getDeviceIp());
            if (!checkConCur) {
                this.logger.error((Object)("highDefenseLinkSwitch check concurOnline false deviceIp = " + configForm.getDeviceIp() + " zoneIp = " + configForm.getZoneIp()));
                return 50005L;
            }
            int backFillCount = this.licenseManagementService.licenseSwitchCountBackfillByDevIp(configForm.getDeviceIp());
            if (backFillCount <= 0) {
                return 50006L;
            }
        }
        return 50000L;
    }

    public void abnormalAlarm(List<AbnormalAlarmEntity> advancedAlarmList) {
        boolean isAadAccount = this.defenseConfigService.isDefenseIndependentAccount();
        long switchDetails = 0L;
        for (AbnormalAlarmEntity advanceAlarm : advancedAlarmList) {
            if (this.advancedIpList.contains(advanceAlarm.getZoneIp())) continue;
            List<DefenseConfigForm> dConfigForms = this.defenseConfigService.queryDefenseConfigsByZoneIp(advanceAlarm.getZoneIp());
            for (DefenseConfigForm configForm : dConfigForms) {
                if (0 == configForm.getSwitchToOnline() || 4 != configForm.getState()) continue;
                switchDetails = this.isSwitchHighDefense(configForm, isAadAccount);
                if (50000L == switchDetails) {
                    this.advancedIpList.add(advanceAlarm.getZoneIp());
                    this.defenseConfigService.switchAutomaticAndBlock(configForm);
                    continue;
                }
                DefenseSwitchHistory switchHistory = new DefenseSwitchHistory();
                switchHistory.setState(1);
                switchHistory.setDetail("defense.err." + switchDetails);
                this.saveSwitchHistory(isAadAccount, configForm, switchHistory);
                String detail = "atic.bis.online.offline.Defense.log.online.details.fail";
                String[] detailPara = new String[]{advanceAlarm.getZoneIp(), switchHistory.getDetail()};
                this.batchRsult(false, detail, detailPara);
            }
        }
    }

    public void checkAdvancedIpState() {
        List<String> loopIpList = this.advancedIpList;
        this.advancedIpList = new ArrayList<String>();
        boolean isAadAccount = this.defenseConfigService.isDefenseIndependentAccount();
        String detail = "";
        String[] detailPara = null;
        for (String advancedIp : loopIpList) {
            List<DefenseConfigForm> dConfigForms = this.defenseConfigService.queryDefenseConfigsByZoneIp(advancedIp);
            for (DefenseConfigForm configForm : dConfigForms) {
                DefenseSwitchHistory switchHistory = new DefenseSwitchHistory();
                boolean switchSuccess = false;
                int i = 0;
                while ((long)i < this.maxCheckTime && !switchSuccess) {
                    switchSuccess = this.defenseConfigService.checkAdvancedIpSwitchState(configForm, switchHistory);
                    try {
                        if (!switchSuccess) {
                            Thread.sleep(this.maxInternalTime);
                        }
                    }
                    catch (InterruptedException e) {
                        this.logger.error((Object)("checkAdvancedIpState InterruptedException :" + e.getMessage()));
                    }
                    ++i;
                }
                if (switchSuccess) {
                    if (!isAadAccount) {
                        this.logger.info((Object)"isNotDefenseIndependentAccount in checkAdvancedIpState()");
                        this.licenseManagementService.refreshSwitchCountByDevIp(configForm.getDeviceIp());
                    }
                    configForm.setState(0);
                    switchHistory.setState(0);
                    detail = "atic.bis.online.offline.Defense.log.online.details.success";
                    detailPara = new String[]{advancedIp};
                    this.batchRsult(true, detail, detailPara);
                } else {
                    this.logger.error((Object)("checkAdvancedIpState failed refreshSwitchCount deviceIp = " + configForm.getDeviceIp() + " zoneIp = " + advancedIp));
                    configForm.setState(4);
                    switchHistory.setState(1);
                    detail = "atic.bis.online.offline.Defense.log.online.details.fail";
                    detailPara = new String[]{advancedIp, switchHistory.getDetail()};
                    this.batchRsult(false, detail, detailPara);
                }
                configForm.setUpdatedDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
                this.defenseConfigService.updateDefenseState(configForm);
                this.saveSwitchHistory(isAadAccount, configForm, switchHistory);
            }
        }
    }

    private void saveSwitchHistory(boolean isAadAccount, DefenseConfigForm configForm, DefenseSwitchHistory switchHistory) {
        switchHistory.setSwitchType(1);
        switchHistory.setSwitchDirection(1);
        switchHistory.setSwitchDateTime(LocalDateTimeUtil.getDateTimeOfTimestamp(System.currentTimeMillis()));
        switchHistory.setOperator("system");
        switchHistory.setDeviceName(configForm.getDeviceName());
        switchHistory.setSwitchIp(configForm.getZoneIp());
        switchHistory.setBackIp(configForm.getBackIp());
        if (isAadAccount) {
            switchHistory.setLicenseNumber("00");
        } else {
            switchHistory.setLicenseNumber(configForm.getLicenseNumber());
        }
        this.logger.info((Object)("checkAdvancedIpSwitchState switchHistory : " + switchHistory.toString()));
        this.defenseConfigService.saveSwitchHistory(switchHistory);
    }

    private void batchRsult(boolean isSuccess, String detail, String[] detailPara) {
        SysOptLog syncSysLog = new SysOptLog();
        syncSysLog.setTargetLocal(Boolean.valueOf(true));
        if (isSuccess) {
            syncSysLog.setResult(1);
            syncSysLog.setLevel(SysoplogLevel.info.getValue());
        } else {
            syncSysLog.setResult(0);
            syncSysLog.setLevel(SysoplogLevel.normal.getValue());
        }
        syncSysLog.setModule("lego.fault.severity.rule.diversion.cloud");
        syncSysLog.setOperation("atic.bis.online.offline.Defense.switch.online");
        syncSysLog.setTarget("atic.bis.online.offline.Defense.config.title");
        syncSysLog.setOperator("system");
        syncSysLog.setTerminalIp("127.0.0.1");
        syncSysLog.setDetail(detail);
        syncSysLog.setDetailPara(detailPara);
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        sysOptLog.writeOptLog(syncSysLog);
    }
}

