/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.rmi.AttackData;
import com.hs.atic.rmi.AttackDataRmiService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.AttackDataForm;
import com.hs.atic.sdk.bis.service.IAttackDataService;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AttackDataServiceImpl
implements IAttackDataService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ZoneCollectorRMIProxy collectorRMIProxy;
    private IAticDeviceService aticDeviceService;
    private ICollectorService collectorService;
    private ICollectorDeviceService collectorDeviceService;

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ZoneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(ZoneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    private List<AttackData> getPageData4AttackEvent(List<String> collectorIpList, List<Integer> collectorDataNum, Map<String, Object> queryMap) {
        int pageSize;
        ArrayList<AttackData> pageData = new ArrayList<AttackData>();
        if (null == collectorIpList || collectorIpList.isEmpty()) {
            return pageData;
        }
        int start = Integer.parseInt(String.valueOf(queryMap.get("start")));
        if (start + (pageSize = Integer.parseInt(String.valueOf(queryMap.get("pageSize")))) < collectorDataNum.get(0)) {
            int startIndex = start;
            int pageSizeNew = pageSize;
            this.logger.info((Object)(collectorIpList.get(0) + ", totalNum:" + collectorDataNum.get(0) + ", limit(" + startIndex + "," + pageSizeNew + ")"));
            List<AttackData> data = this.getCollectorAttackData(startIndex, pageSizeNew, collectorIpList.get(0), queryMap);
            pageData.addAll(data);
        } else {
            int i;
            int allCollectorTotalNum = 0;
            for (i = 0; i < collectorDataNum.size(); ++i) {
                allCollectorTotalNum += collectorDataNum.get(i).intValue();
            }
            if (0 == start && start + pageSize >= allCollectorTotalNum) {
                for (i = 0; i < collectorIpList.size(); ++i) {
                    int startIndex = 0;
                    int pageSizeNew = collectorDataNum.get(i);
                    this.logger.info((Object)("collectorIp: " + collectorIpList.get(i) + ", totalNum: " + collectorDataNum.get(i) + ", limit(" + startIndex + "," + pageSizeNew + ")"));
                    List<AttackData> data = this.getCollectorAttackData(startIndex, pageSizeNew, collectorIpList.get(i), queryMap);
                    pageData.addAll(data);
                }
            } else {
                int currentNum = 0;
                for (int i2 = 0; i2 < collectorDataNum.size(); ++i2) {
                    List<AttackData> data;
                    int pageSizeNew;
                    int startIndex;
                    if (start >= (currentNum += collectorDataNum.get(i2).intValue())) continue;
                    if (start + pageSize < currentNum) {
                        startIndex = start - (currentNum - collectorDataNum.get(i2));
                        pageSizeNew = pageSize;
                        this.logger.info((Object)("collectorIp: " + collectorIpList.get(i2) + ", totalNum: " + collectorDataNum.get(i2) + ", limit(" + startIndex + "," + pageSizeNew + ")"));
                        data = this.getCollectorAttackData(startIndex, pageSizeNew, collectorIpList.get(i2), queryMap);
                        pageData.addAll(data);
                        break;
                    }
                    startIndex = start - (currentNum - collectorDataNum.get(i2));
                    pageSizeNew = currentNum - start;
                    this.logger.info((Object)(collectorIpList.get(i2) + ": totalNum:" + collectorDataNum.get(i2) + ": limit(" + startIndex + "," + pageSizeNew + ")"));
                    data = this.getCollectorAttackData(startIndex, pageSizeNew, collectorIpList.get(i2), queryMap);
                    pageData.addAll(data);
                    start = currentNum;
                    pageSize -= pageSizeNew;
                }
            }
        }
        return pageData;
    }

    private List<AttackData> getCollectorAttackData(int startIndex, int pagetSizeNew, String collectorIp, Map<String, Object> queryMap) {
        queryMap.put("start", startIndex + "");
        queryMap.put("pageSize", pagetSizeNew + "");
        AttackDataRmiService service = this.collectorRMIProxy.getAttackDataService(collectorIp);
        List<AttackData> data = null;
        try {
            data = service.getAttackData(queryMap);
        }
        catch (RemoteException e) {
            throw new LegoCheckedException(570504L, (Throwable)e);
        }
        return data;
    }

    @Override
    public Paging getAttackData(Map<String, Object> queryMap) {
        List<String> collectorIpList = this.getCollectorIp(queryMap);
        Integer totalSize = 0;
        ArrayList<Integer> collectorDataNum = new ArrayList<Integer>();
        for (String collectorIp : collectorIpList) {
            AttackDataRmiService service = this.collectorRMIProxy.getAttackDataService(collectorIp);
            try {
                int thisCollectorNum = service.getQueryAllCount(queryMap);
                collectorDataNum.add(thisCollectorNum);
                totalSize = totalSize + thisCollectorNum;
            }
            catch (RemoteException e) {
                throw new LegoCheckedException(570504L, (Throwable)e);
            }
        }
        List<AttackData> pageData = this.getPageData4AttackEvent(collectorIpList, collectorDataNum, queryMap);
        Paging page = new Paging();
        ArrayList<AttackDataForm> forms = new ArrayList<AttackDataForm>();
        DecimalFormat df = new DecimalFormat("###,###");
        for (AttackData each : pageData) {
            String currentValue;
            AttackDataForm form = new AttackDataForm();
            String unit = AticConstants.attackLogThresholdTrans((int)each.getPpsOrKbps());
            String limitValue = each.getLimitValue() == 0L ? "-" : df.format(each.getLimitValue()) + unit;
            String string = currentValue = each.getCurrentValue() == 0L ? "-" : df.format(each.getCurrentValue()) + unit;
            if (each.isIsMultiCurrent()) {
                unit = AticConstants.attackLogThresholdTrans((int)each.getPpsOrKbps1());
                String limitValue1 = each.getLimitValue1() == 0L ? "-" : df.format(each.getLimitValue1()) + unit;
                limitValue = limitValue + "/" + limitValue1;
                String currentValue1 = each.getCurrentValue1() == 0L ? "-" : df.format(each.getCurrentValue1()) + unit;
                currentValue = currentValue + "/" + currentValue1;
            }
            form.setLimitDisplay(limitValue);
            form.setCurrentDisplay(currentValue);
            AticUtil.copyProperties((Object)each, (Object)form);
            if (null != form.getStartTimeAlert()) {
                form.setStartTimeAlertStr(AticUtil.formateTime((long)form.getStartTimeAlert()));
            }
            if (null != form.getEarlyAlertTime()) {
                form.setEarlyAlertTimeStr(AticUtil.formateTime((long)form.getEarlyAlertTime()));
            }
            if (null == form.getPkId()) {
                form.setPkId(each.getAttackDataPkId());
            }
            forms.add(form);
        }
        page.setData(forms);
        page.setCount(totalSize.intValue());
        return page;
    }

    @Override
    public void modifyAttackDatas(String inputStr, String collectorIP) {
        AttackDataRmiService service = this.collectorRMIProxy.getAttackDataService(collectorIP);
        try {
            service.modifyAttackDatas(inputStr);
        }
        catch (RemoteException e) {
            throw new LegoCheckedException(570504L, (Throwable)e);
        }
    }

    @Override
    public Map<String, Boolean> modifyAttackDatasForResult(String inputStr, String collectorIP) {
        AttackDataRmiService service = this.collectorRMIProxy.getAttackDataService(collectorIP);
        try {
            return service.modifyAttackDatasForResult(inputStr);
        }
        catch (RemoteException e) {
            throw new LegoCheckedException(570504L, (Throwable)e);
        }
    }

    private List<String> getCollectorIp(Map<String, Object> queryMap) {
        ArrayList<String> collectorIpList = new ArrayList<String>();
        String deviceIp = (String)queryMap.get("deviceIp");
        List<Object> deviceIps = new ArrayList();
        if (null != deviceIp && !deviceIp.isEmpty()) {
            String ips = deviceIp.substring(1, deviceIp.length() - 1);
            String[] deviceIpsArray = ips.split(",");
            deviceIps = Arrays.asList(deviceIpsArray);
        }
        for (String devIp : deviceIps) {
            Long deviceId = this.aticDeviceService.getMoidByIP(devIp);
            Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(deviceId);
            if (null == collectorId) {
                throw new LegoCheckedException(570508L);
            }
            String collectorIp = this.collectorService.getCollectorInfo(collectorId.longValue()).getIpAddress();
            if (collectorIpList.contains(collectorIp)) continue;
            collectorIpList.add(collectorIp);
        }
        return collectorIpList;
    }

    @Override
    public int getZoneDefendState(long zoneId, List<Long> devIdList) {
        block7: {
            try {
                List<CollectorInfo> allCollector = this.getCcoListByDevIds(devIdList);
                if (null == allCollector || allCollector.isEmpty()) break block7;
                HashSet<Integer> stateCache = new HashSet<Integer>();
                HashSet coIpCollections = new HashSet();
                for (CollectorInfo each : allCollector) {
                    String collectorIp = each.getIpAddress();
                    if (coIpCollections.contains(collectorIp)) continue;
                    AttackDataRmiService service = this.collectorRMIProxy.getAttackDataService(collectorIp);
                    int eachState = service.getZoneDefendState(zoneId);
                    if (eachState == 1) {
                        return 1;
                    }
                    stateCache.add(eachState);
                }
                if (stateCache.size() == 1) {
                    if (stateCache.contains(0)) {
                        return 0;
                    }
                    if (stateCache.contains(2)) {
                        return 2;
                    }
                    break block7;
                }
                return 1;
            }
            catch (Exception e) {
                this.logger.error((Object)("getZoneDefendState error." + e.getMessage()));
            }
        }
        return 0;
    }

    @Override
    public int getDefendState(long zoneId, Long devId, String deviceIp) {
        try {
            ArrayList<Long> devIdList = new ArrayList<Long>();
            devIdList.add(devId);
            List<CollectorInfo> allCollector = this.getCcoListByDevIds(devIdList);
            if (null != allCollector && !allCollector.isEmpty()) {
                String collectorIp = allCollector.get(0).getIpAddress();
                AttackDataRmiService service = this.collectorRMIProxy.getAttackDataService(collectorIp);
                int eachState = service.getDefendState(zoneId, deviceIp);
                return eachState;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("getZoneDefendState error." + e.getMessage()));
        }
        return 4;
    }

    private List<CollectorInfo> getCcoListByDevIds(List<Long> devIdList) {
        ArrayList<CollectorInfo> allCollector = null;
        if (!devIdList.isEmpty()) {
            allCollector = new ArrayList<CollectorInfo>();
            for (Long devId : devIdList) {
                try {
                    Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(devId);
                    if (collectorId == null) continue;
                    CollectorInfo info = this.collectorService.getCollectorInfo(collectorId.longValue());
                    allCollector.add(info);
                }
                catch (RuntimeException e) {
                    this.logger.error((Object)("getCcoListByDevIds error ,devId is : " + devId));
                }
            }
        }
        return allCollector;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    @Override
    public boolean getAttackStatus(String collectorIp, long zoneId, String zoneIp, String deviceIp) {
        boolean status = false;
        try {
            AttackDataRmiService service = this.collectorRMIProxy.getAttackDataService(collectorIp);
            status = service.getAttackStatus(zoneId, zoneIp, deviceIp);
        }
        catch (Exception e) {
            this.logger.error((Object)("getAttackStatusByIp error." + e.getMessage()));
        }
        return status;
    }
}

