/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.capability.model.ParaBean;
import com.huawei.atic.secservice.sdk.module.ddos.service.IDdosDevCapabilityService;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class BaselineTolerance {
    private static final String PPS_TYPE = "PPS";
    private static final String MBPS_TYPE = "MBPS";
    private static final String CONN_TYPE = "CONN";
    private static final String NEW_CONN_TYPE = "NewCONN";
    private static final String SRC_CONN_TYPE = "SRCCONN";
    private static final String SRC_NEW_CONN_TYPE = "SRCNewCONN";
    private static final String PERCENT_TYPE = "PERCENT";
    private static final String SYN_RATIO_PKT_TYPE = "SYNRatioPKT";
    private static int defaultTolerance4Error = 150;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private int defaultMaxTolerance4Pps;
    private int defaultMaxValue4Pps;
    private int defaultMinTolerance4Pps;
    private int defaultMinValue4Pps;
    private int maxValue4Pps;
    private int minValue4Pps;
    private int defaultMaxTolerance4Mbps;
    private int defaultMaxValue4Mbps;
    private int defaultMinTolerance4Mbps;
    private int defaultMinValue4Mbps;
    private int maxValue4Mbps;
    private int minValue4Mbps;
    private int defaultMaxTolerance4Conn;
    private int defaultMaxValue4Conn;
    private int defaultMinTolerance4Conn;
    private int defaultMinValue4Conn;
    private int maxValue4Conn;
    private int minValue4Conn;
    private int defaultMaxTolerance4NewConn;
    private int defaultMaxValue4NewConn;
    private int defaultMinTolerance4NewConn;
    private int defaultMinValue4NewConn;
    private int maxValue4NewConn;
    private int minValue4NewConn;
    private int defaultMaxTolerance4SrcConn;
    private int defaultMaxValue4SrcConn;
    private int defaultMinTolerance4SrcConn;
    private int defaultMinValue4SrcConn;
    private int maxValue4SrcConn;
    private int minValue4SrcConn;
    private int defaultMaxTolerance4SrcNewConn;
    private int defaultMaxValue4SrcNewConn;
    private int defaultMinTolerance4SrcNewConn;
    private int defaultMinValue4SrcNewConn;
    private int maxValue4SrcNewConn;
    private int minValue4SrcNewConn;
    private int defaultMaxTolerance4Percent;
    private int defaultMaxValue4Percent;
    private int defaultMinTolerance4Percent;
    private int defaultMinValue4Percent;
    private int maxValue4Percent;
    private int minValue4Percent;
    private int defaultMaxTolerance4SYNRatioPKT;
    private int defaultMaxValue4SYNRatioPKT;
    private int defaultMinTolerance4SYNRatioPKT;
    private int defaultMinValue4SYNRatioPKT;
    private int maxValue4SYNRatioPKT;
    private int minValue4SYNRatioPKT;
    private List<ToleranceArea> areas4Pps = new ArrayList<ToleranceArea>();
    private List<ToleranceArea> areas4Mbps = new ArrayList<ToleranceArea>();
    private List<ToleranceArea> areas4Conn = new ArrayList<ToleranceArea>();
    private List<ToleranceArea> areas4NewConn = new ArrayList<ToleranceArea>();
    private List<ToleranceArea> areas4SrcConn = new ArrayList<ToleranceArea>();
    private List<ToleranceArea> areas4SrcNewConn = new ArrayList<ToleranceArea>();
    private List<ToleranceArea> areas4Percent = new ArrayList<ToleranceArea>();
    private List<ToleranceArea> areas4SYNRatioPKT = new ArrayList<ToleranceArea>();
    private IDdosDevCapabilityService ddosDevCapabilityService;

    public BaselineTolerance() {
        String applicationPath = AticInstallUtil.getInstance().getAticInstallPath();
        File file = new File(new File(applicationPath) + File.separator + "vsm_conf" + File.separator + "antiddos" + File.separator + "baseline_tolerance.xml");
        if (file.exists()) {
            this.parseXml(file);
        }
    }

    private void parseAreaNode(Element node, List<ToleranceArea> areaLists) {
        Iterator it = node.elementIterator("area");
        while (it.hasNext()) {
            Element areaNode = (Element)it.next();
            ToleranceArea area = new ToleranceArea();
            if (null != areaNode.attributeValue("maxValue") && !"".equals(areaNode.attributeValue("maxValue"))) {
                area.setMaxValue(Integer.parseInt(areaNode.attributeValue("maxValue")));
            } else {
                area.setMaxValue(Integer.MAX_VALUE);
            }
            if (null != areaNode.attributeValue("minValue") && !"".equals(areaNode.attributeValue("minValue"))) {
                area.setMinValue(Integer.parseInt(areaNode.attributeValue("minValue")));
            } else {
                area.setMinValue(Integer.MIN_VALUE);
            }
            Element toleranceValue = areaNode.element("toleranceValue");
            area.setTolerance(Integer.parseInt(toleranceValue.getStringValue()));
            Element defaultValue = areaNode.element("defaultValue");
            area.setDefaultValue(Integer.parseInt(defaultValue.getStringValue()));
            areaLists.add(area);
        }
    }

    private void getNodes(Element node) {
        String type = node.attributeValue("type");
        if (PPS_TYPE.equals(type)) {
            this.defaultMaxTolerance4Pps = Integer.parseInt(node.attributeValue("defaultMaxTolerance"));
            this.defaultMaxValue4Pps = Integer.parseInt(node.attributeValue("defaultMaxValue"));
            this.defaultMinTolerance4Pps = Integer.parseInt(node.attributeValue("defaultMinTolerance"));
            this.defaultMinValue4Pps = Integer.parseInt(node.attributeValue("defaultMinValue"));
            this.maxValue4Pps = Integer.parseInt(node.attributeValue("maxValue"));
            this.minValue4Pps = Integer.parseInt(node.attributeValue("minValue"));
            this.parseAreaNode(node, this.areas4Pps);
        }
        if (MBPS_TYPE.equals(type)) {
            this.defaultMaxTolerance4Mbps = Integer.parseInt(node.attributeValue("defaultMaxTolerance"));
            this.defaultMaxValue4Mbps = Integer.parseInt(node.attributeValue("defaultMaxValue"));
            this.defaultMinTolerance4Mbps = Integer.parseInt(node.attributeValue("defaultMinTolerance"));
            this.defaultMinValue4Mbps = Integer.parseInt(node.attributeValue("defaultMinValue"));
            this.maxValue4Mbps = Integer.parseInt(node.attributeValue("maxValue"));
            this.minValue4Mbps = Integer.parseInt(node.attributeValue("minValue"));
            this.parseAreaNode(node, this.areas4Mbps);
        }
        if (CONN_TYPE.equals(type)) {
            this.defaultMaxTolerance4Conn = Integer.parseInt(node.attributeValue("defaultMaxTolerance"));
            this.defaultMaxValue4Conn = Integer.parseInt(node.attributeValue("defaultMaxValue"));
            this.defaultMinTolerance4Conn = Integer.parseInt(node.attributeValue("defaultMinTolerance"));
            this.defaultMinValue4Conn = Integer.parseInt(node.attributeValue("defaultMinValue"));
            this.maxValue4Conn = Integer.parseInt(node.attributeValue("maxValue"));
            this.minValue4Conn = Integer.parseInt(node.attributeValue("minValue"));
            this.parseAreaNode(node, this.areas4Conn);
        }
        if (NEW_CONN_TYPE.equals(type)) {
            this.defaultMaxTolerance4NewConn = Integer.parseInt(node.attributeValue("defaultMaxTolerance"));
            this.defaultMaxValue4NewConn = Integer.parseInt(node.attributeValue("defaultMaxValue"));
            this.defaultMinTolerance4NewConn = Integer.parseInt(node.attributeValue("defaultMinTolerance"));
            this.defaultMinValue4NewConn = Integer.parseInt(node.attributeValue("defaultMinValue"));
            this.maxValue4NewConn = Integer.parseInt(node.attributeValue("maxValue"));
            this.minValue4NewConn = Integer.parseInt(node.attributeValue("minValue"));
            this.parseAreaNode(node, this.areas4NewConn);
        }
        if (SRC_CONN_TYPE.equals(type)) {
            this.defaultMaxTolerance4SrcConn = Integer.parseInt(node.attributeValue("defaultMaxTolerance"));
            this.defaultMaxValue4SrcConn = Integer.parseInt(node.attributeValue("defaultMaxValue"));
            this.defaultMinTolerance4SrcConn = Integer.parseInt(node.attributeValue("defaultMinTolerance"));
            this.defaultMinValue4SrcConn = Integer.parseInt(node.attributeValue("defaultMinValue"));
            this.maxValue4SrcConn = Integer.parseInt(node.attributeValue("maxValue"));
            this.minValue4SrcConn = Integer.parseInt(node.attributeValue("minValue"));
            this.parseAreaNode(node, this.areas4SrcConn);
        }
        if (SRC_NEW_CONN_TYPE.equals(type)) {
            this.defaultMaxTolerance4SrcConn = Integer.parseInt(node.attributeValue("defaultMaxTolerance"));
            this.defaultMaxValue4SrcConn = Integer.parseInt(node.attributeValue("defaultMaxValue"));
            this.defaultMinTolerance4SrcConn = Integer.parseInt(node.attributeValue("defaultMinTolerance"));
            this.defaultMinValue4SrcConn = Integer.parseInt(node.attributeValue("defaultMinValue"));
            this.maxValue4SrcConn = Integer.parseInt(node.attributeValue("maxValue"));
            this.minValue4SrcConn = Integer.parseInt(node.attributeValue("minValue"));
            this.parseAreaNode(node, this.areas4SrcNewConn);
        }
        if (PERCENT_TYPE.equals(type)) {
            this.defaultMaxTolerance4Percent = Integer.parseInt(node.attributeValue("defaultMaxTolerance"));
            this.defaultMaxValue4Percent = Integer.parseInt(node.attributeValue("defaultMaxValue"));
            this.defaultMinTolerance4Percent = Integer.parseInt(node.attributeValue("defaultMinTolerance"));
            this.defaultMinValue4Percent = Integer.parseInt(node.attributeValue("defaultMinValue"));
            this.maxValue4Percent = Integer.parseInt(node.attributeValue("maxValue"));
            this.minValue4Percent = Integer.parseInt(node.attributeValue("minValue"));
            this.parseAreaNode(node, this.areas4Percent);
        }
        if (SYN_RATIO_PKT_TYPE.equals(type)) {
            this.defaultMaxTolerance4SYNRatioPKT = Integer.parseInt(node.attributeValue("defaultMaxTolerance"));
            this.defaultMaxValue4SYNRatioPKT = Integer.parseInt(node.attributeValue("defaultMaxValue"));
            this.defaultMinTolerance4SYNRatioPKT = Integer.parseInt(node.attributeValue("defaultMinTolerance"));
            this.defaultMinValue4SYNRatioPKT = Integer.parseInt(node.attributeValue("defaultMinValue"));
            this.maxValue4SYNRatioPKT = Integer.parseInt(node.attributeValue("maxValue"));
            this.minValue4SYNRatioPKT = Integer.parseInt(node.attributeValue("minValue"));
            this.parseAreaNode(node, this.areas4SYNRatioPKT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXml(File file) {
        Document document = null;
        FileInputStream fileInputStream = null;
        SAXReader saxReader = new SAXReader();
        try {
            fileInputStream = new FileInputStream(file);
            XmlUtil.setSecureFeatureForSaxReader((SAXReader)saxReader);
            document = saxReader.read((InputStream)fileInputStream);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator("tolerance");
            while (it.hasNext()) {
                this.getNodes((Element)it.next());
            }
            Collections.sort(this.areas4Pps);
            Collections.sort(this.areas4Mbps);
            Collections.sort(this.areas4Conn);
            Collections.sort(this.areas4NewConn);
            Collections.sort(this.areas4SrcConn);
            Collections.sort(this.areas4SrcNewConn);
            Collections.sort(this.areas4Percent);
            Collections.sort(this.areas4SYNRatioPKT);
        }
        catch (SAXException e) {
            this.logger.error((Object)"parseXml failed, SAXException");
        }
        catch (DocumentException e) {
            this.logger.error((Object)"parseXml failed, DocumentException");
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"parseXml failed, FileNotFoundException");
        }
        finally {
            try {
                if (null != fileInputStream) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"close fileInputStream failed, Exception");
            }
        }
    }

    private long caculateBaseLine(long baseline, List<ToleranceArea> areas) {
        int preAreaMaxValue = 0;
        for (ToleranceArea area : areas) {
            if (baseline > (long)area.getMinValue() && baseline <= (long)area.getMaxValue()) {
                long rbaseline = area.getTolerance() == 0 ? (long)area.getDefaultValue() : (long)area.getTolerance() * baseline / 100L;
                rbaseline = rbaseline > (long)area.getDefaultValue() ? rbaseline : (long)area.getDefaultValue();
                return rbaseline > (long)preAreaMaxValue ? rbaseline : (long)preAreaMaxValue;
            }
            preAreaMaxValue = area.getTolerance() == 0 ? area.getDefaultValue() : area.getTolerance() * area.getMaxValue() / 100;
        }
        return baseline * (long)defaultTolerance4Error / 100L;
    }

    public long calculateBaseLine(String policyItem, long baseline) {
        if ("tcpDesttipNum".equals(policyItem)) {
            return this.caculateBaseLine(baseline, this.areas4Conn);
        }
        if ("tcpNewDestipRate".equals(policyItem)) {
            return this.caculateBaseLine(baseline, this.areas4NewConn);
        }
        if ("tcpSrctipNum".equals(policyItem)) {
            return this.caculateBaseLine(baseline, this.areas4SrcConn);
        }
        if ("tcpNewSrctipRate".equals(policyItem)) {
            return this.caculateBaseLine(baseline, this.areas4SrcNewConn);
        }
        if ("alertSpeed".equals(policyItem) || "fragAlertSpeed".equals(policyItem) || "fingerAlert".equals(policyItem) || "udpMaxSpeed".equals(policyItem) || "udpFragMaxSpeed".equals(policyItem)) {
            return this.caculateBaseLine(baseline, this.areas4Mbps);
        }
        if ("synratioLimitRate".equals(policyItem) || "bigPacketRatio".equals(policyItem)) {
            long suggestionValue = 0L;
            suggestionValue = baseline >= 0L && baseline < 40L ? 50L : (baseline >= 40L && baseline < 90L ? baseline + 10L : (baseline >= 90L && baseline <= 100L ? 100L : this.caculateBaseLine(baseline, this.areas4Percent)));
            return suggestionValue;
        }
        if ("synratioLimitPackets".equals(policyItem)) {
            return this.caculateBaseLine(baseline, this.areas4SYNRatioPKT);
        }
        return this.caculateBaseLine(baseline, this.areas4Pps);
    }

    public long compareSuggestValueThreshold(String policyItem, long suggestionValue, AticDevice aticDevice, String serviceType) {
        DeviceTypeInfo deviceTypeInfo = this.getDeviceTypeInfo(aticDevice, serviceType);
        ParaBean paraBean = this.ddosDevCapabilityService.getParaBean(deviceTypeInfo, policyItem);
        long maxVaule = paraBean.getMaxVal();
        long minVaule = paraBean.getMinVal();
        if (policyItem.contains("Pps")) {
            maxVaule *= 1024L;
            minVaule *= 1024L;
        }
        suggestionValue = suggestionValue > maxVaule ? maxVaule : suggestionValue;
        long l = suggestionValue = suggestionValue < minVaule ? minVaule : suggestionValue;
        if ("synratioLimitRate".equals(policyItem) || "bigPacketRatio".equals(policyItem)) {
            if (suggestionValue < (long)this.minValue4Percent) {
                return this.defaultMinTolerance4Percent == 0 ? (long)this.defaultMinValue4Percent : (long)this.defaultMinTolerance4Percent * suggestionValue / 100L;
            }
            return suggestionValue;
        }
        if ("tcpDesttipNum".equals(policyItem)) {
            if (suggestionValue < (long)this.minValue4Conn) {
                return this.defaultMinTolerance4Conn == 0 ? (long)this.defaultMinValue4Conn : (long)this.defaultMinTolerance4Conn * suggestionValue / 100L;
            }
            return suggestionValue;
        }
        if ("tcpNewDestipRate".equals(policyItem)) {
            if (suggestionValue < (long)this.minValue4NewConn) {
                return this.defaultMinTolerance4NewConn == 0 ? (long)this.defaultMinValue4NewConn : (long)this.defaultMinTolerance4NewConn * suggestionValue / 100L;
            }
            return suggestionValue;
        }
        if ("tcpSrctipNum".equals(policyItem)) {
            if (suggestionValue < (long)this.minValue4SrcConn) {
                return this.defaultMinTolerance4SrcConn == 0 ? (long)this.defaultMinValue4SrcConn : (long)this.defaultMinTolerance4SrcConn * suggestionValue / 100L;
            }
            return suggestionValue;
        }
        if ("tcpNewSrctipRate".equals(policyItem)) {
            if (suggestionValue < (long)this.minValue4SrcNewConn) {
                return this.defaultMinTolerance4SrcNewConn == 0 ? (long)this.defaultMinValue4SrcNewConn : (long)this.defaultMinTolerance4SrcNewConn * suggestionValue / 100L;
            }
            return suggestionValue;
        }
        if ("alertSpeed".equals(policyItem) || "fragAlertSpeed".equals(policyItem) || "fingerAlert".equals(policyItem) || "udpMaxSpeed".equals(policyItem) || "udpFragMaxSpeed".equals(policyItem)) {
            if (suggestionValue < (long)this.minValue4Mbps) {
                return this.defaultMinTolerance4Mbps == 0 ? (long)this.defaultMinValue4Mbps : (long)this.defaultMinTolerance4Mbps * suggestionValue / 100L;
            }
            return suggestionValue;
        }
        if ("synratioLimitPackets".equals(policyItem)) {
            if (suggestionValue < (long)this.minValue4SYNRatioPKT) {
                return this.defaultMinTolerance4SYNRatioPKT == 0 ? (long)this.defaultMinValue4SYNRatioPKT : (long)this.defaultMinTolerance4SYNRatioPKT * suggestionValue / 100L;
            }
            return suggestionValue;
        }
        if (suggestionValue < (long)this.minValue4Pps) {
            return this.defaultMinTolerance4Pps == 0 ? (long)this.defaultMinValue4Pps : (long)this.defaultMinTolerance4Pps * suggestionValue / 100L;
        }
        return suggestionValue;
    }

    private DeviceTypeInfo getDeviceTypeInfo(AticDevice aticDevice, String serviceType) {
        DeviceTypeInfo devInfo = new DeviceTypeInfo();
        if (aticDevice.getDeviceType() == 1) {
            devInfo.setDevType(aticDevice.getDeviceModel());
            devInfo.setDevOSVersion(aticDevice.getVersion());
        } else if (8 == aticDevice.getDeviceType() || 9 == aticDevice.getDeviceType()) {
            devInfo.setDevType("AntiDDoS1820-N");
            devInfo.setDevOSVersion(aticDevice.getVersion());
        }
        if ("DEFAULT".equals(serviceType)) {
            serviceType = "Default";
        }
        devInfo.setDevVersion(serviceType);
        return devInfo;
    }

    public int getDefaultMaxTolerance4Percent() {
        return this.defaultMaxTolerance4Percent;
    }

    public void setDefaultMaxTolerance4Percent(int defaultMaxTolerance4Percent) {
        this.defaultMaxTolerance4Percent = defaultMaxTolerance4Percent;
    }

    public int getDefaultMaxValue4Percent() {
        return this.defaultMaxValue4Percent;
    }

    public void setDefaultMaxValue4Percent(int defaultMaxValue4Percent) {
        this.defaultMaxValue4Percent = defaultMaxValue4Percent;
    }

    public int getDefaultMinTolerance4Percent() {
        return this.defaultMinTolerance4Percent;
    }

    public void setDefaultMinTolerance4Percent(int defaultMinTolerance4Percent) {
        this.defaultMinTolerance4Percent = defaultMinTolerance4Percent;
    }

    public int getDefaultMinValue4Percent() {
        return this.defaultMinValue4Percent;
    }

    public void setDefaultMinValue4Percent(int defaultMinValue4Percent) {
        this.defaultMinValue4Percent = defaultMinValue4Percent;
    }

    public int getMaxValue4Percent() {
        return this.maxValue4Percent;
    }

    public void setMaxValue4Percent(int maxValue4Percent) {
        this.maxValue4Percent = maxValue4Percent;
    }

    public int getMinValue4Percent() {
        return this.minValue4Percent;
    }

    public void setMinValue4Percent(int minValue4Percent) {
        this.minValue4Percent = minValue4Percent;
    }

    public int getDefaultMaxTolerance4Pps() {
        return this.defaultMaxTolerance4Pps;
    }

    public void setDefaultMaxTolerance4Pps(int defaultMaxTolerance4Pps) {
        this.defaultMaxTolerance4Pps = defaultMaxTolerance4Pps;
    }

    public int getDefaultMaxValue4Pps() {
        return this.defaultMaxValue4Pps;
    }

    public void setDefaultMaxValue4Pps(int defaultMaxValue4Pps) {
        this.defaultMaxValue4Pps = defaultMaxValue4Pps;
    }

    public int getDefaultMinTolerance4Pps() {
        return this.defaultMinTolerance4Pps;
    }

    public void setDefaultMinTolerance4Pps(int defaultMinTolerance4Pps) {
        this.defaultMinTolerance4Pps = defaultMinTolerance4Pps;
    }

    public int getDefaultMinValue4Pps() {
        return this.defaultMinValue4Pps;
    }

    public void setDefaultMinValue4Pps(int defaultMinValue4Pps) {
        this.defaultMinValue4Pps = defaultMinValue4Pps;
    }

    public int getDefaultMaxTolerance4Mbps() {
        return this.defaultMaxTolerance4Mbps;
    }

    public void setDefaultMaxTolerance4Mbps(int defaultMaxTolerance4Mbps) {
        this.defaultMaxTolerance4Mbps = defaultMaxTolerance4Mbps;
    }

    public int getDefaultMaxValue4Mbps() {
        return this.defaultMaxValue4Mbps;
    }

    public void setDefaultMaxValue4Mbps(int defaultMaxValue4Mbps) {
        this.defaultMaxValue4Mbps = defaultMaxValue4Mbps;
    }

    public int getDefaultMinTolerance4Mbps() {
        return this.defaultMinTolerance4Mbps;
    }

    public void setDefaultMinTolerance4Mbps(int defaultMinTolerance4Mbps) {
        this.defaultMinTolerance4Mbps = defaultMinTolerance4Mbps;
    }

    public int getDefaultMinValue4Mbps() {
        return this.defaultMinValue4Mbps;
    }

    public void setDefaultMinValue4Mbps(int defaultMinValue4Mbps) {
        this.defaultMinValue4Mbps = defaultMinValue4Mbps;
    }

    public int getDefaultMaxTolerance4Conn() {
        return this.defaultMaxTolerance4Conn;
    }

    public void setDefaultMaxTolerance4Conn(int defaultMaxTolerance4Conn) {
        this.defaultMaxTolerance4Conn = defaultMaxTolerance4Conn;
    }

    public int getDefaultMaxValue4Conn() {
        return this.defaultMaxValue4Conn;
    }

    public void setDefaultMaxValue4Conn(int defaultMaxValue4Conn) {
        this.defaultMaxValue4Conn = defaultMaxValue4Conn;
    }

    public int getDefaultMinTolerance4Conn() {
        return this.defaultMinTolerance4Conn;
    }

    public void setDefaultMinTolerance4Conn(int defaultMinTolerance4Conn) {
        this.defaultMinTolerance4Conn = defaultMinTolerance4Conn;
    }

    public int getDefaultMinValue4Conn() {
        return this.defaultMinValue4Conn;
    }

    public void setDefaultMinValue4Conn(int defaultMinValue4Conn) {
        this.defaultMinValue4Conn = defaultMinValue4Conn;
    }

    public int getMaxValue4Pps() {
        return this.maxValue4Pps;
    }

    public void setMaxValue4Pps(int maxValue4Pps) {
        this.maxValue4Pps = maxValue4Pps;
    }

    public int getMinValue4Pps() {
        return this.minValue4Pps;
    }

    public void setMinValue4Pps(int minValue4Pps) {
        this.minValue4Pps = minValue4Pps;
    }

    public int getMaxValue4Mbps() {
        return this.maxValue4Mbps;
    }

    public void setMaxValue4Mbps(int maxValue4Mbps) {
        this.maxValue4Mbps = maxValue4Mbps;
    }

    public int getMinValue4Mbps() {
        return this.minValue4Mbps;
    }

    public void setMinValue4Mbps(int minValue4Mbps) {
        this.minValue4Mbps = minValue4Mbps;
    }

    public int getMaxValue4Conn() {
        return this.maxValue4Conn;
    }

    public void setMaxValue4Conn(int maxValue4Conn) {
        this.maxValue4Conn = maxValue4Conn;
    }

    public int getMinValue4Conn() {
        return this.minValue4Conn;
    }

    public void setMinValue4Conn(int minValue4Conn) {
        this.minValue4Conn = minValue4Conn;
    }

    public IDdosDevCapabilityService getDdosDevCapabilityService() {
        return this.ddosDevCapabilityService;
    }

    public void setDdosDevCapabilityService(IDdosDevCapabilityService ddosDevCapabilityService) {
        this.ddosDevCapabilityService = ddosDevCapabilityService;
    }

    public int getDefaultMaxTolerance4SrcConn() {
        return this.defaultMaxTolerance4SrcConn;
    }

    public void setDefaultMaxTolerance4SrcConn(int defaultMaxTolerance4SrcConn) {
        this.defaultMaxTolerance4SrcConn = defaultMaxTolerance4SrcConn;
    }

    public int getDefaultMaxValue4SrcConn() {
        return this.defaultMaxValue4SrcConn;
    }

    public void setDefaultMaxValue4SrcConn(int defaultMaxValue4SrcConn) {
        this.defaultMaxValue4SrcConn = defaultMaxValue4SrcConn;
    }

    public int getDefaultMinTolerance4SrcConn() {
        return this.defaultMinTolerance4SrcConn;
    }

    public void setDefaultMinTolerance4SrcConn(int defaultMinTolerance4SrcConn) {
        this.defaultMinTolerance4SrcConn = defaultMinTolerance4SrcConn;
    }

    public int getDefaultMinValue4SrcConn() {
        return this.defaultMinValue4SrcConn;
    }

    public void setDefaultMinValue4SrcConn(int defaultMinValue4SrcConn) {
        this.defaultMinValue4SrcConn = defaultMinValue4SrcConn;
    }

    public int getMaxValue4SrcConn() {
        return this.maxValue4SrcConn;
    }

    public void setMaxValue4SrcConn(int maxValue4SrcConn) {
        this.maxValue4SrcConn = maxValue4SrcConn;
    }

    public int getMinValue4SrcConn() {
        return this.minValue4SrcConn;
    }

    public void setMinValue4SrcConn(int minValue4SrcConn) {
        this.minValue4SrcConn = minValue4SrcConn;
    }

    public int getDefaultMaxTolerance4NewConn() {
        return this.defaultMaxTolerance4NewConn;
    }

    public void setDefaultMaxTolerance4NewConn(int defaultMaxTolerance4NewConn) {
        this.defaultMaxTolerance4NewConn = defaultMaxTolerance4NewConn;
    }

    public int getDefaultMaxValue4NewConn() {
        return this.defaultMaxValue4NewConn;
    }

    public void setDefaultMaxValue4NewConn(int defaultMaxValue4NewConn) {
        this.defaultMaxValue4NewConn = defaultMaxValue4NewConn;
    }

    public int getDefaultMinTolerance4NewConn() {
        return this.defaultMinTolerance4NewConn;
    }

    public void setDefaultMinTolerance4NewConn(int defaultMinTolerance4NewConn) {
        this.defaultMinTolerance4NewConn = defaultMinTolerance4NewConn;
    }

    public int getDefaultMinValue4NewConn() {
        return this.defaultMinValue4NewConn;
    }

    public void setDefaultMinValue4NewConn(int defaultMinValue4NewConn) {
        this.defaultMinValue4NewConn = defaultMinValue4NewConn;
    }

    public int getDefaultMaxTolerance4SrcNewConn() {
        return this.defaultMaxTolerance4SrcNewConn;
    }

    public void setDefaultMaxTolerance4SrcNewConn(int defaultMaxTolerance4SrcNewConn) {
        this.defaultMaxTolerance4SrcNewConn = defaultMaxTolerance4SrcNewConn;
    }

    public int getDefaultMaxValue4SrcNewConn() {
        return this.defaultMaxValue4SrcNewConn;
    }

    public void setDefaultMaxValue4SrcNewConn(int defaultMaxValue4SrcNewConn) {
        this.defaultMaxValue4SrcNewConn = defaultMaxValue4SrcNewConn;
    }

    public int getDefaultMinTolerance4SrcNewConn() {
        return this.defaultMinTolerance4SrcNewConn;
    }

    public void setDefaultMinTolerance4SrcNewConn(int defaultMinTolerance4SrcNewConn) {
        this.defaultMinTolerance4SrcNewConn = defaultMinTolerance4SrcNewConn;
    }

    public int getDefaultMinValue4SrcNewConn() {
        return this.defaultMinValue4SrcNewConn;
    }

    public void setDefaultMinValue4SrcNewConn(int defaultMinValue4SrcNewConn) {
        this.defaultMinValue4SrcNewConn = defaultMinValue4SrcNewConn;
    }

    public int getMaxValue4NewConn() {
        return this.maxValue4NewConn;
    }

    public void setMaxValue4NewConn(int maxValue4NewConn) {
        this.maxValue4NewConn = maxValue4NewConn;
    }

    public int getMinValue4NewConn() {
        return this.minValue4NewConn;
    }

    public void setMinValue4NewConn(int minValue4NewConn) {
        this.minValue4NewConn = minValue4NewConn;
    }

    public int getMaxValue4SrcNewConn() {
        return this.maxValue4SrcNewConn;
    }

    public void setMaxValue4SrcNewConn(int maxValue4SrcNewConn) {
        this.maxValue4SrcNewConn = maxValue4SrcNewConn;
    }

    public int getMinValue4SrcNewConn() {
        return this.minValue4SrcNewConn;
    }

    public void setMinValue4SrcNewConn(int minValue4SrcNewConn) {
        this.minValue4SrcNewConn = minValue4SrcNewConn;
    }

    public int getDefaultMaxTolerance4SYNRatioPKT() {
        return this.defaultMaxTolerance4SYNRatioPKT;
    }

    public void setDefaultMaxTolerance4SYNRatioPKT(int defaultMaxTolerance4SYNRatioPKT) {
        this.defaultMaxTolerance4SYNRatioPKT = defaultMaxTolerance4SYNRatioPKT;
    }

    public int getDefaultMaxValue4SYNRatioPKT() {
        return this.defaultMaxValue4SYNRatioPKT;
    }

    public void setDefaultMaxValue4SYNRatioPKT(int defaultMaxValue4SYNRatioPKT) {
        this.defaultMaxValue4SYNRatioPKT = defaultMaxValue4SYNRatioPKT;
    }

    public int getDefaultMinTolerance4SYNRatioPKT() {
        return this.defaultMinTolerance4SYNRatioPKT;
    }

    public void setDefaultMinTolerance4SYNRatioPKT(int defaultMinTolerance4SYNRatioPKT) {
        this.defaultMinTolerance4SYNRatioPKT = defaultMinTolerance4SYNRatioPKT;
    }

    public int getDefaultMinValue4SYNRatioPKT() {
        return this.defaultMinValue4SYNRatioPKT;
    }

    public void setDefaultMinValue4SYNRatioPKT(int defaultMinValue4SYNRatioPKT) {
        this.defaultMinValue4SYNRatioPKT = defaultMinValue4SYNRatioPKT;
    }

    public int getMaxValue4SYNRatioPKT() {
        return this.maxValue4SYNRatioPKT;
    }

    public void setMaxValue4SYNRatioPKT(int maxValue4SYNRatioPKT) {
        this.maxValue4SYNRatioPKT = maxValue4SYNRatioPKT;
    }

    public int getMinValue4SYNRatioPKT() {
        return this.minValue4SYNRatioPKT;
    }

    public void setMinValue4SYNRatioPKT(int minValue4SYNRatioPKT) {
        this.minValue4SYNRatioPKT = minValue4SYNRatioPKT;
    }

    private static class ToleranceArea
    implements Comparable<ToleranceArea> {
        private int maxValue;
        private int minValue;
        private int tolerance;
        private int defaultValue;

        private ToleranceArea() {
        }

        public int getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(int maxValue) {
            this.maxValue = maxValue;
        }

        public int getMinValue() {
            return this.minValue;
        }

        public void setMinValue(int minValue) {
            this.minValue = minValue;
        }

        public int getTolerance() {
            return this.tolerance;
        }

        public void setTolerance(int tolerance) {
            this.tolerance = tolerance;
        }

        public int getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public int compareTo(ToleranceArea o) {
            return this.maxValue - o.maxValue;
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (!(obj instanceof ToleranceArea)) {
                return false;
            }
            ToleranceArea area = (ToleranceArea)obj;
            return this.maxValue == area.maxValue;
        }

        public int hashCode() {
            return Integer.valueOf(this.maxValue).hashCode();
        }
    }
}

