/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.FaultSeverityRuleDao;
import com.hs.atic.rmi.NotifyFaultSeverityRuleService;
import com.hs.atic.rmi.SecneCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.model.FaultSeverityRule;
import com.hs.atic.sdk.bis.service.FaultSeverityRuleService;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.collector.service.dao.CollectorDao;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FaultSeverityRuleServiceImpl
implements FaultSeverityRuleService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private IZoneService zoneService;
    private IZonePolicyApplyService zonePolicyApplyService;
    private SecneCollectorRMIProxy collectorRMIProxy;
    private CollectorDao collectorDao;
    private FaultSeverityRuleDao dao;
    private ILicenseOutboundService licenseOutboundService;

    public FaultSeverityRuleForm listRule() {
        return this.dao.listRule();
    }

    public FaultSeverityRuleForm getZoneSeverityRuleByZoneId(Long zoneId, Integer direction) {
        return this.dao.listRuleByZoneId(zoneId, direction);
    }

    public boolean saveRule(FaultSeverityRuleForm form) throws RemoteException {
        if (null != form) {
            this.logger.info((Object)"FaultSeverityRule begins to save.");
            String[] arrIps = this.collectorDao.getAllCollectorIP();
            if (arrIps.length > 0) {
                this.logger.info((Object)"FaultSeverityRule atic saves begin.");
                this.dao.saveOrUpdateRule(form);
                this.logger.info((Object)"FaultSeverityRule atic saves end.");
                FaultSeverityRuleForm fRuleForm = this.dao.listRuleByZoneId(form.getCriticalRule().getZoneId(), form.getCriticalRule().getDirection());
                fRuleForm.setNewRule(form.isNewRule());
                try {
                    for (int i = 0; i < arrIps.length; ++i) {
                        NotifyFaultSeverityRuleService client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(arrIps[i]);
                        if (null != client) {
                            this.logger.info((Object)("FaultSeverityRule collect " + i + " saves begin."));
                            client.notifySeverityRule(fRuleForm);
                            this.logger.info((Object)("FaultSeverityRule collect " + i + " saves end."));
                            continue;
                        }
                        this.logger.warn((Object)("Get NotifyFaultSeverityRuleService interface failed, collector ip is " + arrIps[i]));
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"Get NotifyFaultSeverityRuleService interface failed!");
                    throw e;
                }
                catch (RemoteException e) {
                    this.logger.error((Object)("Save FaultSeverityRule data failed!" + e.getMessage()));
                    throw e;
                }
            }
            this.logger.info((Object)"FaultSeverityRule ends to save.");
        }
        return true;
    }

    public String[] saveRuleForRestful(FaultSeverityRuleForm form) throws RemoteException {
        String[] result = new String[4];
        int collectCount = 0;
        int successCount = 0;
        int failedCount = 0;
        StringBuffer saveStateBuffer = new StringBuffer();
        if (null != form) {
            this.logger.info((Object)"Restful:faultSeverityRule begins to save.");
            String[] arrIps = this.collectorDao.getAllCollectorIP();
            if (arrIps.length > 0) {
                collectCount = arrIps.length;
                this.logger.info((Object)"FaultSeverityRule atic saves begin.");
                this.dao.saveOrUpdateRule(form);
                this.logger.info((Object)"FaultSeverityRule atic saves end.");
                FaultSeverityRuleForm fRuleForm = this.dao.listRuleByZoneId(form.getCriticalRule().getZoneId(), form.getCriticalRule().getDirection());
                fRuleForm.setNewRule(form.isNewRule());
                try {
                    for (int i = 0; i < arrIps.length; ++i) {
                        NotifyFaultSeverityRuleService client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(arrIps[i]);
                        if (null != client) {
                            this.logger.info((Object)("FaultSeverityRule collect " + i + " saves begin."));
                            if (client.notifySeverityRule(fRuleForm)) {
                                saveStateBuffer.append(arrIps[i] + "," + 1 + ";");
                                ++successCount;
                            } else {
                                saveStateBuffer.append(arrIps[i] + "," + 0 + ";");
                                ++failedCount;
                            }
                            this.logger.info((Object)("FaultSeverityRule collect " + i + " saves end."));
                            continue;
                        }
                        saveStateBuffer.append(arrIps[i] + "," + 0 + ";");
                        ++failedCount;
                        this.logger.warn((Object)("Get NotifyFaultSeverityRuleService interface failed, collector ip is " + arrIps[i]));
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"Get NotifyFaultSeverityRuleService interface failed!");
                    throw e;
                }
                catch (RemoteException e) {
                    this.logger.error((Object)("Save FaultSeverityRule data failed!" + e.getMessage()));
                    throw e;
                }
            }
            this.logger.info((Object)"Restful:faultSeverityRule ends to save.");
        }
        result[0] = "" + collectCount;
        result[1] = "" + successCount;
        result[2] = "" + failedCount;
        String saveStateString = saveStateBuffer.toString();
        result[3] = "".equals(saveStateString) ? "" : saveStateString.substring(0, saveStateString.length() - 1);
        return result;
    }

    public boolean batchSaveZonesRule(Map<String, Integer> ruleMap, String zondIds) throws RemoteException {
        String[] zoneIds;
        int critical = ruleMap.get("critical");
        int major = ruleMap.get("major");
        int minor = ruleMap.get("minor");
        int warning = ruleMap.get("warning");
        int criticalAction = ruleMap.get("criticalAction");
        int majorAction = ruleMap.get("majorAction");
        int minorAction = ruleMap.get("minorAction");
        int warningAction = ruleMap.get("warningAction");
        int direction = ruleMap.get("direction");
        for (String zoneId : zoneIds = zondIds.split(",")) {
            ZoneInfoForm zoneInfoForm = this.zoneService.getById(Long.valueOf(zoneId));
            ZonePolicyApplyForm zonePolicyApplyForm = this.zonePolicyApplyService.queryByZoneId(zoneInfoForm.getZoneId());
            if (null == zonePolicyApplyForm.getZoneLimitRate()) {
                zonePolicyApplyForm.setZoneLimitRate(1000);
            }
            FaultSeverityRuleForm faultSeverityRuleFormOld = this.getZoneSeverityRuleByZoneId(zoneInfoForm.getZoneId(), direction);
            FaultSeverityRuleForm faultSeverityRuleForm = new FaultSeverityRuleForm();
            if (null == faultSeverityRuleFormOld) {
                faultSeverityRuleFormOld = this.getZoneSeverityRuleByZoneId(0L, direction);
                if (null != faultSeverityRuleFormOld) {
                    FaultSeverityRule cRule = new FaultSeverityRule();
                    AticUtil.copyProperties((Object)faultSeverityRuleFormOld.getCriticalRule(), (Object)cRule);
                    FaultSeverityRule majRule = new FaultSeverityRule();
                    AticUtil.copyProperties((Object)faultSeverityRuleFormOld.getMajorRule(), (Object)majRule);
                    FaultSeverityRule minRule = new FaultSeverityRule();
                    AticUtil.copyProperties((Object)faultSeverityRuleFormOld.getMinorRule(), (Object)minRule);
                    FaultSeverityRule wRule = new FaultSeverityRule();
                    AticUtil.copyProperties((Object)faultSeverityRuleFormOld.getWarningRule(), (Object)wRule);
                    faultSeverityRuleForm.setCriticalRule(cRule);
                    faultSeverityRuleForm.setMajorRule(majRule);
                    faultSeverityRuleForm.setMinorRule(minRule);
                    faultSeverityRuleForm.setWarningRule(wRule);
                }
                faultSeverityRuleForm.setNewRule(true);
                faultSeverityRuleForm.getCriticalRule().setZoneId(zoneInfoForm.getZoneId());
                faultSeverityRuleForm.getCriticalRule().setId(null);
                faultSeverityRuleForm.getMajorRule().setZoneId(zoneInfoForm.getZoneId());
                faultSeverityRuleForm.getMajorRule().setId(null);
                faultSeverityRuleForm.getMinorRule().setZoneId(zoneInfoForm.getZoneId());
                faultSeverityRuleForm.getMinorRule().setId(null);
                faultSeverityRuleForm.getWarningRule().setZoneId(zoneInfoForm.getZoneId());
                faultSeverityRuleForm.getWarningRule().setId(null);
                faultSeverityRuleForm.getCriticalRule().setDirection(direction);
                faultSeverityRuleForm.getMajorRule().setDirection(direction);
                faultSeverityRuleForm.getMinorRule().setDirection(direction);
                faultSeverityRuleForm.getWarningRule().setDirection(direction);
            } else {
                faultSeverityRuleForm = faultSeverityRuleFormOld;
                faultSeverityRuleForm.setNewRule(false);
            }
            faultSeverityRuleForm.getCriticalRule().setInTrafficMbps(zonePolicyApplyForm.getZoneLimitRate() * critical / 100);
            faultSeverityRuleForm.getCriticalRule().setDiversionAction(criticalAction);
            faultSeverityRuleForm.getMajorRule().setInTrafficMbps(zonePolicyApplyForm.getZoneLimitRate() * major / 100);
            faultSeverityRuleForm.getMajorRule().setDiversionAction(majorAction);
            faultSeverityRuleForm.getMinorRule().setInTrafficMbps(zonePolicyApplyForm.getZoneLimitRate() * minor / 100);
            faultSeverityRuleForm.getMinorRule().setDiversionAction(minorAction);
            faultSeverityRuleForm.getWarningRule().setInTrafficMbps(zonePolicyApplyForm.getZoneLimitRate() * warning / 100);
            faultSeverityRuleForm.getWarningRule().setDiversionAction(warningAction);
            faultSeverityRuleForm.getCriticalRule().setInTrafficpps(zonePolicyApplyForm.getZoneLimitRate() * critical / 100 * 400);
            faultSeverityRuleForm.getMajorRule().setInTrafficpps(zonePolicyApplyForm.getZoneLimitRate() * major / 100 * 400);
            faultSeverityRuleForm.getMinorRule().setInTrafficpps(zonePolicyApplyForm.getZoneLimitRate() * minor / 100 * 400);
            faultSeverityRuleForm.getWarningRule().setInTrafficpps(zonePolicyApplyForm.getZoneLimitRate() * warning / 100 * 400);
            if (this.saveRule(faultSeverityRuleForm)) continue;
            return false;
        }
        return true;
    }

    public List<FaultSeverityRuleForm> getAllRules() {
        ArrayList<FaultSeverityRuleForm> fRuleForms = new ArrayList<FaultSeverityRuleForm>();
        List<ZoneInfoForm> allZone = this.zoneService.getAll();
        ZoneInfoForm zForm = new ZoneInfoForm();
        zForm.setZoneId(0L);
        allZone.add(zForm);
        for (ZoneInfoForm zoneInfoForm : allZone) {
            FaultSeverityRuleForm faultSeverityRuleForm = this.getZoneSeverityRuleByZoneId(zoneInfoForm.getZoneId(), 1);
            if (null != faultSeverityRuleForm) {
                faultSeverityRuleForm.setNewRule(true);
                fRuleForms.add(faultSeverityRuleForm);
            }
            if (!this.licenseOutboundService.isSupportOutbound() || null == (faultSeverityRuleForm = this.getZoneSeverityRuleByZoneId(zoneInfoForm.getZoneId(), 2))) continue;
            faultSeverityRuleForm.setNewRule(true);
            fRuleForms.add(faultSeverityRuleForm);
        }
        return fRuleForms;
    }

    public Boolean deleteRule(List<Long> zoneIds) throws RemoteException {
        String[] arrIps;
        if (null != zoneIds && (arrIps = this.collectorDao.getAllCollectorIP()).length > 0) {
            this.dao.deleteAllByZoneId(zoneIds);
            try {
                for (int i = 0; i < arrIps.length; ++i) {
                    NotifyFaultSeverityRuleService client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(arrIps[i]);
                    if (null != client) {
                        client.deleteSeverityRules(zoneIds);
                        continue;
                    }
                    this.logger.warn((Object)("Get NotifyFaultSeverityRuleService interface failed, collector ip is " + arrIps[i]));
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"Get NotifyFaultSeverityRuleService interface failed when delete!");
                throw e;
            }
            catch (RemoteException e) {
                this.logger.error((Object)("Delete FaultSeverityRule data failed!" + e.getMessage()));
                throw e;
            }
        }
        return true;
    }

    public SecneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(SecneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public FaultSeverityRuleDao getDao() {
        return this.dao;
    }

    public void setDao(FaultSeverityRuleDao dao) {
        this.dao = dao;
    }

    public CollectorDao getCollectorDao() {
        return this.collectorDao;
    }

    public void setCollectorDao(CollectorDao collectorDao) {
        this.collectorDao = collectorDao;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IZonePolicyApplyService getZonePolicyApplyService() {
        return this.zonePolicyApplyService;
    }

    public void setZonePolicyApplyService(IZonePolicyApplyService zonePolicyApplyService) {
        this.zonePolicyApplyService = zonePolicyApplyService;
    }

    public ILicenseOutboundService getLicenseOutboundService() {
        return this.licenseOutboundService;
    }

    public void setLicenseOutboundService(ILicenseOutboundService licenseOutboundService) {
        this.licenseOutboundService = licenseOutboundService;
    }
}

