/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.GlobeDeployStatusDao;
import com.hs.atic.bis.dao.LibraryFileDao;
import com.hs.atic.bis.dao.LocationCustomDao;
import com.hs.atic.bis.dao.LocationDevEntityDao;
import com.hs.atic.bis.model.GlobeDeployStatus;
import com.hs.atic.bis.model.LibraryFile;
import com.hs.atic.bis.model.LocationCustom;
import com.hs.atic.bis.model.LocationDevEntity;
import com.hs.atic.rmi.CollectorLocationDevService;
import com.hs.atic.rmi.ZoneCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.form.LibraryFileForm;
import com.hs.atic.sdk.bis.form.LocationIpForm;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.sdk.bis.service.ILocationIpService;
import com.hs.atic.system.SysConfigManager;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.IpLocationUtil;
import com.hs.atic.util.LibFilePathUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.AticInstallUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;

public class LibraryFileServiceImpl
implements ILibraryFileService {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private LibraryFileDao libraryFileDao;
    private GlobeDeployStatusDao globeDeployStatusDao;
    private LocationCustomDao locationCustomDao;
    private LocationDevEntityDao locationDevEntityDao;
    private ILocationIpService locationIpService;
    private IAticDeviceService aticDeviceService;
    private ICollectorService collectorService;
    private ZoneCollectorRMIProxy zoneCollectorRMIProxy;
    private SysConfigManager sysConfigManager;
    private int maxLocLibFileDeployTime = 150;
    private boolean isLocDevListChange;
    private IDataProtectService dataProtectService;

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        Paging page = this.libraryFileDao.queryByPage(queryMap, start, pageSize);
        List libFiles = page.getData();
        ArrayList<LibraryFileForm> libFileForms = new ArrayList<LibraryFileForm>();
        for (LibraryFile libFile : libFiles) {
            LibraryFileForm libraryFileForm = new LibraryFileForm();
            AticUtil.copyProperties((Object)libFile, (Object)libraryFileForm);
            libFileForms.add(libraryFileForm);
        }
        page.setData(libFileForms);
        this.logger.info((Object)("libFileForms size: " + libFileForms.size()));
        return page;
    }

    @Override
    public Long saveLibraryFile(LibraryFileForm libraryFileForm) {
        LibraryFile libraryFile = (LibraryFile)AticUtil.copyProperties((Object)libraryFileForm, (Object)new LibraryFile());
        this.libraryFileDao.saveOrUpdate(libraryFile);
        Long id = libraryFile.getPkId();
        this.logger.info((Object)("saveLibraryFile, name is : " + this.getcleanedMessage(libraryFile.getLibName())));
        return id;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public boolean isExists(String libName) {
        return this.libraryFileDao.isExists(libName);
    }

    @Override
    public int getLibFileCount() {
        int all = this.libraryFileDao.getAll().size();
        this.logger.info((Object)("getLifFileCount all counts : " + all));
        return all;
    }

    @Override
    public BatchOperationResult batchDelLibraryFile(List<BatchOperation> boList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == boList) {
            return result;
        }
        if (!boList.isEmpty()) {
            for (BatchOperation bo : boList) {
                try {
                    LibraryFileForm libFile = this.findById(bo.getTargetId());
                    if (null == libFile) {
                        this.logger.error((Object)("delete libFile : " + this.getcleanedMessage(bo.getTargetName()) + " failed, not exists"));
                        ++fail;
                        bo.setErrorCode(571900L);
                        continue;
                    }
                    if (libFile.getDeployStatus().equals("deploying")) {
                        this.logger.error((Object)("delete libFile : " + this.getcleanedMessage(bo.getTargetName()) + " failed, deployStatus is success"));
                        ++fail;
                        bo.setErrorCode(571902L);
                        continue;
                    }
                    if ("location_sdb_default.zip".equalsIgnoreCase(libFile.getLibName())) {
                        this.logger.error((Object)("delete libFile : " + this.getcleanedMessage(bo.getTargetName()) + " failed, cannot delete this libFile"));
                        ++fail;
                        bo.setErrorCode(630114L);
                        continue;
                    }
                    this.delById(bo.getTargetId());
                    this.globeDeployStatusDao.deleteLibFileByType(bo.getTargetId(), libFile.getLibType());
                    bo.setOptDetail("atic.bis.libraryFile.delete.sucessSumary");
                    bo.setDetailParam(new String[]{bo.getTargetName()});
                    this.logger.info((Object)("delete libFile : " + this.getcleanedMessage(bo.getTargetName()) + "successfully."));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570507L);
                    this.logger.error((Object)("delete libFile : " + this.getcleanedMessage(bo.getTargetName()) + " failed." + e.getMessage()));
                }
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("batch delete libFile result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    @Override
    public LibraryFileForm findById(Long libId) {
        LibraryFile libraryFile = this.libraryFileDao.get(libId);
        this.logger.info((Object)("find libFile by id : " + libId));
        return (LibraryFileForm)AticUtil.copyProperties((Object)libraryFile, (Object)new LibraryFileForm());
    }

    @Override
    public LibraryFileForm findByLibType(String libType) {
        LibraryFile libraryFile = this.libraryFileDao.get(libType);
        this.logger.info((Object)("find libFile by id : " + libType));
        return (LibraryFileForm)AticUtil.copyProperties((Object)libraryFile, (Object)new LibraryFileForm());
    }

    @Override
    public void delById(Long id) {
        this.libraryFileDao.remove(id);
    }

    private void setOtherLibFileToUndeploy(Long libId, String libType, String libFilePath, String ddosVersion) {
        try {
            this.libraryFileDao.setOtherLibFileToUndeploy(libId, libType, libFilePath, ddosVersion);
        }
        catch (Exception e) {
            this.logger.error((Object)("setOtherLibFileToUndeploy Error: " + e.getMessage()));
        }
    }

    @Override
    public boolean setLibFileToDepolying(String update, Long libId, String libType) {
        boolean updateResult = false;
        try {
            if (!StringUtils.isEmpty((CharSequence)update)) {
                this.locationCustomDao.updateLocCustomToDepolying(update, libId);
            } else if (!libType.equals("Location_Custom")) {
                this.libraryFileDao.setLibFileToDepolying(libId);
                this.globeDeployStatusDao.deleteLibFileByType(libId, libType);
            } else {
                this.locationCustomDao.setLocCustomToDepolying(libId);
            }
            updateResult = true;
        }
        catch (Exception e) {
            updateResult = false;
            this.logger.error((Object)("setLibFileToDepolying Error: " + e.getMessage()));
        }
        return updateResult;
    }

    @Override
    public boolean deployLibFileOnDevice(Map<String, String> condition, List<Long> firewallIds) {
        Long objectId = Long.parseLong(condition.get("objectId"));
        String objectType = condition.get("objectType");
        String libFilePath = condition.get("libFilePath");
        String libFilePathLog = condition.get("libFilePath");
        String isMsg4AddDeviceStr = condition.get("MsgForAddDevice");
        String ddosVersion = condition.get("ddosVersion");
        boolean isMsg4AddDevice = Boolean.valueOf(isMsg4AddDeviceStr);
        String libFileDeployStatus = "success";
        int devNum = 0;
        int deploySuccess = 0;
        if (null == firewallIds || firewallIds.isEmpty()) {
            libFileDeployStatus = "undeployed";
        } else {
            try {
                if (libFilePathLog.startsWith(AticInstallUtil.getInstance().getAticInstallPath())) {
                    libFilePathLog = libFilePathLog.substring(AticInstallUtil.getInstance().getAticInstallPath().length());
                }
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"Failed to delete atic install path in the libFilePath");
                libFilePathLog = "";
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to delete atic install path in the libFilePath");
                libFilePathLog = "";
            }
            for (Long devId : firewallIds) {
                GlobeDeployStatus globeDeployStatus = null;
                try {
                    AticDevice firewall = this.aticDeviceService.getDeviceByMoid(devId.longValue());
                    this.logger.info((Object)("deploy:" + firewall.getDeviceModel() + ":" + libFilePathLog));
                    if (firewall.getDeviceModel().startsWith("AntiDDoS18") && libFilePath.toLowerCase(Locale.US).contains("iprpu_h10010000") || firewall.getDeviceModel().startsWith("AntiDDoS8") && libFilePath.toLowerCase(Locale.US).contains("iprpu_h10010001") || firewall.getDeviceModel().startsWith("AntiDDoS12") || libFilePath.toUpperCase(Locale.US).contains("IPS") && !firewall.getDeviceModel().toUpperCase(Locale.US).equals(ddosVersion.toUpperCase(Locale.US))) continue;
                    ++devNum;
                    String opeResult = this.upLoadFileAndExeCmd(firewall, libFilePath, objectId, objectType);
                    if (!opeResult.equals("success")) {
                        libFileDeployStatus = "failure";
                    } else {
                        ++deploySuccess;
                    }
                    globeDeployStatus = this.globeDeployStatusDao.getGlobeDeployStatus(objectId, objectType, firewall.getMoId());
                    if (null != globeDeployStatus) {
                        this.globeDeployStatusDao.deleteGlobeDeployStatus(objectId, objectType, firewall.getMoId());
                    }
                    globeDeployStatus = new GlobeDeployStatus();
                    globeDeployStatus.setObjectId(objectId);
                    globeDeployStatus.setObjectType(objectType);
                    globeDeployStatus.setTargetId(firewall.getMoId());
                    globeDeployStatus.setTargetType(firewall.getDeviceModel());
                    globeDeployStatus.setTargetName(firewall.getName());
                    globeDeployStatus.setTargetIp(firewall.getIpAddress());
                    globeDeployStatus.setDeployTime(System.currentTimeMillis() / 1000L);
                    globeDeployStatus.setDeployStatus(opeResult);
                    this.globeDeployStatusDao.saveOrUpdate(globeDeployStatus);
                    long globeId = globeDeployStatus.getPkId();
                    if (globeId <= 0L) {
                        this.logger.error((Object)("globeDeployStatusDao.save error, objId:" + globeDeployStatus.getObjectId() + ", objType:" + globeDeployStatus.getObjectType()));
                        libFileDeployStatus = "failure";
                    }
                    this.addOperaLogToDB(condition, globeDeployStatus, false, false);
                }
                catch (Exception e) {
                    this.logger.error((Object)("deployLibFileOnDevice unknow error." + e.getMessage()));
                    libFileDeployStatus = "failure";
                    this.addOperaLogToDB(condition, globeDeployStatus, false, false);
                }
            }
            if (this.isLocDevListChange) {
                this.notifyLocDevListChange();
                this.isLocDevListChange = false;
            }
        }
        if (devNum == 0) {
            libFileDeployStatus = "undeployed";
        }
        if (deploySuccess > 0 && deploySuccess < devNum) {
            libFileDeployStatus = "part_suc";
        }
        if (!objectType.equals("Location_Custom")) {
            LibraryFile libraryFile = this.libraryFileDao.get(objectId);
            if (null != libraryFile) {
                if (isMsg4AddDevice && libFileDeployStatus.equals("part_suc")) {
                    libraryFile.setDeployTime(System.currentTimeMillis() / 1000L);
                } else {
                    libraryFile.setDeployStatus(libFileDeployStatus);
                    libraryFile.setDeployTime(System.currentTimeMillis() / 1000L);
                }
                try {
                    this.logger.info((Object)("deployLibFileOnDevice libraryFile getDeployStatus=" + libraryFile.getDeployStatus() + ", getHashCode=" + libraryFile.getHashCode() + ",getImportType=" + libraryFile.getImportType() + ",getLibName=" + libraryFile.getLibName() + ",getLibType=" + libraryFile.getLibType() + ",getDeployTime=" + libraryFile.getDeployTime() + ",getImportTime=" + libraryFile.getImportTime()));
                    this.libraryFileDao.update(libraryFile);
                }
                catch (Exception e) {
                    this.logger.error((Object)("libraryFileDao.update unknow error." + e.getMessage()));
                }
                if (deploySuccess > 0 && "Lib_Location".equals(libraryFile.getLibType())) {
                    IpLocationUtil.loadIpLocFileDataToMemery(libFilePath);
                }
                this.setOtherLibFileToUndeploy(objectId, libraryFile.getLibType(), libFilePath, libraryFile.getDdosVersion());
            }
        } else {
            LocationCustom locCus = this.locationCustomDao.get(objectId);
            if (null != locCus) {
                if (isMsg4AddDevice && libFileDeployStatus.equals("part_suc")) {
                    locCus.setDeployTime(System.currentTimeMillis() / 1000L);
                } else {
                    locCus.setDeployStatus(libFileDeployStatus);
                    locCus.setDeployTime(System.currentTimeMillis() / 1000L);
                }
                this.locationCustomDao.update(locCus);
                IpLocationUtil.loadIpLocCusDataToMemery(locCus);
            }
        }
        return libFileDeployStatus.equals("success");
    }

    @Override
    public boolean unDeployLibFileOnDevice(Map<String, String> condition, List<Long> firewallIds) {
        LocationCustom locCus;
        Long objectId = Long.parseLong(condition.get("objectId"));
        String objectType = condition.get("objectType");
        String udDeployStatus = "success";
        for (Long devId : firewallIds) {
            GlobeDeployStatus globeDeployStatus = null;
            String opeResult = "";
            try {
                AticDevice firewall = this.aticDeviceService.getDeviceByMoid(devId.longValue());
                if (null == firewall || null == (globeDeployStatus = this.globeDeployStatusDao.getGlobeDeployStatus(objectId, objectType, firewall.getMoId()))) continue;
                opeResult = "V100R001C00SPC500".equalsIgnoreCase(firewall.getVersion()) ? "570513" : this.doExecLocCusCmd(firewall.getMoId(), firewall.getIpAddress(), objectId, true);
                if (opeResult.equals("success")) {
                    this.globeDeployStatusDao.deleteGlobeDeployStatus(objectId, objectType, firewall.getMoId());
                } else {
                    udDeployStatus = "failure";
                    globeDeployStatus.setDeployStatus(opeResult);
                    globeDeployStatus.setDeployTime(System.currentTimeMillis() / 1000L);
                    this.globeDeployStatusDao.update(globeDeployStatus);
                }
                this.addOperaLogToDB(condition, globeDeployStatus, true, opeResult.equals("success"));
            }
            catch (Exception e) {
                this.logger.error((Object)("deployLibFileOnDevice unknow error." + e.getMessage()));
                udDeployStatus = "failure";
                this.addOperaLogToDB(condition, globeDeployStatus, true, opeResult.equals("success"));
            }
        }
        if (this.isLocDevListChange) {
            this.notifyLocDevListChange();
            this.isLocDevListChange = false;
        }
        if (objectType.equals("Location_Custom") && null != (locCus = this.locationCustomDao.get(objectId))) {
            if ("success".equals(udDeployStatus)) {
                IpLocationUtil.getIpLocationMap().remove(locCus.getPkId());
                locCus.setDeployStatus("undeployed");
                locCus.setDeployTime(0L);
            } else {
                locCus.setDeployStatus("failure");
                locCus.setDeployTime(System.currentTimeMillis() / 1000L);
            }
            this.locationCustomDao.update(locCus);
        }
        return udDeployStatus.equals("success");
    }

    private void addOperaLogToDB(Map<String, String> condition, GlobeDeployStatus globeDeployStatus, boolean unDeploy, boolean unDeployResult) {
        if (null == globeDeployStatus) {
            return;
        }
        ISysOptLog sysOptLogMgr = this.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        String operator = condition.get("operator");
        String terminalIp = condition.get("terminalIp");
        String operation = "atic.bis.libraryFile.deploy";
        String detail = "atic.bis.libraryFile.deploy.sucessSumary";
        String failDetail = "atic.bis.libraryFile.deploy.failSumary";
        String targetName = "atic.bis.libraryFile";
        Boolean targetLocal = true;
        if (globeDeployStatus.getObjectType().equals("Location_Custom")) {
            LocationCustom form;
            operation = "atic.bis.locationCustom.deploy";
            detail = "atic.bis.locationCustom.deploy.sucessSumary";
            failDetail = "atic.bis.locationCustom.deploy.failSumary";
            if (unDeploy) {
                operation = "atic.bis.locationCustom.unDeploy";
                detail = "atic.bis.locationCustom.unDeploy.sucessSumary";
                failDetail = "atic.bis.locationCustom.unDeploy.failSumary";
            }
            if (null != (form = this.locationCustomDao.get(globeDeployStatus.getObjectId()))) {
                targetName = form.getLocationName();
                targetLocal = false;
            }
        } else {
            LibraryFileForm libFile = this.findById(globeDeployStatus.getObjectId());
            if (null != libFile) {
                targetName = libFile.getLibName();
                targetLocal = false;
            }
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        if (globeDeployStatus.getDeployStatus().equals("success") && !unDeploy || unDeploy && unDeployResult) {
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail(detail);
            sysOptLogLego.setDetailPara(new String[]{globeDeployStatus.getTargetName()});
        } else {
            String failStr = "lego.err.570702";
            String deployStatus = globeDeployStatus.getDeployStatus();
            String[] para = null;
            if (AticUtil.isNum((String)deployStatus).booleanValue()) {
                failStr = "lego.err." + deployStatus;
                para = new String[]{globeDeployStatus.getTargetName(), failStr};
            } else {
                String failDetailStr = "";
                if (deployStatus.contains(",")) {
                    failStr = deployStatus.split(",")[0];
                    failDetailStr = deployStatus.split(",")[1];
                } else {
                    failDetailStr = "atic.bis.libraryFile.deploy.noDetailReason";
                }
                if (AticUtil.isNum((String)failStr).booleanValue()) {
                    failStr = "lego.err." + failStr;
                }
                failDetail = failDetail + ".detailErrorInfo";
                para = new String[]{globeDeployStatus.getTargetName(), failStr, failDetailStr};
            }
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail(failDetail);
            sysOptLogLego.setDetailPara(para);
        }
        sysOptLogLego.setTarget(targetName);
        sysOptLogLego.setTargetLocal(targetLocal);
        sysOptLogLego.setTerminalIp(terminalIp);
        if (null != sysOptLogMgr) {
            sysOptLogMgr.writeOptLog(sysOptLogLego);
        }
    }

    private ISysOptLog getSysOptLog() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            ISysOptLog sysOptLog = (ISysOptLog)context.getService("sysLogService", ISysOptLog.class);
            if (sysOptLog != null) {
                return sysOptLog;
            }
            this.logger.error((Object)"get system/sysLogService service error");
        }
        this.logger.error((Object)"get system/sysLogService service error");
        return null;
    }

    private String upLoadFileAndExeCmd(AticDevice firewall, String libFilePath, Long objectId, String objectType) {
        String result = "failure";
        try {
            long devId = firewall.getMoId();
            String firewallVersion = firewall.getVersion();
            String supportResult = this.checkDevUnsupportLib(firewallVersion, objectType);
            if (!"support".equals(supportResult)) {
                return supportResult;
            }
            if ("Location_Custom".equals(objectType)) {
                result = this.doExecLocCusCmd(devId, firewall.getIpAddress(), objectId, false);
            } else {
                this.logger.info((Object)"start enable ftp");
                result = this.doExecEnableSFTPCmd(devId, firewall.getFtpType());
                if (result.equals("success")) {
                    this.logger.info((Object)"prepare to upload");
                    result = this.doExecUploadLibFileToSFTP(firewall, libFilePath);
                    if (result.equals("success")) {
                        this.logger.info((Object)"upload sucess");
                        result = this.doExecUpDateLibFileCmd(firewall, this.getFileName(libFilePath), objectType);
                        if (result.equals("success")) {
                            this.logger.info((Object)"deploy sucess");
                            result = "success";
                        }
                    }
                }
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"upLoadFileAndExeCmd failed");
        }
        return result;
    }

    private String checkDevUnsupportLib(String firewallVersion, String objectType) {
        if ("V100R001C00SPC500".equalsIgnoreCase(firewallVersion)) {
            return "570513";
        }
        if ("V100R001C00SPC600".equalsIgnoreCase(firewallVersion) || "V100R001C00SPC800".equalsIgnoreCase(firewallVersion) ? "Lib_CNC".equals(objectType) || "Lib_IpReputation".equals(objectType) || "Lib_IPS".equals(objectType) : firewallVersion.startsWith("V100R001") && ("Lib_CNC".equals(objectType) || "Lib_IpReputation".equals(objectType) || "Lib_IPS".equals(objectType))) {
            return "570513";
        }
        return "support";
    }

    private boolean checkIs8000Dev(String deviceModel) {
        return deviceModel.startsWith("AntiDDoS8");
    }

    private String doExecLocCusCmd(long devId, String devIp, Long objectId, boolean unDeploy) {
        String locCusName = this.getLocCusName(objectId);
        if (AticUtil.isNull((String)locCusName)) {
            return String.valueOf(571905);
        }
        String execCmdResult = "failure";
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system-view");
        cmds.add("location");
        String locationName = "geo-location user-defined " + locCusName;
        if (unDeploy) {
            cmds.add("undo " + locationName);
        } else {
            cmds.add("undo " + locationName);
            cmds.add(locationName);
            List<LocationIpForm> ipList = this.locationIpService.getLocationIpByLocId(objectId);
            for (LocationIpForm locationIpForm : ipList) {
                String cmdTemp = "add address range " + IPUtil4Atic.compressIP((String)locationIpForm.getStartIp()) + "  " + IPUtil4Atic.compressIP((String)locationIpForm.getEndIp());
                cmds.add(cmdTemp);
            }
        }
        List results = null;
        this.logger.warn((Object)("cmds:" + this.getcleanedMessage(((Object)cmds).toString())));
        try {
            results = this.aticDeviceService.execCmdNoTransaction(cmds, devId);
            if (AticUtil.isCmdSucess((List)results)) {
                if (unDeploy) {
                    int deleteResult = this.locationDevEntityDao.deleteLocationDevEntity(objectId, devIp);
                    if (!this.isLocDevListChange && deleteResult > 0) {
                        this.isLocDevListChange = true;
                    }
                    execCmdResult = "success";
                } else {
                    int idFromDev = this.getIdFromDev((String)results.get(3));
                    boolean saveResult = this.saveLocationDevEntityToDB(objectId, idFromDev, devIp);
                    execCmdResult = saveResult ? "success" : String.valueOf(570503);
                }
            } else {
                boolean isLocationDevEntity = this.getLocationDevEntityToDB(objectId, devIp);
                boolean isUsedByLocation = this.isUsedByLocationEntity(results);
                this.logger.info((Object)("isLocationDevEntity=" + isLocationDevEntity + " isUsedByLocation=" + isUsedByLocation + " unDeploy=" + unDeploy));
                if (isLocationDevEntity && isUsedByLocation && !unDeploy) {
                    execCmdResult = "success";
                } else {
                    String returnStr = this.recordExecCmdReult(results, "doExecLocCusCmd");
                    execCmdResult = "570503," + returnStr;
                }
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("doExecLocCusCmd LegoCheckedException error:" + e.getMessage()));
            execCmdResult = String.valueOf(e.getErrorCode());
        }
        catch (Exception e) {
            this.logger.error((Object)("doExecLocCusCmd unkonw error:" + e.getMessage()));
            execCmdResult = String.valueOf(570507);
        }
        return execCmdResult;
    }

    private String recordExecCmdReult(List<String> cmdResult, String cmdType) {
        if (cmdResult.isEmpty()) {
            return "";
        }
        String cmdReusultStr = "";
        String returnStr = "";
        StringBuffer buf = new StringBuffer();
        Iterator<String> iterator = cmdResult.iterator();
        while (iterator.hasNext()) {
            String resultTemp;
            String result = resultTemp = iterator.next();
            buf.append(result + ";");
            if (result.contains("Error: The specified user-defined geographic location does not exist")) continue;
            if (result.contains("Being referred to by geographic location set")) {
                result = result.replace("Info:", "Error:");
            }
            if (result.contains("Error:") && AticUtil.isNull((String)returnStr)) {
                returnStr = result.lastIndexOf("[") > result.indexOf("Error:") ? result.substring(result.indexOf("Error:"), result.lastIndexOf("[") - 1).trim() : result.substring(result.indexOf("Error:")).trim();
            }
            if (!result.contains("remain space of CF card is less than")) continue;
            returnStr = result.substring(result.indexOf("Info:")).trim();
        }
        cmdReusultStr = buf.toString();
        this.logger.error((Object)(this.getcleanedMessage(cmdType) + " execCmdReult: " + this.getcleanedMessage(cmdReusultStr)));
        return returnStr;
    }

    private boolean saveLocationDevEntityToDB(Long objectId, int idFromDev, String devIp) {
        LocationDevEntity locationDevEntity = this.locationDevEntityDao.getLocationDevEntity(objectId, devIp);
        if (null != locationDevEntity && idFromDev > 0) {
            return true;
        }
        if (null == locationDevEntity && idFromDev > 0) {
            locationDevEntity = new LocationDevEntity();
            locationDevEntity.setDeviceIp(devIp);
            locationDevEntity.setIdFromDev(idFromDev);
            locationDevEntity.setLocationId(objectId);
            this.locationDevEntityDao.save(locationDevEntity);
            if (!this.isLocDevListChange) {
                this.isLocDevListChange = true;
            }
            return true;
        }
        return false;
    }

    private boolean getLocationDevEntityToDB(Long objectId, String devIp) {
        LocationDevEntity locationDevEntity = this.locationDevEntityDao.getLocationDevEntity(objectId, devIp);
        return null != locationDevEntity;
    }

    private boolean isUsedByLocationEntity(List<String> results) {
        for (String result : results) {
            if (!result.contains("Being referred to by geographic location set")) continue;
            return true;
        }
        return false;
    }

    private void notifyLocDevListChange() {
        boolean collectorResult = false;
        HashMap conditions = new HashMap();
        List collectors = this.collectorService.listCollector(conditions);
        ArrayList<CollectorLocationDevService> collectorLocationDevServices = new ArrayList<CollectorLocationDevService>();
        for (CollectorInfo collector : collectors) {
            CollectorLocationDevService collectorLocationDevService = this.zoneCollectorRMIProxy.getCollectorLocationDevService(collector.getIpAddress());
            if (null == collectorLocationDevService) {
                this.logger.error((Object)("collectorRMIProxy.getCollectorSendSyslogService failed. collectorIp: " + this.getcleanedMessage(collector.getIpAddress()) + "; collectorStatus: " + collector.getStatus()));
                continue;
            }
            collectorLocationDevServices.add(collectorLocationDevService);
        }
        for (CollectorLocationDevService collectorLocationDevService : collectorLocationDevServices) {
            try {
                collectorResult = collectorLocationDevService.notifyLocDevListChange();
            }
            catch (Exception e) {
                this.logger.error((Object)("Collector synchronize notifyLocDevListChange error." + e.getMessage()));
            }
            if (collectorResult) continue;
            this.logger.error((Object)"Collector synchronize notifyLocDevListChange error.");
        }
    }

    private int getIdFromDev(String cmdStr) {
        if (cmdStr.contains("geo-location-id") && cmdStr.contains("geo-location-maskid")) {
            int startIndex = cmdStr.indexOf("geo-location-id") + "geo-location-id".length();
            int endIndex = cmdStr.indexOf("geo-location-maskid");
            String idFromDevStr = cmdStr.substring(startIndex, endIndex).trim();
            try {
                return Integer.parseInt(idFromDevStr);
            }
            catch (Exception e) {
                this.logger.error((Object)("Integer.parseInt(" + idFromDevStr + ") error." + e.getMessage()));
                return 0;
            }
        }
        return 0;
    }

    private String getLocCusName(Long objectId) {
        LocationCustom locationCustom = this.locationCustomDao.get(objectId);
        if (null != locationCustom) {
            return locationCustom.getLocationName();
        }
        return "";
    }

    private String doExecEnableSFTPCmd(Long devId, int ftpType) {
        String result = "failure";
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system-view");
        if (ftpType == 1) {
            cmds.add("sftp server enable");
        } else if (ftpType == 0) {
            cmds.add("ftp server enable");
        }
        List results = null;
        this.logger.warn((Object)("cmds:" + this.getcleanedMessage(((Object)cmds).toString())));
        try {
            results = this.aticDeviceService.execCmdNoTransaction(cmds, devId.longValue());
            if (AticUtil.isCmdSucess((List)results)) {
                result = "success";
            } else {
                this.recordExecCmdReult(results, "doExecEnableSFTPCmd");
                result = String.valueOf(570503);
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("doExecEnableSFTPCmd LegoCheckedException error:" + e.getMessage()));
            result = String.valueOf(e.getErrorCode());
        }
        catch (Exception e) {
            this.logger.error((Object)("doExecEnableSFTPCmd unkonw error:" + e.getMessage()));
            result = String.valueOf(570507);
        }
        return result;
    }

    private String doExecUpDateLibFileCmd(AticDevice firewall, String fileName, String libType) {
        String result = "failure";
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system-view");
        String ftpPath = "hda1";
        if (this.checkIs8000Dev(firewall.getDeviceModel())) {
            ftpPath = "cfcard";
        }
        String libFileType = "";
        if ("Lib_Location".equals(libType)) {
            libFileType = "location-sdb";
            this.maxLocLibFileDeployTime = 150;
        } else if ("Lib_IpReputation".equals(libType)) {
            libFileType = "ip-reputation";
            this.maxLocLibFileDeployTime = 900;
        } else if ("Lib_IPS".equals(libType)) {
            libFileType = "ips-sdb";
            this.maxLocLibFileDeployTime = 900;
        } else if ("Lib_CNC".equals(libType)) {
            libFileType = "cnc";
            this.maxLocLibFileDeployTime = 150;
        }
        cmds.add("update local " + libFileType + " file " + ftpPath + ":/" + fileName);
        List results = null;
        this.logger.warn((Object)("cmds:" + this.getcleanedMessage(((Object)cmds).toString())));
        try {
            results = this.aticDeviceService.execCmdNoTransaction(cmds, firewall.getMoId(), this.maxLocLibFileDeployTime);
            if (results != null) {
                if (AticUtil.isCmdSucess((List)results)) {
                    result = "success";
                } else {
                    String returnStr = this.recordExecCmdReult(results, "doExecUpDateLibFileCmd");
                    result = "570503," + returnStr;
                }
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("doExecUpDateLibFileCmd LegoCheckedException error:" + e.getMessage()));
            result = String.valueOf(e.getErrorCode());
        }
        catch (Exception e) {
            this.logger.error((Object)"doExecUpDateLibFileCmd unkonw error ");
            result = String.valueOf(570507);
        }
        return result;
    }

    private String doExecUploadLibFileToSFTP(AticDevice firewall, String filePath) {
        String result = "";
        int ftpType = firewall.getFtpType();
        if (ftpType == 1) {
            result = this.uploadLibFileToSftp(firewall, filePath);
        } else if (ftpType == 0) {
            result = this.uploadLibFileToFtp(firewall, filePath);
        }
        this.logger.info((Object)("doExecUploadLibFileToSFTP result:" + this.getcleanedMessage(result)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadLibFileToFtp(AticDevice firewall, String filePath) {
        String result = "failure";
        FTPClient ftp = null;
        InputStream instream = null;
        try {
            String user = firewall.getFtpUser();
            StringBuffer psw = DataProtectServiceConst.sdpDecryptLocalBuffer((String)firewall.getFtpPassword());
            String ip = firewall.getIpAddress();
            int port = firewall.getFtpPort();
            ftp = new FTPClient();
            ftp.setConnectTimeout(1000);
            ftp.connect(ip);
            ftp.setDefaultPort(port);
            int replyCode = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                ftp.disconnect();
                this.logger.error((Object)"FTP server refused connection.");
                throw new LegoCheckedException(512L);
            }
            if (!ftp.login(user, psw.toString())) {
                ftp.logout();
                this.logger.error((Object)"user name or password error.");
                throw new LegoCheckedException(514L);
            }
            ftp.setFileType(2);
            instream = new FileInputStream(new File(filePath));
            if (!ftp.storeFile(this.getFileName(filePath), instream)) {
                this.logger.error((Object)"upload file failed");
                throw new LegoCheckedException(515L);
            }
            ftp.logout();
            result = "success";
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("LegoCheckedException error," + e.getMessage()));
            result = String.valueOf(e.getErrorCode());
        }
        catch (FTPConnectionClosedException e) {
            result = String.valueOf(516L);
            this.logger.error((Object)("Server closed connection." + e.getMessage()));
        }
        catch (FileNotFoundException e) {
            result = String.valueOf(571915);
            this.logger.error((Object)" FileNotFoundException error.");
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not connect to server.");
            result = String.valueOf(513L);
        }
        catch (RuntimeException e) {
            result = String.valueOf(571904);
            this.logger.error((Object)"unknow error");
        }
        finally {
            if (null != ftp && ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    this.logger.error((Object)"disconnect ftp exception");
                }
            }
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"instream.close() error");
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadLibFileToSftp(AticDevice firewall, String filePath) {
        String result;
        block24: {
            result = "failure";
            Session session = null;
            Channel channel = null;
            OutputStream outstream = null;
            FileInputStream instream = null;
            ByteArrayInputStream in = null;
            try {
                int n;
                CharSequence buffer;
                String user = firewall.getFtpUser();
                StringBuffer psw = DataProtectServiceConst.sdpDecryptLocalBuffer((String)firewall.getFtpPassword());
                String ip = firewall.getIpAddress();
                int port = firewall.getFtpPort();
                JSch jsch = new JSch();
                if (null != firewall.getSshPublicKey() && !"".equals(firewall.getSshPublicKey())) {
                    this.logger.info((Object)"hostKey will be validate");
                    buffer = new StringBuffer();
                    ((StringBuffer)buffer).append(ip);
                    ((StringBuffer)buffer).append(' ');
                    ((StringBuffer)buffer).append("ssh-rsa");
                    ((StringBuffer)buffer).append(' ');
                    ((StringBuffer)buffer).append(firewall.getSshPublicKey());
                    in = new ByteArrayInputStream(((StringBuffer)buffer).toString().getBytes("UTF-8"));
                    jsch.setKnownHosts((InputStream)in);
                } else {
                    this.logger.info((Object)"hostKey is null, hostKey will not be validate");
                }
                session = jsch.getSession(user, ip, port);
                if (session == null) {
                    buffer = String.valueOf(571904);
                    return buffer;
                }
                session.setConfig("cipher.c2s", "aes256-ctr");
                session.setConfig("mac.c2s", "hmac-sha2-256");
                session.setConfig("cipher.s2c", "aes256-ctr");
                session.setConfig("mac.s2c", "hmac-sha2-256");
                session.setConfig("CheckCiphers", "aes256-ctr");
                session.setConfig("CheckKexes", "diffie-hellman-group14-sha1");
                session.setConfig("kex", "diffie-hellman-group14-sha1");
                session.setConfig("server_host_key", "ssh-rsa");
                session.setPassword(psw.toString());
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect(10000);
                channel = session.openChannel("sftp");
                channel.connect(1000);
                outstream = ((ChannelSftp)channel).put(this.getFileName(filePath));
                instream = new FileInputStream(new File(filePath));
                byte[] b = new byte[1024];
                while ((n = ((InputStream)instream).read(b)) != -1) {
                    outstream.write(b, 0, n);
                }
                outstream.flush();
                result = "success";
                this.closeInputStream(in);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("LegoCheckedException error," + e.getMessage()));
                result = String.valueOf(e.getErrorCode());
                break block24;
            }
            catch (FileNotFoundException e) {
                result = String.valueOf(571915);
                this.logger.error((Object)" FileNotFoundException error.");
                break block24;
            }
            catch (IOException e) {
                result = String.valueOf(571915);
                this.logger.error((Object)" IOException error.");
                break block24;
            }
            catch (SftpException e) {
                result = String.valueOf(571915);
                this.logger.error((Object)" SftpException error.");
                break block24;
            }
            catch (JSchException e) {
                result = String.valueOf(571904);
                this.logger.error((Object)(this.getcleanedMessage(firewall.getIpAddress()) + "-The sftp server hostkey was not accepted by the verifier callback!"));
                break block24;
            }
            catch (RuntimeException e) {
                result = String.valueOf(571904);
                this.logger.error((Object)"unknow error");
                break block24;
            }
            finally {
                this.closeInputStream(in);
                this.closeOutputStream(outstream);
                this.closeInputStream(instream);
                if (null != session) {
                    session.disconnect();
                }
                if (null != channel) {
                    channel.disconnect();
                }
            }
            this.closeOutputStream(outstream);
            this.closeInputStream(instream);
            if (null != session) {
                session.disconnect();
            }
            if (null != channel) {
                channel.disconnect();
            }
        }
        return result;
    }

    private void closeOutputStream(OutputStream output) {
        if (null != output) {
            try {
                output.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"outstream.close() error");
            }
            finally {
                output = null;
            }
        }
    }

    private void closeInputStream(InputStream input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"instream.close() error");
            }
            finally {
                input = null;
            }
        }
    }

    private String getFileName(String filePath) {
        int indexOther;
        int index = filePath.lastIndexOf("\\");
        int realIndex = index > (indexOther = filePath.lastIndexOf("/")) ? index : indexOther;
        String fileName = filePath.substring(realIndex + 1, filePath.length());
        return fileName;
    }

    public LibraryFileDao getLibraryFileDao() {
        return this.libraryFileDao;
    }

    public void setLibraryFileDao(LibraryFileDao libraryFileDao) {
        this.libraryFileDao = libraryFileDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public GlobeDeployStatusDao getGlobeDeployStatusDao() {
        return this.globeDeployStatusDao;
    }

    public void setGlobeDeployStatusDao(GlobeDeployStatusDao globeDeployStatusDao) {
        this.globeDeployStatusDao = globeDeployStatusDao;
    }

    public LocationCustomDao getLocationCustomDao() {
        return this.locationCustomDao;
    }

    public void setLocationCustomDao(LocationCustomDao locationCustomDao) {
        this.locationCustomDao = locationCustomDao;
    }

    public ILocationIpService getLocationIpService() {
        return this.locationIpService;
    }

    public void setLocationIpService(ILocationIpService locationIpService) {
        this.locationIpService = locationIpService;
    }

    @Override
    public Map<Long, IpLocation> getIpLocationMap() {
        return IpLocationUtil.getIpLocationMap();
    }

    @Override
    public LibraryFileForm getMaxVerLibFile(String libFileType, String productName) {
        LibraryFile libFile;
        String fileName = "";
        String ddosVersion = "";
        if (libFileType.equals("Lib_IpReputation") && productName.startsWith("AntiDDoS18")) {
            fileName = "IPRPU_H10010001";
        } else if (libFileType.equals("Lib_IpReputation") && productName.startsWith("AntiDDoS8")) {
            fileName = "IPRPU_H10010000";
        }
        if (libFileType.equals("Lib_IPS")) {
            ddosVersion = productName;
        }
        if (null == (libFile = this.libraryFileDao.getMaxVerLibFile(libFileType, fileName, ddosVersion))) {
            return null;
        }
        LibraryFileForm libraryFileForm = new LibraryFileForm();
        AticUtil.copyProperties((Object)libFile, (Object)libraryFileForm);
        return libraryFileForm;
    }

    public void deployIpLocation4AddDevice(List<Long> moidList, Map<String, String> condtion) {
        String operator = "";
        String terminalIp = "";
        if (null != condtion) {
            if (condtion.containsKey("operator")) {
                operator = condtion.get("operator");
            }
            if (condtion.containsKey("terminalIp")) {
                terminalIp = condtion.get("terminalIp");
            }
        }
        this.deployIpLocationFile(moidList, operator, terminalIp);
        this.deployIpLocationCustom(moidList, operator, terminalIp);
    }

    private void deployIpLocationFile(List<Long> devIdList, String operator, String terminalIp) {
        LibraryFile libraryFile = this.libraryFileDao.getDeployedIpLocationFile();
        if (null == libraryFile) {
            return;
        }
        HashMap<String, String> condtionMap = new HashMap<String, String>();
        condtionMap.put("objectId", String.valueOf(libraryFile.getPkId()));
        condtionMap.put("objectType", String.valueOf(libraryFile.getLibType()));
        condtionMap.put("libFilePath", LibFilePathUtil.getLibFilePath() + libraryFile.getLibName());
        condtionMap.put("operator", operator);
        condtionMap.put("terminalIp", terminalIp);
        condtionMap.put("MsgForAddDevice", String.valueOf(true));
        if (this.deployLibFileOnDevice(condtionMap, devIdList)) {
            this.logger.info((Object)("deployLibFileOnDevice success, id=" + libraryFile.getPkId() + ",name=" + this.getcleanedMessage(libraryFile.getLibName())));
        } else {
            this.logger.info((Object)("deployLibFileOnDevice failuer, id=" + libraryFile.getPkId() + ",name=" + this.getcleanedMessage(libraryFile.getLibName())));
        }
    }

    private void deployIpLocationCustom(List<Long> devIdList, String operator, String terminalIp) {
        List<LocationCustom> locCusList = this.locationCustomDao.getDeployedIpLocationCustom();
        for (LocationCustom locationCustom : locCusList) {
            try {
                HashMap<String, String> condtionMap = new HashMap<String, String>();
                condtionMap.put("objectId", String.valueOf(locationCustom.getPkId()));
                condtionMap.put("objectType", "Location_Custom");
                condtionMap.put("operator", operator);
                condtionMap.put("terminalIp", terminalIp);
                condtionMap.put("MsgForAddDevice", String.valueOf(true));
                if (this.deployLibFileOnDevice(condtionMap, devIdList)) {
                    this.logger.info((Object)("deployIpLocationCustom success, id=" + locationCustom.getPkId() + ",name=" + this.getcleanedMessage(locationCustom.getLocationName())));
                    continue;
                }
                this.logger.info((Object)("deployIpLocationCustom failuer, id=" + locationCustom.getPkId() + ",name=" + this.getcleanedMessage(locationCustom.getLocationName())));
            }
            catch (Exception e) {
                this.logger.error((Object)("deployIpLocationCustom catch an unknown exception! " + e.getMessage()));
            }
        }
    }

    @Override
    public String getSecDownHttpPort() {
        String httpPort = this.sysConfigManager.getSystemValue("secDownHttpPort");
        if (AticUtil.isNull((String)httpPort)) {
            httpPort = "80";
        }
        return httpPort;
    }

    @Override
    public String getSecDownHttpUrl() {
        String httpUrl = this.sysConfigManager.getSystemValue("secDownHttpUrl");
        if (AticUtil.isNull((String)httpUrl)) {
            httpUrl = "sec.huawei.com";
        }
        return httpUrl;
    }

    public LocationDevEntityDao getLocationDevEntityDao() {
        return this.locationDevEntityDao;
    }

    public void setLocationDevEntityDao(LocationDevEntityDao locationDevEntityDao) {
        this.locationDevEntityDao = locationDevEntityDao;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public ZoneCollectorRMIProxy getZoneCollectorRMIProxy() {
        return this.zoneCollectorRMIProxy;
    }

    public void setZoneCollectorRMIProxy(ZoneCollectorRMIProxy zoneCollectorRMIProxy) {
        this.zoneCollectorRMIProxy = zoneCollectorRMIProxy;
    }

    public SysConfigManager getSysConfigManager() {
        return this.sysConfigManager;
    }

    public void setSysConfigManager(SysConfigManager sysConfigManager) {
        this.sysConfigManager = sysConfigManager;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }

    public String getIpLocationNameById(String id) {
        Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
        return this.getIpLocationNameById(id, locale);
    }

    public String getIpLocationNameById(String id, Locale locale) {
        String ipLocationName = null;
        IpLocation ipLocation = this.getIpLocationMap().get(Long.valueOf(id));
        String language = locale.getLanguage();
        this.logger.info((Object)("current user locale : " + language));
        if (null != ipLocation) {
            ipLocationName = language.equalsIgnoreCase("zh") ? ipLocation.getLocationNameZh() : ipLocation.getLocationNameEn();
        }
        return ipLocationName;
    }

    @Override
    public boolean queryByLibTypeStatus(String libType) {
        LibraryFile liFile = this.libraryFileDao.queryByTypeStatus(libType);
        return null != liFile && libType.equals(liFile.getLibType());
    }

    @Override
    public List<LibraryFile> queryByDeployStatus(String deployStatus) {
        return this.libraryFileDao.queryByDeployStatus(deployStatus);
    }

    @Override
    public void setLibFileDepolyStatus(String depolyStatus, Long libId) {
        this.libraryFileDao.setLibFileDepolyStatus(depolyStatus, libId);
    }

    @Override
    public List<LibraryFile> getAutoIPReputationLibFile() {
        List<LibraryFile> liFileList = this.libraryFileDao.getAutoIPReputationLibFile();
        return liFileList;
    }

    @Override
    public LibraryFile getLastAutoIPReputationLibFile() {
        LibraryFile liFile = this.libraryFileDao.getLastAutoIPReputationLibFile();
        return liFile;
    }

    @Override
    public LibraryFile getDeployIPReputationLibFile() {
        LibraryFile liFile = this.libraryFileDao.getDeployIPReputationLibFile();
        return liFile;
    }

    @Override
    public LibraryFile getDeployedIPReputationLibFile() {
        LibraryFile libFile = this.libraryFileDao.getDeployedIPReputationLibFile();
        return libFile;
    }
}

