/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.sdk.bis.service.IVpnService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.Vpn;
import com.huawei.atic.sdk.bis.form.VpnForm;
import com.huawei.atic.secne.resource.dao.VpnDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VpnServiceImpl
implements IVpnService {
    private VpnDao vpnDao;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public VpnDao getVpnDao() {
        return this.vpnDao;
    }

    public void setVpnDao(VpnDao vpnDao) {
        this.vpnDao = vpnDao;
    }

    @Override
    public List<VpnForm> getVpnListByMoId(Long moId) {
        ArrayList<VpnForm> listVpnForm = new ArrayList<VpnForm>();
        List vpnList = this.vpnDao.getVpnListByMoId(moId.longValue());
        for (Vpn vpn : vpnList) {
            VpnForm form = new VpnForm();
            this.copyProperties(vpn, form);
            listVpnForm.add(form);
        }
        return listVpnForm;
    }

    @Override
    public Paging queryPagingVpnByMoId(Long moId, String vpnName, int start, int pageSize) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("moId", String.valueOf(moId));
        queryMap.put("vpnName", vpnName);
        queryMap.put("sortType", "ASC");
        queryMap.put("sortName", "vname");
        Paging page = this.vpnDao.queryByPage(queryMap, start, pageSize);
        List vpnInfos = page.getData();
        ArrayList<VpnForm> vpnForms = new ArrayList<VpnForm>();
        for (Vpn vpn : vpnInfos) {
            VpnForm vpnForm = new VpnForm();
            this.copyProperties(vpn, vpnForm);
            vpnForms.add(vpnForm);
        }
        page.setData(vpnForms);
        return page;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public boolean isVpnExist(Long deviceMoId, String vpnName) {
        if (null == deviceMoId || null == vpnName || vpnName.isEmpty()) {
            this.logger.info((Object)("isVpnExist return false. deviceMoId:" + deviceMoId + " vpnName:" + this.getcleanedMessage(vpnName) + "."));
            return false;
        }
        return this.vpnDao.isVpnExist(deviceMoId.longValue(), vpnName);
    }

    private void copyProperties(Vpn vpn, VpnForm vpnForm) {
        vpnForm.setId(vpn.getId());
        vpnForm.setTopMoid(vpn.getMoid());
        vpnForm.setVname(vpn.getVpnName());
    }
}

