/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.service.CollectorZoneState;
import com.hs.atic.bis.service.ZoneStateConsumer;
import com.hs.atic.rmi.ZoneState;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public final class ZoneStateBuffer {
    private static ZoneStateBuffer instance = new ZoneStateBuffer();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Map<Long, ZoneStateConsumer> zoneStatesRepository = new HashMap<Long, ZoneStateConsumer>();

    private ZoneStateBuffer() {
    }

    public static ZoneStateBuffer getInstance() {
        return instance;
    }

    public Map<Long, ZoneStateConsumer> getZoneStatesRepository() {
        return this.zoneStatesRepository;
    }

    public void setZoneStatesRepository(Map<Long, ZoneStateConsumer> zoneStatesRepository) {
        this.zoneStatesRepository = zoneStatesRepository;
    }

    private ZoneStateConsumer getZoneStateConsumerByZoneId(Long zoneId) {
        if (!this.zoneStatesRepository.containsKey(zoneId)) {
            this.zoneStatesRepository.put(zoneId, new ZoneStateConsumer(zoneId));
        }
        return this.zoneStatesRepository.get(zoneId);
    }

    public int getZoneState(ZoneState zoneState, String collectorIp) {
        Long zoneId = zoneState.getZoneId();
        if (1 == zoneState.getState() && !this.zoneStatesRepository.containsKey(zoneId)) {
            return 1;
        }
        CollectorZoneState collectorZoneState = new CollectorZoneState(zoneState, collectorIp);
        if (1 == zoneState.getState()) {
            this.zoneStatesRepository.get(zoneId).removeZoneState(collectorZoneState);
            if (1 == this.zoneStatesRepository.get(zoneId).getState()) {
                this.zoneStatesRepository.remove(zoneId);
                return 1;
            }
            return this.zoneStatesRepository.get(zoneId).getState();
        }
        this.getZoneStateConsumerByZoneId(zoneId).addZoneState(collectorZoneState);
        return this.zoneStatesRepository.get(zoneId).getState();
    }

    public Map<Long, Integer> getAllZoneState() {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (Map.Entry<Long, ZoneStateConsumer> entry : this.zoneStatesRepository.entrySet()) {
            try {
                map.put(entry.getKey(), entry.getValue().getState());
            }
            catch (Exception e) {
                this.logger.error((Object)("getAllZoneState error!" + e.getMessage()));
            }
        }
        return map;
    }
}

