/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.util;

import com.hs.atic.bis.action.LibraryFileAction;
import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnDeployLocCusThread
extends Thread {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private Long libId;
    private String libType;
    private String libFilePath;
    private List<AticDevice> allDdosFirewall;
    private Map<String, String> conditionMap;

    public UnDeployLocCusThread(Map<String, String> conditionMap, List<AticDevice> allDdosFirewall) {
        this.libId = Long.parseLong(conditionMap.get("objectId"));
        this.libType = conditionMap.get("objectType");
        this.libFilePath = conditionMap.get("libFilePath");
        this.allDdosFirewall = allDdosFirewall;
        this.conditionMap = conditionMap;
    }

    @Override
    public void run() {
        try {
            ArrayList<Long> firewallIds = new ArrayList<Long>();
            for (AticDevice firewall : this.allDdosFirewall) {
                firewallIds.add(firewall.getMoId());
            }
            if (this.libType.equals("Location_Custom")) {
                this.processUnDeployLocCus(firewallIds);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("undeploy loc cus thread error." + e.getMessage()));
        }
    }

    private void processUnDeployLocCus(List<Long> firewallIds) {
        ILibraryFileService libraryFileService = (ILibraryFileService)ServiceContext.getInstance().getService("libraryFileService", ILibraryFileService.class);
        ILocationCustomService locationCustomService = (ILocationCustomService)ServiceContext.getInstance().getService("locationCustomService", ILocationCustomService.class);
        LocationCustomForm locCus = locationCustomService.findById(this.libId);
        if (null == locCus) {
            this.logger.error((Object)("locationCustomId=" + this.libId + " is not exist."));
            throw new LegoCheckedException(571905L);
        }
        libraryFileService.unDeployLibFileOnDevice(this.conditionMap, firewallIds);
        LibraryFileAction.getDeployOrUndeploy().put(this.conditionMap.get("httpSessionId"), "unDeploy");
    }

    public Long getLibId() {
        return this.libId;
    }

    public void setLibId(Long libId) {
        this.libId = libId;
    }

    public String getLibType() {
        return this.libType;
    }

    public void setLibType(String libType) {
        this.libType = libType;
    }

    public String getLibFilePath() {
        return this.libFilePath;
    }

    public void setLibFilePath(String libFilePath) {
        this.libFilePath = libFilePath;
    }

    public List<AticDevice> getAllDdosFirewall() {
        return this.allDdosFirewall;
    }

    public void setAllDdosFirewall(List<AticDevice> allDdosFirewall) {
        this.allDdosFirewall = allDdosFirewall;
    }

    public Map<String, String> getConditionMap() {
        return this.conditionMap;
    }

    public void setConditionMap(Map<String, String> conditionMap) {
        this.conditionMap = conditionMap;
    }
}

