/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.util;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterDeviceZoneForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.VtyConfigService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class ZoneBisUtil {
    private ZoneBisUtil() {
    }

    public static IAticDeviceService getIFirewallService() {
        IAticDeviceService firewallService = (IAticDeviceService)AticUtil.getServiceContext().getService("aticDeviceService", IAticDeviceService.class);
        if (firewallService == null) {
            throw new LegoCheckedException(570506L);
        }
        return firewallService;
    }

    public static IZoneDeviceService getIZoneDeviceService() {
        IZoneDeviceService zoneDeviceService = (IZoneDeviceService)AticUtil.getServiceContext().getService("zoneDeviceService", IZoneDeviceService.class);
        if (zoneDeviceService == null) {
            throw new LegoCheckedException(570506L);
        }
        return zoneDeviceService;
    }

    public static IZoneServiceService getIZoneServiceService() {
        IZoneServiceService zoneServiceService = (IZoneServiceService)AticUtil.getServiceContext().getService("zoneServiceService", IZoneServiceService.class);
        if (zoneServiceService == null) {
            throw new LegoCheckedException(570506L);
        }
        return zoneServiceService;
    }

    public static boolean createFile(String importPath) {
        File file = new File(importPath);
        if (!file.exists()) {
            boolean ret = file.mkdir();
            return ret;
        }
        return true;
    }

    public static boolean checkIsErrorCode(String deployStatus) {
        String resource;
        String deployErrorCode = deployStatus;
        if (deployStatus.contains(",")) {
            deployErrorCode = deployErrorCode.split(",")[0];
        }
        return AticUtil.isNum((String)deployErrorCode) != false && !(resource = ZoneBisUtil.getText("lego.err." + deployErrorCode)).equals("lego.err." + deployErrorCode);
    }

    public static String getDeployStatus4Jsp(String deployStatus, boolean unDeploy) {
        String deployStatusJsp = "";
        if (deployStatus.equals("undeployed")) {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.undeployed");
        } else if (deployStatus.equals("failure")) {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.failure");
        } else if (deployStatus.equals("success")) {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.success");
        } else if (deployStatus.equals("deploying")) {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.deploying");
        } else if (deployStatus.equals("part_suc")) {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.partSuccess");
        } else if (ZoneBisUtil.checkIsErrorCode(deployStatus)) {
            if (deployStatus.contains(",")) {
                String deployErrorCode = deployStatus.split(",")[0];
                String errorInfo = deployStatus.substring(deployStatus.indexOf(",") + 1);
                deployStatusJsp = ZoneBisUtil.getText("lego.err." + deployErrorCode) + "(" + errorInfo + ")";
            } else {
                deployStatusJsp = ZoneBisUtil.getText("lego.err." + deployStatus);
            }
        } else {
            deployStatusJsp = ZoneBisUtil.getText("atic.bis.libraryFile.deployStatus.undeployed");
        }
        return deployStatusJsp;
    }

    public static Long getMoidByZoneid(Long zoneId) {
        Long moid = 0L;
        ServiceContext serviceContext = ServiceContext.getInstance();
        IZoneService zoneService = (IZoneService)serviceContext.getService("zoneService", IZoneService.class);
        ZoneInfoForm zoneInfoForm = zoneService.getById(zoneId);
        if (null != zoneInfoForm) {
            moid = zoneInfoForm.getMoId();
        }
        return moid;
    }

    public static ILicenseOutboundService getLicenseOutboundService() {
        ServiceContext serviceContext = ServiceContext.getInstance();
        return (ILicenseOutboundService)serviceContext.getService("licenseOutboundService", ILicenseOutboundService.class);
    }

    public static VtyConfigService getVtyConfigService() {
        ServiceContext serviceContext = ServiceContext.getInstance();
        return (VtyConfigService)serviceContext.getService("vtyConfigService", VtyConfigService.class);
    }

    public static String getText(String i18n) {
        return LocaleUtil.getInstance().getText(i18n);
    }

    public static void checkUserSecurity(String resourceType, List<Long> idList) {
        ArrayList<String> nameList = new ArrayList<String>();
        String targetName = "";
        if ("ZoneInfo".equals(resourceType)) {
            targetName = "atic.user.list";
            for (long zoneId : idList) {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                Long moId = ZoneBisUtil.getMoidByZoneid(zoneId);
                moIdList.add(moId);
                List deviceIdList = ZoneReferUtil.getFirewallService().getDeviceByZoneId(zoneId);
                for (AticDevice aticDevice : deviceIdList) {
                    moIdList.add(aticDevice.getMoId());
                }
                try {
                    BisUtil.checkUserSecurity(moIdList);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        ZoneInfoForm zoneInfo = ZoneReferUtil.getZoneService().getZoneNOIpById(zoneId);
                        nameList.add(zoneInfo.getZoneDesc());
                        continue;
                    }
                    throw e;
                }
                catch (Exception e) {
                    throw e;
                }
            }
        } else if ("Filter".equals(resourceType)) {
            targetName = "com.hs.vsm.secservice.ddos.filter.list";
            for (long filterId : idList) {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                List<FilterDeviceZoneForm> filterDeviceZoneLIst = ZoneReferUtil.getFilterDeviceZoneInfoService().getByFilterId(filterId);
                for (FilterDeviceZoneForm filterDeviceZone : filterDeviceZoneLIst) {
                    Long zoneMoId;
                    Long zoneId;
                    Long deviceId = filterDeviceZone.getDeviceId();
                    if (!moIdList.contains(deviceId)) {
                        moIdList.add(deviceId);
                    }
                    if (null == (zoneId = filterDeviceZone.getZoneId()) || 0L == zoneId || moIdList.contains(zoneMoId = ZoneBisUtil.getMoidByZoneid(zoneId))) continue;
                    moIdList.add(zoneMoId);
                }
                try {
                    BisUtil.checkUserSecurity(moIdList);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        FilterForm filterInfo = (FilterForm)ZoneReferUtil.getFilterService().query(filterId);
                        nameList.add(filterInfo.getFilterName());
                        continue;
                    }
                    throw e;
                }
                catch (Exception e) {
                    throw e;
                }
            }
        } else if ("NPFilter".equals(resourceType)) {
            targetName = "lego.dic.module.NPFilter";
            for (long npFilterId : idList) {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                List<NPFilterDeviceForm> npFilterDeviceLIst = ZoneReferUtil.getNPFilterService().getNPFilterDevicesByFilterId(npFilterId);
                for (NPFilterDeviceForm npFilterDevice : npFilterDeviceLIst) {
                    Long deviceId = npFilterDevice.getDeviceId();
                    if (moIdList.contains(deviceId)) continue;
                    moIdList.add(deviceId);
                }
                try {
                    BisUtil.checkUserSecurity(moIdList);
                }
                catch (LegoCheckedException e) {
                    if (630114L == e.getErrorCode()) {
                        NPFilterForm npFilterInfo = ZoneReferUtil.getNPFilterService().getById(npFilterId);
                        nameList.add(npFilterInfo.getFilterName());
                        continue;
                    }
                    throw e;
                }
                catch (Exception e) {
                    throw e;
                }
            }
        } else {
            throw new LegoCheckedException(630114L);
        }
        if (!nameList.isEmpty()) {
            String[] parameter = new String[]{ZoneBisUtil.getText(targetName), ((Object)nameList).toString()};
            if ("Filter".equals(resourceType)) {
                throw new LegoCheckedException(630174L, parameter);
            }
            throw new LegoCheckedException(630173L, parameter);
        }
    }
}

