/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.collect.Model.CollectModel;
import com.hs.atic.collect.Model.CollectParam;
import com.hs.atic.collect.service.CommandCollectPool;
import com.hs.atic.collect.service.CommandCollectResult;
import com.hs.atic.collect.service.CommandTranslate;
import com.hs.atic.collect.service.EnumCommandOrder;
import com.hs.atic.collect.service.EnumFileCommandOrder;
import com.hs.atic.collect.service.IssuedCommandResults;
import com.hs.atic.collect.util.ConstantUtil;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.FileUtils;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import com.hs.lego.ui.plat.common.util.OperateLocker;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.ProgressMgr;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.opensymphony.xwork2.ActionContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OneKeyCollectAction
extends BaseAction {
    private static final int MASK_IPV4_ACL = 0;
    private static final int MASK_IPV6_ACL = 1;
    private static final long serialVersionUID = -2320713946758535651L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private CollectModel collectModel;
    private List<AticDevice> devices;
    @Autowired
    private IAticDeviceService aticDeviceService;
    @Autowired
    private CommandTranslate commandTranslate;
    @Autowired
    private CommandCollectPool commandCollectPool;
    private long progressId;
    private int progress;
    private InputStream inputStream;
    private String downLoadName;
    private Map<Long, Boolean> devicesStatus;
    private String result;
    private Map<String, Map<String, List<String>>> devices2Command2Result = new HashMap<String, Map<String, List<String>>>();
    private String userCommand;
    private Map<Long, String> cfcards;
    private Map<Long, String> cfcardResult;
    private int length;

    public String sendCommand() {
        ArrayList<CmdParam> cmdParams;
        Map<String, String> commands;
        if (null == this.collectModel) {
            this.logger.error((Object)"collectModel is null!");
            return "error";
        }
        User user = (User)this.getSession().getAttribute("currentUser");
        Set<AticDevice> sets = null;
        try {
            sets = this.devicesValidate();
        }
        catch (LegoCheckedException e) {
            this.writSyslog(false, user.getUserName(), "atic.bis.onekeyCollection.operation.download", "atic.bis.onekeyCollection.operation.download.success", "atic.bis.onekeyCollection.operation.download.failed");
            throw new LegoCheckedException(e.getErrorCode());
        }
        if (sets.size() == 0) {
            this.logger.error((Object)"devices is null!");
            this.writSyslog(false, user.getUserName(), "atic.bis.onekeyCollection.operation.download", "atic.bis.onekeyCollection.operation.download.success", "atic.bis.onekeyCollection.operation.download.failed");
            throw new LegoCheckedException(630153L);
        }
        String devicesx = this.devNames(sets);
        CollectParam cp = this.collectModel.getCollectParam().get("zoneConfig");
        if (null != cp) {
            String zoneName = this.collectModel.getCollectParam().get("zoneConfig").getZoneName();
            IZoneService zoneService = ZoneReferUtil.getZoneService();
            List<ZoneInfoForm> zoneInfos = zoneService.getZoneByNameOrDesc(zoneName, zoneName);
            if (zoneInfos.isEmpty()) {
                this.logger.error((Object)"zone is null!");
                this.writSyslog(false, devicesx, "atic.bis.onekeyCollection.operation.download", "atic.bis.onekeyCollection.operation.download.success", "atic.bis.onekeyCollection.operation.download.failed");
                throw new LegoCheckedException(630009L);
            }
            ZoneInfoForm info = zoneInfos.get(0);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(info.getMoId());
            BisUtil.checkUserSecurity(moIdList);
        }
        if ((commands = this.commandTranslate.doTranslate(this.collectModel, cmdParams = new ArrayList<CmdParam>())).size() == 0) {
            this.logger.error((Object)"commands size is 0!");
            this.writSyslog(false, devicesx, "atic.bis.onekeyCollection.operation.download", "atic.bis.onekeyCollection.operation.download.success", "atic.bis.onekeyCollection.operation.download.failed");
            return "error";
        }
        this.progressId = new Date().getTime();
        ProgressBar progressBar = ProgressMgr.getInstance().createProgressBar(commands.size() * sets.size() + 1, this.progressId);
        if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.COLLECT_DEVICE_INFO)) {
            this.logger.error((Object)"device info collect operate is executing!");
            throw new LegoCheckedException(570516L);
        }
        this.commandCollectPool.createThreadPool(progressBar, commands, sets, ServletActionContext.getServletContext().getRealPath("/"), ActionContext.getContext().getLocale(), 0);
        this.logger.info((Object)("device=[" + devicesx + "] commands=" + commands.toString()));
        String target = devicesx;
        this.writSyslog(true, target, "atic.bis.onekeyCollection.operation.download", "atic.bis.onekeyCollection.operation.download.success", "atic.bis.onekeyCollection.operation.download.failed");
        return "success";
    }

    private String devNames(Set<AticDevice> sets) {
        if (null == sets) {
            return "";
        }
        StringBuffer devicesx = new StringBuffer();
        for (AticDevice device : sets) {
            if (null == device) continue;
            devicesx.append(device.getName());
            devicesx.append(";");
        }
        String temp = devicesx.toString();
        temp = temp.endsWith(";") ? temp.substring(0, temp.length() - 1) : temp;
        return temp;
    }

    private Set<AticDevice> devicesValidate() {
        HashSet<AticDevice> sets = new HashSet<AticDevice>();
        if (this.collectModel.getDeviceId() != 0L) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(this.collectModel.getDeviceId());
            BisUtil.checkUserSecurity(moIdList);
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.collectModel.getDeviceId());
            if (null != aticDevice) {
                sets.add(aticDevice);
            }
        }
        if (this.collectModel.getDeviceId() == 0L) {
            User user = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
            List devicesl = this.aticDeviceService.getAntiDDoSDevice(user.getUserID());
            for (AticDevice aticDevice : devicesl) {
                sets.add(aticDevice);
            }
        }
        return sets;
    }

    public String fetchCollectProgress() {
        if (this.progressId == 0L) {
            return "error";
        }
        try {
            ProgressBar progressBar = ProgressMgr.getInstance().getProgressBar(this.progressId);
            if (null == progressBar) {
                this.logger.error((Object)"progressBar is null!");
                return "error";
            }
            this.progress = progressBar.getProgress();
            return "success";
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"fetchCollectProgress error!");
            return "error";
        }
        catch (Exception e) {
            this.logger.error((Object)"fetchCollectProgress error!");
            return "error";
        }
    }

    public String fetchIssuedStatus() {
        if (this.progressId == 0L) {
            return "error";
        }
        try {
            this.devicesStatus = IssuedCommandResults.getInstance().getIssuedResults().get(this.progressId);
            ProgressBar progressBar = ProgressMgr.getInstance().getProgressBar(this.progressId);
            if (null != progressBar) {
                this.result = progressBar.getCurrentTask();
                this.cfcards = IssuedCommandResults.getInstance().getCfcards().get(this.progressId);
                this.cfcardResult = IssuedCommandResults.getInstance().getCfcardResult().get(this.progressId);
            }
            return "success";
        }
        catch (Exception e) {
            this.logger.error((Object)("fetchIssuedStatus error!" + e.getMessage()));
            return "error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadCollectZip() {
        if (this.progressId == 0L) {
            this.logger.error((Object)"downloadCollectZip error cause of progressId is 0 !");
            return "error";
        }
        String path = ServletActionContext.getServletContext().getRealPath("/") + ConstantUtil.PACKAGE_DIR + this.progressId + File.separator + this.progressId + ".zip";
        try {
            Date date;
            File downloadFile = org.apache.commons.io.FileUtils.getFile((String[])new String[]{path});
            if (!downloadFile.exists()) {
                this.logger.error((Object)("download collect zip error cause of file : " + downloadFile.getName() + "not exists!"));
                String string = "error";
                return string;
            }
            if (!AticUtil.checkFileType((File)downloadFile, (String)"504B0304") && !AticUtil.checkFileType((File)downloadFile, (String)"504B0506")) {
                this.log.error((Object)"checkFile() file path is error file type!");
                String string = "error";
                return string;
            }
            String fileNameTime = "";
            if (this.progressId > 0L) {
                date = new Date(this.progressId);
                fileNameTime = this.format(date);
            } else {
                date = new Date();
                fileNameTime = this.format(date);
            }
            this.downLoadName = "output_" + fileNameTime + ".zip";
            byte[] tmp = FileUtils.copyFileDeleteSrc((String)path);
            this.inputStream = new ByteArrayInputStream(tmp);
        }
        catch (IOException e) {
            this.logger.error((Object)"download CollectZip error !");
        }
        finally {
            CommandCollectResult.getInstance().clear(this.progressId);
            AticUtil.deleteTempFile((String)path);
            this.del();
        }
        return "success";
    }

    private void del() {
        try {
            String contextPath = ServletActionContext.getServletContext().getRealPath("/");
            String cmdexport = contextPath + ConstantUtil.EXPORT_DIR + this.progressId;
            String ftpexport = contextPath + ConstantUtil.EXPORT_FTP_DIR + this.progressId;
            String packexport = contextPath + ConstantUtil.PACKAGE_DIR + this.progressId;
            FileUtils.deletEmptyFolders((File)new File(cmdexport));
            FileUtils.deletEmptyFolders((File)new File(ftpexport));
            FileUtils.deletEmptyFolders((File)new File(packexport));
        }
        catch (RuntimeException e) {
            this.logger.info((Object)"delete dir failed!");
        }
    }

    private String format(Date date) {
        String fileNameTime = new SimpleDateFormat("yyyyMMddHHmmssSS").format(date);
        return fileNameTime;
    }

    public String issuedCommand() {
        if (null == this.collectModel) {
            this.logger.error((Object)"action: issuedCommand collectModel is null!");
            return "error";
        }
        Set<AticDevice> sets = this.devicesValidate();
        if (sets.size() == 0) {
            this.logger.error((Object)"issued command device is null!");
            return "error";
        }
        this.progressId = new Date().getTime();
        try {
            ProgressMgr.getInstance().createProgressBar(EnumCommandOrder.values().length * sets.size() + 1, this.progressId);
            String target = this.generateLogTarget(sets);
            this.collectModel.setTarget(target);
            User user = (User)this.getSession().getAttribute("currentUser");
            this.collectModel.setUser(user);
            this.collectModel.setModule("lego.dic.module.onekeycollection");
            this.collectModel.setRemoteAddr(this.fetchRequest().getRemoteAddr());
            ConstantUtil.factoryInstance(this.progressId, sets, this.collectModel, ActionContext.getContext().getLocale(), 0, EnumCommandOrder.values().length, EnumCommandOrder.COMMAND_ACL_ISSUED_COMMAND.getIndex(), ServletActionContext.getServletContext().getRealPath("/"));
            return "success";
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"issued command error!");
            this.writSyslog(false, this.generateLogTarget(sets), "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
            return "error";
        }
        catch (Exception e) {
            this.logger.error((Object)"issued command error!");
            this.writSyslog(false, this.generateLogTarget(sets), "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
            return "error";
        }
    }

    private String generateLogTarget(Set<AticDevice> sets) {
        StringBuffer commands = new StringBuffer();
        for (EnumCommandOrder command : EnumCommandOrder.values()) {
            CollectParam collectParam;
            if (null == command || null == command.getCommand() || null == (collectParam = this.collectModel.getCollectParam().get(EnumCommandOrder.COMMAND_ACL_ISSUED_COMMAND.getIndex()))) continue;
            String cmdLog = this.translateCmd(collectParam, command);
            commands.append(cmdLog);
            commands.append(";");
        }
        String cmd = commands.toString();
        cmd = cmd.length() > 0 && cmd.endsWith(";") ? cmd.substring(0, cmd.length() - 1) : cmd;
        String devicesx = this.devNames(sets);
        this.logger.info((Object)("device=[" + devicesx + "] commands=" + cmd));
        return devicesx;
    }

    private String translateCmd(CollectParam collectParam, EnumCommandOrder each) {
        String sourceIp = null == collectParam || null == collectParam.getSourceIp() ? "" : collectParam.getSourceIp();
        String destIp = null == collectParam || null == collectParam.getDestIp() ? "" : collectParam.getDestIp();
        String type = "";
        String mask = "0";
        if (IPUtil.isIpv6((String)sourceIp) || IPUtil.isIpv6((String)destIp)) {
            type = "ipv6";
            mask = "1";
        }
        String cmd = each.getCommand();
        if (each == EnumCommandOrder.COMMAND_RULE && null != collectParam) {
            cmd = String.format(cmd, ConstantUtil.placeholder(collectParam.getSourceIp()), mask, ConstantUtil.placeholder(collectParam.getDestIp()), mask);
            cmd = ConstantUtil.re(ConstantUtil.cut(cmd));
        }
        if (each == EnumCommandOrder.COMMAND_ACL_NUM) {
            cmd = String.format(cmd, type, 3998);
        }
        if (each == EnumCommandOrder.COMMAND_ACL_ISSUED_COMMAND) {
            cmd = String.format(cmd, 3998);
        }
        this.logger.info((Object)("EnumCommandOrder --- cmd : " + cmd));
        return cmd;
    }

    public String fetchDevices() {
        if (null == this.devices) {
            this.devices = new ArrayList<AticDevice>();
        }
        User user = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        List des = this.aticDeviceService.getAntiDDoSDevice(user.getUserID());
        this.devices.addAll(des);
        return "success";
    }

    public boolean validateSourceIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("interfaceAcceleration")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("interfaceAcceleration").getSourceIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateDestIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("interfaceAcceleration")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("interfaceAcceleration").getDestIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateTableResourcesSourceIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("tableResources")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("tableResources").getSourceIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateTableResourcesDestIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("tableResources")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("tableResources").getDestIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateDestIPMonitoringSourceIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("destIPMonitoring")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("destIPMonitoring").getSourceIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateDestIPMonitoringDestIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("destIPMonitoring")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("destIPMonitoring").getDestIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateSourceIPMonitoringSourceIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("sourceIPMonitoring")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("sourceIPMonitoring").getSourceIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateSourceIPMonitoringDestIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("sourceIPMonitoring")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("sourceIPMonitoring").getDestIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateTcpSessionSourceIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("tcpSession")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("tcpSession").getSourceIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateTcpSessionDestIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("tcpSession")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("tcpSession").getDestIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateUdpSessionSourceIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("udpSession")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("udpSession").getSourceIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateUdpSessionDestIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("udpSession")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("udpSession").getDestIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateDynamicBlacklistSourceIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("dynamicBlacklist")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("dynamicBlacklist").getSourceIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateDynamicBlacklistDestIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("dynamicBlacklist")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("dynamicBlacklist").getDestIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateZoneConfigSourceIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("zoneConfig")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("zoneConfig").getSourceIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateZoneConfigDestIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("zoneConfig")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("zoneConfig").getDestIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateAclSourceIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("acl")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("acl").getSourceIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateAclDestIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("acl")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("acl").getDestIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        return IPUtil.isIpv4((String)ipTemp.trim()) || IPUtil.isIpv6((String)ipTemp.trim());
    }

    public boolean validateAclIssuedCommandSourceIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("aclIssuedCommand")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("aclIssuedCommand").getSourceIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        if (IPUtil.isIpv4((String)ipTemp.trim()) && AticUtil.validateIpv4((String)ipTemp.trim())) {
            return true;
        }
        if (IPUtil.isIpv6((String)ipTemp.trim())) {
            String ipTempIpv6 = IPUtil4Atic.convert2CompleteIpV6((String)ipTemp.trim());
            return !ipTempIpv6.equals(this.getText("atic.all.zero.ipv6"));
        }
        return false;
    }

    public boolean validateAclIssuedCommandDestIp() {
        if (null == this.collectModel) {
            return true;
        }
        if (null == this.collectModel.getCollectParam()) {
            return true;
        }
        if (null == this.collectModel.getCollectParam().get("aclIssuedCommand")) {
            return true;
        }
        String ipTemp = this.collectModel.getCollectParam().get("aclIssuedCommand").getDestIp();
        if (null == ipTemp || "".equals(ipTemp)) {
            return true;
        }
        if (IPUtil.isIpv4((String)ipTemp.trim()) && AticUtil.validateIpv4((String)ipTemp.trim())) {
            return true;
        }
        if (IPUtil.isIpv6((String)ipTemp.trim())) {
            String ipTempIpv6 = IPUtil4Atic.convert2CompleteIpV6((String)ipTemp.trim());
            return !ipTempIpv6.equals(this.getText("atic.all.zero.ipv6"));
        }
        return false;
    }

    public boolean validateProgresId() {
        long id = 0L;
        try {
            id = this.progressId;
        }
        catch (NumberFormatException e) {
            return false;
        }
        return id >= 1L;
    }

    public boolean validateParam4UserCommand() {
        if (StringUtils.isBlank((CharSequence)this.userCommand) || this.userCommand.length() > 500) {
            return false;
        }
        String regex = "^[\\w\\s|\\-|/|!|@|#|$|^|:|,|+|=|?|\\[|\\]|*|;|.||]*$";
        return this.userCommand.matches(regex);
    }

    public String sendUserCommand() {
        String devicesx;
        if (null == this.collectModel) {
            this.logger.error((Object)"collectModel is null!");
            return "error";
        }
        User user = (User)this.getSession().getAttribute("currentUser");
        Set<AticDevice> sets = null;
        try {
            sets = this.devicesValidate();
        }
        catch (LegoCheckedException e) {
            this.writSyslog(false, user.getUserName(), "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
            return "error";
        }
        String target = devicesx = this.devNames(sets);
        if (sets.size() == 0) {
            this.logger.error((Object)"devices is null!");
            this.writSyslog(false, target, "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
            return "error";
        }
        if (null == this.userCommand) {
            this.logger.error((Object)"user command is null!");
            this.writSyslog(false, target, "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
            return "error";
        }
        String[] cmds = this.userCommand.split(";");
        LinkedHashMap<String, String> commands = new LinkedHashMap<String, String>();
        int index = 1;
        for (String cmd : cmds) {
            if (null == cmd || cmd.trim().isEmpty()) continue;
            commands.put(index + cmd.replace(" ", "_"), AticUtil.htmlEncode((String)cmd));
            ++index;
        }
        if (commands.size() == 0) {
            this.logger.error((Object)"command size is 0!");
            this.writSyslog(false, target, "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
            return "error";
        }
        if (commands.size() > 5) {
            this.length = commands.size();
            this.logger.error((Object)"command size is > 5!");
            this.writSyslog(false, target, "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
            return "error";
        }
        try {
            this.progressId = new Date().getTime();
            ProgressBar progressBar = ProgressMgr.getInstance().createProgressBar(commands.size() * sets.size() + 1, this.progressId);
            this.commandCollectPool.createThreadPool(progressBar, commands, sets, ServletActionContext.getServletContext().getRealPath("/"), ActionContext.getContext().getLocale(), 1);
            this.writSyslog(true, target, "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
            return "success";
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"send user command error!");
            this.writSyslog(false, target, "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
            return "error";
        }
        catch (Exception e) {
            this.logger.error((Object)"send user command error!");
            this.writSyslog(false, target, "atic.bis.onekeyCollection.operation.run", "atic.bis.onekeyCollection.operation.run.success", "atic.bis.onekeyCollection.operation.run.failed");
            return "error";
        }
    }

    public String readCommandResult() {
        if (this.progressId == 0L) {
            return "error";
        }
        this.devices2Command2Result = CommandCollectResult.getInstance().getCollect4DeviceResult().get(this.progressId);
        if (null == this.devices2Command2Result) {
            return "success";
        }
        CommandCollectResult.getInstance().clear(this.progressId);
        return "success";
    }

    public String sendCommand4Log() {
        if (null == this.collectModel) {
            this.logger.error((Object)"collectModel is null!");
            return "error";
        }
        Set<AticDevice> sets = this.devicesValidate();
        if (sets.size() == 0) {
            this.logger.error((Object)"devices is null!");
            return "error";
        }
        if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.COLLECT_DEVICE_LOG)) {
            this.logger.error((Object)"device log collect operate is executing!");
            throw new LegoCheckedException(570516L);
        }
        this.progressId = new Date().getTime();
        this.collectModel.setWebPath(ServletActionContext.getServletContext().getRealPath("/"));
        User user = (User)this.getSession().getAttribute("currentUser");
        this.collectModel.setUser(user);
        this.collectModel.setModule("lego.dic.module.onekeycollection");
        this.collectModel.setRemoteAddr(this.fetchRequest().getRemoteAddr());
        this.collectModel.setAticDeviceSet(sets);
        ProgressMgr.getInstance().createProgressBar(EnumFileCommandOrder.values().length * sets.size() + 1, this.progressId);
        ConstantUtil.factoryInstance(this.progressId, sets, this.collectModel, ActionContext.getContext().getLocale(), 1, EnumFileCommandOrder.values().length, "log", ServletActionContext.getServletContext().getRealPath("/"));
        return "success";
    }

    private void writSyslog(boolean isSucc, String target, String operation, String success, String failed) {
        if (null == target) {
            target = "";
        }
        if (target.length() >= 255) {
            target = target.substring(0, 250);
        }
        SysOptLog sysOptLog = new SysOptLog();
        sysOptLog.setOperation(operation);
        sysOptLog.setModule("lego.dic.module.onekeycollection");
        sysOptLog.setLevel(SysoplogLevel.normal.getValue());
        sysOptLog.setTarget(target);
        if (isSucc) {
            sysOptLog.setResult(1);
            sysOptLog.setDetail(success);
            sysOptLog.setDetailPara(new String[0]);
        } else {
            sysOptLog.setResult(0);
            sysOptLog.setDetail(failed);
            sysOptLog.setDetailPara(new String[0]);
        }
        User user = (User)this.getSession().getAttribute("currentUser");
        sysOptLog.setOperator(user.getUserName());
        sysOptLog.setTerminalIp(this.fetchRequest().getRemoteAddr());
        sysOptLog.setDate(new Date());
        ISysOptLog service = ZoneReferUtil.getSysOptLog();
        service.writeOptLog(sysOptLog);
    }

    public CollectModel getCollectModel() {
        return this.collectModel;
    }

    public void setCollectModel(CollectModel collectModel) {
        this.collectModel = collectModel;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getDownLoadName() {
        return this.downLoadName;
    }

    public void setDownLoadName(String downLoadName) {
        this.downLoadName = downLoadName;
    }

    public long getProgressId() {
        return this.progressId;
    }

    public void setProgressId(long progressId) {
        this.progressId = progressId;
    }

    public Map<Long, Boolean> getDevicesStatus() {
        return this.devicesStatus;
    }

    public void setDevicesStatus(Map<Long, Boolean> devicesStatus) {
        this.devicesStatus = devicesStatus;
    }

    public List<AticDevice> getDevices() {
        return this.devices;
    }

    public void setDevices(List<AticDevice> devices) {
        this.devices = devices;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getUserCommand() {
        return this.userCommand;
    }

    public void setUserCommand(String userCommand) {
        this.userCommand = userCommand;
    }

    public Map<String, Map<String, List<String>>> getDevices2Command2Result() {
        return this.devices2Command2Result;
    }

    public void setDevices2Command2Result(Map<String, Map<String, List<String>>> devices2Command2Result) {
        this.devices2Command2Result = devices2Command2Result;
    }

    public Map<Long, String> getCfcards() {
        return this.cfcards;
    }

    public void setCfcards(Map<Long, String> cfcards) {
        this.cfcards = cfcards;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Map<Long, String> getCfcardResult() {
        return this.cfcardResult;
    }

    public void setCfcardResult(Map<Long, String> cfcardResult) {
        this.cfcardResult = cfcardResult;
    }
}

