/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service;

import com.hs.atic.collect.service.CommandCollectResult;
import com.hs.atic.collect.service.ZipCommandResult;
import com.hs.atic.collect.util.ConstantUtil;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.atic.util.FileUtils;
import com.hs.atic.util.LocalizedTextUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import com.hs.lego.ui.plat.common.util.OperateLocker;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.service.impl.AticDeviceServiceImpl;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.south.model.TelnetPara;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipOutputStream;
import org.springframework.stereotype.Service;

@Service
public class CommandCollectPool {
    private static final int SO_TIME = 150;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public void createThreadPool(final ProgressBar progressBar, final Map<String, String> commands, Set<AticDevice> devices, final String webPath, final Locale locale, final int type) {
        this.logger.info((Object)"create all devices Thread pool 4 progress!");
        ThreadPoolExecutor allDeviceThreadPool = new ThreadPoolExecutor(5, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        final CountDownLatch startEachDevice = new CountDownLatch(1);
        final CountDownLatch endAllDevice = new CountDownLatch(devices.size());
        ArrayList<Future<String>> allDeviceResults = new ArrayList<Future<String>>();
        Future<String> eachDeviceResult = null;
        for (final AticDevice aticDevice : devices) {
            eachDeviceResult = allDeviceThreadPool.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return CommandCollectPool.this.eachDevicePoll(startEachDevice, endAllDevice, progressBar, commands, webPath, aticDevice, locale, type);
                }
            });
            allDeviceResults.add(eachDeviceResult);
        }
        CommandResultThread commandResultThread = new CommandResultThread(startEachDevice, endAllDevice, allDeviceThreadPool, allDeviceResults, progressBar, webPath, type);
        commandResultThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
        commandResultThread.start();
    }

    private void execReturn(ExcmdConnectUtil excmdConnectUtil) {
        List<String> ret = null;
        try {
            ret = CmdUtil.execCmds4OneKeyCollect(excmdConnectUtil, Arrays.asList("return"), true, 150, false);
            this.logger.info(ret);
        }
        catch (RuntimeException e) {
            try {
                ret = CmdUtil.execCmds4OneKeyCollect(excmdConnectUtil, Arrays.asList("return"), true, 150, false);
            }
            catch (Exception ex) {
                this.logger.error((Object)("exec return error : " + ex.getMessage()));
            }
            this.logger.error((Object)("exec return error : " + (null == ret ? "--" : "..")));
        }
        catch (Exception e) {
            try {
                ret = CmdUtil.execCmds4OneKeyCollect(excmdConnectUtil, Arrays.asList("return"), true, 150, false);
            }
            catch (Exception ex) {
                this.logger.error((Object)("exec return error : " + ex.getMessage()));
            }
            this.logger.error((Object)("exec return error : " + (null == ret ? "--" : "..")));
        }
        try {
            CmdUtil.execCmds4OneKeyCollect(excmdConnectUtil, new ArrayList<String>(), false, 150, false);
        }
        catch (Exception ex) {
            this.logger.error((Object)("exec return error : " + ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String eachDevicePoll(CountDownLatch startEachDevice, CountDownLatch endAllDevice, ProgressBar progressBar, Map<String, String> commands, String webPath, AticDevice aticDevice, Locale locale, int type) {
        try {
            startEachDevice.await();
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e.getMessage());
        }
        this.logger.info((Object)("===============start eachDevicePoll! " + aticDevice.getName()));
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(1, 20, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(commands.size());
        ArrayList<Future<String>> results = new ArrayList<Future<String>>();
        ExcmdConnectUtil excmdConnectUtil = null;
        if (type == 1) {
            AticDeviceServiceImpl aticDeviceService = (AticDeviceServiceImpl)ServiceContext.getInstance().getService("aticDeviceService", AticDeviceServiceImpl.class);
            TelnetPara telnetPara = aticDeviceService.getDeviceTelnetPara(aticDevice.getMoId());
            excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
            this.execReturn(excmdConnectUtil);
        }
        for (Map.Entry entry : commands.entrySet()) {
            Future<String> future = threadPool.submit(new EachCommandThread(progressBar, start, end, (String)entry.getKey(), (String)entry.getValue(), aticDevice, webPath, locale, type, excmdConnectUtil));
            results.add(future);
        }
        try {
            start.countDown();
            end.await();
            threadPool.shutdown();
            for (Future future : results) {
                try {
                    String res = (String)future.get();
                    this.logger.info((Object)("each device : " + aticDevice.getName() + " command exec result :" + res));
                }
                catch (ExecutionException e) {
                    this.logger.error((Object)"results");
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)e.getMessage());
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"start eachDevicePoll error!");
        }
        finally {
            if (type == 1) {
                try {
                    CmdUtil.execCmds4OneKeyCollect(excmdConnectUtil, new ArrayList<String>(), false, 150, true);
                }
                catch (Exception ex) {
                    this.logger.error((Object)("exec return error : " + ex.getMessage()));
                }
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
            }
            this.logger.info((Object)("================end eachDevicePoll! " + aticDevice.getName()));
            endAllDevice.countDown();
        }
        return "success";
    }

    static class CommandResultThread
    extends Thread {
        private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
        private CountDownLatch start;
        private CountDownLatch end;
        private ThreadPoolExecutor threadPool;
        private List<Future<String>> results;
        private ProgressBar progressBar;
        private String webPath;
        private int type;

        public CommandResultThread(CountDownLatch start, CountDownLatch end, ThreadPoolExecutor threadPool, List<Future<String>> results, ProgressBar progressBar, String webPath, int type) {
            this.start = start;
            this.end = end;
            this.threadPool = threadPool;
            this.results = results;
            this.progressBar = progressBar;
            this.webPath = webPath;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block38: {
                this.logger.info((Object)"start execut each device thread");
                try {
                    this.start.countDown();
                    this.end.await();
                    this.threadPool.shutdown();
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)"start all device thread pool error");
                }
                inFileDir = null;
                outFile = null;
                try {
                    if (this.progressBar.isCancled()) {
                        this.progressBar.setCurrentTask("zip opt is calceled!");
                        this.logger.info((Object)("CommandResultThread id in canceled branch:" + this.progressBar.getProgressBarID() + ":info:" + this.progressBar.toString()));
                        return;
                    }
                    for (Future<String> ret : this.results) {
                        try {
                            res = ret.get();
                            this.logger.info((Object)("each device collect result :" + res));
                        }
                        catch (ExecutionException e) {
                            this.logger.error((Object)"results");
                        }
                        catch (InterruptedException e) {
                            this.logger.error((Object)"results");
                        }
                    }
                    this.logger.info((Object)"package start!");
                    progressId = this.progressBar.getProgressBarID();
                    inFileDir = new File(this.webPath + ConstantUtil.EXPORT_DIR + progressId);
                    outFile = new File(this.webPath + ConstantUtil.PACKAGE_DIR + progressId + File.separator + progressId + ".zip");
                    fos = null;
                    try {
                        fos = new FileOutputStream(outFile);
                    }
                    catch (FileNotFoundException e1) {
                        this.logger.error((Object)"run() fileNotFoundException");
                    }
                    zos = new ZipOutputStream(fos);
                    zos.setComment("zip collect file");
                    try {
                        date = new Date(progressId);
                        dirName = new SimpleDateFormat("yyyyMMddHHmmssSS").format(date);
                        ZipCommandResult.zipFile(inFileDir, zos, "", dirName);
                    }
                    catch (RuntimeException e) {
                        this.logger.error((Object)("zipFile " + inFileDir.getName() + "error"));
                    }
                    finally {
                        try {
                            zos.close();
                            if (null != fos) {
                                fos.close();
                            }
                        }
                        catch (IOException e) {
                            this.logger.error((Object)"close stream error");
                        }
                    }
                    this.progressBar.setCurrentTask("zip opt over!");
                    ** try [egrp 11[TRYBLOCK] [12 : 610->618)] { 
                }
                catch (RuntimeException e) {
                    this.progressBar.setCurrentTask("zip opt error!");
                    break block38;
                }
                finally {
                    try {
                        FileUtils.deleteDirectory(inFileDir, outFile);
                    }
                    catch (IOException e) {
                        this.logger.error((Object)"inFileDir deleteDirectory error!");
                    }
                    this.progressBar.next();
                    if (this.type == 0) {
                        OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.COLLECT_DEVICE_INFO);
                    }
                }
lbl-1000:
                // 1 sources

                {
                    FileUtils.deleteDirectory((File)inFileDir, (File)outFile);
                }
lbl61:
                // 1 sources

                catch (IOException e) {
                    this.logger.error((Object)"inFileDir deleteDirectory error!");
                }
                this.progressBar.next();
                if (this.type == 0) {
                    OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.COLLECT_DEVICE_INFO);
                }
            }
        }
    }

    static class EachCommandThread
    implements Callable<String> {
        private static final String CMD_SPECIAL = "aaaaaaaaaaaaaa";
        private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
        private ProgressBar progressBar;
        private String command;
        private AticDevice aticDevice;
        private CountDownLatch start;
        private CountDownLatch end;
        private String commandName;
        private String webPath;
        private Locale locale;
        private int type;
        private ExcmdConnectUtil excmdConnectUtil = null;

        public EachCommandThread(ProgressBar progressBar, CountDownLatch start, CountDownLatch end, String commandName, String command, AticDevice aticDevice, String webPath, Locale locale, int type, ExcmdConnectUtil excmdConnectUtil) {
            this.progressBar = progressBar;
            this.start = start;
            this.end = end;
            this.command = command;
            this.aticDevice = aticDevice;
            this.commandName = commandName;
            this.webPath = webPath;
            this.locale = locale;
            this.type = type;
            this.excmdConnectUtil = excmdConnectUtil;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() {
            try {
                this.start.await();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("call thread await error in device " + this.aticDevice.getName() + "!"));
                this.progressBar.setCurrentTask("call thread await error in device " + this.aticDevice.getName() + "!");
                this.end.countDown();
                this.progressBar.next();
                return e.getMessage();
            }
            long startTime = System.currentTimeMillis();
            try {
                if (this.progressBar.isCancled()) {
                    this.logger.info((Object)("progress id in canceled branch:" + this.progressBar.getProgressBarID() + ":info:" + this.progressBar.toString()));
                    this.progressBar.setCurrentTask("in device " + this.aticDevice.getName() + " exec calceled!");
                    String string = "cancled";
                    return string;
                }
                this.logger.info((Object)("command :  in device " + this.aticDevice.getName() + " call start"));
                boolean isReturn = false;
                int soTimeout = 0;
                if (this.type == 0) {
                    AticDeviceServiceImpl aticDeviceService = (AticDeviceServiceImpl)ServiceContext.getInstance().getService("aticDeviceService", AticDeviceServiceImpl.class);
                    TelnetPara telnetPara = aticDeviceService.getDeviceTelnetPara(this.aticDevice.getMoId());
                    this.excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                    this.execReturn();
                    isReturn = true;
                    soTimeout = 150;
                }
                if (this.type == 1) {
                    try {
                        CmdUtil.execCmds4OneKeyCollect(this.excmdConnectUtil, Collections.singletonList(CMD_SPECIAL), isReturn, soTimeout, false);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e.getMessage());
                    }
                }
                List<String> result = CmdUtil.execCmds4OneKeyCollect(this.excmdConnectUtil, Collections.singletonList(this.command), isReturn, soTimeout, false);
                if (this.commandName.equals("tcpSession")) {
                    this.top50(result);
                }
                if (this.commandName.equals("udpSession")) {
                    this.top50(result);
                }
                if (this.commandName.equals("tcpSession_ipv6")) {
                    this.top50(result);
                }
                if (this.commandName.equals("udpSession_ipv6")) {
                    this.top50(result);
                }
                if (this.type == 0) {
                    ZipCommandResult.fillResultToFile(result, this.commandName, this.webPath, this.progressBar.getProgressBarID(), this.aticDevice);
                }
                CommandCollectResult.getInstance().putData(this.progressBar.getProgressBarID(), this.aticDevice.getName(), this.commandName, result);
                String string = "success";
                return string;
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)("command :  in device " + this.aticDevice.getName() + " get result error : " + LocalizedTextUtil.findDefaultText((String)("lego.err." + e.getErrorCode() + ""), (Locale)this.locale)));
                this.progressBar.setCurrentTask("in device " + this.aticDevice.getName() + " exec error : " + LocalizedTextUtil.findDefaultText((String)("lego.err." + e.getErrorCode() + ""), (Locale)this.locale));
                if (this.type == 0) {
                    ZipCommandResult.fillResultToFile(Collections.singletonList(LocalizedTextUtil.findDefaultText((String)("lego.err." + e.getErrorCode() + ""), (Locale)this.locale)), this.commandName, this.webPath, this.progressBar.getProgressBarID(), this.aticDevice);
                }
                CommandCollectResult.getInstance().putData(this.progressBar.getProgressBarID(), this.aticDevice.getName(), this.commandName, Collections.singletonList(LocalizedTextUtil.findDefaultText((String)("lego.err." + e.getErrorCode() + ""), (Locale)this.locale)));
                String string = LocalizedTextUtil.findDefaultText((String)("lego.err." + e.getErrorCode() + ""), (Locale)this.locale);
                return string;
            }
            finally {
                if (this.type == 0) {
                    try {
                        CmdUtil.execCmds4OneKeyCollect(this.excmdConnectUtil, new ArrayList<String>(), false, 150, true);
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)"CmdUtil.execCmds4OneKeyCollect error");
                    }
                    ExcmdConnectionPool.getInstance().excmdConnectionRelease(this.aticDevice.getMoId(), this.excmdConnectUtil);
                }
                long endTime = System.currentTimeMillis();
                this.end.countDown();
                this.logger.info((Object)("command run time : " + (endTime - startTime) + ""));
                this.progressBar.next();
            }
        }

        private void top50(List<String> result) {
            if (null == result || result.size() <= 0) {
                return;
            }
            String[] ary = result.get(0).split("\r\n");
            if (ary.length <= 0) {
                return;
            }
            int blanks = 0;
            result.clear();
            for (String string : ary) {
                if (blanks >= 50) break;
                if (null != string && string.trim().equals("")) {
                    ++blanks;
                }
                result.add(string + "\r\n");
            }
        }

        private void execReturn() {
            List<String> ret = null;
            try {
                ret = CmdUtil.execCmds4OneKeyCollect(this.excmdConnectUtil, Arrays.asList("return"), true, 0, false);
                this.logger.info(ret);
            }
            catch (RuntimeException e) {
                try {
                    ret = CmdUtil.execCmds4OneKeyCollect(this.excmdConnectUtil, Arrays.asList("return"), true, 0, false);
                }
                catch (Exception ex) {
                    this.logger.error((Object)("exec return error : " + ex.getMessage()));
                }
                this.logger.error((Object)("exec return error : " + (null == ret ? "--" : ret)));
            }
        }
    }
}

