/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service;

import com.hs.atic.collect.Model.CollectModel;
import com.hs.atic.collect.Model.CollectParam;
import com.hs.atic.collect.service.IEnumCommand;
import com.hs.atic.collect.service.IIssuedCommandResultAnalyze;
import com.hs.atic.collect.service.IssuedCommandExec;
import com.hs.atic.collect.service.IssuedCommandResults;
import com.hs.atic.collect.util.ConstantUtil;
import com.hs.atic.util.LocalizedTextUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.common.util.ProgressMgr;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.service.impl.AticDeviceServiceImpl;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.south.model.TelnetPara;
import java.util.List;
import java.util.Locale;

public abstract class IssuedCommandStep<T extends IIssuedCommandResultAnalyze> {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    protected ExcmdConnectUtil excmdConnectUtil;
    private IssuedCommandStep<T> nextStep;
    private IEnumCommand command;
    private T analyse;
    private List<String> results = null;
    private long progressId;
    private long deviceId;
    private CollectModel collectModel;
    private String execRet;
    private AticDevice aticDevice;
    private AticDeviceServiceImpl aticDeviceService;
    private Locale locale;
    private int step = 0;
    private String lastResult;
    private int commandLenth;
    private String paramKey;

    public IssuedCommandStep(IssuedCommandStep<T> nextStep, T analyse, long progressId, IEnumCommand command, long deviceId, int commandLenth, String paramKey) {
        this.nextStep = nextStep;
        this.analyse = analyse;
        this.progressId = progressId;
        this.command = command;
        this.deviceId = deviceId;
        this.commandLenth = commandLenth;
        this.paramKey = paramKey;
    }

    public void execute() {
        String result = "";
        this.instanceDeviceInfo();
        try {
            this.execStep(this);
            result = this.analyse.analyze(this.getResults());
            this.setExecRet(result);
        }
        catch (Exception e) {
            this.progressInfo(this.getInfo("atic.cbb.policy.collect.error") + "$$");
            this.end();
            IssuedCommandResults.getInstance().putStatus(this.progressId, this.deviceId, false);
            IssuedCommandResults.getInstance().putLocalKey(this.progressId, this.deviceId, "error", this.generateCmd()[0], this.generateCmd()[1]);
            this.disconnect();
            return;
        }
        if (result.contains("lego.err.")) {
            logger.info((Object)(this.command.getCommand() + " command execute failed reason : " + LocalizedTextUtil.findDefaultText((String)result, (Locale)this.locale)));
            this.progressInfo("[" + this.aticDevice.getName() + "]" + LocalizedTextUtil.findDefaultText((String)result, (Locale)this.locale) + "$$");
            this.end();
            IssuedCommandResults.getInstance().putStatus(this.progressId, this.deviceId, false);
            IssuedCommandResults.getInstance().putLocalKey(this.progressId, this.deviceId, result, this.generateCmd()[0], this.generateCmd()[1]);
            this.disconnect();
            return;
        }
        if (result.equals("unsupport")) {
            logger.info((Object)(this.command.getCommand() + " command execute failed reason : " + (null != this.results ? this.results.toString() : "")));
            this.progressInfo(this.getInfo("atic.cbb.policy.collect.unsupport") + "$$");
            this.end();
            IssuedCommandResults.getInstance().putStatus(this.progressId, this.deviceId, false);
            IssuedCommandResults.getInstance().putLocalKey(this.progressId, this.deviceId, "unsupport", this.generateCmd()[0], this.generateCmd()[1]);
            this.disconnect();
            return;
        }
        if (result.toLowerCase(Locale.getDefault()).contains("error")) {
            logger.error((Object)(this.command.getCommand() + " command execute failed reason : " + (null != this.results ? this.results.toString() : "")));
            this.progressInfo(this.getInfo("atic.cbb.policy.collect.error") + "$$");
            this.end();
            IssuedCommandResults.getInstance().putStatus(this.progressId, this.deviceId, false);
            IssuedCommandResults.getInstance().putLocalKey(this.progressId, this.deviceId, "error", this.generateCmd()[0], this.generateCmd()[1]);
            this.disconnect();
            return;
        }
        if (result.equals("wrong")) {
            logger.error((Object)(this.command.getCommand() + " command execute failed reason : " + (null != this.results ? this.results.toString() : "")));
            this.progressInfo(this.getInfo("atic.cbb.policy.collect.wrong") + "$$");
            this.end();
            IssuedCommandResults.getInstance().putStatus(this.progressId, this.deviceId, false);
            IssuedCommandResults.getInstance().putLocalKey(this.progressId, this.deviceId, "wrong", this.generateCmd()[0], this.generateCmd()[1]);
            this.disconnect();
            return;
        }
        ++this.step;
        if (null == this.nextStep && this.step == this.commandLenth) {
            IssuedCommandResults.getInstance().putStatus(this.progressId, this.deviceId, true);
            IssuedCommandResults.getInstance().putLocalKey(this.progressId, this.deviceId, result, this.generateCmd()[0], this.generateCmd()[1]);
            this.disconnect();
            this.next();
            return;
        }
        logger.info((Object)("step : [" + this.step + "] device : [" + this.aticDevice.getName() + "] command : [" + this.command + "]"));
        if (null != this.nextStep) {
            this.nextStep.setCollectModel(this.getCollectModel());
            this.nextStep.aticDevice = this.aticDevice;
            this.nextStep.excmdConnectUtil = this.excmdConnectUtil;
            this.nextStep.setLocale(this.locale);
            this.nextStep.setStep(this.step);
            this.nextStep.setLastResult(result);
            this.next();
            this.nextStep.execute();
        }
    }

    private void disconnect() {
        ExcmdConnectionPool.getInstance().excmdConnectionRelease(this.deviceId, this.excmdConnectUtil);
    }

    private void instanceDeviceInfo() {
        if (null == this.aticDeviceService) {
            this.aticDeviceService = (AticDeviceServiceImpl)ServiceContext.getInstance().getService("aticDeviceService", AticDeviceServiceImpl.class);
        }
        if (null == this.aticDevice) {
            this.aticDevice = this.aticDeviceService.getDeviceByMoid(this.deviceId);
        }
        if (null == this.excmdConnectUtil) {
            TelnetPara telPara = this.aticDeviceService.getDeviceTelnetPara(this.deviceId);
            this.excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telPara);
        }
    }

    private String getInfo(String key) {
        if (null == this.collectModel || null == this.collectModel.getCollectParam() || null == this.collectModel.getCollectParam().get(this.paramKey)) {
            logger.error((Object)(null != this.aticDevice && null != this.aticDevice.getName() ? this.aticDevice.getName() : " command exec error cause of collectModel is null"));
            return String.format(LocalizedTextUtil.findDefaultText((String)key, (Locale)this.locale), null != this.aticDevice && null != this.aticDevice.getName() ? this.aticDevice.getName() : "", this.getCommand());
        }
        return String.format(LocalizedTextUtil.findDefaultText((String)key, (Locale)this.locale), null != this.aticDevice && null != this.aticDevice.getName() ? this.aticDevice.getName() : "", ConstantUtil.translateCmd(this.collectModel.getCollectParam().get(this.paramKey), this.getCommand()));
    }

    private String[] generateCmd() {
        CollectParam collectParam = new CollectParam();
        collectParam.setDestIp("");
        collectParam.setSourceIp("");
        collectParam.setZoneName("");
        collectParam.setIpTypeStr("");
        return new String[]{null != this.aticDevice && null != this.aticDevice.getName() ? this.aticDevice.getName() : "", ConstantUtil.translateCmd(null != this.collectModel && null != this.collectModel.getCollectParam() && null != this.collectModel.getCollectParam().get(this.paramKey) ? this.collectModel.getCollectParam().get(this.paramKey) : collectParam, this.getCommand())};
    }

    private void end() {
        ProgressMgr.getInstance().getProgressBar(this.progressId).next(this.commandLenth - this.step);
    }

    private void next() {
        ProgressMgr.getInstance().getProgressBar(this.progressId).next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void progressInfo(String info) {
        Class<IssuedCommandExec> clazz = IssuedCommandExec.class;
        synchronized (IssuedCommandExec.class) {
            String current = ProgressMgr.getInstance().getProgressBar(this.progressId).getCurrentTask();
            if (null == current) {
                current = "";
            }
            current = current + info;
            ProgressMgr.getInstance().getProgressBar(this.progressId).setCurrentTask(current);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected abstract void execStep(IssuedCommandStep<T> var1) throws Exception;

    public T getAnalyse() {
        return this.analyse;
    }

    public void setAnalyse(T analyse) {
        this.analyse = analyse;
    }

    public IssuedCommandStep<T> getNextStep() {
        return this.nextStep;
    }

    public void setNextStep(IssuedCommandStep<T> nextStep) {
        this.nextStep = nextStep;
    }

    public IEnumCommand getCommand() {
        return this.command;
    }

    public void setCommand(IEnumCommand command) {
        this.command = command;
    }

    public List<String> getResults() {
        return this.results;
    }

    public void setResults(List<String> results) {
        this.results = results;
    }

    public long getProgressId() {
        return this.progressId;
    }

    public void setProgressId(long progressId) {
        this.progressId = progressId;
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    public CollectModel getCollectModel() {
        return this.collectModel;
    }

    public void setCollectModel(CollectModel collectModel) {
        this.collectModel = collectModel;
    }

    public String getExecRet() {
        return this.execRet;
    }

    public void setExecRet(String execRet) {
        this.execRet = execRet;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public String getLastResult() {
        return this.lastResult;
    }

    public void setLastResult(String lastResult) {
        this.lastResult = lastResult;
    }

    public int getCommandLenth() {
        return this.commandLenth;
    }

    public void setCommandLenth(int commandLenth) {
        this.commandLenth = commandLenth;
    }

    public String getParamKey() {
        return this.paramKey;
    }

    public void setParamKey(String paramKey) {
        this.paramKey = paramKey;
    }
}

