/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service;

import com.hs.atic.collect.service.IssuedCommandResults;
import com.hs.atic.collect.service.ZipCommandResult;
import com.hs.atic.collect.util.ConstantUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.service.impl.AticDeviceServiceImpl;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.south.model.TelnetPara;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.zip.ZipOutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssuedDownloadFtp {
    public static final int CORE_POOL_SIZE = 5;
    public static final String SEC_LOG = "log.sec";
    public static final String splitStr = "/";
    public static final String SEC_LOG_PATH = "/seclog";
    public static final String LOG_LOG = "log.log";
    public static final String LOG_LOG_PATH = "/log";
    public static final String SEC_LOG_12000 = "security.log";
    public static final String SEC_LOG_PATH_12000 = "/logfile/security";
    public static final String LOG_LOG_12000 = "log.log";
    public static final String LOG_LOG_PATH_12000 = "/logfile";
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    @Autowired
    private AticDeviceServiceImpl aticDeviceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeviceCmdDownload(String webPath, long progressId, CountDownLatch start, AticDevice device, AticDevice aticDevice, TelnetPara telnetPara) {
        String restlt;
        boolean a;
        String dstPath = webPath + ConstantUtil.EXPORT_FTP_DIR + progressId + File.separator + aticDevice.getName();
        File dstDir = new File(dstPath);
        if (!dstDir.exists() && !(a = dstDir.mkdirs())) {
            logger.error((Object)(dstDir.getName() + " mkdirs error"));
        }
        Map<Long, String> cfcards = IssuedCommandResults.getInstance().getCfcards().get(progressId);
        Map<Long, String> cfcardsResults = IssuedCommandResults.getInstance().getCfcardResult().get(progressId);
        String cfcard = null != cfcards ? cfcards.get(device.getMoId()) : null;
        String string = restlt = null != cfcardsResults ? cfcardsResults.get(device.getMoId()) : null;
        if (null == cfcard) {
            ZipCommandResult.fillResultToFile(Arrays.asList(restlt), device.getName(), dstPath);
            return;
        }
        ExcmdConnectUtil excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
        try {
            String ftpModel = this.doExecEnableSFTPCmd(excmdConnectUtil, device.getMoId(), aticDevice.getFtpType(), progressId, cfcard);
            if (ftpModel.equals("success")) {
                String result = this.doExecDownloadLibFileToSFTP(aticDevice, SEC_LOG_PATH, SEC_LOG, dstPath);
                String result2 = this.doExecDownloadLibFileToSFTP(aticDevice, LOG_LOG_PATH, "log.log", dstPath);
                logger.info((Object)result);
                logger.info((Object)result2);
            }
            try {
                start.await();
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage());
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
        }
    }

    private void start(CountDownLatch start, CountDownLatch end, ThreadPoolExecutor executor, List<Future<String>> futures, long progressId, String webPath) {
        try {
            start.countDown();
            end.await();
            executor.shutdown();
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage());
        }
        for (Future<String> each : futures) {
            try {
                String eachResult = each.get();
                logger.info((Object)("thread error" + eachResult));
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage());
            }
            catch (ExecutionException e) {
                logger.error((Object)e.getMessage());
            }
        }
        this.zipLogs(progressId, webPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipLogs(long progressId, String webPath) {
        boolean a;
        File outDir;
        boolean a2;
        File inFileDir = new File(webPath + ConstantUtil.EXPORT_FTP_DIR + progressId);
        File outFile = new File(webPath + ConstantUtil.PACKAGE_DIR + progressId + File.separator + progressId + ".zip");
        if (!(inFileDir.exists() && inFileDir.isDirectory() || (a2 = inFileDir.mkdirs()))) {
            logger.error((Object)(inFileDir.getName() + " mkdirs error"));
        }
        if (!(outDir = new File(webPath + ConstantUtil.PACKAGE_DIR + progressId + File.separator)).exists() && !(a = outDir.mkdirs())) {
            logger.error((Object)(outDir.getName() + " mkdirs error"));
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(outFile));
            zos.setComment("zip log file");
            ZipCommandResult.zipFile(inFileDir, zos, "", null);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("zipFile()" + inFileDir.getName() + "error"));
        }
        finally {
            try {
                if (null != zos) {
                    zos.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close stream error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadLibFileToFtp(AticDevice firewall, String filePath, String fileName, String dstPath) {
        String result = "failure";
        FTPClient ftp = null;
        OutputStream outputStream = null;
        FilterOutputStream bos = null;
        try {
            String user = firewall.getFtpUser();
            StringBuffer psw = DataProtectServiceConst.sdpDecryptLocalBuffer((String)firewall.getFtpPassword());
            String ip = firewall.getIpAddress();
            int port = firewall.getFtpPort();
            ftp = new FTPClient();
            ftp.setConnectTimeout(1000);
            ftp.connect(ip);
            ftp.setDefaultPort(port);
            int replyCode = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                ftp.disconnect();
                logger.error((Object)"FTP server refused connection.");
                throw new LegoCheckedException(512L);
            }
            if (!ftp.login(user, psw.toString())) {
                ftp.logout();
                logger.error((Object)"user name or password error.");
                throw new LegoCheckedException(514L);
            }
            ftp.setFileType(2);
            File localFilex = new File(dstPath + File.separator + fileName);
            outputStream = new FileOutputStream(localFilex);
            bos = new BufferedOutputStream(outputStream);
            ftp.retrieveFile(filePath + splitStr + fileName, (OutputStream)bos);
            ftp.logout();
            result = "success";
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"LegoCheckedException error");
            result = String.valueOf(e.getErrorCode());
        }
        catch (FTPConnectionClosedException e) {
            result = String.valueOf(516L);
            logger.error((Object)"Server closed connection.");
        }
        catch (FileNotFoundException e) {
            result = String.valueOf(571915);
        }
        catch (IOException e) {
            logger.error((Object)"Could not connect to server.");
            result = String.valueOf(513L);
        }
        catch (RuntimeException e) {
            result = String.valueOf(571904);
            logger.error((Object)"unknow error");
        }
        finally {
            if (null != ftp && ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    logger.error((Object)"disconnect ftp exception");
                }
            }
            if (null != bos) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error((Object)"instream.close() error");
                }
            }
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"instream.close() error");
                }
            }
        }
        return result;
    }

    private String doExecEnableSFTPCmd(ExcmdConnectUtil excmdConnectUtil, Long devId, int ftpType, long progressId, String cfcard) {
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(devId.longValue());
        String result = "failure";
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("system-view");
        if (ftpType == 1) {
            cmds.add("sftp server enable");
        } else if (ftpType == 0) {
            cmds.add("ftp server enable");
        }
        if (null != cfcard) {
            cmds.add("return");
            cmds.add("sys");
            cmds.add("aaa");
            cmds.add("manager-user " + aticDevice.getFtpUser());
            cmds.add("ftp-directory " + cfcard);
        }
        List<String> results = null;
        try {
            results = CmdUtil.execCmds(excmdConnectUtil, cmds, false);
            if (AticUtil.isCmdSucess(results)) {
                result = "success";
            } else {
                this.recordExecCmdReult(results, "doExecEnableSFTPCmd");
                result = String.valueOf(570503);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("doExecEnableSFTPCmd LegoCheckedException error:" + e.getMessage()));
            result = String.valueOf(e.getErrorCode());
        }
        catch (Exception e) {
            logger.error((Object)("doExecEnableSFTPCmd unkonw error:" + e.getMessage()));
            result = String.valueOf(570507);
        }
        return result;
    }

    private String recordExecCmdReult(List<String> cmdResult, String cmdType) {
        if (cmdResult.isEmpty()) {
            return "";
        }
        String cmdReusultStr = "";
        String returnStr = "";
        StringBuffer buf = new StringBuffer();
        Iterator<String> iterator = cmdResult.iterator();
        while (iterator.hasNext()) {
            String resultTemp;
            String result = resultTemp = iterator.next();
            buf.append(result + ";");
            if (result.contains("Error: The specified user-defined geographic location does not exist")) continue;
            if (result.contains("Being referred to by geographic location set")) {
                result = result.replace("Info:", "Error:");
            }
            if (result.contains("Error:") && AticUtil.isNull((String)returnStr)) {
                returnStr = result.lastIndexOf("[") > result.indexOf("Error:") ? result.substring(result.indexOf("Error:"), result.lastIndexOf("[") - 1).trim() : result.substring(result.indexOf("Error:")).trim();
            }
            if (!result.contains("remain space of CF card is less than")) continue;
            returnStr = result.substring(result.indexOf("Info:")).trim();
        }
        cmdReusultStr = buf.toString();
        logger.error((Object)(" execCmdReult: " + cmdReusultStr));
        return returnStr;
    }

    private String doExecDownloadLibFileToSFTP(AticDevice firewall, String filePath, String fileName, String dstPath) {
        String result = "";
        int ftpType = firewall.getFtpType();
        if (ftpType == 1) {
            result = this.downloadLibFileToSftp(firewall, filePath, fileName, dstPath);
        } else if (ftpType == 0) {
            result = this.downloadLibFileToFtp(firewall, filePath, fileName, dstPath);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadLibFileToSftp(AticDevice firewall, String filePath, String fileName, String dstPath) {
        String result;
        block26: {
            result = "failure";
            Session session = null;
            Channel channel = null;
            FileOutputStream outstream = null;
            InputStream instream = null;
            ByteArrayInputStream in = null;
            try {
                int n;
                CharSequence buffer;
                String user = firewall.getFtpUser();
                StringBuffer psw = DataProtectServiceConst.sdpDecryptLocalBuffer((String)firewall.getFtpPassword());
                String ip = firewall.getIpAddress();
                int port = firewall.getFtpPort();
                JSch jsch = new JSch();
                if (null != firewall.getSshPublicKey() && !"".equals(firewall.getSshPublicKey())) {
                    logger.info((Object)"hostKey will be validate");
                    buffer = new StringBuffer();
                    ((StringBuffer)buffer).append(ip);
                    ((StringBuffer)buffer).append(' ');
                    ((StringBuffer)buffer).append("ssh-rsa");
                    ((StringBuffer)buffer).append(' ');
                    ((StringBuffer)buffer).append(firewall.getSshPublicKey());
                    in = new ByteArrayInputStream(((StringBuffer)buffer).toString().getBytes("UTF-8"));
                    jsch.setKnownHosts((InputStream)in);
                } else {
                    logger.info((Object)"hostKey is null, hostKey will not be validate");
                }
                session = jsch.getSession(user, ip, port);
                if (session == null) {
                    buffer = String.valueOf(571904);
                    return buffer;
                }
                session.setConfig("cipher.c2s", "aes256-ctr");
                session.setConfig("mac.c2s", "hmac-sha2-256");
                session.setConfig("cipher.s2c", "aes256-ctr");
                session.setConfig("mac.s2c", "hmac-sha2-256");
                session.setConfig("CheckCiphers", "aes256-ctr");
                session.setConfig("CheckKexes", "diffie-hellman-group14-sha1");
                session.setConfig("kex", "diffie-hellman-group14-sha1");
                session.setConfig("server_host_key", "ssh-rsa");
                session.setPassword(psw.toString());
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect(10000);
                channel = session.openChannel("sftp");
                channel.connect(1000);
                instream = ((ChannelSftp)channel).get(filePath + splitStr + fileName);
                outstream = new FileOutputStream(new File(dstPath + File.separator + fileName));
                byte[] b = new byte[1024];
                while ((n = instream.read(b)) != -1) {
                    ((OutputStream)outstream).write(b, 0, n);
                }
                outstream.flush();
                result = "success";
                this.closeInputStream(in);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"LegoCheckedException error");
                result = String.valueOf(e.getErrorCode());
                break block26;
            }
            catch (FileNotFoundException e) {
                result = String.valueOf(571915);
                break block26;
            }
            catch (JSchException e) {
                logger.error((Object)e.getMessage());
                break block26;
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage());
                break block26;
            }
            catch (IOException e) {
                logger.error((Object)"downloadLibFileToSftp get inputStream IOException");
                break block26;
            }
            catch (SftpException e) {
                logger.error((Object)"downloadLibFileToSftp get inputStream SftpException");
                break block26;
            }
            catch (RuntimeException e) {
                result = String.valueOf(571904);
                logger.error((Object)"unknow error");
                break block26;
            }
            finally {
                this.closeInputStream(in);
                this.closeOutputStream(outstream);
                this.closeInputStream(instream);
                if (null != session) {
                    session.disconnect();
                }
                if (null != channel) {
                    channel.disconnect();
                }
            }
            this.closeOutputStream(outstream);
            this.closeInputStream(instream);
            if (null != session) {
                session.disconnect();
            }
            if (null != channel) {
                channel.disconnect();
            }
        }
        return result;
    }

    private void closeOutputStream(OutputStream output) {
        if (null != output) {
            try {
                output.close();
            }
            catch (IOException e) {
                logger.error((Object)"outstream.close() error");
            }
            finally {
                output = null;
            }
        }
    }

    private void closeInputStream(InputStream input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.error((Object)"instream.close() error");
            }
            finally {
                input = null;
            }
        }
    }
}

