/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service;

import com.hs.atic.collect.service.EnumFileCommandOrder;
import com.hs.atic.collect.service.IssuedCommandResults;
import com.hs.atic.util.LocalizedTextUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.south.model.FtpPara;
import com.jcraft.jsch.ChannelSftp;
import java.util.Locale;

public abstract class IssuedFileCommandExec {
    private ChannelSftp sftpChannel;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private boolean interrupt = false;
    private long errorCode;
    private IssuedFileCommandExec next;
    private FtpPara ftpPara;
    private ProgressBar progressBar;
    private String webPath;
    private AticDevice aticDevice;
    private int step = 0;
    private Locale locale;

    protected abstract void execStep();

    public void exec() {
        this.logger.info((Object)(this.getClass().getSimpleName() + " exec start!"));
        this.execStep();
        if (this.interrupt) {
            this.logger.info((Object)(this.getClass().getSimpleName() + " exec interrupt!"));
            IssuedCommandResults.getInstance().putStatus(this.progressBar.getProgressBarID(), this.aticDevice.getMoId(), false);
            IssuedCommandResults.getInstance().putCfcardResult(this.progressBar.getProgressBarID(), this.aticDevice.getMoId(), LocalizedTextUtil.findDefaultText((String)("atic.bis.onekeyCollection.error." + this.errorCode), (Locale)this.locale));
            IssuedCommandResults.getInstance().putCfcard(this.progressBar.getProgressBarID(), this.aticDevice.getMoId(), "atic.bis.onekeyCollection.error." + this.errorCode);
            this.progressBar.next(EnumFileCommandOrder.values().length - this.step);
            this.disconnectSFtpClient();
            return;
        }
        this.logger.info((Object)("step ---------------------- " + this.step));
        this.logger.info((Object)("progressBar ---------------------- " + this.progressBar.getCurrentStep()));
        ++this.step;
        if (null == this.next) {
            this.logger.info((Object)(this.getClass().getSimpleName() + " exec end!"));
            IssuedCommandResults.getInstance().putStatus(this.progressBar.getProgressBarID(), this.aticDevice.getMoId(), true);
            IssuedCommandResults.getInstance().putCfcardResult(this.progressBar.getProgressBarID(), this.aticDevice.getMoId(), LocalizedTextUtil.findDefaultText((String)("atic.bis.onekeyCollection.error." + this.errorCode), (Locale)this.locale));
            IssuedCommandResults.getInstance().putCfcard(this.progressBar.getProgressBarID(), this.aticDevice.getMoId(), "atic.bis.onekeyCollection.error." + this.errorCode);
            this.progressBar.next();
            this.disconnectSFtpClient();
            return;
        }
        this.progressBar.next();
        this.next.setSftpChannel(this.sftpChannel);
        this.next.setStep(this.step);
        this.next.exec();
    }

    private void disconnectSFtpClient() {
        if (null != this.sftpChannel) {
            try {
                this.sftpChannel.disconnect();
            }
            catch (Exception e) {
                this.logger.error((Object)("sftpChannel.disconnect() error! " + e.getMessage()));
            }
        }
    }

    public boolean isHighDevice(boolean isHighDevice) {
        if (null != this.aticDevice.getDeviceModel() && !this.aticDevice.getDeviceModel().startsWith("AntiDDoS8")) {
            isHighDevice = false;
        }
        return isHighDevice;
    }

    public boolean isHigh12Device() {
        return null == this.aticDevice.getDeviceModel() || this.aticDevice.getDeviceModel().startsWith("AntiDDoS12");
    }

    public IssuedFileCommandExec getNext() {
        return this.next;
    }

    public void setNext(IssuedFileCommandExec next) {
        this.next = next;
    }

    public FtpPara getFtpPara() {
        return this.ftpPara;
    }

    public void setFtpPara(FtpPara ftpPara) {
        this.ftpPara = ftpPara;
    }

    public boolean isInterrupt() {
        return this.interrupt;
    }

    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    public String getWebPath() {
        return this.webPath;
    }

    public void setWebPath(String webPath) {
        this.webPath = webPath;
    }

    public AticDevice getAticDevice() {
        return this.aticDevice;
    }

    public void setAticDevice(AticDevice aticDevice) {
        this.aticDevice = aticDevice;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ChannelSftp getSftpChannel() {
        return this.sftpChannel;
    }

    public void setSftpChannel(ChannelSftp sftpChannel) {
        this.sftpChannel = sftpChannel;
    }
}

