/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service;

import com.hs.atic.collect.util.ConstantUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.LineIterator;

public class ZipCommandResult {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);

    public static void fillResultToFile(List<String> result, String commandName, String webPath, long progressId, AticDevice aticDevice) {
        ZipCommandResult.doFill(result, commandName, webPath, progressId, aticDevice);
    }

    public static void fillResultToFile(List<String> result, String name, String dstPath) {
        ZipCommandResult.doFill(result, name, dstPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doFill(List<String> result, String name, String dstPath) {
        boolean a;
        File dir = new File(dstPath);
        if (!dir.exists() && !(a = dir.mkdirs())) {
            logger.error((Object)(dir.getName() + "dir mkdirs error"));
        }
        File file = new File(dstPath + File.separator + name + ".txt");
        FileOutputStream os = null;
        OutputStreamWriter osw = null;
        BufferedWriter writer = null;
        try {
            os = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)os, Charset.forName("utf-8"));
            writer = new BufferedWriter(osw);
            for (String string : result) {
                writer.write(string);
            }
            ZipCommandResult.close(os, osw, writer);
        }
        catch (IOException e) {
            logger.error((Object)"fillResultToFile error");
        }
        finally {
            ZipCommandResult.close(os, osw, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doFill(List<String> result, String commandName, String webPath, long progressId, AticDevice aticDevice) {
        File file = ZipCommandResult.createFile(commandName, webPath, progressId, aticDevice);
        FileOutputStream os = null;
        OutputStreamWriter osw = null;
        BufferedWriter writer = null;
        try {
            os = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)os, Charset.forName("utf-8"));
            writer = new BufferedWriter(osw);
            for (String string : result) {
                writer.write(string);
            }
            ZipCommandResult.close(os, osw, writer);
        }
        catch (IOException e) {
            logger.error((Object)"fillResultToFile error");
        }
        finally {
            ZipCommandResult.close(os, osw, writer);
        }
    }

    private static File createFile(String commandName, String webPath, long progressId, AticDevice aticDevice) {
        boolean a;
        String dir = webPath + ConstantUtil.EXPORT_DIR + progressId + File.separator + aticDevice.getName();
        String packageDir = webPath + ConstantUtil.PACKAGE_DIR + progressId;
        File dirFile = new File(dir);
        File packageDirFile = new File(packageDir);
        if (!dirFile.exists() && !(a = dirFile.mkdirs())) {
            logger.error((Object)(dirFile.getName() + "dirFile.mkdirs error"));
        }
        if (!packageDirFile.exists() && !(a = packageDirFile.mkdirs())) {
            logger.error((Object)(packageDirFile.getName() + "packageDirFile.mkdirs error"));
        }
        File exportFile = new File(dir + File.separator + commandName + ".txt");
        try {
            boolean a2;
            if (!exportFile.exists() && !(a2 = exportFile.createNewFile())) {
                logger.error((Object)(exportFile.getName() + "exportFile.createNewFile error"));
            }
        }
        catch (IOException e) {
            logger.error((Object)"createFile error");
        }
        return exportFile;
    }

    private static void close(OutputStream os, OutputStreamWriter osw, BufferedWriter writer) {
        try {
            if (null != writer) {
                writer.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close stream error");
        }
        try {
            if (null != osw) {
                osw.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close stream error");
        }
        try {
            if (null != os) {
                os.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"close stream error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File inFile, ZipOutputStream zos, String dir, String dirName) {
        block17: {
            block16: {
                if (!inFile.isDirectory()) break block16;
                File[] files = inFile.listFiles();
                if (null == files) break block17;
                for (File file : files) {
                    if (null == dirName) {
                        dirName = inFile.getName();
                    }
                    ZipCommandResult.zipFile(file, zos, dir + dirName + File.separator, null);
                }
                break block17;
            }
            String entryName = null;
            entryName = !"".equals(dir) ? dir + inFile.getName() : inFile.getName();
            ZipEntry entry = new ZipEntry(entryName);
            FileInputStream fis = null;
            BufferedInputStream is = null;
            try {
                zos.putNextEntry(entry);
                fis = new FileInputStream(inFile);
                is = new BufferedInputStream(fis);
                byte[] datas = new byte[2048];
                int len = 0;
                while ((len = is.read(datas)) != -1) {
                    zos.write(datas, 0, len);
                }
            }
            catch (IOException e) {
                logger.error((Object)"zipFile IOException");
            }
            finally {
                try {
                    if (null != is) {
                        is.close();
                    }
                    if (null != fis) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"close stream error");
                }
            }
        }
    }

    public static ConcurrentHashMap<String, List<String>> readesultToFile(long progressId) {
        String dir = ConstantUtil.EXPORT_DIR + progressId + File.separator;
        ConcurrentHashMap<String, List<String>> device2List = new ConcurrentHashMap<String, List<String>>();
        File dirFile = new File(dir);
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return device2List;
        }
        File[] subDirs = dirFile.listFiles();
        if (null != subDirs) {
            for (File subDir : subDirs) {
                ZipCommandResult.readOneDir(device2List, subDir);
            }
        }
        return device2List;
    }

    private static void readOneDir(Map<String, List<String>> device2List, File subDir) {
        if (!subDir.exists() || !subDir.isDirectory()) {
            return;
        }
        File[] txts = subDir.listFiles();
        if (null == txts) {
            return;
        }
        for (File txt : txts) {
            ZipCommandResult.readOne(device2List, subDir.getName(), txt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void readOne(Map<String, List<String>> device2List, String key, File txt) {
        block14: {
            LineIterator lineIterator;
            BufferedReader reader;
            InputStreamReader osr;
            FileInputStream is;
            block12: {
                ArrayList<String> ret = new ArrayList<String>();
                is = null;
                osr = null;
                reader = null;
                lineIterator = null;
                is = new FileInputStream(txt);
                osr = new InputStreamReader((InputStream)is, Charset.forName("utf-8"));
                reader = new BufferedReader(osr);
                lineIterator = new LineIterator((Reader)reader);
                while (lineIterator.hasNext()) {
                    ret.add(lineIterator.nextLine());
                }
                device2List.put(key, ret);
                if (null == lineIterator) break block12;
                try {
                    LineIterator.closeQuietly((LineIterator)lineIterator);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
            ZipCommandResult.close(is, osr, reader);
            break block14;
            catch (IOException e) {
                block13: {
                    try {
                        logger.error((Object)("read txt : " + txt.getName() + " error"));
                        if (null == lineIterator) break block13;
                    }
                    catch (Throwable throwable) {
                        if (null != lineIterator) {
                            try {
                                LineIterator.closeQuietly(lineIterator);
                            }
                            catch (Exception e2) {
                                logger.error((Object)e2.getMessage());
                            }
                        }
                        ZipCommandResult.close(is, osr, reader);
                        throw throwable;
                    }
                    try {
                        LineIterator.closeQuietly((LineIterator)lineIterator);
                    }
                    catch (Exception e3) {
                        logger.error((Object)e3.getMessage());
                    }
                }
                ZipCommandResult.close(is, osr, reader);
            }
        }
    }

    private static void close(InputStream is, InputStreamReader osr, BufferedReader reader) {
        if (null != reader) {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error((Object)"close reader error");
            }
        }
        if (null != osr) {
            try {
                osr.close();
            }
            catch (IOException e) {
                logger.error((Object)"close inputStreamReader error");
            }
        }
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error((Object)"close inputStream error");
            }
        }
    }
}

