/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collect.service.impl;

import com.hs.atic.collect.service.IssuedFileCommandExec;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.south.model.FtpPara;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;

public class TestFtpReachable
extends IssuedFileCommandExec {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private static final String SFTP = "sftp";
    private static final int TIME_OUT = 20000;
    private static final int CONNECT_TIME_OUT = 1000;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openSftpChannel(FtpPara ftpPara) {
        boolean bl;
        ChannelSftp sftpChannel = null;
        ByteArrayInputStream in = null;
        String host = ftpPara.getServiceIp();
        int port = ftpPara.getPort();
        String username = ftpPara.getUserName();
        String psw = ftpPara.getFtpPassWord();
        String hostKey = ftpPara.getHostKey();
        try {
            JSch jsch = new JSch();
            if (null != hostKey && !"".equals(hostKey)) {
                LOGGER.info((Object)"hostKey will be validate");
                StringBuffer buffer = new StringBuffer();
                buffer.append(host);
                buffer.append(" ");
                buffer.append("ssh-rsa");
                buffer.append(" ");
                buffer.append(hostKey);
                in = new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
                jsch.setKnownHosts((InputStream)in);
            }
            Session session = jsch.getSession(username, host, port);
            session.setConfig("cipher.c2s", "aes256-ctr");
            session.setConfig("mac.c2s", "hmac-sha2-256");
            session.setConfig("cipher.s2c", "aes256-ctr");
            session.setConfig("mac.s2c", "hmac-sha2-256");
            session.setConfig("CheckCiphers", "aes256-ctr");
            session.setConfig("CheckKexes", "diffie-hellman-group14-sha1");
            session.setConfig("kex", "diffie-hellman-group14-sha1");
            session.setConfig("server_host_key", "ssh-rsa");
            LOGGER.debug((Object)"get sshSession not null");
            session.setPassword(psw);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect(20000);
            Channel channel = session.openChannel(SFTP);
            channel.connect(1000);
            sftpChannel = (ChannelSftp)channel;
            super.setSftpChannel(sftpChannel);
            bl = true;
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.disconnectSFtpClient(sftpChannel);
                LOGGER.error((Object)"get hostkey info error.");
                throw new LegoCheckedException(601L);
                catch (JSchException e2) {
                    this.disconnectSFtpClient(sftpChannel);
                    LOGGER.error((Object)(host + "-The sftp server hostkey was not accepted by the verifier callback!"));
                    throw new LegoCheckedException(601L);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return bl;
    }

    private void disconnectSFtpClient(ChannelSftp sftpChannel) {
        if (null != sftpChannel) {
            try {
                sftpChannel.disconnect();
            }
            catch (Exception e) {
                LOGGER.error((Object)("sftpChannel.disconnect() error! " + e.getMessage()));
            }
        }
    }

    @Override
    protected void execStep() {
        try {
            boolean isReach = this.openSftpChannel(super.getFtpPara());
            LOGGER.info((Object)("TestFtpReachable - execStep : SFTP Server is connected [" + isReach + "] :" + super.getFtpPara().getServiceIp()));
        }
        catch (LegoCheckedException e) {
            super.setErrorCode(e.getErrorCode());
            super.setInterrupt(true);
        }
    }
}

