/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.common.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.sdk.comm.Paging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class BaseDao<T, PK extends Serializable>
extends HibernateDaoSupport {
    protected Class<T> persistentClass;

    public BaseDao(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public List<T> findPageByHql(final String hql, final int start, final int pageSize, final Map<Integer, String> param) {
        return (List)new HibernateTemplate(this.getSessionFactory()).execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(hql);
                Set entrys = param.entrySet();
                for (Map.Entry entry : entrys) {
                    query.setString(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
                }
                query.setFirstResult(start);
                if (pageSize != 0) {
                    query.setMaxResults(pageSize);
                }
                return query.list();
            }
        });
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        StringBuffer hql = new StringBuffer();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        List<Object> objects = this.initQuery(queryMap, hql);
        for (int i = 0; i < objects.size(); ++i) {
            param.put(i, String.valueOf(objects.get(i)));
        }
        List<T> list = this.findPageByHql(hql.toString(), start, pageSize, param);
        Paging page = new Paging();
        page.setData(list);
        page.setCount(this.getRowCountByHsql(this.generateRowCountSqlByHsql(hql.toString()), objects.toArray()));
        return page;
    }

    public void remove(PK id) {
        T t = this.get(id);
        if (t == null) {
            return;
        }
        this.getHibernateTemplate().delete(t);
    }

    public T get(PK id) {
        return (T)this.getHibernateTemplate().get(this.persistentClass, id);
    }

    public T save(T object) {
        return (T)this.getHibernateTemplate().merge(object);
    }

    public List<T> getAll() {
        return this.findByHql(this.basicHql());
    }

    protected String generateRowCountSqlByHsql(String hsql) {
        String hsqlLowerCase = hsql.toLowerCase(Locale.getDefault());
        int sqlFrom = hsqlLowerCase.indexOf("from ");
        int sqlOrderby = hsqlLowerCase.lastIndexOf("order by");
        int sqlGroupby = hsqlLowerCase.lastIndexOf("group by");
        String rowCountSql = "";
        rowCountSql = sqlOrderby > 0 ? "select count(*) AS rowCount " + hsql.substring(sqlFrom, sqlOrderby) : (sqlGroupby > 0 ? "select count(*) from (select count(*) AS rowCount " + hsql.substring(sqlFrom) + ") as tab" : "select count(*) AS rowCount " + hsql.substring(sqlFrom));
        return rowCountSql;
    }

    public int getRowCountByHsql(String hsql) {
        return Integer.parseInt(super.getHibernateTemplate().find(this.generateRowCountSqlByHsql(hsql), new Object[0]).get(0).toString());
    }

    public int getRowCountByHsql(String hsql, Object[] objects) {
        return Integer.parseInt(super.getHibernateTemplate().find(this.generateRowCountSqlByHsql(hsql), objects).get(0).toString());
    }

    public List<T> findByHql(String hql) {
        return super.getHibernateTemplate().find(hql, new Object[0]);
    }

    public List<T> findByHql(String hql, Object object) {
        return super.getHibernateTemplate().find(hql, new Object[]{object});
    }

    public List<T> findByHql(String hql, Object[] object) {
        return super.getHibernateTemplate().find(hql, object);
    }

    protected List<Object> initQuery(Map<String, String> queryMap, StringBuffer hql) {
        this.basicHql(hql);
        List<Object> param = this.conditionHql(queryMap, hql);
        this.sortHql(queryMap, hql);
        return param;
    }

    protected List<Object> conditionHql(Map<String, String> queryMap, StringBuffer hql) {
        return new ArrayList<Object>();
    }

    protected String basicHql() {
        StringBuffer hql = new StringBuffer();
        this.basicHql(hql);
        return hql.toString();
    }

    private void basicHql(StringBuffer hql) {
        hql.append("from " + this.persistentClass.getSimpleName());
    }

    protected void sortHql(Map<String, String> queryMap, StringBuffer hql) {
        String regular;
        String sortType = queryMap.get("sortType");
        String sortName = queryMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql.append(" order by ").append(sortName).append(' ').append(sortType);
        }
    }

    public void update(T object) {
        this.getHibernateTemplate().update(object);
    }
}

